/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.WeakTimerListener;
import org.netbeans.editor.ext.ListCompletionView;
import org.netbeans.editor.ext.java.JCCellRenderer;
import org.netbeans.editor.ext.java.JavaFastOpenPanel;
import org.netbeans.editor.ext.java.JavaSettingsDefaults;
import org.openide.util.RequestProcessor;

public abstract class JavaFastOpen
implements ActionListener {
    private static final int TIMER_DELAY = 1000;
    private JavaFastOpenPanel panel;
    private ListCellRenderer cellRenderer;
    private JList resultList;
    private Dialog dialog;
    private JButton[] buttons;
    private Evaluator evaluator;
    private static Timer timer;
    protected boolean caseSensitive;
    protected boolean includeInnerClasses;
    protected boolean includeLibraryClasses;
    private static final int SET_EXP = 1;
    private static final int POPULATE_LIST = 2;
    private static final int OPEN = 3;
    protected static JavaFastOpen fastOpen;

    public JavaFastOpen() {
        timer = new Timer(0, (ActionListener)new WeakTimerListener((ActionListener)this));
        timer.setRepeats(false);
    }

    public void setDialogVisible(boolean bl) {
        if (this.dialog == null) {
            this.dialog = this.createDialog();
        }
        if (bl) {
            this.caseSensitive = this.isCaseSensitive();
            this.includeInnerClasses = this.isIncludeInnerClasses();
            this.includeLibraryClasses = this.isIncludeLibraryClasses();
            this.getPanel().setCaseSensitive(this.caseSensitive);
            this.getPanel().setIncludeInnerClasses(this.includeInnerClasses);
            this.getPanel().setIncludeLibraryClasses(this.includeLibraryClasses);
            this.getPanel().popupNotify();
            this.dialog.setVisible(true);
        } else {
            this.dialog.setVisible(false);
            if (this.evaluator != null) {
                this.evaluator.breakLoop();
            }
            this.dialog.dispose();
            fastOpen = null;
        }
    }

    protected void openSource(Object object, int n) {
    }

    protected ListCellRenderer createCellRenderer() {
        JCCellRenderer jCCellRenderer = new JCCellRenderer();
        return jCCellRenderer;
    }

    protected JList createResultList() {
        ListCompletionView listCompletionView = new ListCompletionView(this.getCellRenderer());
        listCompletionView.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ListCompletionView listCompletionView = (ListCompletionView)JavaFastOpen.this.getResultList();
                if (mouseEvent.getClickCount() == 2 && listCompletionView.showingData()) {
                    JavaFastOpen.this.actionPerformed(new ActionEvent(JavaFastOpen.this.getButtons()[0], 0, ""));
                }
            }
        });
        return listCompletionView;
    }

    protected JButton[] getButtons() {
        if (this.buttons == null) {
            this.buttons = new JButton[]{new JButton(LocaleSupport.getString((String)"JFO_openSourceButton", (String)"Open Source")), new JButton(LocaleSupport.getString((String)"JFO_closeButton", (String)"Close"))};
            this.buttons[0].setEnabled(false);
            String string = LocaleSupport.getString((String)"JFO_openSourceButtonMnemonic", (String)"O");
            if (string != null && string.length() > 0) {
                this.buttons[0].setMnemonic(string.charAt(0));
            }
            if ((string = LocaleSupport.getString((String)"JFO_closeButtonMnemonic", (String)"C")) != null && string.length() > 0) {
                this.buttons[1].setMnemonic(string.charAt(0));
            }
            this.buttons[0].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_JFO_openSourceButton"));
            this.buttons[1].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_JFO_closeButton"));
        }
        return this.buttons;
    }

    protected Class getKitClass() {
        return null;
    }

    protected boolean isCaseSensitive() {
        Class clazz = this.getKitClass();
        if (clazz != null) {
            return SettingsUtil.getBoolean((Class)clazz, (String)"goto-class-case-sensitive", (Boolean)JavaSettingsDefaults.defaultGotoClassCaseSensitive);
        }
        return JavaSettingsDefaults.defaultGotoClassCaseSensitive;
    }

    protected void setCaseSensitive(boolean bl) {
    }

    protected boolean isIncludeInnerClasses() {
        Class clazz = this.getKitClass();
        if (clazz != null) {
            return SettingsUtil.getBoolean((Class)clazz, (String)"goto-class-show-inner-classes", (Boolean)JavaSettingsDefaults.defaultGotoClassShowInnerClasses);
        }
        return JavaSettingsDefaults.defaultGotoClassShowInnerClasses;
    }

    protected void setIncludeInnerClasses(boolean bl) {
    }

    protected boolean isIncludeLibraryClasses() {
        Class clazz = this.getKitClass();
        if (clazz != null) {
            return SettingsUtil.getBoolean((Class)clazz, (String)"goto-class-show-library-classes", (Boolean)JavaSettingsDefaults.defaultGotoClassShowLibraryClasses);
        }
        return JavaSettingsDefaults.defaultGotoClassShowLibraryClasses;
    }

    protected void setIncludeLibraryClasses(boolean bl) {
    }

    protected Dialog createDialog() {
        String string = LocaleSupport.getString((String)"JFO_title", (String)"Open Java Source");
        Dialog dialog = DialogSupport.createDialog((String)string, (JPanel)this.getPanel(), (boolean)false, (JButton[])this.getButtons(), (boolean)false, (int)0, (int)1, (ActionListener)this);
        if (dialog instanceof JDialog) {
            ((JDialog)dialog).getRootPane().setDefaultButton(null);
        }
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JavaFastOpen.this.setDialogVisible(false);
            }

            public void windowClosed(WindowEvent windowEvent) {
            }
        });
        return dialog;
    }

    protected JavaFastOpenPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JavaFastOpenPanel(this);
        }
        return this.panel;
    }

    ListCellRenderer getCellRenderer() {
        if (this.cellRenderer == null) {
            this.cellRenderer = this.createCellRenderer();
        }
        return this.cellRenderer;
    }

    protected JList getResultList() {
        if (this.resultList == null) {
            this.resultList = this.createResultList();
        }
        return this.resultList;
    }

    private Evaluator getEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = new Evaluator(0);
            RequestProcessor.getDefault().post((Runnable)this.evaluator);
        }
        return this.evaluator;
    }

    protected String getSearchText() {
        return this.getPanel().getSearchText();
    }

    public void setSearchText(String string) {
        this.getPanel().setSearchText(string);
        this.postUpdate();
    }

    protected void postUpdate() {
        SwingUtilities.invokeLater(new Evaluator(1));
    }

    protected abstract List findClasses(String var1, boolean var2, boolean var3, boolean var4);

    List evaluate(String string, boolean bl, boolean bl2, boolean bl3) {
        List list = null;
        if (string != null && string.length() > 0) {
            timer.setInitialDelay(1000);
            timer.setDelay(1000);
            timer.start();
            list = this.findClasses(string, bl, bl2, bl3);
            timer.stop();
            this.getPanel().setCursor(Cursor.getPredefinedCursor(0));
        }
        return list;
    }

    void populate(List list) {
        if (list != null && this.getResultList() instanceof ListCompletionView) {
            SwingUtilities.invokeLater(new Evaluator(2, list));
        }
    }

    private String listActionFor(KeyEvent keyEvent) {
        InputMap inputMap = this.resultList.getInputMap();
        Object object = inputMap.get(KeyStroke.getKeyStrokeForEvent(keyEvent));
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    boolean boundScrollingKey(KeyEvent keyEvent) {
        String string = this.listActionFor(keyEvent);
        return "selectPreviousRow".equals(string) || "selectNextRow".equals(string) || "selectFirstRow".equals(string) || "selectLastRow".equals(string) || "scrollUp".equals(string) || "scrollDown".equals(string);
    }

    void delegateScrollingKey(KeyEvent keyEvent) {
        String string = this.listActionFor(keyEvent);
        Action action = this.resultList.getActionMap().get(string);
        if (action != null) {
            action.actionPerformed(new ActionEvent(this.resultList, 0, string));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.buttons[0] || object == this.panel) {
            this.setCaseSensitive(this.caseSensitive);
            this.setIncludeInnerClasses(this.includeInnerClasses);
            this.setIncludeLibraryClasses(this.includeLibraryClasses);
            this.getEvaluator().postOpen();
        } else if (object instanceof Timer) {
            this.getPanel().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setDialogVisible(false);
        }
    }

    private void open() {
        SwingUtilities.invokeLater(new Evaluator(3));
    }

    static {
        fastOpen = null;
    }

    private class Evaluator
    implements Runnable {
        private int opID;
        private List result;
        private String exp;
        private String lastExp;
        private boolean open;
        private boolean exit;
        private boolean lastCaseSensitive;
        private boolean lastIncludeInnerClasses;
        private boolean lastIncludeLibraryClasses;

        Evaluator(int n) {
            this(n, null);
        }

        Evaluator(int n, List list) {
            this.opID = n;
            this.result = list;
        }

        synchronized void setExp(String string) {
            this.exp = string;
        }

        synchronized void postOpen() {
            this.open = true;
        }

        void breakLoop() {
            this.exit = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            switch (this.opID) {
                case 1: {
                    String string = JavaFastOpen.this.getPanel().getSearchText();
                    String string2 = ((JavaFastOpen)JavaFastOpen.this).getEvaluator().lastExp;
                    if (string2 == null && string.length() > 0) {
                        JavaFastOpen.this.getButtons()[0].setEnabled(true);
                    }
                    if ((string2 == null || string2.length() == 0) && string.length() > 0) {
                        ((ListCompletionView)JavaFastOpen.this.getResultList()).displayWaitStatus();
                    }
                    JavaFastOpen.this.getEvaluator().setExp(string);
                    JavaFastOpen.this.caseSensitive = JavaFastOpen.this.getPanel().getCaseSensitive();
                    JavaFastOpen.this.includeInnerClasses = JavaFastOpen.this.getPanel().getIncludeInnerClasses();
                    JavaFastOpen.this.includeLibraryClasses = JavaFastOpen.this.getPanel().getIncludeLibraryClasses();
                    return;
                }
                case 2: {
                    ((ListCompletionView)JavaFastOpen.this.getResultList()).setResult(this.result);
                    JavaFastOpen.this.getResultList().setSelectedIndex(0);
                    JavaFastOpen.this.getButtons()[0].setEnabled(this.result.size() > 0);
                    if (JavaFastOpen.this.dialog instanceof JDialog) {
                        JDialog jDialog = (JDialog)JavaFastOpen.this.dialog;
                        jDialog.getRootPane().setDefaultButton(JavaFastOpen.this.getButtons()[0].isEnabled() ? JavaFastOpen.this.getButtons()[0] : null);
                    }
                    return;
                }
                case 3: {
                    int n = JavaFastOpen.this.getResultList().getSelectedIndex();
                    if (n >= 0) {
                        int n2;
                        for (n2 = n; n2 > 0 && JavaFastOpen.this.getResultList().getModel().getElementAt(n).equals(JavaFastOpen.this.getResultList().getModel().getElementAt(n2 - 1)); --n2) {
                        }
                        JavaFastOpen.this.openSource(JavaFastOpen.this.getResultList().getModel().getElementAt(n), n - n2);
                        JavaFastOpen.this.setDialogVisible(false);
                    }
                    return;
                }
            }
            try {
                while (!this.exit) {
                    Object object;
                    if (this.exp != null && !this.exp.equals(this.lastExp) || JavaFastOpen.this.caseSensitive != this.lastCaseSensitive || JavaFastOpen.this.includeInnerClasses != this.lastIncludeInnerClasses || JavaFastOpen.this.includeLibraryClasses != this.lastIncludeLibraryClasses) {
                        this.lastExp = this.exp;
                        this.lastCaseSensitive = JavaFastOpen.this.caseSensitive;
                        this.lastIncludeInnerClasses = JavaFastOpen.this.includeInnerClasses;
                        this.lastIncludeLibraryClasses = JavaFastOpen.this.includeLibraryClasses;
                        if (this.lastExp != null) {
                            object = JavaFastOpen.this.evaluate(this.lastExp, this.lastCaseSensitive, this.lastIncludeInnerClasses, this.lastIncludeLibraryClasses);
                            if (this.lastExp.equals(this.exp)) {
                                JavaFastOpen.this.populate((List)object);
                            }
                        }
                    }
                    object = this;
                    synchronized (object) {
                        if (this.exp != null && this.exp.equals(this.lastExp) && this.open) {
                            JavaFastOpen.this.open();
                            this.open = false;
                        }
                    }
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

