/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.ext.java.JavaFastOpen;

class JavaFastOpenPanel
extends JPanel {
    private static String CASE_SENSITIVE_SHORTCUT_ACTION = "JFOP_CaseSensitiveShortcutAction";
    private static String INNER_CLASSES_SHORTCUT_ACTION = "JFOP_InnerClassesShortcutAction";
    private static String LIBRARY_CLASSES_SHORTCUT_ACTION = "JFOP_LibraryClassesShortcutAction";
    private JavaFastOpen jfo;
    private JCheckBox caseSensitive;
    private JPanel checkBoxesPanel;
    private JTextField expField;
    private JLabel expLabel;
    private JLabel foundLabel;
    private JCheckBox innerClasses;
    private JCheckBox libraryClasses;
    private JPanel listPanel;
    private JScrollPane listScrollPane;
    private JPanel queryPanel;

    public JavaFastOpenPanel(JavaFastOpen javaFastOpen) {
        this.jfo = javaFastOpen;
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_JFO"));
        this.expField.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_JFOP_expLabel"));
        this.expField.setPreferredSize(null);
        final JList jList = javaFastOpen.getResultList();
        this.listScrollPane.setViewportView(jList);
        this.foundLabel.setLabelFor(jList);
        jList.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_JFOP_foundLabel"));
        jList.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("model".equals(propertyChangeEvent.getPropertyName())) {
                    JavaFastOpenPanel.this.expField.setForeground(jList.getModel().getSize() == 0 ? Color.red : Color.black);
                }
            }
        });
        this.expLabel.setDisplayedMnemonic(LocaleSupport.getString((String)"JFOP_expLabelMnemonic", (String)"C").charAt(0));
        this.expLabel.setLabelFor(this.expField);
        this.expField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (!this.checkArrows(keyEvent)) {
                    this.change();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (!this.isArrows(keyEvent)) {
                    this.change();
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
                if (!this.isArrows(keyEvent)) {
                    this.change();
                }
            }

            private boolean isArrows(KeyEvent keyEvent) {
                return JavaFastOpenPanel.this.jfo.boundScrollingKey(keyEvent);
            }

            private boolean checkArrows(KeyEvent keyEvent) {
                if (this.isArrows(keyEvent)) {
                    JavaFastOpenPanel.this.jfo.delegateScrollingKey(keyEvent);
                    keyEvent.consume();
                    return true;
                }
                return false;
            }

            private void change() {
                JavaFastOpenPanel.this.jfo.postUpdate();
            }
        });
        InputMap inputMap = this.expField.getInputMap();
        ActionMap actionMap = this.expField.getActionMap();
        this.caseSensitive.setMnemonic(LocaleSupport.getString((String)"JFOP_caseSensitiveBoxMnemonic", (String)"S").charAt(0));
        this.caseSensitive.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_JFOP_caseSensitiveBox"));
        this.caseSensitive.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaFastOpenPanel.this.jfo.postUpdate();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(this.caseSensitive.getMnemonic(), 8), CASE_SENSITIVE_SHORTCUT_ACTION);
        actionMap.put(CASE_SENSITIVE_SHORTCUT_ACTION, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaFastOpenPanel.this.caseSensitive.doClick();
            }
        });
        this.innerClasses.setMnemonic(LocaleSupport.getString((String)"JFOP_innerClassesBoxMnemonic", (String)"I").charAt(0));
        this.innerClasses.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_JFOP_innerClassesBox"));
        this.innerClasses.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaFastOpenPanel.this.jfo.postUpdate();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(this.innerClasses.getMnemonic(), 8), INNER_CLASSES_SHORTCUT_ACTION);
        actionMap.put(INNER_CLASSES_SHORTCUT_ACTION, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaFastOpenPanel.this.innerClasses.doClick();
            }
        });
        this.libraryClasses.setMnemonic(LocaleSupport.getString((String)"JFOP_libraryClassesBoxMnemonic", (String)"P").charAt(0));
        this.libraryClasses.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_JFOP_libraryClassesBox"));
        this.libraryClasses.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaFastOpenPanel.this.jfo.postUpdate();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(this.libraryClasses.getMnemonic(), 8), LIBRARY_CLASSES_SHORTCUT_ACTION);
        actionMap.put(LIBRARY_CLASSES_SHORTCUT_ACTION, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaFastOpenPanel.this.libraryClasses.doClick();
            }
        });
        this.foundLabel.setDisplayedMnemonic(LocaleSupport.getString((String)"JFOP_foundLabelMnemonic", (String)"F").charAt(0));
        this.foundLabel.setLabelFor(javaFastOpen.getResultList());
    }

    private Dimension getScrollPanePreferredSize() {
        FontMetrics fontMetrics;
        Font font = this.listScrollPane.getFont();
        Graphics graphics = this.listScrollPane.getGraphics();
        if (font != null && graphics != null && (fontMetrics = graphics.getFontMetrics(font)) != null) {
            return new Dimension(fontMetrics.stringWidth("o") * 60, fontMetrics.getHeight() * 12);
        }
        return this.listScrollPane.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        this.listScrollPane.setPreferredSize(this.getScrollPanePreferredSize());
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = this.getMaximumSize();
        if (dimension.width > dimension2.width) {
            dimension.width = dimension2.width;
        }
        if (dimension.height > dimension2.height) {
            dimension.height = dimension2.height;
        }
        return dimension;
    }

    void popupNotify() {
        this.expField.requestFocus();
    }

    String getSearchText() {
        return this.expField.getText();
    }

    void setSearchText(String string) {
        this.expField.setText(string);
        this.expField.selectAll();
    }

    boolean getCaseSensitive() {
        return this.caseSensitive.isSelected();
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive.setSelected(bl);
    }

    boolean getIncludeInnerClasses() {
        return this.innerClasses.isSelected();
    }

    void setIncludeInnerClasses(boolean bl) {
        this.innerClasses.setSelected(bl);
    }

    boolean getIncludeLibraryClasses() {
        return this.libraryClasses.isSelected();
    }

    void setIncludeLibraryClasses(boolean bl) {
        this.libraryClasses.setSelected(bl);
    }

    private void initComponents() {
        this.queryPanel = new JPanel();
        this.expLabel = new JLabel();
        this.expField = new JTextField();
        this.listPanel = new JPanel();
        this.foundLabel = new JLabel();
        this.listScrollPane = new JScrollPane();
        this.checkBoxesPanel = new JPanel();
        this.caseSensitive = new JCheckBox();
        this.innerClasses = new JCheckBox();
        this.libraryClasses = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
        this.queryPanel.setLayout(new GridBagLayout());
        this.expLabel.setLabelFor(this.expField);
        this.expLabel.setText(LocaleSupport.getString((String)"JFOP_expLabel", (String)"Class Name:"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.queryPanel.add((Component)this.expLabel, gridBagConstraints);
        this.expField.setPreferredSize(new Dimension(100, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.queryPanel.add((Component)this.expField, gridBagConstraints);
        this.add((Component)this.queryPanel, "North");
        this.listPanel.setLayout(new GridBagLayout());
        this.listPanel.setBorder(new EmptyBorder(new Insets(12, 0, 0, 0)));
        this.foundLabel.setText(LocaleSupport.getString((String)"JFOP_foundLabel", (String)"Matching Classes:"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.listPanel.add((Component)this.foundLabel, gridBagConstraints);
        this.listScrollPane.setPreferredSize(new Dimension(200, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.listPanel.add((Component)this.listScrollPane, gridBagConstraints);
        this.add((Component)this.listPanel, "Center");
        this.checkBoxesPanel.setLayout(new GridBagLayout());
        this.checkBoxesPanel.setBorder(new EmptyBorder(new Insets(12, 0, 0, 0)));
        this.caseSensitive.setText(LocaleSupport.getString((String)"JFOP_caseSensitiveBox", (String)"Case Sensitive"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.checkBoxesPanel.add((Component)this.caseSensitive, gridBagConstraints);
        this.innerClasses.setText(LocaleSupport.getString((String)"JFOP_innerClassesBox", (String)"Show Inner Classes"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.checkBoxesPanel.add((Component)this.innerClasses, gridBagConstraints);
        this.libraryClasses.setText(LocaleSupport.getString((String)"JFOP_libraryClassesBox", (String)"Show Non-Project Classes"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.checkBoxesPanel.add((Component)this.libraryClasses, gridBagConstraints);
        this.add((Component)this.checkBoxesPanel, "South");
    }
}

