/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Finder;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.TextBatchProcessor;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCExpression;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JCType;
import org.netbeans.editor.ext.java.JCUtilities;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.editor.ext.java.JavaDeclarationProcessor;
import org.netbeans.editor.ext.java.JavaImport;
import org.netbeans.editor.ext.java.JavaTokenContext;

public abstract class JavaSyntaxSupport
extends ExtSyntaxSupport {
    static final int INIT = 0;
    static final int AFTER_TYPE = 1;
    static final int AFTER_VARIABLE = 2;
    static final int AFTER_COMMA = 3;
    static final int AFTER_DOT = 4;
    static final int AFTER_TYPE_LSB = 5;
    static final int AFTER_MATCHING_VARIABLE_LSB = 6;
    static final int AFTER_MATCHING_VARIABLE = 7;
    static final int AFTER_EQUAL = 8;
    private static final TokenID[] COMMENT_TOKENS = new TokenID[]{JavaTokenContext.LINE_COMMENT, JavaTokenContext.BLOCK_COMMENT};
    private static final TokenID[] BRACKET_SKIP_TOKENS = new TokenID[]{JavaTokenContext.LINE_COMMENT, JavaTokenContext.BLOCK_COMMENT, JavaTokenContext.CHAR_LITERAL, JavaTokenContext.STRING_LITERAL};
    private static final char[] COMMAND_SEPARATOR_CHARS = new char[]{';', '{', '}'};
    private JavaImport javaImport;
    private boolean java15;

    public JavaSyntaxSupport(BaseDocument baseDocument) {
        super(baseDocument);
        this.tokenNumericIDsValid = true;
    }

    protected abstract JCFinder getFinder();

    protected JavaImport createJavaImport() {
        return new JavaImport(this);
    }

    protected void documentModified(DocumentEvent documentEvent) {
        super.documentModified(documentEvent);
        if (this.javaImport != null) {
            this.javaImport.documentModifiedAtPosition(documentEvent.getOffset(), this.getDocument());
        }
    }

    protected void setJava15(boolean bl) {
        this.java15 = bl;
    }

    public TokenID[] getCommentTokens() {
        return COMMENT_TOKENS;
    }

    public TokenID[] getBracketSkipTokens() {
        return BRACKET_SKIP_TOKENS;
    }

    public int getLastCommandSeparator(int n) throws BadLocationException {
        if (n == 0) {
            return 0;
        }
        TextBatchProcessor textBatchProcessor = new TextBatchProcessor(){

            public int processTextBatch(BaseDocument baseDocument, int n, int n2, boolean bl) {
                try {
                    int n3;
                    int[] nArray;
                    int[] nArray2 = JavaSyntaxSupport.this.getCommentBlocks(n2, n);
                    FinderFactory.CharArrayBwdFinder charArrayBwdFinder = new FinderFactory.CharArrayBwdFinder(COMMAND_SEPARATOR_CHARS);
                    int n4 = JavaSyntaxSupport.this.findOutsideBlocks((Finder)charArrayBwdFinder, n, n2, nArray2);
                    if (n4 < 1) {
                        return n4;
                    }
                    TokenID tokenID = JavaSyntaxSupport.this.getTokenID(n4);
                    if (tokenID.getNumericID() == 58 && (nArray = JavaSyntaxSupport.this.findMatchingBlock(n4, true)) != null && (n3 = Utilities.getFirstNonWhiteBwd((BaseDocument)JavaSyntaxSupport.this.getDocument(), (int)nArray[0])) > -1 && JavaSyntaxSupport.this.getTokenID(n3).getNumericID() == 56) {
                        return JavaSyntaxSupport.this.getLastCommandSeparator(n3);
                    }
                    if (tokenID.getNumericID() != 57 && tokenID.getNumericID() != 58 && tokenID.getNumericID() != 51) {
                        n4 = this.processTextBatch(baseDocument, n4, 0, bl);
                    }
                    return n4;
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                    return -1;
                }
            }
        };
        int n2 = this.getDocument().processText(textBatchProcessor, n, 0);
        TokenItem tokenItem = this.getTokenChain(n - 1, n);
        do {
            int n3 = tokenItem.getOffset();
            if (n2 != -1 && n3 < n2) break;
            if (tokenItem.getTokenContextPath().contains(JavaTokenContext.contextPath)) continue;
            n2 = tokenItem.getNext() != null ? tokenItem.getNext().getOffset() : tokenItem.getOffset() + tokenItem.getImage().length();
            break;
        } while ((tokenItem = tokenItem.getPrevious()) != null);
        return n2;
    }

    public JCClass getClassFromName(String string, boolean bl) {
        this.refreshJavaImport();
        JCClass jCClass = JavaCompletion.getPrimitiveClass(string);
        if (jCClass == null) {
            jCClass = this.getJavaImport().getClazz(string);
        }
        if (jCClass == null && bl) {
            if (this.isUnknownImport(string)) {
                return null;
            }
            List list = this.getFinder().findClasses(null, string, true);
            if (list != null && list.size() > 0 && list.size() > 0) {
                jCClass = (JCClass)list.get(0);
            }
        }
        return jCClass;
    }

    public synchronized JavaImport getJavaImport() {
        if (this.javaImport == null) {
            this.javaImport = this.createJavaImport();
        }
        this.javaImport.update(this.getDocument());
        return this.javaImport;
    }

    protected boolean isUnknownImport(String string) {
        return this.getJavaImport().isUnknownImport(string);
    }

    protected List getUnknownImports() {
        return this.getJavaImport().getUnknownImports();
    }

    public boolean isImported(JCClass jCClass) {
        return this.getJavaImport().isImported(jCClass);
    }

    public void refreshJavaImport() {
        if (this.javaImport != null) {
            this.javaImport.update(this.getDocument());
        }
    }

    protected void refreshClassInfo() {
    }

    protected List getImportedInnerClasses() {
        this.refreshJavaImport();
        return this.getJavaImport().getInnerClasses();
    }

    public JCClass getClass(int n) {
        return null;
    }

    public boolean isStaticBlock(int n) {
        return false;
    }

    public boolean isAnnotation(int n) {
        try {
            BaseDocument baseDocument = this.getDocument();
            int n2 = Utilities.getFirstNonWhiteBwd((BaseDocument)baseDocument, (int)n);
            int n3 = 42;
            while (n2 > -1 && (n3 = baseDocument.getChars(n2, 1)[0]) == 46) {
                if ((n2 = Utilities.getFirstNonWhiteBwd((BaseDocument)baseDocument, (int)n2)) > -1) {
                    n2 = Utilities.getPreviousWord((BaseDocument)baseDocument, (int)n2);
                }
                if (n2 <= -1) continue;
                n2 = Utilities.getFirstNonWhiteBwd((BaseDocument)baseDocument, (int)n2);
            }
            if (n2 > -1 && n3 == 64) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    public int[] getFunctionBlock(int[] nArray) throws BadLocationException {
        int[] nArray2 = super.getFunctionBlock(nArray);
        if (!this.isAnnotation(nArray[0])) {
            return nArray2;
        }
        return null;
    }

    protected ExtSyntaxSupport.DeclarationTokenProcessor createDeclarationTokenProcessor(String string, int n, int n2) {
        return this.java15 ? new JavaDeclarationProcessor(this, string) : new JavaDeclarationTokenProcessor(this, string);
    }

    protected ExtSyntaxSupport.VariableMapTokenProcessor createVariableMapTokenProcessor(int n, int n2) {
        return this.java15 ? new JavaDeclarationProcessor(this, null) : new JavaDeclarationTokenProcessor(this, null);
    }

    private boolean insideMethod(JTextComponent jTextComponent, int n) {
        try {
            int n2 = 0;
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            for (int i = n - 1; i > 0; --i) {
                char c = baseDocument.getChars(i, 1)[0];
                if (c == ';') {
                    return false;
                }
                if (c == ')') {
                    ++n2;
                }
                if (c != '(') continue;
                if (n2 == 0) {
                    return true;
                }
                --n2;
            }
            return false;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public int checkCompletion(JTextComponent jTextComponent, String string, boolean bl) {
        if (!bl) {
            int n = jTextComponent.getCaret().getDot();
            switch (string.charAt(0)) {
                case ' ': {
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    if (n < 2) break;
                    int n2 = Math.max(n - 8, 0);
                    try {
                        String string2 = baseDocument.getText(n2, n - n2);
                        if (string2.endsWith("import ") && !Character.isJavaIdentifierPart(string2.charAt(0))) {
                            return 0;
                        }
                        if (string2.endsWith(", ") && this.insideMethod(jTextComponent, n)) {
                            return 0;
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                    break;
                }
                case '.': {
                    return 0;
                }
                case ',': {
                    if (this.insideMethod(jTextComponent, n)) {
                        return 0;
                    }
                }
                default: {
                    if (!Character.isJavaIdentifierStart(string.charAt(0)) || n < 5) break;
                    try {
                        String string3 = jTextComponent.getDocument().getText(n - 5, 4);
                        if (string3.equals("new ")) {
                            return 0;
                        }
                        break;
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            return 1;
        }
        switch (string.charAt(0)) {
            case ';': 
            case '=': 
            case '{': {
                return 4;
            }
        }
        return 3;
    }

    public boolean isAssignable(JCType jCType, JCType jCType2) {
        JCClass jCClass = jCType.getClazz();
        JCClass jCClass2 = jCType2.getClazz();
        if (jCClass.equals(JavaCompletion.NULL_CLASS)) {
            return jCType2.getArrayDepth() > 0 || !JavaCompletion.isPrimitiveClass(jCClass2);
        }
        if (jCClass2.equals(JavaCompletion.OBJECT_CLASS)) {
            return jCType.getArrayDepth() > jCType2.getArrayDepth() || jCType.getArrayDepth() == jCType2.getArrayDepth() && !JavaCompletion.isPrimitiveClass(jCClass);
        }
        if (jCType.getArrayDepth() != jCType2.getArrayDepth()) {
            return false;
        }
        if (jCClass.equals(jCClass2)) {
            return true;
        }
        if (jCClass.isInterface()) {
            return jCClass2.isInterface() && JCUtilities.getAllInterfaces(this.getFinder(), jCClass).indexOf(jCClass2) >= 0;
        }
        TokenID tokenID = JavaTokenContext.getKeyword(jCClass.getName());
        if (tokenID != null) {
            TokenID tokenID2 = JavaTokenContext.getKeyword(jCClass2.getName());
            return tokenID2 != null && JCUtilities.getPrimitivesAssignable(tokenID.getNumericID(), tokenID2.getNumericID());
        }
        if (jCClass2.isInterface()) {
            return JCUtilities.getAllInterfaces(this.getFinder(), jCClass).indexOf(jCClass2) >= 0;
        }
        return JCUtilities.getSuperclasses(this.getFinder(), jCClass).indexOf(jCClass2) >= 0;
    }

    public JCType getCommonType(JCType jCType, JCType jCType2) {
        if (jCType.equals(jCType2)) {
            return jCType;
        }
        TokenID tokenID = JavaTokenContext.getKeyword(jCType.getClazz().getName());
        TokenID tokenID2 = JavaTokenContext.getKeyword(jCType2.getClazz().getName());
        if (tokenID == null && tokenID2 == null) {
            if (this.isAssignable(jCType, jCType2)) {
                return jCType;
            }
            if (this.isAssignable(jCType2, jCType)) {
                return jCType2;
            }
            return null;
        }
        if (jCType.getArrayDepth() != jCType2.getArrayDepth()) {
            return null;
        }
        if (tokenID != null && tokenID2 != null) {
            return JavaCompletion.getType(JCUtilities.getPrimitivesCommonClass(tokenID.getNumericID(), tokenID2.getNumericID()), jCType.getArrayDepth());
        }
        return null;
    }

    public List filterMethods(List list, List list2, boolean bl) {
        if (list2 == null) {
            return list;
        }
        ArrayList<JCConstructor> arrayList = new ArrayList<JCConstructor>();
        int n = list2.size();
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            JCConstructor jCConstructor = (JCConstructor)list.get(i);
            JCParameter[] jCParameterArray = jCConstructor.getParameters();
            if (jCParameterArray.length != n && (!bl || jCParameterArray.length < n)) continue;
            boolean bl2 = true;
            boolean bl3 = !bl;
            for (int j = 0; bl2 && j < n; ++j) {
                JCType jCType = jCParameterArray[j].getType();
                JCType jCType2 = (JCType)list2.get(j);
                if (jCType2 != null) {
                    if (jCType2.equals(jCType)) continue;
                    bl3 = false;
                    if (this.isAssignable(jCType2, jCType)) continue;
                    bl2 = false;
                    break;
                }
                bl3 = false;
            }
            if (!bl2) continue;
            if (bl3) {
                arrayList.clear();
            }
            arrayList.add(jCConstructor);
            if (bl3) break;
        }
        return arrayList;
    }

    protected boolean isAbbrevDisabled(int n) {
        boolean bl = false;
        TokenID[] tokenIDArray = BRACKET_SKIP_TOKENS;
        if (tokenIDArray != null) {
            TokenItem tokenItem;
            try {
                tokenItem = this.getTokenChain(n, n + 1);
            }
            catch (BadLocationException badLocationException) {
                tokenItem = null;
            }
            if (tokenItem != null) {
                TokenItem tokenItem2;
                if (n > tokenItem.getOffset()) {
                    for (int i = tokenIDArray.length - 1; i >= 0; --i) {
                        if (tokenItem.getTokenID() != tokenIDArray[i]) continue;
                        bl = true;
                        break;
                    }
                }
                if (!bl && tokenItem.getOffset() == n && (tokenItem2 = tokenItem.getPrevious()) != null && tokenItem2.getTokenID() == JavaTokenContext.LINE_COMMENT) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public boolean isCompletionDisabled(int n) {
        boolean bl = false;
        TokenID[] tokenIDArray = BRACKET_SKIP_TOKENS;
        if (tokenIDArray != null) {
            TokenItem tokenItem;
            try {
                tokenItem = this.getTokenChain(n, n + 1);
            }
            catch (BadLocationException badLocationException) {
                tokenItem = null;
            }
            if (tokenItem != null) {
                TokenItem tokenItem2;
                if (n > tokenItem.getOffset()) {
                    for (int i = tokenIDArray.length - 1; i >= 0; --i) {
                        if (tokenItem.getTokenID() != tokenIDArray[i]) continue;
                        bl = true;
                        break;
                    }
                }
                if (!(bl || tokenItem.getOffset() != n || (tokenItem2 = tokenItem.getPrevious()) == null || tokenItem2.getTokenID() != JavaTokenContext.LINE_COMMENT && tokenItem2.getTokenID() != JavaTokenContext.FLOAT_LITERAL && tokenItem2.getTokenID() != JavaTokenContext.DOUBLE_LITERAL)) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static class JavaDeclarationTokenProcessor
    implements ExtSyntaxSupport.DeclarationTokenProcessor,
    ExtSyntaxSupport.VariableMapTokenProcessor {
        protected JavaSyntaxSupport sup;
        protected int decStartPos = -1;
        protected int decArrayDepth;
        protected int typeStartPos;
        protected int typeEndPos;
        protected int decVarNameOffset;
        protected int decVarNameLen;
        protected int parenthesisCounter;
        protected int arrayDepth;
        protected char[] buffer;
        protected int bufferStartPos;
        protected String varName;
        protected int state;
        protected HashMap varMap;

        public JavaDeclarationTokenProcessor(JavaSyntaxSupport javaSyntaxSupport, String string) {
            this.sup = javaSyntaxSupport;
            this.varName = string;
            if (string == null) {
                this.varMap = new HashMap();
            }
        }

        public int getDeclarationPosition() {
            return this.decStartPos;
        }

        public Map getVariableMap() {
            return this.varMap;
        }

        protected void processDeclaration() {
            if (this.varName == null) {
                Object object;
                String string = new String(this.buffer, this.typeStartPos - this.bufferStartPos, this.typeEndPos - this.typeStartPos);
                if (string.indexOf(32) >= 0) {
                    string = Analyzer.removeSpaces((String)string);
                }
                String string2 = new String(this.buffer, this.decVarNameOffset, this.decVarNameLen);
                JCClass jCClass = null;
                JCClass jCClass2 = this.sup.getClass(this.decVarNameOffset);
                if (jCClass2 != null) {
                    object = jCClass2.getFullName();
                    jCClass = this.sup.getFinder().getExactClass((String)object + "." + string);
                    if (jCClass != null) {
                        this.varMap.put(string2, JavaCompletion.getType(jCClass, this.decArrayDepth));
                    }
                }
                if (jCClass == null && (object = this.sup.getClassFromName(string, true)) != null) {
                    this.varMap.put(string2, JavaCompletion.getType((JCClass)object, this.decArrayDepth));
                }
            } else {
                this.decStartPos = this.typeStartPos;
            }
        }

        public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
            int n3 = this.bufferStartPos + n;
            if (!tokenContextPath.contains(JavaTokenContext.contextPath)) {
                this.state = 0;
                return true;
            }
            block0 : switch (tokenID.getNumericID()) {
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: {
                    this.typeStartPos = n3;
                    this.arrayDepth = 0;
                    this.typeEndPos = n3 + n2;
                    this.state = 1;
                    break;
                }
                case 48: {
                    switch (this.state) {
                        case 1: {
                            this.state = 4;
                            this.typeEndPos = n3 + n2;
                            break block0;
                        }
                        case 2: 
                        case 8: {
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 124: {
                    switch (this.state) {
                        case 1: {
                            ++this.arrayDepth;
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 55: {
                    switch (this.state) {
                        case 1: {
                            this.state = 5;
                            ++this.arrayDepth;
                            break block0;
                        }
                        case 7: {
                            this.state = 6;
                            ++this.decArrayDepth;
                            break block0;
                        }
                        case 8: {
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 56: {
                    switch (this.state) {
                        case 5: {
                            this.state = 1;
                            break block0;
                        }
                        case 6: {
                            this.state = 7;
                            break block0;
                        }
                        case 8: {
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 53: {
                    ++this.parenthesisCounter;
                    if (this.state == 8) break;
                    this.state = 0;
                    break;
                }
                case 54: {
                    if (this.state == 7) {
                        this.processDeclaration();
                    }
                    if (this.parenthesisCounter > 0) {
                        --this.parenthesisCounter;
                    }
                    if (this.state == 8) break;
                    this.state = 0;
                    break;
                }
                case 57: 
                case 58: {
                    if (this.parenthesisCounter > 0) {
                        --this.parenthesisCounter;
                    }
                    this.state = 0;
                    break;
                }
                case 49: {
                    if (this.parenthesisCounter > 0) {
                        if (this.parenthesisCounter == 1 && this.state == 7) {
                            this.processDeclaration();
                        }
                        if (this.state == 8) break;
                        this.state = 0;
                        break;
                    }
                    switch (this.state) {
                        case 7: {
                            this.processDeclaration();
                        }
                        case 2: 
                        case 8: {
                            this.state = 3;
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 96: {
                    if (this.state == 8) break;
                    this.state = 0;
                    break;
                }
                case 17: {
                    switch (this.state) {
                        case 7: {
                            this.processDeclaration();
                        }
                        case 2: {
                            this.state = 8;
                            break block0;
                        }
                        case 8: {
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 51: {
                    if (this.state == 7) {
                        this.processDeclaration();
                    }
                    this.state = 0;
                    break;
                }
                case 6: {
                    switch (this.state) {
                        case 1: 
                        case 3: {
                            if (this.varName == null || Analyzer.equals((String)this.varName, (char[])this.buffer, (int)n, (int)n2)) {
                                this.decArrayDepth = this.arrayDepth;
                                this.decVarNameOffset = n;
                                this.decVarNameLen = n2;
                                this.state = 7;
                                break block0;
                            }
                            this.state = 2;
                            break block0;
                        }
                        case 2: {
                            this.state = 0;
                            break block0;
                        }
                        case 8: {
                            break block0;
                        }
                        case 4: {
                            this.typeEndPos = n3 + n2;
                            this.state = 1;
                            break block0;
                        }
                        case 0: {
                            this.typeStartPos = n3;
                            this.arrayDepth = 0;
                            this.typeEndPos = n3 + n2;
                            this.state = 1;
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 5: {
                    break;
                }
                case 50: {
                    this.processDeclaration();
                }
                default: {
                    this.state = 0;
                }
            }
            return true;
        }

        public int eot(int n) {
            return 0;
        }

        public void nextBuffer(char[] cArray, int n, int n2, int n3, int n4, boolean bl) {
            this.buffer = cArray;
            this.bufferStartPos = n3 - n;
        }
    }

    public static interface OffsetJavaVariable
    extends JavaVariable {
        public int getOffset();
    }

    public static interface JavaVariable {
        public JCExpression getTypeExpression();

        public JCExpression getVariableExpression();
    }
}

