/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor.mimelookup;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.editor.mimelookup.OldProxyLookup;
import org.netbeans.spi.editor.mimelookup.MimeLookupInitializer;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakSet;

public final class MimeLookup
extends Lookup {
    private static DelegatingResult rootInitializers;
    private static final Map mime2lookup;
    private MimeLookup parent;
    private DelegatorLookup delegator;
    private final List initializersListeners = new ArrayList();
    private final List initializersList = new ArrayList();
    private final Map mime2childLookup = new HashMap();

    private MimeLookup(MimeLookup mimeLookup, String string) {
        this.parent = mimeLookup;
        this.delegator = new DelegatorLookup();
        this.initMimeLookup(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MimeLookup getMimeLookup(String string) {
        MimeLookup mimeLookup;
        if (string == null) {
            throw new NullPointerException("mimeType must not be null");
        }
        Map map = mime2lookup;
        synchronized (map) {
            Reference reference = (Reference)mime2lookup.get(string);
            MimeLookup mimeLookup2 = mimeLookup = reference == null ? null : (MimeLookup)((Object)reference.get());
            if (mimeLookup == null) {
                mimeLookup = new MimeLookup(null, string);
                mime2lookup.put(string, new WeakReference<MimeLookup>(mimeLookup));
            }
        }
        return mimeLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimeLookup childLookup(String string) {
        MimeLookup mimeLookup;
        if (string == null) {
            throw new NullPointerException("mimeType must not be null");
        }
        Map map = this.mime2childLookup;
        synchronized (map) {
            Reference reference = (Reference)this.mime2childLookup.get(string);
            MimeLookup mimeLookup2 = mimeLookup = reference == null ? null : (MimeLookup)((Object)reference.get());
            if (mimeLookup == null) {
                mimeLookup = new MimeLookup(this, string);
                this.mime2childLookup.put(string, new WeakReference<MimeLookup>(mimeLookup));
            }
        }
        return mimeLookup;
    }

    public Object lookup(Class clazz) {
        return this.delegator.lookup(clazz);
    }

    public Lookup.Result lookup(Lookup.Template template) {
        return this.delegator.lookup(template);
    }

    private void initMimeLookup(String string) {
        Iterator iterator;
        Iterator iterator2 = iterator = this.parent == null ? MimeLookup.getRootInitializers().allInstances().iterator() : this.parent.initializersList.iterator();
        while (iterator.hasNext()) {
            MimeLookupInitializer mimeLookupInitializer = (MimeLookupInitializer)iterator.next();
            Lookup.Result result = mimeLookupInitializer.child(string);
            Iterator iterator3 = result.allInstances().iterator();
            while (iterator3.hasNext()) {
                this.initializersList.add(iterator3.next());
            }
            this.initializersListeners.add(new InitializersListener(result));
        }
        if (this.parent == null) {
            this.initializersListeners.add(new InitializersListener(rootInitializers));
        }
        this.rebuildLookups();
    }

    private static DelegatingResult getRootInitializers() {
        if (rootInitializers == null) {
            rootInitializers = new DelegatingResult(Lookup.getDefault().lookup(new Lookup.Template(MimeLookupInitializer.class)));
        }
        return rootInitializers;
    }

    private void rebuildLookups() {
        ArrayList arrayList = new ArrayList();
        Lookup[] lookupArray = this.initializersListeners.iterator();
        while (lookupArray.hasNext()) {
            InitializersListener initializersListener = (InitializersListener)lookupArray.next();
            arrayList.addAll(initializersListener.getLookups());
        }
        lookupArray = new Lookup[arrayList.size()];
        arrayList.toArray(lookupArray);
        this.delegator.setDelegatorLookups(lookupArray);
    }

    static {
        mime2lookup = new HashMap();
    }

    private final class InitializersListener
    implements LookupListener {
        private Lookup.Result initializersResult;
        private List lookupList = Collections.EMPTY_LIST;
        private Map initializer2lookup = new HashMap();

        public InitializersListener(Lookup.Result result) {
            this.initializersResult = result;
            result.addLookupListener((LookupListener)this);
            this.rebuild(result.allInstances());
        }

        public synchronized List getLookups() {
            return this.lookupList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rebuild(Collection collection) {
            ArrayList<Lookup> arrayList = new ArrayList<Lookup>();
            this.initializer2lookup.keySet().retainAll(collection);
            Object object = collection.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                this.initializer2lookup.remove(e);
                Lookup lookup = ((MimeLookupInitializer)e).lookup();
                if (lookup == null) continue;
                this.initializer2lookup.put(e, lookup);
                arrayList.add(lookup);
            }
            object = this;
            synchronized (object) {
                this.lookupList = arrayList;
            }
        }

        public void resultChanged(LookupEvent lookupEvent) {
            Lookup.Result result = (Lookup.Result)lookupEvent.getSource();
            this.rebuild(result.allInstances());
            MimeLookup.this.rebuildLookups();
        }
    }

    private class DelegatorLookup
    extends OldProxyLookup {
        public void setDelegatorLookups(Lookup[] lookupArray) {
            this.setLookups(lookupArray);
        }
    }

    private static class DelegatingResult
    extends Lookup.Result {
        private final Lookup.Result delegator;
        private final Set listeners = new WeakSet(10);

        public DelegatingResult(Lookup.Result result) {
            this.delegator = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLookupListener(LookupListener lookupListener) {
            Set set = this.listeners;
            synchronized (set) {
                this.listeners.remove(lookupListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLookupListener(LookupListener lookupListener) {
            Set set = this.listeners;
            synchronized (set) {
                this.listeners.add(lookupListener);
            }
        }

        public Collection allInstances() {
            return this.delegator.allInstances();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged() {
            LookupListener[] lookupListenerArray;
            Set set = this.listeners;
            synchronized (set) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                lookupListenerArray = this.listeners.toArray(new LookupListener[this.listeners.size()]);
            }
            set = new LookupEvent((Lookup.Result)this);
            for (int i = 0; i < lookupListenerArray.length; ++i) {
                lookupListenerArray[i].resultChanged((LookupEvent)set);
            }
        }
    }
}

