/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.netbeans.modules.editor.mimelookup.CompositeLayerFolderLookup;
import org.netbeans.spi.editor.mimelookup.InstanceProvider;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class LayerFolderObjectsProvider {
    private static final boolean debugFoldersListening = Boolean.getBoolean("netbeans.debug.editor.mimelookup.mimefolders.listening");
    private String suffixFolder;
    private Class clazz;
    private InstanceProvider instanceProvider;
    private Map mimePath2folderObjectsResults = new HashMap();

    public LayerFolderObjectsProvider() {
    }

    public LayerFolderObjectsProvider(String string, Class clazz, InstanceProvider instanceProvider) {
        this.suffixFolder = string;
        this.clazz = clazz;
        this.instanceProvider = instanceProvider;
    }

    public Class getClazz() {
        return this.clazz;
    }

    private DataFolder getDataFolder(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (dataObject instanceof DataFolder) {
                return (DataFolder)dataObject;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private Lookup.Result getLookupResult(String[] stringArray) {
        String string = this.mimePath2String(stringArray, true, true);
        FileObject fileObject = this.getExistingParentFolder(string);
        DataFolder dataFolder = this.getDataFolder(fileObject);
        if (dataFolder == null) {
            return null;
        }
        List list = new ArrayList();
        list = this.getInheritedFolders(stringArray);
        CompositeLayerFolderLookup compositeLayerFolderLookup = new CompositeLayerFolderLookup(this.instanceProvider, list);
        Lookup.Result result = compositeLayerFolderLookup.lookup(new Lookup.Template(this.clazz));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup.Result folderObjects(String[] stringArray) {
        String string = this.mimePath2String(stringArray, true, true);
        Map map = this.mimePath2folderObjectsResults;
        synchronized (map) {
            Lookup.Result result = (Lookup.Result)this.mimePath2folderObjectsResults.get(string);
            if (result != null) {
                return result;
            }
            result = string.indexOf("+") > 0 ? new CompoundDelegatingLookupResult(stringArray) : new DelegatingLookupResult(stringArray);
            this.mimePath2folderObjectsResults.put(string, result);
            return result;
        }
    }

    private List getInheritedFolders(String[] stringArray) {
        DataFolder dataFolder;
        ArrayList<DataFolder> arrayList = new ArrayList<DataFolder>();
        for (int i = 0; i < stringArray.length; ++i) {
            dataFolder = new String[stringArray.length - i];
            System.arraycopy(stringArray, 0, dataFolder, 0, ((String[])dataFolder).length);
            String string = this.mimePath2String((String[])dataFolder, true, true);
            DataFolder dataFolder2 = this.getDataFolder(this.getLayerFolder(string));
            if (dataFolder2 == null) continue;
            arrayList.add(dataFolder2);
        }
        FileObject fileObject = this.getLayerFolder(this.mimePath2String(new String[0], true, true));
        dataFolder = this.getDataFolder(fileObject);
        if (dataFolder != null) {
            arrayList.add(dataFolder);
        }
        return arrayList;
    }

    private FileObject getLayerFolder(String string) {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(string);
        if (fileObject == null || fileObject.isData() || !fileObject.isValid() || fileObject.isVirtual()) {
            return null;
        }
        return fileObject;
    }

    private String mimePath2String(String[] stringArray, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("Editors/");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append("/");
        }
        if (bl2 && this.suffixFolder != null) {
            String string = stringArray.length > 0 ? "/" : "";
            stringBuffer.append(string + this.suffixFolder);
        }
        return stringBuffer.toString();
    }

    private FileObject getExistingParentFolder(String string) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        int n2 = stringTokenizer.countTokens();
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = n > 0 ? stringArray[n - 1] + "/" + stringTokenizer.nextToken() : stringTokenizer.nextToken();
        }
        for (n = stringArray.length - 1; n >= 0; --n) {
            FileObject fileObject = this.getLayerFolder(stringArray[n]);
            if (fileObject == null) continue;
            return fileObject;
        }
        return null;
    }

    private class CompoundDelegatingLookupResult
    extends Lookup.Result {
        private String[] mimePath;
        private List delegators = new ArrayList();

        public CompoundDelegatingLookupResult(String[] stringArray) {
            this.mimePath = stringArray;
            List list = this.getPaths(stringArray);
            for (int i = 0; i < list.size(); ++i) {
                String[] stringArray2 = (String[])list.get(i);
                this.delegators.add(new DelegatingLookupResult(stringArray2));
            }
        }

        public synchronized void addLookupListener(LookupListener lookupListener) {
            Iterator iterator = this.delegators.iterator();
            while (iterator.hasNext()) {
                DelegatingLookupResult delegatingLookupResult = (DelegatingLookupResult)iterator.next();
                delegatingLookupResult.addLookupListener(lookupListener);
            }
        }

        public synchronized void removeLookupListener(LookupListener lookupListener) {
            Iterator iterator = this.delegators.iterator();
            while (iterator.hasNext()) {
                DelegatingLookupResult delegatingLookupResult = (DelegatingLookupResult)iterator.next();
                delegatingLookupResult.removeLookupListener(lookupListener);
            }
        }

        public synchronized Collection allInstances() {
            DataFolder dataFolder;
            Object object;
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.delegators.iterator();
            while (iterator.hasNext()) {
                object = (DelegatingLookupResult)iterator.next();
                dataFolder = LayerFolderObjectsProvider.this.getDataFolder(LayerFolderObjectsProvider.this.getExistingParentFolder(((DelegatingLookupResult)object).path));
                if (dataFolder == null) continue;
                List list = LayerFolderObjectsProvider.this.getInheritedFolders(((DelegatingLookupResult)object).mimePath);
                for (int i = 0; i < list.size(); ++i) {
                    Object e = list.get(i);
                    if (arrayList.contains(e)) continue;
                    arrayList.add(e);
                }
            }
            object = new CompositeLayerFolderLookup(LayerFolderObjectsProvider.this.instanceProvider, arrayList);
            dataFolder = object.lookup(new Lookup.Template(LayerFolderObjectsProvider.this.clazz));
            return dataFolder.allInstances();
        }

        public List getPaths(String[] stringArray) {
            Object object = new ArrayList<String[]>();
            object.add(new String[0]);
            for (int i = 0; i < stringArray.length; ++i) {
                Object object2;
                Object object3;
                String string = null;
                int n = stringArray[i].indexOf("+");
                int n2 = stringArray[i].indexOf("/");
                if (n > 0) {
                    object3 = stringArray[i].substring(0, n2 + 1);
                    object2 = stringArray[i].substring(n + 1);
                    if (object2 != null && "xml".equals(((String)object2).toLowerCase())) {
                        object3 = "text/";
                    }
                    string = (String)object3 + (String)object2;
                }
                object3 = new ArrayList();
                for (int j = 0; j < object.size(); ++j) {
                    String[] stringArray2 = (String[])object.get(j);
                    int n3 = stringArray2.length;
                    String[] stringArray3 = new String[n3 + 1];
                    System.arraycopy(stringArray2, 0, stringArray3, 0, n3);
                    stringArray3[n3] = stringArray[i];
                    object3.add(stringArray3);
                }
                object2 = new ArrayList();
                if (string != null) {
                    for (int j = 0; j < object.size(); ++j) {
                        String[] stringArray4 = (String[])object.get(j);
                        int n4 = stringArray4.length;
                        String[] stringArray5 = new String[n4 + 1];
                        System.arraycopy(stringArray4, 0, stringArray5, 0, n4);
                        stringArray5[n4] = string;
                        object2.add(stringArray5);
                    }
                }
                object = object3;
                object.addAll(object2);
            }
            return object;
        }
    }

    private class ParentFolderListener
    extends FileChangeAdapter {
        ParentFolderNotificator notificator;
        String path;

        public ParentFolderListener(ParentFolderNotificator parentFolderNotificator, String string) {
            this.notificator = parentFolderNotificator;
            this.path = string;
        }

        public void fileDeleted(FileEvent fileEvent) {
            FileObject fileObject;
            if (debugFoldersListening) {
                System.out.println("");
                System.out.println("ParentFolderListener.fileDeleted:" + fileEvent.getFile());
            }
            if ((fileObject = fileEvent.getFile()) == null || !fileObject.isFolder()) {
                if (debugFoldersListening) {
                    System.out.println("    - not a folder, ignore");
                }
                return;
            }
            if (this.path.equals(fileObject.getPath())) {
                if (debugFoldersListening) {
                    System.out.println("    - folder on which we were listening has been removed:" + this.path);
                }
                this.notificator.folderDeleted(fileObject);
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            FileObject fileObject;
            if (debugFoldersListening) {
                System.out.println("");
                System.out.println("ParentFolderListener.fileFolderCreated:" + fileEvent.getFile());
            }
            if ((fileObject = fileEvent.getFile()) == null || !fileObject.isFolder()) {
                if (debugFoldersListening) {
                    System.out.println("    - not a folder, ignore");
                }
                return;
            }
            this.notificator.folderCreated(fileObject);
        }
    }

    private static interface ParentFolderNotificator {
        public void folderCreated(FileObject var1);

        public void folderDeleted(FileObject var1);
    }

    private class DelegatingLookupResult
    extends Lookup.Result
    implements ParentFolderNotificator {
        private String[] mimePath;
        private Lookup.Result delegator;
        private ParentFolderListener parentFolderListener;
        private final String path;
        private String lastAttachedListenerPath = null;
        private WeakHashMap listeners = new WeakHashMap();

        public DelegatingLookupResult(String[] stringArray) {
            this.path = LayerFolderObjectsProvider.this.mimePath2String(stringArray, true, true);
            this.delegator = LayerFolderObjectsProvider.this.getLookupResult(stringArray);
            this.mimePath = stringArray;
            this.attachFolderListener(this.path);
        }

        public void folderCreated(FileObject fileObject) {
            List list;
            fileObject = LayerFolderObjectsProvider.this.getExistingParentFolder(this.path);
            Lookup.Result result = this.delegator;
            this.delegator = LayerFolderObjectsProvider.this.getLookupResult(this.mimePath);
            if (debugFoldersListening) {
                System.out.println("    *** delegator created for:" + fileObject);
            }
            if ((list = (List)this.listeners.get(result)) != null) {
                for (int i = 0; i < list.size(); ++i) {
                    LookupListener lookupListener = (LookupListener)list.get(i);
                    result.removeLookupListener(lookupListener);
                    this.delegator.addLookupListener(lookupListener);
                }
            }
            this.listeners.remove(result);
            this.listeners.put(this.delegator, list);
            result = null;
            this.fireResultChanged(new LookupEvent((Lookup.Result)this));
            this.attachFolderListener(this.path);
        }

        public void folderDeleted(FileObject fileObject) {
            Lookup.Result result = this.delegator;
            this.delegator = LayerFolderObjectsProvider.this.getLookupResult(this.mimePath);
            List list = (List)this.listeners.get(result);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    LookupListener lookupListener = (LookupListener)list.get(i);
                    result.removeLookupListener(lookupListener);
                    this.delegator.addLookupListener(lookupListener);
                }
            }
            this.listeners.remove(result);
            this.listeners.put(this.delegator, list);
            result = null;
            this.fireResultChanged(new LookupEvent((Lookup.Result)this));
            if (debugFoldersListening) {
                System.out.println("    *** delegator disposed, acting as FAKE lookup result");
            }
            this.attachFolderListener(this.path);
        }

        private void fireResultChanged(LookupEvent lookupEvent) {
            List list;
            if (this.delegator != null && (list = (List)this.listeners.get(this.delegator)) != null) {
                for (int i = 0; i < list.size(); ++i) {
                    LookupListener lookupListener = (LookupListener)list.get(i);
                    lookupListener.resultChanged(lookupEvent);
                }
            }
        }

        private synchronized void attachFolderListener(String string) {
            FileObject fileObject;
            if (this.lastAttachedListenerPath != null && (fileObject = LayerFolderObjectsProvider.this.getLayerFolder(this.lastAttachedListenerPath)) != null) {
                if (debugFoldersListening) {
                    System.out.println("remove PREVIOUSLY ATTACHED and now not needed parentFolderListener from:" + fileObject);
                }
                fileObject.removeFileChangeListener((FileChangeListener)this.parentFolderListener);
            }
            if ((fileObject = LayerFolderObjectsProvider.this.getExistingParentFolder(string)) == null) {
                return;
            }
            this.parentFolderListener = new ParentFolderListener(this, fileObject.getPath());
            if (debugFoldersListening) {
                System.out.println("");
                System.out.println("attaching parentFolderListener to existingParent:" + fileObject);
                System.out.println("for global path:" + string);
            }
            fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.parentFolderListener, (Object)fileObject));
            this.lastAttachedListenerPath = fileObject.getPath();
        }

        public synchronized void addLookupListener(LookupListener lookupListener) {
            this.delegator.addLookupListener(lookupListener);
            ArrayList<LookupListener> arrayList = (ArrayList<LookupListener>)this.listeners.get(this.delegator);
            if (arrayList == null) {
                arrayList = new ArrayList<LookupListener>();
            }
            arrayList.add(lookupListener);
            this.listeners.remove(this.delegator);
            this.listeners.put(this.delegator, arrayList);
        }

        public synchronized void removeLookupListener(LookupListener lookupListener) {
            this.delegator.removeLookupListener(lookupListener);
            List list = (List)this.listeners.get(this.delegator);
            if (list != null) {
                list.remove(lookupListener);
            }
            this.listeners.remove(this.delegator);
            this.listeners.put(this.delegator, list);
        }

        public Collection allInstances() {
            if (this.delegator != null) {
                return this.delegator.allInstances();
            }
            return Collections.EMPTY_LIST;
        }

        public Collection allItems() {
            if (this.delegator != null) {
                return this.delegator.allItems();
            }
            return Collections.EMPTY_LIST;
        }

        public Set allClasses() {
            if (this.delegator != null) {
                return this.delegator.allClasses();
            }
            return Collections.EMPTY_SET;
        }
    }
}

