/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

public class MimeLookupUtils {
    private static final boolean debugSort = Boolean.getBoolean("netbeans.debug.editor.mimelookup.utils.sort.debug");
    private static List hidden = new ArrayList();

    private MimeLookupUtils() {
    }

    public static List mergeObjects(List list) {
        Object object;
        int n;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        hidden.clear();
        for (n = 0; n < list.size(); ++n) {
            object = (DataFolder)list.get(n);
            MimeLookupUtils.addDataObjects(hashMap, object.getChildren());
        }
        for (n = 0; n < list.size(); ++n) {
            object = (DataFolder)list.get(n);
            MimeLookupUtils.addEdges(hashMap2, hashMap, object);
        }
        try {
            return Utilities.topologicalSort(hashMap.values(), hashMap2);
        }
        catch (TopologicalSortException topologicalSortException) {
            object = topologicalSortException.partialSort();
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.log(16, "Note: MimeLookup objects cannot be consistently sorted due to ordering conflicts.");
            errorManager.notify(1, (Throwable)topologicalSortException);
            errorManager.log(16, "Using partial sort: " + object);
            return object;
        }
    }

    private static void addDataObjects(Map map, DataObject[] dataObjectArray) {
        int n = dataObjectArray.length;
        for (int i = 0; i < n; ++i) {
            DataObject dataObject = dataObjectArray[i];
            String string = dataObject.getPrimaryFile().getNameExt();
            if (string != null && string.endsWith("_hidden")) {
                String string2 = string.substring(0, string.indexOf("_hidden"));
                hidden.add(string2);
                continue;
            }
            if (MimeLookupUtils.isHidden(dataObject.getPrimaryFile())) {
                hidden.add(string);
                continue;
            }
            if (hidden.contains(string)) continue;
            if (dataObject instanceof DataFolder) {
                map.put(dataObject.getPrimaryFile().getPath(), dataObject);
                continue;
            }
            map.put(string, dataObject);
        }
    }

    private static boolean isHidden(FileObject fileObject) {
        Enumeration enumeration = fileObject.getAttributes();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string = (String)enumeration.nextElement();
            if (!"hidden".equals(string) || !((object = fileObject.getAttribute(string)) instanceof Boolean) || !((Boolean)object).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static void addEdges(Map map, Map map2, DataFolder dataFolder) {
        FileObject fileObject = dataFolder.getPrimaryFile();
        String string = fileObject.getPath();
        Enumeration enumeration = fileObject.getAttributes();
        while (enumeration.hasMoreElements()) {
            Collection<DataObject> collection;
            Object object;
            DataObject dataObject;
            Object object2;
            String string2 = (String)enumeration.nextElement();
            int n = string2.indexOf("/");
            if (n == -1 || !((object2 = fileObject.getAttribute(string2)) instanceof Boolean) || !((Boolean)object2).booleanValue()) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            if (debugSort) {
                System.err.println("SORT-PAIR: [" + string3 + ", " + string4 + "]");
            }
            if ((dataObject = (DataObject)map2.get(string3)) == null) {
                object = string + "/" + string3;
                dataObject = (DataObject)map2.get(object);
            }
            if ((object = (DataObject)map2.get(string4)) == null) {
                collection = string + "/" + string3;
                object = (DataObject)map2.get(collection);
            }
            if (dataObject == null || object == null) continue;
            collection = (Collection)map.get(dataObject);
            if (collection == null) {
                collection = Collections.singletonList(object);
                map.put(dataObject, collection);
                continue;
            }
            if (collection.size() == 1) {
                collection = new HashSet<DataObject>(collection);
                collection.add((DataObject)object);
                map.put(dataObject, collection);
                continue;
            }
            collection.add((DataObject)object);
        }
    }
}

