/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.simpletype;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.simpletype.EncoderUtils;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoderBase;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class XSDDateTimeDateEncoder
extends SimpleTypeEncoderBase {
    private static final SimpleTypeEncoder encoder = new XSDDateTimeDateEncoder();
    protected static final Locale locale = new Locale("en_US");
    protected static final SimpleDateFormat timeZoneFormatter = new SimpleDateFormat("HH:mm", locale);
    protected static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
    protected static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", locale);

    static {
        dateFormatter.setTimeZone(gmtTimeZone);
        timeZoneFormatter.setTimeZone(gmtTimeZone);
    }

    protected XSDDateTimeDateEncoder() {
    }

    public static SimpleTypeEncoder getInstance() {
        return encoder;
    }

    public static void validateDateStr(String dateStr) throws Exception {
        if (dateStr.length() < 19) {
            throw new DeserializationException("xsd.invalid.date", dateStr);
        }
    }

    protected static String getDateFormatPattern(String xsdDateTime) {
        String formatPattern = "yyyy";
        int idx = xsdDateTime.indexOf(45, 4);
        int i = 4;
        while (i < idx) {
            formatPattern = formatPattern + "y";
            ++i;
        }
        formatPattern = formatPattern + "-MM-dd'T'HH:mm:ss";
        int i2 = idx = xsdDateTime.indexOf(46);
        while (i2 < xsdDateTime.length() - 1 && i2 < idx + 3) {
            if (!Character.isDigit(xsdDateTime.charAt(i2 + 1))) break;
            if (i2 == idx) {
                formatPattern = formatPattern + ".";
            }
            formatPattern = formatPattern + "S";
            ++i2;
        }
        return formatPattern;
    }

    protected static int getDateFormatPattern(String dateStr, StringBuffer strBuf) {
        String formatPattern = "yyyy";
        strBuf.append(formatPattern);
        int idx = dateStr.indexOf(45, 4);
        int i = 4;
        while (i < idx) {
            strBuf.append('y');
            ++i;
        }
        strBuf.append("-MM-dd'T'HH:mm:ss");
        int i2 = idx = dateStr.indexOf(46);
        while (idx > 0 && i2 < dateStr.length() - 1 && i2 < idx + 3) {
            if (!Character.isDigit(dateStr.charAt(i2 + 1))) break;
            if (i2 == idx) {
                strBuf.append('.');
            }
            strBuf.append('S');
            ++i2;
        }
        return strBuf.length() - 2;
    }

    public Object stringToObject(String str, XMLReader reader) throws Exception {
        if (str == null) {
            return null;
        }
        return XSDDateTimeDateEncoder.decodeDateUtil(str, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String objectToString(Object obj, XMLWriter writer) throws Exception {
        if (obj == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(gmtTimeZone);
        calendar.setTime((Date)obj);
        boolean isBC = calendar.get(0) == 0;
        StringBuffer buf = new StringBuffer();
        if (isBC) {
            calendar.set(0, 1);
            buf.append("-");
        }
        SimpleDateFormat simpleDateFormat = dateFormatter;
        synchronized (simpleDateFormat) {
            buf.append(dateFormatter.format(calendar.getTime()));
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Date decodeDateUtil(String str, StringBuffer zone) throws Exception {
        if (str == null) {
            return null;
        }
        str = EncoderUtils.collapseWhitespace(str);
        Calendar cal = Calendar.getInstance();
        boolean isNeg = false;
        if ((str = EncoderUtils.collapseWhitespace(str)).charAt(0) == '+') {
            str = str.substring(1);
        }
        if (str.charAt(0) == '-') {
            str = str.substring(1);
            isNeg = true;
        }
        XSDDateTimeDateEncoder.validateDateStr(str);
        StringBuffer strBuf = new StringBuffer(30);
        int dateLen = XSDDateTimeDateEncoder.getDateFormatPattern(str, strBuf);
        String pattern = strBuf.toString();
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        df.setTimeZone(gmtTimeZone);
        String tmp = str.substring(0, dateLen);
        Date date = df.parse(str.substring(0, dateLen));
        if (dateLen < str.length()) {
            int start = dateLen;
            if (Character.isDigit(str.charAt(start))) {
                int end = start;
                while (end < str.length() && Character.isDigit(str.charAt(end))) {
                    ++end;
                }
                String tmp2 = str.substring(start, start + 1);
                int fractmilli = Integer.parseInt(str.substring(start, start + 1));
                if (fractmilli >= 5) {
                    date.setTime(date.getTime() + 1L);
                }
                start = end;
            }
            if (start < str.length()) {
                if (str.charAt(start) != 'Z') {
                    Date tzOffset;
                    if (zone != null) {
                        zone.append(str.substring(start));
                    }
                    tmp = str.substring(start + 1);
                    SimpleDateFormat simpleDateFormat = timeZoneFormatter;
                    synchronized (simpleDateFormat) {
                        tzOffset = timeZoneFormatter.parse(str.substring(start + 1));
                    }
                    long millis = str.charAt(start) == '+' ? -tzOffset.getTime() : tzOffset.getTime();
                    date.setTime(date.getTime() + millis);
                } else if (str.charAt(start) == 'Z') {
                    cal.setTimeZone(gmtTimeZone);
                }
            }
        }
        if (isNeg) {
            cal.setTime(date);
            cal.set(0, 0);
            date = cal.getTime();
        }
        return date;
    }
}

