/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator.nodes;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.nodes.JaxRpcMappingNode;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServiceInterfaceMappingNode
extends JaxRpcMappingNode {
    private static final String MYNAME = "ServiceInterfaceMappingNode";

    public Node write(Node parent, String nodeName, Configuration config, Service service) throws Exception {
        Element node = JaxRpcMappingNode.appendChild(parent, nodeName);
        ProcessorEnvironment env = (ProcessorEnvironment)config.getEnvironment();
        QName serviceQName = service.getName();
        String serviceNS = serviceQName.getNamespaceURI();
        String serviceJavaName = env.getNames().customJavaTypeClassName(service.getJavaInterface());
        JaxRpcMappingNode.appendTextChild((Node)node, "service-interface", serviceJavaName);
        Element wsdlServiceName = (Element)JaxRpcMappingNode.appendTextChild((Node)node, "wsdl-service-name", "serviceNS:" + serviceQName.getLocalPart());
        wsdlServiceName.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:serviceNS", serviceNS);
        Iterator portIter = service.getPorts();
        while (portIter.hasNext()) {
            Port port = (Port)portIter.next();
            QName portQName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortName");
            String portName = portQName.getLocalPart();
            String portJavaName = Names.getPortName(port);
            Element portMappingNode = JaxRpcMappingNode.appendChild(node, "port-mapping");
            JaxRpcMappingNode.appendTextChild((Node)portMappingNode, "port-name", portName);
            JaxRpcMappingNode.appendTextChild((Node)portMappingNode, "java-port-name", portJavaName);
        }
        return node;
    }
}

