/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.sp;

import com.sun.xml.rpc.sp.ParseException;
import com.sun.xml.rpc.sp.Parser;
import com.sun.xml.rpc.sp.StreamingParser;
import com.sun.xml.rpc.sp.StreamingParserFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public final class StreamingParserImpl
extends StreamingParser {
    private Parser parser = null;
    private static final int DOC_END = -1;
    private static final int DOC_START = -2;
    private static final int EMPTY = -3;
    private static final int EXCEPTION = -4;
    private int cur = -3;
    private String curName = null;
    private String curValue = null;
    private String curURI = null;
    private boolean validating;
    private boolean coalescing;
    private boolean namespaceAware;
    private int curLine = -1;
    private int curCol = -1;
    private String publicId = null;
    private String systemId = null;

    public int column() {
        return this.curCol;
    }

    public int line() {
        return this.curLine;
    }

    public int parse() throws ParseException, IOException {
        if (this.cur == -1) {
            return -1;
        }
        this.cur = this.parser.parse();
        this.curName = this.parser.getCurName();
        this.curValue = this.parser.getCurValue();
        this.curURI = this.parser.getCurURI();
        this.curLine = this.parser.getLineNumber();
        this.curCol = this.parser.getColumnNumber();
        return this.cur;
    }

    public int state() {
        if (this.cur == -3) {
            throw new IllegalStateException("Parser not started");
        }
        if (this.cur < -1) {
            throw new InternalError();
        }
        return this.cur;
    }

    public boolean isCoalescing() {
        return this.coalescing;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    private StreamingParserImpl(StreamingParserFactory pf) {
        this.validating = pf.isValidating();
        this.coalescing = pf.isCoalescing();
        this.namespaceAware = pf.isNamespaceAware();
    }

    public String name() {
        if (this.curName == null) {
            throw new IllegalStateException("Name not defined in this state");
        }
        return this.curName;
    }

    public String publicId() {
        return this.publicId;
    }

    public String systemId() {
        return this.systemId;
    }

    public String uriString() {
        if (!this.namespaceAware) {
            return null;
        }
        if (this.curURI == null) {
            throw new IllegalStateException("Value not defined in this state");
        }
        return this.curURI;
    }

    public String value() {
        if (this.curValue == null) {
            throw new IllegalStateException("Value not defined in this state");
        }
        return this.curValue;
    }

    public String describe(boolean articleNeeded) {
        return StreamingParser.describe(this.cur, this.curName, this.curValue, articleNeeded);
    }

    StreamingParserImpl(StreamingParserFactory pf, File file) throws IOException {
        this(pf);
        this.parser = new Parser(file, this.coalescing, this.namespaceAware);
    }

    StreamingParserImpl(StreamingParserFactory pf, InputStream in) {
        this(pf);
        this.parser = new Parser(in, this.coalescing, this.namespaceAware);
    }
}

