/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.util.exception;

import com.sun.xml.rpc.util.exception.NestableExceptionSupport;
import com.sun.xml.rpc.util.localization.Localizable;
import com.sun.xml.rpc.util.localization.LocalizableSupport;
import com.sun.xml.rpc.util.localization.Localizer;
import java.io.PrintStream;
import java.io.PrintWriter;
import javax.xml.rpc.JAXRPCException;

public abstract class JAXRPCExceptionBase
extends JAXRPCException
implements Localizable {
    protected LocalizableSupport localizablePart;
    protected NestableExceptionSupport nestablePart = new NestableExceptionSupport();

    public JAXRPCExceptionBase() {
    }

    public void printStackTrace() {
        super.printStackTrace();
        this.nestablePart.printStackTrace();
    }

    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        this.nestablePart.printStackTrace(s);
    }

    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        this.nestablePart.printStackTrace(s);
    }

    public Object[] getArguments() {
        return this.localizablePart.getArguments();
    }

    public String getKey() {
        return this.localizablePart.getKey();
    }

    public String getMessage() {
        Localizer localizer = new Localizer();
        return localizer.localize(this);
    }

    public abstract String getResourceBundleName();

    public String toString() {
        return this.getMessage();
    }

    public JAXRPCExceptionBase(String key) {
        this();
        this.localizablePart = new LocalizableSupport(key);
    }

    public Throwable getLinkedException() {
        return this.nestablePart.getCause();
    }

    public JAXRPCExceptionBase(String key, Localizable localizable) {
        this(key, new Object[]{localizable});
    }

    protected JAXRPCExceptionBase(String key, Object[] args) {
        this();
        this.localizablePart = new LocalizableSupport(key, args);
        if (args != null && this.nestablePart.getCause() == null) {
            int i = 0;
            while (i < args.length) {
                if (args[i] instanceof Throwable) {
                    this.nestablePart.setCause((Throwable)args[i]);
                    break;
                }
                ++i;
            }
        }
    }

    public JAXRPCExceptionBase(String key, String arg) {
        this();
        this.localizablePart = new LocalizableSupport(key, arg);
    }
}

