/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.wsdl.framework;

import com.sun.xml.rpc.wsdl.framework.DuplicateEntityException;
import com.sun.xml.rpc.wsdl.framework.Entity;
import com.sun.xml.rpc.wsdl.framework.EntityAction;
import com.sun.xml.rpc.wsdl.framework.EntityReferenceValidator;
import com.sun.xml.rpc.wsdl.framework.GloballyKnown;
import com.sun.xml.rpc.wsdl.framework.Identifiable;
import com.sun.xml.rpc.wsdl.framework.Kind;
import com.sun.xml.rpc.wsdl.framework.NoSuchEntityException;
import com.sun.xml.rpc.wsdl.framework.QNameAction;
import com.sun.xml.rpc.wsdl.framework.ValidationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public abstract class AbstractDocument {
    private Map _kinds = new HashMap();
    private Map _identifiables = new HashMap();
    private String _systemId;
    private Set _importedDocuments;
    private List _importedEntities = new ArrayList();
    private Set _includedDocuments;
    private List _includedEntities;

    protected AbstractDocument() {
        this._importedDocuments = new HashSet();
        this._includedEntities = new ArrayList();
        this._includedDocuments = new HashSet();
    }

    public void validate() {
        this.validate(null);
    }

    public void validateLocally() {
        LocallyValidatingAction action = new LocallyValidatingAction();
        this.withAllSubEntitiesDo(action);
        if (action.getException() != null) {
            throw action.getException();
        }
    }

    protected abstract Entity getRoot();

    public void addImportedEntity(Entity entity) {
        this._importedEntities.add(entity);
    }

    public void addIncludedEntity(Entity entity) {
        this._includedEntities.add(entity);
    }

    public void withAllSubEntitiesDo(EntityAction action) {
        if (this.getRoot() != null) {
            action.perform(this.getRoot());
        }
        Iterator iter = this._importedEntities.iterator();
        while (iter.hasNext()) {
            action.perform((Entity)iter.next());
        }
        Iterator iter2 = this._includedEntities.iterator();
        while (iter2.hasNext()) {
            action.perform((Entity)iter2.next());
        }
    }

    public abstract void validate(EntityReferenceValidator var1);

    public void define(GloballyKnown e) {
        Map map = this.getMap(e.getKind());
        if (e.getName() == null) {
            return;
        }
        QName name = new QName(e.getDefining().getTargetNamespaceURI(), e.getName());
        if (map.containsKey(name)) {
            throw new DuplicateEntityException(e);
        }
        map.put(name, e);
    }

    public void undefine(GloballyKnown e) {
        Map map = this.getMap(e.getKind());
        if (e.getName() == null) {
            return;
        }
        QName name = new QName(e.getDefining().getTargetNamespaceURI(), e.getName());
        if (map.containsKey(name)) {
            throw new NoSuchEntityException(name);
        }
        map.remove(name);
    }

    public void defineID(Identifiable e) {
        String id = e.getID();
        if (id == null) {
            return;
        }
        if (this._identifiables.containsKey(id)) {
            throw new DuplicateEntityException(e);
        }
        this._identifiables.put(id, e);
    }

    public void undefineID(Identifiable e) {
        String id = e.getID();
        if (id == null) {
            return;
        }
        if (this._identifiables.containsKey(id)) {
            throw new NoSuchEntityException(id);
        }
        this._identifiables.remove(id);
    }

    public String getSystemId() {
        return this._systemId;
    }

    public void addImportedDocument(String systemId) {
        this._importedDocuments.add(systemId);
    }

    public void addIncludedDocument(String systemId) {
        this._includedDocuments.add(systemId);
    }

    public void setSystemId(String s) {
        if (this._systemId != null && !this._systemId.equals(s)) {
            throw new IllegalArgumentException();
        }
        this._systemId = s;
        if (s != null) {
            this._importedDocuments.add(s);
        }
    }

    public boolean isImportedDocument(String systemId) {
        return this._importedDocuments.contains(systemId) || this._includedDocuments.contains(systemId);
    }

    public boolean isIncludedDocument(String systemId) {
        return this._includedDocuments.contains(systemId) || this._importedDocuments.contains(systemId);
    }

    public Set collectAllNamespaces() {
        final HashSet result = new HashSet();
        EntityAction action = new EntityAction(){

            public void perform(Entity entity) {
                entity.withAllQNamesDo(new QNameAction(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void perform(QName name) {
                        3.access$100(this.this$1).add(name.getNamespaceURI());
                    }
                });
                entity.withAllSubEntitiesDo(this);
            }

            static /* synthetic */ Set access$100(3 x0) {
                return x0.result;
            }
        };
        this.withAllSubEntitiesDo(action);
        return result;
    }

    public Set collectAllQNames() {
        final HashSet result = new HashSet();
        EntityAction action = new EntityAction(){

            public void perform(Entity entity) {
                entity.withAllQNamesDo(new QNameAction(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void perform(QName name) {
                        1.access$000(this.this$1).add(name);
                    }
                });
                entity.withAllSubEntitiesDo(this);
            }

            static /* synthetic */ Set access$000(1 x0) {
                return x0.result;
            }
        };
        this.withAllSubEntitiesDo(action);
        return result;
    }

    public Identifiable findByID(String id) {
        Object result = this._identifiables.get(id);
        if (result == null) {
            throw new NoSuchEntityException(id);
        }
        return (Identifiable)result;
    }

    public Map getMap(Kind k) {
        HashMap m = (HashMap)this._kinds.get(k.getName());
        if (m == null) {
            m = new HashMap();
            this._kinds.put(k.getName(), m);
        }
        return m;
    }

    public GloballyKnown find(Kind k, QName name) {
        Map map = this.getMap(k);
        Object result = map.get(name);
        if (result == null) {
            throw new NoSuchEntityException(name);
        }
        return (GloballyKnown)result;
    }

    private class LocallyValidatingAction
    implements EntityAction {
        private ValidationException _exception;

        public void perform(Entity entity) {
            block2: {
                try {
                    entity.validateThis();
                    entity.withAllSubEntitiesDo(this);
                }
                catch (ValidationException e) {
                    if (this._exception != null) break block2;
                    this._exception = e;
                }
            }
        }

        public ValidationException getException() {
            return this._exception;
        }
    }
}

