/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sdnchina.ncrev2;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.j2seproject.ui.customizer.J2SESourceRootsUi;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class FolderList
extends JPanel {
    public static final String PROP_FILES = "files";
    public static final String PROP_LAST_USED_DIR = "lastUsedDir";
    private String fcMessage;
    private File projectFolder;
    private File lastUsedFolder;
    private FolderList relatedFolderList;
    private JButton addButton;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JButton removeButton;
    private JList roots;

    public FolderList(String label, char mnemonic, String accessibleDesc, String fcMessage, char addButtonMnemonic, String addButtonAccessibleDesc, char removeButtonMnemonic, String removeButtonAccessibleDesc) {
        this.fcMessage = fcMessage;
        this.initComponents();
        this.jLabel1.setText(label);
        this.jLabel1.setDisplayedMnemonic(mnemonic);
        this.roots.getAccessibleContext().setAccessibleDescription(accessibleDesc);
        this.roots.setCellRenderer(new Renderer());
        this.roots.setModel(new DefaultListModel());
        this.roots.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    FolderList.this.removeButton.setEnabled(FolderList.this.roots.getSelectedIndices().length != 0);
                }
            }
        });
        this.addButton.getAccessibleContext().setAccessibleDescription(addButtonAccessibleDesc);
        this.addButton.setMnemonic(addButtonMnemonic);
        this.removeButton.getAccessibleContext().setAccessibleDescription(removeButtonAccessibleDesc);
        this.removeButton.setMnemonic(removeButtonMnemonic);
        this.removeButton.setEnabled(false);
    }

    public void setProjectFolder(File projectFolder) {
        this.projectFolder = projectFolder;
    }

    public void setRelatedFolderList(FolderList relatedFolderList) {
        this.relatedFolderList = relatedFolderList;
    }

    public File[] getFiles() {
        Object[] files = ((DefaultListModel)this.roots.getModel()).toArray();
        File[] result = new File[files.length];
        System.arraycopy(files, 0, result, 0, files.length);
        return result;
    }

    public void setFiles(File[] files) {
        DefaultListModel model = (DefaultListModel)this.roots.getModel();
        model.clear();
        for (int i = 0; i < files.length; ++i) {
            model.addElement(files[i]);
        }
        if (files.length > 0) {
            this.roots.setSelectedIndex(0);
        }
    }

    public void setLastUsedDir(File lastUsedDir) {
        if (this.lastUsedFolder == null ? lastUsedDir != null : !this.lastUsedFolder.equals(lastUsedDir)) {
            File oldValue = this.lastUsedFolder;
            this.lastUsedFolder = lastUsedDir;
            this.firePropertyChange(PROP_LAST_USED_DIR, oldValue, this.lastUsedFolder);
        }
    }

    public File getLastUsedDir() {
        return this.lastUsedFolder;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.roots = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.roots);
        this.jLabel1.setText("jLabel1");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.roots);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.addButton.setText(ResourceBundle.getBundle("org/netbeans/modules/java/j2seproject/ui/wizards/Bundle").getString("CTL_AddFolder"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FolderList.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setText(ResourceBundle.getBundle("org/netbeans/modules/java/j2seproject/ui/wizards/Bundle").getString("CTL_RemoveFolder"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FolderList.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.removeButton, gridBagConstraints);
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        Object[] selection = this.roots.getSelectedValues();
        for (int i = 0; i < selection.length; ++i) {
            ((DefaultListModel)this.roots.getModel()).removeElement(selection[i]);
        }
        this.firePropertyChange(PROP_FILES, null, null);
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setDialogTitle(this.fcMessage);
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(true);
        if (this.lastUsedFolder != null && this.lastUsedFolder.isDirectory()) {
            chooser.setCurrentDirectory(this.lastUsedFolder);
        } else if (this.projectFolder != null && this.projectFolder.isDirectory()) {
            chooser.setCurrentDirectory(this.projectFolder);
        }
        if (chooser.showOpenDialog(this) == 0) {
            File[] files = chooser.getSelectedFiles();
            int[] indecesToSelect = new int[files.length];
            DefaultListModel model = (DefaultListModel)this.roots.getModel();
            HashSet<File> invalidRoots = new HashSet<File>();
            File[] relatedFolders = this.relatedFolderList == null ? new File[]{} : this.relatedFolderList.getFiles();
            int i = 0;
            int index = model.size();
            while (i < files.length) {
                File normalizedFile = FileUtil.normalizeFile((File)files[i]);
                if (!FolderList.isValidRoot(normalizedFile, relatedFolders, this.projectFolder)) {
                    invalidRoots.add(normalizedFile);
                } else {
                    int pos = model.indexOf(normalizedFile);
                    if (pos == -1) {
                        model.addElement(normalizedFile);
                        indecesToSelect[i] = index;
                    } else {
                        indecesToSelect[i] = pos;
                    }
                }
                ++i;
                ++index;
            }
            this.roots.setSelectedIndices(indecesToSelect);
            this.firePropertyChange(PROP_FILES, null, null);
            File cd = chooser.getCurrentDirectory();
            if (cd != null) {
                this.setLastUsedDir(FileUtil.normalizeFile((File)cd));
            }
            if (invalidRoots.size() > 0) {
                J2SESourceRootsUi.showIllegalRootsDialog(invalidRoots);
            }
        }
    }

    static boolean isValidRoot(File file, File[] relatedRoots, File projectFolder) {
        Project p = FileOwnerQuery.getOwner((URI)file.toURI());
        if (p != null && !file.getAbsolutePath().startsWith(projectFolder.getAbsolutePath() + File.separatorChar)) {
            Sources sources = (Sources)p.getLookup().lookup(Sources.class);
            if (sources == null) {
                return false;
            }
            SourceGroup[] sourceGroups = sources.getSourceGroups("generic");
            SourceGroup[] javaGroups = sources.getSourceGroups("java");
            SourceGroup[] groups = new SourceGroup[sourceGroups.length + javaGroups.length];
            System.arraycopy(sourceGroups, 0, groups, 0, sourceGroups.length);
            System.arraycopy(javaGroups, 0, groups, sourceGroups.length, javaGroups.length);
            FileObject projectDirectory = p.getProjectDirectory();
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (projectDirectory == null || fileObject == null) {
                return false;
            }
            for (int i = 0; i < groups.length; ++i) {
                FileObject sgRoot = groups[i].getRootFolder();
                if (fileObject.equals(sgRoot)) {
                    return false;
                }
                if (projectDirectory.equals(sgRoot) || !FileUtil.isParentOf((FileObject)sgRoot, (FileObject)fileObject)) continue;
                return false;
            }
            return true;
        }
        return !FolderList.contains(file, relatedRoots);
    }

    private static boolean contains(File folder, File[] roots) {
        String path = folder.getAbsolutePath();
        for (int i = 0; i < roots.length; ++i) {
            String rootPath = roots[i].getAbsolutePath();
            if (!rootPath.equals(path) && !path.startsWith(rootPath + File.separatorChar)) continue;
            return true;
        }
        return false;
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            File f = (File)value;
            Project p = FileOwnerQuery.getOwner((URI)f.toURI());
            String message = f.getAbsolutePath();
            Component result = super.getListCellRendererComponent((JList<?>)list, message, index, isSelected, cellHasFocus);
            return result;
        }
    }
}

