/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sdnchina.ncrev2;

import com.sun.sdnchina.ncrev2.PanelConfigureProject;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.j2seproject.J2SEProjectGenerator;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class NCREProjectWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    static final int TYPE_APP = 0;
    static final int TYPE_LIB = 1;
    static final int TYPE_EXT = 2;
    static final String PROP_NAME_INDEX = "nameIndex";
    private static final String MANIFEST_FILE = "manifest.mf";
    private static final long serialVersionUID = 1L;
    private int type;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;

    private WizardDescriptor.Panel[] createPanels() {
        WizardDescriptor.Panel[] panelArray = new WizardDescriptor.Panel[1];
        panelArray[0] = new PanelConfigureProject(2);
        return panelArray;
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage((Class)NCREProjectWizardIterator.class, (String)"LAB_ConfigureProject")};
    }

    public Set instantiate() throws IOException {
        HashSet<FileObject> resultSet = new HashSet<FileObject>();
        File dirF = (File)this.wiz.getProperty("projdir");
        if (dirF != null) {
            dirF = FileUtil.normalizeFile((File)dirF);
        }
        String name = (String)this.wiz.getProperty("name");
        String mainClass = (String)this.wiz.getProperty("mainClass");
        File[] sourceFolders = (File[])this.wiz.getProperty("sourceRoot");
        File[] testFolders = (File[])this.wiz.getProperty("testRoot");
        J2SEProjectGenerator.createProject((File)dirF, (String)name, (File[])sourceFolders, (File[])testFolders, (String)MANIFEST_FILE);
        for (int i = 0; i < sourceFolders.length; ++i) {
            FileObject srcFo = FileUtil.toFileObject((File)sourceFolders[i]);
            if (srcFo == null) continue;
            resultSet.add(srcFo);
        }
        FileObject dir = FileUtil.toFileObject((File)dirF);
        NCREProjectWizardIterator.createManifest(dir, MANIFEST_FILE);
        String confPath = dirF.getAbsolutePath() + File.separatorChar + "nbproject" + File.separatorChar + "project.properties";
        System.out.println(confPath);
        Configuration rc = new Configuration(confPath);
        rc.setValue("work.dir", sourceFolders[0].getAbsolutePath());
        rc.saveFile(confPath, "project.properties");
        rc = null;
        resultSet.add(dir);
        File file = dirF = dirF != null ? dirF.getParentFile() : null;
        if (dirF != null && dirF.exists()) {
            ProjectChooser.setProjectsFolder((File)dirF);
        }
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
        this.wiz.putProperty("sourceRoot", (Object)new File[0]);
        this.wiz.putProperty("testRoot", (Object)new File[0]);
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.wiz.putProperty("mainClass", null);
        this.wiz.putProperty("sourceRoot", null);
        this.wiz.putProperty("testRoot", null);
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage((Class)NCREProjectWizardIterator.class, (String)"LAB_IteratorName"), new Integer(this.index + 1), new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    private FileObject getMainClassFO(FileObject sourcesRoot, String mainClass) {
        mainClass = mainClass.replace('.', '/');
        return sourcesRoot.getFileObject(mainClass + ".java");
    }

    static String getPackageName(String displayName) {
        StringBuffer builder = new StringBuffer();
        boolean firstLetter = true;
        for (int i = 0; i < displayName.length(); ++i) {
            char c = displayName.charAt(i);
            if ((firstLetter || !Character.isJavaIdentifierPart(c)) && (!firstLetter || !Character.isJavaIdentifierStart(c))) continue;
            firstLetter = false;
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            }
            builder.append(c);
        }
        return builder.length() == 0 ? NbBundle.getMessage((Class)NCREProjectWizardIterator.class, (String)"TXT_DefaultPackageName") : builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createManifest(FileObject dir, String path) throws IOException {
        FileObject manifest = dir.createData(MANIFEST_FILE);
        FileLock lock = manifest.lock();
        try {
            OutputStream os = manifest.getOutputStream(lock);
            try {
                PrintWriter pw = new PrintWriter(os);
                pw.println("Manifest-Version: 1.0");
                pw.println("X-COMMENT: Main-Class will be added automatically by build");
                pw.println();
                pw.flush();
            }
            finally {
                os.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    private class Configuration {
        private Properties propertie = new Properties();
        private FileInputStream inputFile;
        private FileOutputStream outputFile;

        public Configuration() {
        }

        public Configuration(String filePath) {
            try {
                this.inputFile = new FileInputStream(filePath);
                this.propertie.load(this.inputFile);
                this.inputFile.close();
            }
            catch (FileNotFoundException ex) {
                System.out.println("Can't find the configuration files");
                ex.printStackTrace();
            }
            catch (IOException ex) {
                System.out.println("fail to load the configuration files");
                ex.printStackTrace();
            }
        }

        public String getValue(String key) {
            if (this.propertie.containsKey(key)) {
                String value = this.propertie.getProperty(key);
                return value;
            }
            return "";
        }

        public String getValue(String fileName, String key) {
            try {
                String value = "";
                this.inputFile = new FileInputStream(fileName);
                this.propertie.load(this.inputFile);
                this.inputFile.close();
                if (this.propertie.containsKey(key)) {
                    value = this.propertie.getProperty(key);
                    return value;
                }
                return value;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return "";
            }
            catch (IOException e) {
                e.printStackTrace();
                return "";
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return "";
            }
        }

        public void clear() {
            this.propertie.clear();
        }

        public void setValue(String key, String value) {
            this.propertie.setProperty(key, value);
        }

        public void saveFile(String fileName, String description) {
            try {
                this.outputFile = new FileOutputStream(fileName);
                this.propertie.store(this.outputFile, description);
                this.outputFile.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

