/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sdnchina.ncrev2;

import com.sun.sdnchina.ncrev2.PanelConfigureProject;
import com.sun.sdnchina.ncrev2.PanelProjectLocationVisual;
import com.sun.sdnchina.ncrev2.SettingsPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class PanelProjectLocationExtSrc
extends SettingsPanel {
    private PanelConfigureProject firer;
    private WizardDescriptor wizardDescriptor;
    private boolean calculatePF;
    private static final String PROJECT_PREFIX = "NCREProject";
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField projectLocation;
    private JTextField projectName;
    private JTextField sourceLocation;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PanelProjectLocationExtSrc(PanelConfigureProject panel) {
        this.firer = panel;
        this.initComponents();
        this.projectName.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.changeProjectName();
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.changeProjectName();
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.changeProjectName();
                PanelProjectLocationExtSrc.this.dataChanged();
            }
        });
        this.sourceLocation.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.calculateProjectFolder();
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.calculateProjectFolder();
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.calculateProjectFolder();
                PanelProjectLocationExtSrc.this.dataChanged();
            }
        });
    }

    private synchronized void calculateProjectFolder() {
        if (this.calculatePF) {
            File parent;
            String sourceFolder = this.sourceLocation.getText().trim();
            File projLoc = new File(sourceFolder).getAbsoluteFile();
            if (PanelProjectLocationVisual.getCanonicalFile(projLoc) == null) {
                projLoc = ProjectChooser.getProjectsFolder();
            }
            if ((parent = projLoc.getParentFile()) == null) {
                this.projectLocation.setText(projLoc.getAbsolutePath() + PROJECT_PREFIX + File.separator + this.projectName.getText());
            } else {
                this.projectLocation.setText(parent.getAbsolutePath() + File.separator + PROJECT_PREFIX + File.separator + this.projectName.getText());
            }
            this.projectName.setText(projLoc.getAbsolutePath().substring(projLoc.getAbsolutePath().lastIndexOf(File.separator) + 1));
            this.setCalculateProjectFolder(true);
        }
    }

    private synchronized void changeProjectName() {
        if (this.calculatePF) {
            String projectFolder = this.projectLocation.getText();
            String projectName = this.projectName.getText().trim();
            int last = projectFolder.lastIndexOf(File.separator);
            if (last > 0) {
                this.projectLocation.setText(projectFolder.subSequence(0, last) + File.separator + projectName);
                this.setCalculateProjectFolder(true);
            }
        }
    }

    private synchronized void setCalculateProjectFolder(boolean value) {
        this.calculatePF = value;
    }

    private void dataChanged() {
        this.firer.fireChangeEvent();
    }

    void read(WizardDescriptor settings) {
        this.wizardDescriptor = settings;
        this.setCalculateProjectFolder(true);
        File[] list = (File[])settings.getProperty("sourceRoot");
        File sourceLocation = null;
        sourceLocation = list == null || list.length <= 0 ? ProjectChooser.getProjectsFolder().getParentFile() : list[0];
        this.sourceLocation.setText(sourceLocation.getAbsolutePath());
        this.projectName.selectAll();
    }

    void store(WizardDescriptor settings) {
        settings.putProperty("name", (Object)this.projectName.getText());
        File projectsDir = new File(this.projectLocation.getText());
        settings.putProperty("projdir", (Object)projectsDir);
        File[] list = new File[]{new File(this.sourceLocation.getText().trim())};
        settings.putProperty("sourceRoot", (Object)list);
    }

    boolean valid(WizardDescriptor settings) {
        String result = PanelProjectLocationExtSrc.checkValidity(this.projectName.getText().trim(), this.projectLocation.getText().trim(), this.sourceLocation.getText().trim());
        if (result == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
            return true;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)result);
        return false;
    }

    static String checkValidity(String projectName, String projectLocation, String sourceLocation) {
        File source;
        if (projectName.length() == 0 || projectName.indexOf(47) > 0 || projectName.indexOf(92) > 0 || projectName.indexOf(58) > 0) {
            return NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"MSG_IllegalProjectName");
        }
        File projLoc = new File(projectLocation).getAbsoluteFile();
        if (PanelProjectLocationVisual.getCanonicalFile(projLoc) == null) {
            return NbBundle.getMessage((Class)PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectLocation");
        }
        while (projLoc != null && !projLoc.exists()) {
            projLoc = projLoc.getParentFile();
        }
        if (projLoc == null || !projLoc.canWrite()) {
            return NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"MSG_ProjectFolderReadOnly");
        }
        File destFolder = FileUtil.normalizeFile((File)new File(projectLocation));
        File[] kids = destFolder.listFiles();
        if (destFolder.exists() && kids != null && kids.length > 0) {
            String file = null;
            for (int i = 0; i < kids.length; ++i) {
                String childName = kids[i].getName();
                if ("nbproject".equals(childName)) {
                    file = NbBundle.getMessage((Class)(class$com$sun$sdnchina$ncrev2$PanelProjectLocationExtSrc == null ? PanelProjectLocationExtSrc.class$("com.sun.sdnchina.ncrev2.PanelProjectLocationExtSrc") : class$com$sun$sdnchina$ncrev2$PanelProjectLocationExtSrc), (String)"TXT_NetBeansProject");
                } else if ("build".equals(childName)) {
                    file = NbBundle.getMessage((Class)(class$com$sun$sdnchina$ncrev2$PanelProjectLocationExtSrc == null ? PanelProjectLocationExtSrc.class$("com.sun.sdnchina.ncrev2.PanelProjectLocationExtSrc") : class$com$sun$sdnchina$ncrev2$PanelProjectLocationExtSrc), (String)"TXT_BuildFolder");
                } else if ("dist".equals(childName)) {
                    file = NbBundle.getMessage((Class)(class$com$sun$sdnchina$ncrev2$PanelProjectLocationExtSrc == null ? PanelProjectLocationExtSrc.class$("com.sun.sdnchina.ncrev2.PanelProjectLocationExtSrc") : class$com$sun$sdnchina$ncrev2$PanelProjectLocationExtSrc), (String)"TXT_DistFolder");
                } else if ("build.xml".equals(childName)) {
                    file = NbBundle.getMessage((Class)(class$com$sun$sdnchina$ncrev2$PanelProjectLocationExtSrc == null ? PanelProjectLocationExtSrc.class$("com.sun.sdnchina.ncrev2.PanelProjectLocationExtSrc") : class$com$sun$sdnchina$ncrev2$PanelProjectLocationExtSrc), (String)"TXT_BuildXML");
                } else if ("manifest.mf".equals(childName)) {
                    file = NbBundle.getMessage((Class)(class$com$sun$sdnchina$ncrev2$PanelProjectLocationExtSrc == null ? PanelProjectLocationExtSrc.class$("com.sun.sdnchina.ncrev2.PanelProjectLocationExtSrc") : class$com$sun$sdnchina$ncrev2$PanelProjectLocationExtSrc), (String)"TXT_Manifest");
                }
                if (file == null) continue;
                String format = NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"MSG_ProjectFolderInvalid");
                return MessageFormat.format(format, file);
            }
        }
        if (destFolder.isDirectory()) {
            FileObject destFO = FileUtil.toFileObject((File)destFolder);
            if (!$assertionsDisabled && destFO == null) {
                throw new AssertionError((Object)("No FileObject for " + destFolder));
            }
            boolean clear = false;
            try {
                clear = ProjectManager.getDefault().findProject(destFO) == null;
            }
            catch (IOException e) {
                // empty catch block
            }
            if (!clear) {
                return NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"MSG_ProjectFolderHasDeletedProject");
            }
        }
        if (!(source = new File(sourceLocation)).isDirectory() || !source.canRead()) {
            return MessageFormat.format(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"MSG_IllegalSources"), source.getAbsolutePath());
        }
        if (!PanelProjectLocationExtSrc.searchJavaFiles(source)) {
            return NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"path_not_have_code");
        }
        String sloc = source.getAbsolutePath();
        if (projectLocation.equals(sloc) || projectLocation.startsWith(sloc + File.separatorChar)) {
            return NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"MSG_IllegalProjectFolder");
        }
        return null;
    }

    void validate(WizardDescriptor d) throws WizardValidationException {
    }

    private static boolean searchJavaFiles(File path) {
        File[] list = path.listFiles();
        int len = list.length;
        for (int i = 0; i < len; ++i) {
            FileObject fileObj = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)list[i]));
            if (fileObj == null || !fileObj.getExt().toLowerCase().equals("java")) continue;
            return true;
        }
        return false;
    }

    private void searchClassFiles(File[] folders) throws WizardValidationException {
        boolean found = false;
        for (int i = 0; i < folders.length; ++i) {
            FileObject folder = FileUtil.toFileObject((File)folders[i]);
            if (folder == null) continue;
            Enumeration en = folder.getData(true);
            while (!found && en.hasMoreElements()) {
                Object obj = en.nextElement();
                if (!$assertionsDisabled && !(obj instanceof FileObject)) {
                    throw new AssertionError((Object)("Instance of FileObject: " + obj));
                }
                FileObject fo = (FileObject)obj;
                found = "class".equals(fo.getExt()) && !fo.isVirtual();
            }
        }
        if (found) {
            JButton DELETE_OPTION = new JButton(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"TXT_DeleteOption"));
            JButton KEEP_OPTION = new JButton(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"TXT_KeepOption"));
            JButton CANCEL_OPTION = new JButton(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"TXT_CancelOption"));
            KEEP_OPTION.setMnemonic(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"MNE_KeepOption").charAt(0));
            DELETE_OPTION.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"AD_DeleteOption"));
            KEEP_OPTION.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"AD_KeepOption"));
            CANCEL_OPTION.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"AD_CancelOption"));
            NotifyDescriptor desc = new NotifyDescriptor((Object)NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"MSG_FoundClassFiles"), NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"MSG_FoundClassFiles_Title"), 1, 3, new Object[]{DELETE_OPTION, KEEP_OPTION, CANCEL_OPTION}, (Object)DELETE_OPTION);
            Object result = DialogDisplayer.getDefault().notify(desc);
            if (DELETE_OPTION.equals(result)) {
                this.deleteClassFiles(folders);
            } else if (!KEEP_OPTION.equals(result)) {
                throw new WizardValidationException((JComponent)this, "", "");
            }
        }
    }

    private void deleteClassFiles(File[] folders) {
        for (int i = 0; i < folders.length; ++i) {
            FileObject folder = FileUtil.toFileObject((File)folders[i]);
            Enumeration en = folder.getData(true);
            while (en.hasMoreElements()) {
                Object obj = en.nextElement();
                if (!$assertionsDisabled && !(obj instanceof FileObject)) {
                    throw new AssertionError((Object)("Instance of FileObject: " + obj));
                }
                FileObject fo = (FileObject)obj;
                try {
                    if (!"class".equals(fo.getExt())) continue;
                    fo.delete();
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
        }
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.projectName = new JTextField();
        this.jLabel6 = new JLabel();
        this.sourceLocation = new JTextField();
        this.jButton3 = new JButton();
        this.jLabel1 = new JLabel();
        this.projectLocation = new JTextField();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"ACSN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"ACSD_PanelSourceFolders"));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel4.setLabelFor(this.jPanel2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)ResourceBundle.getBundle("com/sun/sdnchina/ncrev2/Bundle").getString("TT_Choose_Location"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel4.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"ACSN_jLabel4"));
        this.jLabel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"ACSD_jLabel4"));
        this.jLabel5.setDisplayedMnemonic(ResourceBundle.getBundle("com/sun/sdnchina/ncrev2/Bundle").getString("LBL_NWP1_ProjectName_LabelMnemonic").charAt(0));
        this.jLabel5.setLabelFor(this.projectName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)ResourceBundle.getBundle("com/sun/sdnchina/ncrev2/Bundle").getString("LBL_NWP1_ProjectName_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel5.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"ACSN_projectNameLabel"));
        this.jLabel5.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"ACSD_projectNameLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.jPanel2.add((Component)this.projectName, gridBagConstraints);
        this.jLabel6.setDisplayedMnemonic(NbBundle.getBundle((Class)PanelProjectLocationExtSrc.class).getString("LBL_NWP1_SourceFolder_LablelMnemonic").charAt(0));
        this.jLabel6.setLabelFor(this.sourceLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)ResourceBundle.getBundle("com/sun/sdnchina/ncrev2/Bundle").getString("LBL_NWP1_SourceProjectFolder_Lablel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel6.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"ACSN_projectLocationLabel"));
        this.jLabel6.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"ACSD_projectLocationLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.jPanel2.add((Component)this.sourceLocation, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton3, (String)ResourceBundle.getBundle("com/sun/sdnchina/ncrev2/Bundle").getString("LBL_NWP1_BrowseLocation_Button1"));
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelProjectLocationExtSrc.this.browseProjectLocation(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.jPanel2.add((Component)this.jButton3, gridBagConstraints);
        this.jButton3.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"ACSN_browseButton"));
        this.jButton3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"ACSD_browseButton"));
        this.jLabel1.setDisplayedMnemonic(ResourceBundle.getBundle("com/sun/sdnchina/ncrev2/Bundle").getString("LBL_NWP1_ProjectLocation_LabelMnemonic").charAt(0));
        this.jLabel1.setLabelFor(this.projectLocation);
        this.jLabel1.setText(ResourceBundle.getBundle("com/sun/sdnchina/ncrev2/Bundle").getString("LBL_NWP1_ProjectLocation_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.projectLocation.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.jPanel2.add((Component)this.projectLocation, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"ACSN_jPanel1"));
        this.jPanel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"ACSD_jPanel1"));
    }

    private void browseProjectLocation(ActionEvent evt) {
        File file;
        File f;
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setDialogTitle(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_SelectProjectLocation"));
        chooser.setFileSelectionMode(1);
        String path = this.sourceLocation.getText();
        if (path.length() > 0 && (f = new File(path)).exists()) {
            chooser.setSelectedFile(f);
        }
        if (chooser.showOpenDialog(this) == 0 && (file = chooser.getSelectedFile()) != null) {
            this.sourceLocation.setText(FileUtil.normalizeFile((File)file).getAbsolutePath());
        }
    }

    static {
        $assertionsDisabled = !PanelProjectLocationExtSrc.class.desiredAssertionStatus();
    }
}

