/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import java.io.IOException;
import java.io.Writer;
import java.util.regex.Pattern;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.AbstractFormatLayer;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.FormatLayer;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.editor.ext.html.HTMLSyntax;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLTokenContext;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class HTMLFormatter
extends ExtFormatter {
    private static final Pattern VALID_TAG_NAME = Pattern.compile("\\w+");
    private static final String[] UNFORMATTABLE_TAGS = new String[]{"pre", "script"};
    private static final int WORKUNITS_MAX = 100;

    public HTMLFormatter(Class clazz) {
        super(clazz);
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof HTMLSyntax;
    }

    protected void initFormatLayers() {
        this.addFormatLayer((FormatLayer)new OutLineLayer());
    }

    public Writer reformat(final BaseDocument baseDocument, final int n, final int n2, final boolean bl) throws BadLocationException, IOException {
        final HTMLSyntaxSupport hTMLSyntaxSupport = (HTMLSyntaxSupport)baseDocument.getSyntaxSupport().get(HTMLSyntaxSupport.class);
        if (n == n2) {
            TokenItem tokenItem;
            int n3 = Utilities.getFirstNonWhiteBwd((BaseDocument)baseDocument, (int)n2);
            if (n3 != -1 && (tokenItem = hTMLSyntaxSupport.getTokenChain(n3, n3 + 1)) != null && tokenItem.getTokenID() == HTMLTokenContext.TAG_CLOSE_SYMBOL && !tokenItem.getImage().equals("/>")) {
                int[] nArray;
                while ((tokenItem = tokenItem.getPrevious()) != null && tokenItem.getTokenID() != HTMLTokenContext.TAG_OPEN) {
                }
                if (tokenItem != null && !hTMLSyntaxSupport.isSingletonTag(tokenItem) && ((nArray = hTMLSyntaxSupport.findMatchingBlock(tokenItem.getOffset(), false)) != null && nArray[0] > n2 || nArray == null)) {
                    DTD.Element element;
                    TokenItem tokenItem2 = tokenItem;
                    DTD dTD = hTMLSyntaxSupport.getDTD();
                    if (tokenItem2 != null && dTD != null && (element = dTD.getElement(tokenItem2.getImage().toUpperCase())) != null && !element.hasOptionalEnd()) {
                        int n4 = Utilities.getRowIndent((BaseDocument)baseDocument, (int)tokenItem.getOffset());
                        int n5 = n4 + this.getShiftWidth();
                        this.changeRowIndent(baseDocument, n, n5);
                        return null;
                    }
                }
            }
            int n6 = Utilities.getRowIndent((BaseDocument)baseDocument, (int)n2, (boolean)false);
            this.changeRowIndent(baseDocument, n, n6);
            return null;
        }
        if (!bl && n2 - n > 50000) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        HTMLFormatter.this.doReformat(baseDocument, hTMLSyntaxSupport, n, n2, bl, true);
                    }
                    catch (BadLocationException badLocationException) {
                        ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
                    }
                }
            }, 0, Math.max(0, Thread.currentThread().getPriority() - 1));
        } else {
            this.doReformat(baseDocument, hTMLSyntaxSupport, n, n2, bl, false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReformat(BaseDocument baseDocument, HTMLSyntaxSupport hTMLSyntaxSupport, int n, int n2, boolean bl, boolean bl2) throws BadLocationException {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        ProgressHandle progressHandle = null;
        if (bl2) {
            progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getBundle((Class)HTMLFormatter.class).getString("MSG_code_reformat"));
            progressHandle.start();
            progressHandle.switchToDeterminate(100);
        }
        HackedBaseDocument hackedBaseDocument = new HackedBaseDocument(baseDocument.getKitClass(), false);
        hackedBaseDocument.insertString(0, baseDocument.getText(0, baseDocument.getLength()), null);
        HTMLSyntaxSupport hTMLSyntaxSupport2 = new HTMLSyntaxSupport(hackedBaseDocument);
        int n8 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n);
        int n9 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n2);
        int n10 = n9 - n8;
        hackedBaseDocument.atomicLock();
        try {
            n7 = -1;
            n6 = Utilities.getRowStart((BaseDocument)hackedBaseDocument, (int)n2);
            TokenItem tokenItem = null;
            n5 = 0;
            block8: do {
                try {
                    int n11 = Utilities.getRowFirstNonWhite((BaseDocument)hackedBaseDocument, (int)n6);
                    if (n11 == -1) {
                        n11 = n6;
                    }
                    tokenItem = hTMLSyntaxSupport2.getTokenChain(n11, n11 + 1);
                    if (bl2 && (n4 = 100 - (n3 = Utilities.getLineOffset((BaseDocument)hackedBaseDocument, (int)n11)) * 100 / n10) % 10 == 0 && n5 < n4) {
                        n5 = n4;
                        progressHandle.progress((int)((double)n4 * 0.8));
                    }
                    if (tokenItem == null || tokenItem.getNext() == null) continue;
                    if ((tokenItem = tokenItem.getNext()).getOffset() <= n7) {
                        n7 = -1;
                    }
                    if (!tokenItem.getTokenContextPath().contains(HTMLTokenContext.contextPath) || tokenItem.getTokenID().getNumericID() != 5) continue;
                    String string = tokenItem.getImage();
                    n4 = -1;
                    while (tokenItem != null) {
                        if (tokenItem.getOffset() > n7) {
                            if (tokenItem.getTokenContextPath().contains(HTMLTokenContext.contextPath) && HTMLSyntaxSupport.isTag(tokenItem) && !hTMLSyntaxSupport2.isSingletonTag(tokenItem)) {
                                if (tokenItem.getImage().trim().equals(string) && tokenItem.getTokenID().getNumericID() == 4) {
                                    if (n4 == 0) {
                                        if (this.isFormattableTag(tokenItem.getImage()) || bl) {
                                            hackedBaseDocument.remove(n6, n11 - n6);
                                            n11 = Utilities.getRowFirstNonWhite((BaseDocument)hackedBaseDocument, (int)tokenItem.getOffset());
                                            n4 = Utilities.getRowStart((BaseDocument)hackedBaseDocument, (int)n11);
                                            hackedBaseDocument.insertString(n6, hackedBaseDocument.getText(n4, n11 - n4), null);
                                            int n12 = Utilities.getRowIndent((BaseDocument)hackedBaseDocument, (int)n6);
                                            if (bl) continue block8;
                                            int n13 = Utilities.getRowStart((BaseDocument)hackedBaseDocument, (int)(Utilities.getRowStart((BaseDocument)hackedBaseDocument, (int)n6) - 1));
                                            int n14 = Utilities.getRowIndent((BaseDocument)hackedBaseDocument, (int)n6) + this.getShiftWidth();
                                            int n15 = 0;
                                            String string2 = null;
                                            while (n13 > n4) {
                                                int n16 = Utilities.getRowFirstNonWhite((BaseDocument)hackedBaseDocument, (int)n13);
                                                if (n16 > -1) {
                                                    tokenItem = hTMLSyntaxSupport2.getTokenChain(n16, n16 + 1);
                                                    boolean bl3 = false;
                                                    for (TokenItem tokenItem2 = tokenItem; tokenItem2 != null && Utilities.getRowStart((BaseDocument)hackedBaseDocument, (int)tokenItem2.getOffset()) == Utilities.getRowStart((BaseDocument)hackedBaseDocument, (int)tokenItem.getOffset()); tokenItem2 = tokenItem2.getNext()) {
                                                        if (tokenItem2.getTokenID() == HTMLTokenContext.TAG_OPEN && string2 != null && tokenItem2.getImage().equalsIgnoreCase(string2)) {
                                                            string2 = null;
                                                            bl3 = false;
                                                        }
                                                        if (tokenItem2.getTokenID() != HTMLTokenContext.TAG_CLOSE) continue;
                                                        string2 = !this.isFormattableTag(tokenItem2.getImage().trim()) ? tokenItem2.getImage().trim() : null;
                                                        bl3 = true;
                                                    }
                                                    if ((bl3 || string2 == null) && tokenItem != null && tokenItem.getTokenContextPath().contains(HTMLTokenContext.contextPath)) {
                                                        this.changeRowIndent(hackedBaseDocument, n13, n14);
                                                        int n17 = Utilities.getRowIndent((BaseDocument)hackedBaseDocument, (int)n13);
                                                        n15 = n15 + Utilities.getRowFirstNonWhite((BaseDocument)hackedBaseDocument, (int)n13) - n16;
                                                    }
                                                }
                                                n13 = Utilities.getRowStart((BaseDocument)hackedBaseDocument, (int)(n13 - 1));
                                            }
                                            n6 += n15;
                                            n7 = n4;
                                            continue block8;
                                        }
                                    } else {
                                        --n4;
                                    }
                                } else if (tokenItem.getImage().equals(string)) {
                                    ++n4;
                                }
                            }
                            tokenItem = tokenItem.getPrevious();
                            continue;
                        }
                        n7 = -1;
                        continue block8;
                    }
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(16, (Throwable)exception);
                }
            } while ((n6 = Utilities.getRowStart((BaseDocument)hackedBaseDocument, (int)(n6 - 1))) > n && n6 > 0);
        }
        finally {
            hackedBaseDocument.atomicUnlock();
        }
        baseDocument.atomicLock();
        try {
            for (n7 = n8; n7 <= n9; ++n7) {
                int n18;
                n6 = Utilities.getRowStartFromLineOffset((BaseDocument)hackedBaseDocument, (int)n7);
                int n19 = Utilities.getFirstNonWhiteFwd((BaseDocument)hackedBaseDocument, (int)n6);
                n5 = n19 - n6;
                if (n19 <= 0 || (n4 = (n3 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)(n18 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n7)))) - n18) == n5) continue;
                if (n3 > 0) {
                    baseDocument.remove(n18, n3 - n18);
                }
                baseDocument.insertString(n18, hackedBaseDocument.getText(n6, n19 - n6), null);
            }
        }
        finally {
            baseDocument.atomicUnlock();
        }
        if (bl2) {
            progressHandle.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getReformatBlock(JTextComponent jTextComponent, String string) {
        int[] nArray;
        block27: {
            nArray = super.getReformatBlock(jTextComponent, string);
            char c = string.charAt(string.length() - 1);
            try {
                int n;
                int n2;
                TokenItem tokenItem;
                BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
                int n3 = jTextComponent.getCaret().getDot();
                HTMLSyntaxSupport hTMLSyntaxSupport = (HTMLSyntaxSupport)baseDocument.getSyntaxSupport().get(HTMLSyntaxSupport.class);
                if (c == '>') {
                    TokenItem tokenItem2;
                    tokenItem = tokenItem2 = hTMLSyntaxSupport.getTokenChain(n3 - 1, n3);
                    int n4 = tokenItem2.getOffset();
                    if (tokenItem2.getTokenID().getNumericID() == 15 && !tokenItem2.getImage().endsWith("/>")) {
                        String string2;
                        while ((tokenItem2 = tokenItem2.getPrevious()) != null) {
                            if (!HTMLSyntaxSupport.isTag(tokenItem2)) continue;
                        }
                        if (tokenItem2 == null) {
                            return nArray;
                        }
                        if (tokenItem2.getTokenID().getNumericID() == 5) {
                            string2 = tokenItem2.getImage().trim();
                            int n5 = -1;
                            while (tokenItem2 != null) {
                                if (HTMLSyntaxSupport.isTag(tokenItem2)) {
                                    if (tokenItem2.getImage().trim().equals(string2) && tokenItem2.getTokenID().getNumericID() == 4) {
                                        if (n5 == 0) {
                                            int n6 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n3);
                                            return new int[]{n6, n3};
                                        }
                                        --n5;
                                    } else if (tokenItem2.getImage().equals(string2)) {
                                        ++n5;
                                    }
                                }
                                tokenItem2 = tokenItem2.getPrevious();
                            }
                        } else {
                            int[] nArray2;
                            DTD.Element element;
                            string2 = tokenItem2.getImage();
                            DTD dTD = hTMLSyntaxSupport.getDTD();
                            if (dTD != null && (element = dTD.getElement(string2.toUpperCase())) != null && !element.hasOptionalEnd() && (n2 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)(tokenItem.getOffset() + tokenItem.getImage().length()))) != -1 && Utilities.getLineOffset((BaseDocument)baseDocument, (int)tokenItem.getOffset()) < Utilities.getLineOffset((BaseDocument)baseDocument, (int)n2) && ((nArray2 = hTMLSyntaxSupport.findMatchingBlock(tokenItem2.getOffset(), false)) != null && nArray2[0] < n3 || nArray2 == null) && VALID_TAG_NAME.matcher(string2).matches()) {
                                baseDocument.atomicLock();
                                try {
                                    baseDocument.insertString(n3, "</" + string2 + ">", null);
                                }
                                catch (BadLocationException badLocationException) {
                                }
                                finally {
                                    baseDocument.atomicUnlock();
                                }
                                jTextComponent.setCaretPosition(n3);
                            }
                        }
                    }
                }
                if (c != '\n' || (n = Utilities.getRowStart((BaseDocument)baseDocument, (int)n3) - 1) <= 0 || (tokenItem = hTMLSyntaxSupport.getTokenChain(n - 1, n)) == null || tokenItem.getTokenID() != HTMLTokenContext.TAG_CLOSE_SYMBOL) break block27;
                while ((tokenItem = tokenItem.getPrevious()) != null && tokenItem.getTokenID() != HTMLTokenContext.TAG_OPEN) {
                }
                if (tokenItem == null || tokenItem.getTokenID() != HTMLTokenContext.TAG_OPEN) break block27;
                String string3 = tokenItem.getImage();
                tokenItem = hTMLSyntaxSupport.getTokenChain(n3, n3 + 1);
                if (tokenItem == null || tokenItem.getTokenID() != HTMLTokenContext.TAG_OPEN_SYMBOL || !"</".equals(tokenItem.getImage()) || !tokenItem.getNext().getImage().equals(string3)) break block27;
                int n7 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)tokenItem.getOffset());
                baseDocument.atomicLock();
                try {
                    baseDocument.insertString(n3, "\n", null);
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    baseDocument.atomicUnlock();
                }
                int n8 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n7);
                int n9 = Utilities.getRowIndent((BaseDocument)baseDocument, (int)Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(n7 - 1)));
                n2 = n9 + this.getShiftWidth();
                this.changeRowIndent(baseDocument, n8, n2);
                jTextComponent.setCaretPosition(Utilities.getRowEnd((BaseDocument)baseDocument, (int)n8));
                int n10 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(n7 + 1));
                int n11 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n10);
                return new int[]{n10, n11};
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(16, (Throwable)exception);
            }
        }
        return nArray;
    }

    private boolean isFormattableTag(String string) {
        for (int i = 0; i < UNFORMATTABLE_TAGS.length; ++i) {
            if (!string.equalsIgnoreCase(UNFORMATTABLE_TAGS[i])) continue;
            return false;
        }
        return true;
    }

    private class HackedBaseDocument
    extends BaseDocument {
        public HackedBaseDocument(Class clazz, boolean bl) {
            super(clazz, bl);
        }

        boolean notifyModifyCheckStart(int n, String string) throws BadLocationException {
            return false;
        }

        protected void fireInsertUpdate(DocumentEvent documentEvent) {
        }

        protected void postRemoveUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
        }
    }

    public class OutLineLayer
    extends AbstractFormatLayer {
        public OutLineLayer() {
            super("html-out-line");
        }

        public void format(FormatWriter formatWriter) {
            BaseDocument baseDocument = (BaseDocument)formatWriter.getDocument();
            int n = formatWriter.getOffset();
            if (baseDocument != null && n > 0) {
                try {
                    int n2 = 0;
                    n2 = Utilities.getFirstNonWhiteRow((BaseDocument)baseDocument, (int)(n - 1), (boolean)false);
                    if (n2 == -1) {
                        return;
                    }
                    int n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n2);
                    int n4 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n3);
                    baseDocument.insertString(n, baseDocument.getText(n3, n4 - n3), null);
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify(16, (Throwable)badLocationException);
                }
            }
        }
    }
}

