/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLCompletionQuery;
import org.netbeans.editor.ext.html.HTMLTokenContext;
import org.netbeans.editor.ext.html.SyntaxElement;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.dtd.InvalidateEvent;
import org.netbeans.editor.ext.html.dtd.InvalidateListener;
import org.netbeans.editor.ext.html.dtd.Registry;

public class HTMLSyntaxSupport
extends ExtSyntaxSupport
implements InvalidateListener {
    private static final String FALLBACK_DOCTYPE = "-//W3C//DTD HTML 4.01 Transitional//EN";
    private DTD dtd;
    private String docType;

    public HTMLSyntaxSupport(BaseDocument baseDocument) {
        super(baseDocument);
    }

    public void dtdInvalidated(InvalidateEvent invalidateEvent) {
        if (this.dtd != null && invalidateEvent.isInvalidatedIdentifier(this.docType)) {
            this.dtd = null;
        }
    }

    public DTD getDTD() {
        String string = this.getDocType();
        if (string == null) {
            string = FALLBACK_DOCTYPE;
        }
        if (this.dtd != null && string == this.docType) {
            return this.dtd;
        }
        this.docType = string;
        this.dtd = Registry.getDTD(this.docType, null);
        return this.dtd;
    }

    protected String getDocType() {
        try {
            SyntaxElement syntaxElement = this.getElementChain(0);
            if (syntaxElement == null) {
                return null;
            }
            int n = syntaxElement.getType();
            while (n != 1 && n != 4 && (syntaxElement = syntaxElement.getNext()) != null) {
                n = syntaxElement.getType();
            }
            if (n == 1) {
                return ((SyntaxElement.Declaration)syntaxElement).getPublicIdentifier();
            }
            return null;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int[] findMatchingBlock(int n, boolean bl) throws BadLocationException {
        TokenItem tokenItem;
        int n2;
        TokenItem tokenItem2;
        TokenItem tokenItem3 = tokenItem2 = this.getTokenChain(n, n + 1);
        if (tokenItem2 != null && tokenItem2.getTokenID().getNumericID() == 15) {
            tokenItem2 = tokenItem2.getPrevious();
        }
        boolean bl2 = false;
        if (tokenItem2 != null) {
            if (HTMLSyntaxSupport.isTagButNotSymbol(tokenItem2)) {
                bl2 = true;
            } else if (tokenItem2.getTokenID() == HTMLTokenContext.TAG_OPEN_SYMBOL) {
                if ((tokenItem2 = tokenItem2.getNext()) == null || tokenItem2.getTokenID() != HTMLTokenContext.TAG_CLOSE && tokenItem2.getTokenID() != HTMLTokenContext.TAG_OPEN) return null;
                bl2 = true;
            } else {
                for (tokenItem2 = tokenItem2.getPrevious(); tokenItem2 != null && !HTMLSyntaxSupport.isTagButNotSymbol(tokenItem2) && tokenItem2.getTokenID().getNumericID() != 15; tokenItem2 = tokenItem2.getPrevious()) {
                }
                if (tokenItem2 != null && HTMLSyntaxSupport.isTagButNotSymbol(tokenItem2)) {
                    bl2 = true;
                }
            }
        }
        if (tokenItem2 != null && HTMLSyntaxSupport.isTagButNotSymbol(tokenItem2) && bl2) {
            String string;
            n2 = -1;
            if (tokenItem2.getTokenID() == HTMLTokenContext.TAG_CLOSE) {
                string = tokenItem2.getImage().trim().toLowerCase();
                while (tokenItem2 != null) {
                    if (HTMLSyntaxSupport.isTagButNotSymbol(tokenItem2)) {
                        if (tokenItem2.getImage().trim().toLowerCase().equals(string) && tokenItem2.getTokenID() == HTMLTokenContext.TAG_OPEN && !this.isSingletonTag(tokenItem2)) {
                            if (n2 == 0) {
                                int n3 = tokenItem2.getPrevious().getOffset();
                                tokenItem2 = tokenItem2.getNext();
                                int n4 = tokenItem2.getOffset() + (tokenItem2.getTokenID() == HTMLTokenContext.TAG_CLOSE_SYMBOL ? tokenItem2.getImage().length() : 0);
                                return new int[]{n3, n4};
                            }
                            --n2;
                        } else if (tokenItem2.getImage().toLowerCase().indexOf(string) > -1 && !this.isSingletonTag(tokenItem2)) {
                            ++n2;
                        }
                    }
                    tokenItem2 = tokenItem2.getPrevious();
                }
            } else {
                if (tokenItem2.getImage().charAt(0) == '>') {
                    return null;
                }
                if (this.isSingletonTag(tokenItem2)) {
                    return null;
                }
                string = tokenItem2.getImage().toLowerCase();
                while (tokenItem2 != null) {
                    if (HTMLSyntaxSupport.isTagButNotSymbol(tokenItem2)) {
                        if (tokenItem2.getImage().trim().toLowerCase().equals(string) && tokenItem2.getTokenID() == HTMLTokenContext.TAG_CLOSE) {
                            if (n2 == 0) {
                                int n5 = tokenItem2.getPrevious().getOffset();
                                int n6 = tokenItem2.getOffset() + tokenItem2.getImage().length() + 1;
                                for (tokenItem2 = tokenItem2.getNext(); tokenItem2 != null && tokenItem2.getTokenID().getNumericID() != 15; tokenItem2 = tokenItem2.getNext()) {
                                }
                                if (tokenItem2 == null) return new int[]{n5, n6};
                                n6 = tokenItem2.getOffset() + tokenItem2.getImage().length();
                                return new int[]{n5, n6};
                            }
                            --n2;
                        } else if (tokenItem2.getImage().toLowerCase().equals(string) && !this.isSingletonTag(tokenItem2)) {
                            ++n2;
                        }
                    }
                    tokenItem2 = tokenItem2.getNext();
                }
            }
        }
        if (tokenItem3 == null || tokenItem3.getTokenID() != HTMLTokenContext.BLOCK_COMMENT) return null;
        String string = tokenItem3.getImage();
        if (string.startsWith("<!--") && n < tokenItem3.getOffset() + "<!--".length()) {
            for (tokenItem = tokenItem3; tokenItem != null && tokenItem.getTokenID() == HTMLTokenContext.BLOCK_COMMENT; tokenItem = tokenItem.getNext()) {
                if (!tokenItem.getImage().endsWith("-->")) continue;
                n2 = tokenItem.getOffset() + tokenItem.getImage().length() - "-->".length();
                int n7 = tokenItem.getOffset() + tokenItem.getImage().length();
                return new int[]{n2, n7};
            }
        }
        if (!string.endsWith("-->") || n < tokenItem3.getOffset() + tokenItem3.getImage().length() - "-->".length()) return null;
        while (tokenItem != null && tokenItem.getTokenID() == HTMLTokenContext.BLOCK_COMMENT) {
            if (tokenItem.getImage().startsWith("<!--")) {
                n2 = tokenItem.getOffset();
                int n8 = tokenItem.getOffset() + "<!--".length();
                return new int[]{n2, n8};
            }
            tokenItem = tokenItem.getPrevious();
        }
        return null;
    }

    public boolean isSingletonTag(TokenItem tokenItem) {
        for (TokenItem tokenItem2 = tokenItem; tokenItem2 != null; tokenItem2 = tokenItem2.getNext()) {
            if (tokenItem2.getTokenID() == HTMLTokenContext.TAG_CLOSE_SYMBOL) {
                if ("/>".equals(tokenItem2.getImage())) {
                    return true;
                }
                if (">".equals(tokenItem2.getImage())) break;
            }
            if (tokenItem2.getTokenID() == HTMLTokenContext.TEXT || tokenItem2.getTokenID() == HTMLTokenContext.TAG_OPEN_SYMBOL) break;
        }
        return false;
    }

    private final int getTokenEnd(TokenItem tokenItem) {
        return tokenItem.getOffset() + tokenItem.getImage().length();
    }

    public SyntaxElement getElementChain(int n) throws BadLocationException {
        TokenItem tokenItem;
        TokenItem tokenItem2;
        for (tokenItem2 = tokenItem = this.getTokenChain(n, Math.min(n + 10, this.getDocument().getLength())); tokenItem2 != null && !tokenItem2.getTokenContextPath().contains(HTMLTokenContext.contextPath); tokenItem2 = tokenItem2.getPrevious()) {
        }
        if (tokenItem2 == null) {
            return null;
        }
        TokenID tokenID = tokenItem2.getTokenID();
        int n2 = tokenItem2.getOffset();
        if (tokenID == HTMLTokenContext.CHARACTER) {
            while (tokenID != null && tokenID == HTMLTokenContext.CHARACTER) {
                n2 = tokenItem2.getOffset();
                tokenID = (tokenItem2 = tokenItem2.getPrevious()) == null ? null : tokenItem2.getTokenID();
            }
            if (tokenID != HTMLTokenContext.VALUE && tokenID != HTMLTokenContext.TEXT) {
                return this.getNextElement(n2);
            }
        }
        if (tokenID == HTMLTokenContext.WS || tokenID == HTMLTokenContext.ARGUMENT || tokenID == HTMLTokenContext.OPERATOR || tokenID == HTMLTokenContext.VALUE) {
            do {
                tokenItem2 = tokenItem2.getPrevious();
                tokenID = tokenItem2.getTokenID();
            } while (!HTMLSyntaxSupport.isTag(tokenItem2));
            return this.getNextElement(tokenItem2.getOffset());
        }
        if (tokenID == HTMLTokenContext.TEXT) {
            while (tokenID != null && (tokenID == HTMLTokenContext.TEXT || tokenID == HTMLTokenContext.CHARACTER)) {
                n2 = tokenItem2.getOffset();
                tokenID = (tokenItem2 = tokenItem2.getPrevious()) == null ? null : tokenItem2.getTokenID();
            }
            return this.getNextElement(n2);
        }
        if (HTMLSyntaxSupport.isTag(tokenItem2)) {
            if (tokenItem2.getTokenID() == HTMLTokenContext.TAG_OPEN || tokenItem2.getTokenID() == HTMLTokenContext.TAG_OPEN_SYMBOL) {
                return this.getNextElement(tokenItem2.getOffset());
            }
            TokenItem tokenItem3 = null;
            do {
                if ((tokenItem3 = tokenItem2.getPrevious()) == null) {
                    return this.getNextElement(tokenItem2.getOffset());
                }
                tokenItem2 = tokenItem3;
                tokenID = tokenItem2.getTokenID();
            } while (!HTMLSyntaxSupport.isTag(tokenItem2));
            return this.getNextElement(tokenItem2.getOffset());
        }
        if (tokenID == HTMLTokenContext.ERROR) {
            return new SyntaxElement(this, tokenItem2.getOffset(), this.getTokenEnd(tokenItem2), 2);
        }
        if (tokenID == HTMLTokenContext.BLOCK_COMMENT) {
            TokenItem tokenItem4 = null;
            while (tokenID == HTMLTokenContext.BLOCK_COMMENT && !tokenItem2.getImage().startsWith("<!--")) {
                tokenItem4 = tokenItem2;
                tokenItem2 = tokenItem2.getPrevious();
                tokenID = tokenItem2.getTokenID();
            }
            if (tokenItem2.getTokenID() != HTMLTokenContext.BLOCK_COMMENT) {
                tokenItem2 = tokenItem4;
            }
            return this.getNextElement(tokenItem2.getOffset());
        }
        if (tokenID == HTMLTokenContext.DECLARATION || tokenID == HTMLTokenContext.SGML_COMMENT) {
            while (tokenID != HTMLTokenContext.DECLARATION || !tokenItem2.getImage().startsWith("<!")) {
                tokenItem2 = tokenItem2.getPrevious();
                tokenID = tokenItem2.getTokenID();
            }
            return this.getNextElement(tokenItem2.getOffset());
        }
        return null;
    }

    SyntaxElement getPreviousElement(int n) throws BadLocationException {
        return n == 0 ? null : this.getElementChain(n - 1);
    }

    private static String getQuotedString(StringBuffer stringBuffer) {
        char c;
        int n = 0;
        if (stringBuffer == null || stringBuffer.length() == 0) {
            return null;
        }
        while (stringBuffer.charAt(n) == ' ') {
            ++n;
        }
        if ((c = stringBuffer.charAt(n++)) == '\"' || c == '\'') {
            for (int i = n; i < stringBuffer.length(); ++i) {
                if (stringBuffer.charAt(i) != c) continue;
                String string = stringBuffer.substring(n, i);
                stringBuffer.delete(0, i + 1);
                return string;
            }
        }
        return null;
    }

    public SyntaxElement getNextElement(int n) throws BadLocationException {
        TokenItem tokenItem = this.getTokenChain(n, Math.min(n + 10, this.getDocument().getLength()));
        if (tokenItem == null) {
            return null;
        }
        TokenID tokenID = tokenItem.getTokenID();
        int n2 = this.getTokenEnd(tokenItem);
        if (tokenID == HTMLTokenContext.BLOCK_COMMENT) {
            while (tokenID == HTMLTokenContext.BLOCK_COMMENT) {
                n2 = this.getTokenEnd(tokenItem);
                if ((tokenItem = tokenItem.getNext()) == null) break;
                tokenID = tokenItem.getTokenID();
            }
            return new SyntaxElement(this, n, n2, 0);
        }
        if (tokenID == HTMLTokenContext.DECLARATION) {
            String string;
            String string2;
            StringBuffer stringBuffer = new StringBuffer(tokenItem.getImage());
            while (tokenID == HTMLTokenContext.DECLARATION || tokenID == HTMLTokenContext.SGML_COMMENT) {
                n2 = this.getTokenEnd(tokenItem);
                if ((tokenItem = tokenItem.getNext()) == null) break;
                tokenID = tokenItem.getTokenID();
                if (tokenID != HTMLTokenContext.DECLARATION) continue;
                stringBuffer.append(tokenItem.getImage());
            }
            if (!(string2 = stringBuffer.toString()).startsWith("<!DOCTYPE")) {
                return new SyntaxElement.Declaration(this, n, n2, null, null, null);
            }
            int n3 = (string2 = string2.substring(9).trim()).indexOf(32);
            if (n3 < 0) {
                return new SyntaxElement.Declaration(this, n, n2, null, null, null);
            }
            String string3 = string2.substring(0, n3);
            if ((string2 = string2.substring(n3).trim()).startsWith("PUBLIC")) {
                stringBuffer = new StringBuffer(string2 = string2.substring(6).trim());
                String string4 = HTMLSyntaxSupport.getQuotedString(stringBuffer);
                if (string4 != null) {
                    String string5 = HTMLSyntaxSupport.getQuotedString(stringBuffer);
                    return new SyntaxElement.Declaration(this, n, n2, string3, string4, string5);
                }
            } else if (string2.startsWith("SYSTEM") && (string = HTMLSyntaxSupport.getQuotedString(stringBuffer = new StringBuffer(string2 = string2.substring(6).trim()))) != null) {
                return new SyntaxElement.Declaration(this, n, n2, string3, null, string);
            }
            return new SyntaxElement.Declaration(this, n, n2, null, null, null);
        }
        if (tokenID == HTMLTokenContext.ERROR) {
            return new SyntaxElement(this, tokenItem.getOffset(), n2, 2);
        }
        if (tokenID == HTMLTokenContext.TEXT || tokenID == HTMLTokenContext.CHARACTER) {
            while (tokenID == HTMLTokenContext.TEXT || tokenID == HTMLTokenContext.CHARACTER) {
                n2 = this.getTokenEnd(tokenItem);
                if ((tokenItem = tokenItem.getNext()) == null) break;
                tokenID = tokenItem.getTokenID();
            }
            return new SyntaxElement(this, n, n2, 3);
        }
        String string = tokenItem.getImage();
        if (tokenID == HTMLTokenContext.TAG_CLOSE || tokenID == HTMLTokenContext.TAG_CLOSE_SYMBOL) {
            String string6 = string;
            TokenID tokenID2 = tokenID = (tokenItem = tokenItem.getNext()) == null ? null : tokenItem.getTokenID();
            while (tokenID == HTMLTokenContext.WS) {
                n2 = this.getTokenEnd(tokenItem);
                tokenID = (tokenItem = tokenItem.getNext()) == null ? null : tokenItem.getTokenID();
            }
            if (tokenID == HTMLTokenContext.TAG_CLOSE_SYMBOL) {
                return new SyntaxElement.Named(this, n, this.getTokenEnd(tokenItem), 5, string6);
            }
            return new SyntaxElement.Named(this, n, n2, 5, string6);
        }
        if (tokenID == HTMLTokenContext.TAG_OPEN || tokenID == HTMLTokenContext.TAG_OPEN_SYMBOL) {
            String string7 = string;
            ArrayList<String> arrayList = new ArrayList<String>();
            TokenID tokenID3 = tokenID = (tokenItem = tokenItem.getNext()) == null ? null : tokenItem.getTokenID();
            while (!(tokenID == null || tokenID != HTMLTokenContext.WS && tokenID != HTMLTokenContext.ARGUMENT && tokenID != HTMLTokenContext.OPERATOR && tokenID != HTMLTokenContext.VALUE && tokenID != HTMLTokenContext.CHARACTER && tokenItem.getTokenContextPath().contains(HTMLTokenContext.contextPath))) {
                if (tokenID == HTMLTokenContext.ARGUMENT) {
                    arrayList.add(tokenItem.getImage());
                }
                n2 = this.getTokenEnd(tokenItem);
                tokenID = (tokenItem = tokenItem.getNext()) == null ? null : tokenItem.getTokenID();
            }
            if (tokenID == HTMLTokenContext.TAG_CLOSE_SYMBOL) {
                return new SyntaxElement.Tag(this, n, this.getTokenEnd(tokenItem), string7, arrayList, tokenItem.getImage().equals("/>"));
            }
            return new SyntaxElement.Tag(this, n, n2, string7, arrayList);
        }
        return null;
    }

    public List getPossibleEndTags(int n, String string) throws BadLocationException {
        string = string.toUpperCase();
        int n2 = string.length();
        SyntaxElement syntaxElement = this.getElementChain(n);
        Stack<String> stack = new Stack<String>();
        ArrayList<HTMLCompletionQuery.EndTagItem> arrayList = new ArrayList<HTMLCompletionQuery.EndTagItem>();
        HashSet<String> hashSet = new HashSet<String>();
        DTD dTD = this.getDTD();
        if (syntaxElement == null) {
            if (n > 0) {
                syntaxElement = this.getElementChain(n - 1);
                if (syntaxElement == null) {
                    return arrayList;
                }
            } else {
                return arrayList;
            }
        }
        int n3 = 0;
        while (syntaxElement != null) {
            DTD.Element element;
            if (syntaxElement.getType() == 5 && syntaxElement.getText().endsWith(">")) {
                element = dTD.getElement(((SyntaxElement.Named)syntaxElement).getName().toUpperCase());
                if (element != null && !element.isEmpty()) {
                    stack.push(((SyntaxElement.Named)syntaxElement).getName().toUpperCase());
                }
            } else if (syntaxElement.getType() == 4 && !syntaxElement.getText().startsWith("<") && (element = dTD.getElement(((SyntaxElement.Tag)syntaxElement).getName().toUpperCase())) != null && !element.isEmpty()) {
                String string2 = element.getName();
                if (stack.empty()) {
                    if (string2.startsWith(string) && !hashSet.contains(string2)) {
                        hashSet.add(string2);
                        arrayList.add(new HTMLCompletionQuery.EndTagItem(string2, n - 2 - n2, n2 + 2, string2, n3));
                    }
                    if (!element.hasOptionalEnd()) {
                        break;
                    }
                } else if (stack.peek().equals(string2)) {
                    stack.pop();
                } else if (!element.hasOptionalEnd()) break;
            }
            syntaxElement = syntaxElement.getPrevious();
        }
        return arrayList;
    }

    public int checkCompletion(JTextComponent jTextComponent, String string, boolean bl) {
        if (!bl) {
            int n = 1;
            int n2 = jTextComponent.getCaret().getDot();
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            switch (string.charAt(string.length() - 1)) {
                case '/': {
                    if (n2 < 2) break;
                    try {
                        String string2 = baseDocument.getText(n2 - 2, 2);
                        if (!string2.equals("</")) break;
                        n = 0;
                    }
                    catch (BadLocationException badLocationException) {}
                    break;
                }
                case ' ': {
                    HTMLSyntaxSupport hTMLSyntaxSupport = (HTMLSyntaxSupport)baseDocument.getSyntaxSupport().get(HTMLSyntaxSupport.class);
                    try {
                        TokenItem tokenItem = hTMLSyntaxSupport.getTokenChain(n2 - 1, n2);
                        if (tokenItem != null && tokenItem.getTokenID() == HTMLTokenContext.WS) {
                            return 0;
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                    break;
                }
                case '&': 
                case '<': {
                    n = 0;
                }
            }
            return n;
        }
        switch (string.charAt(0)) {
            case ';': 
            case '>': {
                return 4;
            }
        }
        return 3;
    }

    public static boolean isTag(TokenItem tokenItem) {
        return tokenItem.getTokenID() == HTMLTokenContext.TAG_OPEN || tokenItem.getTokenID() == HTMLTokenContext.TAG_CLOSE || tokenItem.getTokenID() == HTMLTokenContext.TAG_OPEN_SYMBOL || tokenItem.getTokenID() == HTMLTokenContext.TAG_CLOSE_SYMBOL;
    }

    public static boolean isTagButNotSymbol(TokenItem tokenItem) {
        return tokenItem.getTokenID() == HTMLTokenContext.TAG_OPEN || tokenItem.getTokenID() == HTMLTokenContext.TAG_CLOSE;
    }
}

