/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.html.HTMLSyntax;

public class LineWrapFormatter
extends ExtFormatter {
    int textLimit;
    Class kitClass;

    public LineWrapFormatter(Class clazz) {
        super(clazz);
        this.kitClass = clazz;
        this.textLimit = this.getTextLimit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTextLimit() {
        Object object = this.getSettingValue("text-limit-width");
        if (object != null && object instanceof Integer) {
            return (Integer)object;
        }
        Class clazz = Settings.class;
        synchronized (clazz) {
            Object object2 = Settings.getValue((Class)this.kitClass, (String)"text-limit-width");
            if (object2 != null && object2 instanceof Integer) {
                return (Integer)object2;
            }
        }
        return SettingsDefaults.defaultTextLimitWidth;
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        String string;
        super.settingsChange(settingsChangeEvent);
        String string2 = string = settingsChangeEvent != null ? settingsChangeEvent.getSettingName() : null;
        if (string == null || "text-limit-width".equals(string)) {
            this.textLimit = this.getTextLimit();
        }
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof HTMLSyntax;
    }

    public int[] getReformatBlock(JTextComponent jTextComponent, String string) {
        BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
        int n = jTextComponent.getCaret().getDot();
        if (string.length() == 0 || string.charAt(0) == '\b' || string.charAt(0) == '\u007f') {
            return null;
        }
        if (baseDocument != null) {
            try {
                String string2;
                int n2;
                int n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
                if (n - n3 > this.textLimit && (n2 = (string2 = baseDocument.getText(n3, n - n3)).lastIndexOf(32)) > 0) {
                    baseDocument.remove(n3 + n2, 1);
                    baseDocument.insertString(n3 + n2, "\n", null);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        return null;
    }

    protected int getEOLOffset(BaseDocument baseDocument, int n) throws BadLocationException {
        return n;
    }

    protected void initFormatLayers() {
    }
}

