/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;

public class SyntaxElement {
    public static final int TYPE_COMMENT = 0;
    public static final int TYPE_DECLARATION = 1;
    public static final int TYPE_ERROR = 2;
    public static final int TYPE_TEXT = 3;
    public static final int TYPE_TAG = 4;
    public static final int TYPE_ENDTAG = 5;
    public static final String[] TYPE_NAMES = new String[]{"comment", "declaration", "error", "text", "tag", "endtag"};
    private HTMLSyntaxSupport support;
    private SyntaxElement previous;
    private SyntaxElement next;
    int offset;
    int length;
    int type;

    public SyntaxElement(HTMLSyntaxSupport hTMLSyntaxSupport, int n, int n2, int n3) {
        this.support = hTMLSyntaxSupport;
        this.offset = n;
        this.length = n2 - n;
        this.type = n3;
    }

    public int getElementOffset() {
        return this.offset;
    }

    public int getElementLength() {
        return this.length;
    }

    public int getType() {
        return this.type;
    }

    public String getText() {
        try {
            return this.support.getDocument().getText(this.offset, this.length);
        }
        catch (BadLocationException badLocationException) {
            throw new ConcurrentModificationException("SyntaxElement in inconsistent state");
        }
    }

    public SyntaxElement getPrevious() throws BadLocationException {
        if (this.previous == null) {
            this.previous = this.support.getPreviousElement(this.offset);
            if (this.previous != null) {
                this.previous.next = this;
            }
        }
        return this.previous;
    }

    public SyntaxElement getNext() throws BadLocationException {
        if (this.next == null) {
            this.next = this.support.getNextElement(this.offset + this.length);
            if (this.next != null) {
                this.next.previous = this;
            }
        }
        return this.next;
    }

    public String toString() {
        String string = this.getType() == 3 ? this.getText() : "";
        return "Element(" + TYPE_NAMES[this.type] + ")[" + this.offset + "," + (this.offset + this.length - 1) + "] \"" + string + "";
    }

    public static class Tag
    extends Named {
        Collection attribs;
        private boolean empty = false;

        public Tag(HTMLSyntaxSupport hTMLSyntaxSupport, int n, int n2, String string, Collection collection) {
            this(hTMLSyntaxSupport, n, n2, string, collection, false);
        }

        public Tag(HTMLSyntaxSupport hTMLSyntaxSupport, int n, int n2, String string, Collection collection, boolean bl) {
            super(hTMLSyntaxSupport, n, n2, 4, string);
            this.attribs = collection;
            this.empty = bl;
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public Collection getAttributes() {
            return this.attribs;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append(" - {");
            Iterator iterator = this.attribs.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
                stringBuffer.append(", ");
            }
            stringBuffer.append("}");
            if (this.isEmpty()) {
                stringBuffer.append(" (EMPTY TAG)");
            }
            return stringBuffer.toString();
        }
    }

    public static class Named
    extends SyntaxElement {
        String name;

        public Named(HTMLSyntaxSupport hTMLSyntaxSupport, int n, int n2, int n3, String string) {
            super(hTMLSyntaxSupport, n, n2, n3);
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return super.toString() + " - \"" + this.name + '\"';
        }
    }

    public static class Declaration
    extends SyntaxElement {
        private String root;
        private String publicID;
        private String file;

        public Declaration(HTMLSyntaxSupport hTMLSyntaxSupport, int n, int n2, String string, String string2, String string3) {
            super(hTMLSyntaxSupport, n, n2, 1);
            this.root = string;
            this.publicID = string2;
            this.file = string3;
        }

        public String getRootElement() {
            return this.root;
        }

        public String getPublicIdentifier() {
            return this.publicID;
        }

        public String getDoctypeFile() {
            return this.file;
        }
    }
}

