/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.Invocation;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterClass;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKind;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.VariableAccess;
import org.netbeans.modules.editor.hints.spi.ChangeInfo;
import org.netbeans.modules.java.hints.CreateElementJavaHint;
import org.netbeans.modules.java.hints.DeclarationInfo;
import org.netbeans.modules.java.hints.PositionUtils;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class CreateMethodJavaHint
extends CreateElementJavaHint {
    private ClassDefinition javaClass;
    private static final Integer zero = new Integer(0);

    CreateMethodJavaHint(NamedElement namedElement, ClassDefinition classDefinition) {
        super(namedElement);
        this.javaClass = classDefinition;
        if (classDefinition instanceof ParameterizedType) {
            this.javaClass = ((ParameterizedType)classDefinition).getDefinition();
        }
        String string = this.name + '(' + this.getParameters() + ')';
        this.hintText = NbBundle.getMessage((Class)CreateMethodJavaHint.class, (String)"MSG_CreateMethod", (Object)string, (Object)classDefinition.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeInfo implement() {
        Method method;
        boolean bl;
        Resource resource;
        boolean bl2 = true;
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            JavaModel.setClassPath((Resource)this.unresolvedSymbol.getResource());
            resource = this.javaClass.getResource();
            Resource resource2 = this.unresolvedSymbol.getResource();
            bl = resource.equals(resource2);
            Type type = DeclarationInfo.computeType((Element)this.unresolvedSymbol);
            int n = this.computeAccessModifiers(this.javaClass, resource2);
            method = this.createMethod(n |= this.computeStaticModifier(this.unresolvedSymbol), type);
            bl2 = false;
        }
        finally {
            JavaModel.getJavaRepository().endTrans(bl2);
        }
        resource = PositionUtils.selectFirstStatement(method);
        if (!bl) {
            this.addModified();
        }
        return resource;
    }

    private Method createMethod(int n, Type type) {
        JavaModelPackage javaModelPackage = (JavaModelPackage)this.javaClass.refImmediatePackage();
        TypeReference typeReference = JavaModelUtil.resolveImportsForType((Element)this.javaClass, (Type)type);
        List list = this.createParams();
        String string = this.createBody(type);
        Method method = javaModelPackage.getMethod().createMethod(this.name, null, n, null, null, null, string, null, list, null, typeReference, 0);
        List list2 = this.javaClass.getContents();
        int n2 = PositionUtils.getProposedMethodIndex(list2);
        list2.add(n2, method);
        return method;
    }

    private String createBody(Type type) {
        String string;
        if (type instanceof PrimitiveType) {
            PrimitiveTypeKind primitiveTypeKind = ((PrimitiveType)type).getKind();
            if (PrimitiveTypeKindEnum.BOOLEAN.equals((Object)primitiveTypeKind)) {
                string = "false";
            } else if (PrimitiveTypeKindEnum.CHAR.equals((Object)primitiveTypeKind)) {
                string = "'\\0'";
            } else {
                if (PrimitiveTypeKindEnum.VOID.equals((Object)primitiveTypeKind)) {
                    return "throw new UnsupportedOperationException(\"Not yet implemented\");";
                }
                string = "0";
            }
        } else if (type instanceof ClassDefinition) {
            string = "null";
        } else {
            throw new IllegalArgumentException("Type " + type.getClass());
        }
        return "return ".concat(string).concat(";");
    }

    private List createParams() {
        JavaModelPackage javaModelPackage = (JavaModelPackage)this.javaClass.refImmediatePackage();
        ParameterClass parameterClass = javaModelPackage.getParameter();
        Invocation invocation = (Invocation)this.unresolvedSymbol;
        Expression[] expressionArray = invocation.getParameters().toArray(new Expression[0]);
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>(expressionArray.length);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < expressionArray.length; ++i) {
            Type type = expressionArray[i].getType();
            type = type == null ? javaModelPackage.getType().resolve("java.lang.Object") : CreateMethodJavaHint.getNamedType(type);
            TypeReference typeReference = JavaModelUtil.resolveImportsForType((Element)this.javaClass, (Type)type);
            String string = CreateMethodJavaHint.getName(expressionArray[i], type);
            Integer n = (Integer)hashMap.get(string);
            if (n != null) {
                hashMap.put(string, new Integer(n + 1));
                string = string.concat(n.toString());
            } else {
                hashMap.put(string, zero);
            }
            Parameter parameter = parameterClass.createParameter(string, null, false, typeReference, 0, false);
            arrayList.add(parameter);
        }
        return arrayList;
    }

    private static String getName(Expression expression, Type type) {
        if (expression instanceof VariableAccess) {
            VariableAccess variableAccess = (VariableAccess)expression;
            return variableAccess.getName();
        }
        return CreateMethodJavaHint.getName(type);
    }

    private static String getName(Type type) {
        if (type instanceof PrimitiveType) {
            return type.getName().substring(0, 1);
        }
        if (type instanceof JavaClass) {
            String string = ((JavaClass)type).getSimpleName();
            String string2 = string.substring(0, 1).toLowerCase().concat(string.substring(1));
            return Utilities.isJavaIdentifier((String)string2) ? string2 : 'a' + string;
        }
        if (type instanceof Array) {
            return CreateMethodJavaHint.getName(((Array)type).getType());
        }
        throw new IllegalArgumentException("Uknow type " + type.getClass());
    }

    private String getParameters() {
        Invocation invocation = (Invocation)this.unresolvedSymbol;
        Expression[] expressionArray = invocation.getParameters().toArray(new Expression[0]);
        if (expressionArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < expressionArray.length; ++i) {
                Type type = expressionArray[i].getType();
                String string = type != null ? CreateMethodJavaHint.getNamedType(type).getName() : "java.lang.Object";
                stringBuffer.append(string).append(',');
            }
            return stringBuffer.substring(0, stringBuffer.length() - 1);
        }
        return "";
    }

    private static Type getNamedType(Type type) {
        if (type instanceof ClassDefinition && type.getName() == null) {
            ClassDefinition classDefinition = (ClassDefinition)type;
            JavaClass[] javaClassArray = classDefinition.getInterfaces().toArray(new JavaClass[1]);
            type = javaClassArray[0] != null ? javaClassArray[0] : classDefinition.getSuperClass();
        }
        return type;
    }
}

