/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.Assignment;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Condition;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.InfixExpression;
import org.netbeans.jmi.javamodel.Invocation;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.LocalVariable;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.OperatorEnum;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.PrefixExpression;
import org.netbeans.jmi.javamodel.PrimaryExpression;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.ReturnStatement;
import org.netbeans.jmi.javamodel.SwitchStatement;
import org.netbeans.jmi.javamodel.ThisExpression;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeClass;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.openide.ErrorManager;

final class DeclarationInfo {
    private static ErrorManager ERR = ErrorManager.getDefault().getInstance("org.netbeans.modules.java.hints");
    private static Map primitiveTypeWeights = new HashMap();

    DeclarationInfo() {
    }

    public static String getSimpleName(Type type) {
        if (type instanceof JavaClass) {
            JavaClass javaClass = (JavaClass)type;
            String string = javaClass.getSimpleName();
            ClassDefinition classDefinition = javaClass.getDeclaringClass();
            String string2 = DeclarationInfo.getSimpleName((Type)classDefinition);
            if (string2 != null) {
                return string2 + "." + string;
            }
            return string;
        }
        if (type instanceof Array) {
            return DeclarationInfo.getSimpleName(((Array)type).getType()) + "[]";
        }
        if (type != null) {
            return type.getName();
        }
        return null;
    }

    private static String getPackageName(ClassDefinition classDefinition) {
        return classDefinition.getResource().getPackageName();
    }

    private static void collectMethods(ClassDefinition classDefinition, MethodMatcher methodMatcher, List list, Set set) {
        List list2;
        String string = classDefinition.getName();
        if (set.contains(string)) {
            return;
        }
        set.add(string);
        Object[] objectArray = classDefinition.getContents().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof Method) || DeclarationInfo.containsMethod(list, (Method)(list2 = (Method)objectArray[i])) || !methodMatcher.matches((Method)list2)) continue;
            list.add(list2);
        }
        JavaClass javaClass = classDefinition.getSuperClass();
        if (javaClass != null) {
            DeclarationInfo.collectMethods((ClassDefinition)javaClass, methodMatcher, list, set);
        }
        list2 = classDefinition.getInterfaces();
        JavaClass[] javaClassArray = list2.toArray(new JavaClass[0]);
        for (int i = 0; i < javaClassArray.length; ++i) {
            DeclarationInfo.collectMethods((ClassDefinition)javaClassArray[i], methodMatcher, list, set);
        }
    }

    public static boolean isAssignableFrom(Type type, Type type2) {
        if (type instanceof PrimitiveType && type2 instanceof PrimitiveType) {
            int n;
            String string = ((PrimitiveType)type).getName();
            String string2 = ((PrimitiveType)type2).getName();
            if (string.equals("void") || string2.equals("void")) {
                return false;
            }
            if (string.equals(string2)) {
                return true;
            }
            if (string.equals("boolean") || string2.equals("boolean")) {
                return false;
            }
            int n2 = (Integer)primitiveTypeWeights.get(string);
            return n2 >= (n = ((Integer)primitiveTypeWeights.get(string2)).intValue());
        }
        if (type instanceof ClassDefinition && type2 instanceof ClassDefinition) {
            ClassDefinition classDefinition = (ClassDefinition)type;
            ClassDefinition classDefinition2 = (ClassDefinition)type2;
            return classDefinition.getName().equals(classDefinition2.getName()) || classDefinition2.isSubTypeOf(classDefinition);
        }
        return false;
    }

    private static boolean containsMethod(List list, Method method) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!method.signatureEquals((Method)iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean isFeatureAccessibleFrom(Feature feature, ClassDefinition classDefinition, Expression expression) {
        int n = feature.getModifiers();
        if ((1 & n) != 0) {
            return true;
        }
        ClassDefinition classDefinition2 = feature.getDeclaringClass();
        if ((2 & n) != 0) {
            return DeclarationInfo.isSameOrInnerClassOf(feature.getDeclaringClass(), classDefinition);
        }
        if ((4 & n) != 0 && (expression == null || expression instanceof ThisExpression)) {
            return DeclarationInfo.getPackageName(classDefinition2).equals(DeclarationInfo.getPackageName(classDefinition)) || classDefinition.isSubTypeOf(classDefinition2);
        }
        return DeclarationInfo.getPackageName(classDefinition2).equals(DeclarationInfo.getPackageName(classDefinition));
    }

    public static boolean isSameOrInnerClassOf(ClassDefinition classDefinition, ClassDefinition classDefinition2) {
        ClassDefinition classDefinition3 = classDefinition;
        while (classDefinition != null) {
            if (classDefinition.getName().equals(classDefinition2.getName())) {
                return true;
            }
            if (classDefinition instanceof JavaClass) {
                classDefinition = ((JavaClass)classDefinition).getDeclaringClass();
                continue;
            }
            classDefinition = null;
        }
        return false;
    }

    public static ClassDefinition getContainingClass(Element element) {
        Element element2 = element;
        while (element2 != null && element2 instanceof RefObject && !(element2 instanceof ClassDefinition)) {
            element2 = ((RefObject)element2).refImmediateComposite();
        }
        return element2 instanceof ClassDefinition ? (ClassDefinition)element2 : null;
    }

    public static Method getMethodByNameAndParamTypeNames(ClassDefinition classDefinition, String string, String[] stringArray) {
        Feature[] featureArray = classDefinition.getFeatures().toArray(new Feature[0]);
        for (int i = 0; i < featureArray.length; ++i) {
            List list;
            Method method;
            if (!(featureArray[i] instanceof Method) || !(method = (Method)featureArray[i]).getName().equals(string) || (list = method.getParameters()).size() != stringArray.length) continue;
            Parameter[] parameterArray = method.getParameters().toArray(new Parameter[0]);
            for (int j = 0; j < parameterArray.length; ++j) {
                if (parameterArray[j].getType().getName().equals(stringArray[j])) continue;
            }
            return method;
        }
        return null;
    }

    public static List getMethodsByNameAndParamCount(ClassDefinition classDefinition, String string, int n) {
        ArrayList arrayList = new ArrayList();
        HashSet hashSet = new HashSet();
        DeclarationInfo.collectMethods(classDefinition, new MethodNameAndParamCountMatcher(string, n), arrayList, hashSet);
        return arrayList;
    }

    public static List getConstructorsByParamCount(ClassDefinition classDefinition, int n) {
        Feature[] featureArray = classDefinition.getFeatures().toArray(new Feature[0]);
        ArrayList<Constructor> arrayList = new ArrayList<Constructor>();
        for (int i = 0; i < featureArray.length; ++i) {
            Constructor constructor;
            Feature feature = featureArray[i];
            if (!(feature instanceof Constructor) || (constructor = (Constructor)feature).getParameters().size() != n) continue;
            arrayList.add(constructor);
        }
        return arrayList;
    }

    public static List getAbstractMethods(ClassDefinition classDefinition) {
        HashSet hashSet = new HashSet();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        DeclarationInfo.collectMethods(classDefinition, new AbstractMethodMatcher(arrayList2), arrayList, hashSet);
        return arrayList;
    }

    protected static Type computeType(Element element) {
        Feature feature;
        Element element2;
        Element element3 = element;
        Object object = null;
        do {
            element2 = element3;
        } while ((element3 = (Element)element3.refImmediateComposite()) != null && !(element3 instanceof Assignment) && !(element3 instanceof LocalVariable) && !(element3 instanceof Field) && !(element3 instanceof ReturnStatement) && !(element3 instanceof Invocation) && !(element3 instanceof InfixExpression) && !(element3 instanceof PrefixExpression) && !(element3 instanceof SwitchStatement) && !(element3 instanceof Condition));
        if (element3 instanceof ReturnStatement) {
            feature = JavaModelUtil.getDeclaringFeature((Element)element3);
            object = (Method)feature;
        } else if (element3 instanceof Assignment) {
            feature = (Assignment)element3;
            Expression expression = feature.getRightSide();
            PrimaryExpression primaryExpression = feature.getLeftSide();
            object = element2.equals(expression) ? primaryExpression : expression;
        } else if (element3 instanceof Variable) {
            object = (Variable)element3;
        } else if (element3 instanceof Invocation) {
            List list;
            feature = (Invocation)element3;
            CallableFeature callableFeature = (CallableFeature)feature.getElement();
            int n = feature.getParameters().indexOf(element2);
            if (callableFeature != null && n >= 0 && (list = callableFeature.getParameters()).size() > n) {
                object = (Parameter)list.get(n);
            }
        } else if (element3 instanceof InfixExpression) {
            feature = (InfixExpression)element3;
            Expression expression = feature.getRightSide();
            Expression expression2 = feature.getLeftSide();
            object = element2.equals(expression) ? expression2 : expression;
        } else {
            if (element3 instanceof PrefixExpression) {
                TypeClass typeClass = ((JavaModelPackage)element3.refImmediatePackage()).getType();
                PrefixExpression prefixExpression = (PrefixExpression)element3;
                if (OperatorEnum.NOT.equals((Object)prefixExpression.getOperator())) {
                    return typeClass.resolve("boolean");
                }
                return typeClass.resolve("int");
            }
            if (element3 instanceof SwitchStatement) {
                feature = (SwitchStatement)element3;
                object = feature.getExpression();
            } else if (element3 instanceof Condition && (feature = (Condition)element3).getExpression().equals(element2)) {
                TypeClass typeClass = ((JavaModelPackage)element3.refImmediatePackage()).getType();
                return typeClass.resolve("boolean");
            }
        }
        if (object != null && (feature = object.getType()) != null) {
            return feature;
        }
        return DeclarationInfo.comupteDefaultType(element);
    }

    private static Type comupteDefaultType(Element element) {
        TypeClass typeClass = ((JavaModelPackage)element.refImmediatePackage()).getType();
        String string = element instanceof Invocation ? "void" : "java.lang.Object";
        return typeClass.resolve(string);
    }

    static boolean canbeCastTo(Type type, Type type2) {
        if (type2 instanceof PrimitiveType && type instanceof PrimitiveType) {
            return true;
        }
        if (type2 instanceof Array && type instanceof Array) {
            Array array = (Array)type2;
            Array array2 = (Array)type;
            return DeclarationInfo.canbeCastTo(array2.getType(), array.getType());
        }
        if (type2 instanceof ClassDefinition && type instanceof ClassDefinition) {
            ClassDefinition classDefinition = (ClassDefinition)type2;
            ClassDefinition classDefinition2 = (ClassDefinition)type;
            if (classDefinition2 instanceof TypeParameter) {
                ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>(1);
                arrayList.add(classDefinition2.getSuperClass());
                arrayList.addAll(classDefinition2.getInterfaces());
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    if (!DeclarationInfo.canbeCastTo((Type)((JavaClass)iterator.next()), (Type)classDefinition)) continue;
                    return true;
                }
                return false;
            }
            if (classDefinition.isSubTypeOf(classDefinition2)) {
                return true;
            }
        }
        return false;
    }

    static {
        primitiveTypeWeights.put("byte", new Integer(0));
        primitiveTypeWeights.put("char", new Integer(1));
        primitiveTypeWeights.put("short", new Integer(2));
        primitiveTypeWeights.put("int", new Integer(3));
        primitiveTypeWeights.put("long", new Integer(4));
        primitiveTypeWeights.put("float", new Integer(5));
        primitiveTypeWeights.put("double", new Integer(6));
    }

    private static class ReturnTypeMatcher
    implements MethodMatcher {
        Type returnType;

        ReturnTypeMatcher(Type type) {
            this.returnType = type;
        }

        public boolean matches(Method method) {
            ClassDefinition classDefinition;
            ClassDefinition classDefinition2;
            Type type = method.getType();
            boolean bl = false;
            if (type instanceof PrimitiveType && this.returnType instanceof PrimitiveType) {
                String string = ((PrimitiveType)type).getName();
                String string2 = ((PrimitiveType)this.returnType).getName();
                if (string2.equals("boolean") && string.equals("boolean")) {
                    return true;
                }
                if (!(string.equals("void") || string.equals("boolean") || string2.equals("boolean"))) {
                    int n = (Integer)primitiveTypeWeights.get(string);
                    int n2 = (Integer)primitiveTypeWeights.get(string2);
                    if (n2 >= n) {
                        return true;
                    }
                }
            } else if (type instanceof ClassDefinition && this.returnType instanceof ClassDefinition && DeclarationInfo.isAssignableFrom((Type)(classDefinition2 = (ClassDefinition)this.returnType), (Type)(classDefinition = (ClassDefinition)type))) {
                return true;
            }
            return false;
        }
    }

    private static class AbstractMethodMatcher
    implements MethodMatcher {
        List checkedMethods;

        AbstractMethodMatcher(List list) {
            this.checkedMethods = list;
        }

        public boolean matches(Method method) {
            boolean bl = Modifier.isAbstract(method.getModifiers());
            if (bl && DeclarationInfo.containsMethod(this.checkedMethods, method)) {
                bl = false;
            }
            this.checkedMethods.add(method);
            return bl;
        }
    }

    private static class MethodNameAndParamCountMatcher
    implements MethodMatcher {
        String name;
        int paramCount;

        MethodNameAndParamCountMatcher(String string, int n) {
            this.name = string;
            this.paramCount = n;
        }

        public boolean matches(Method method) {
            return method.getName().equals(this.name) && method.getParameters().size() == this.paramCount;
        }
    }

    private static interface MethodMatcher {
        public boolean matches(Method var1);
    }
}

