/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.java.hints.DeclarationInfo;
import org.netbeans.modules.javacore.api.JavaModel;

public final class GeneratorUtils {
    public static final int GETTER = 1;
    public static final int SETTER = 2;
    private static final int OK = 0;
    private static final int AMBIGUOUS = 1;
    private static final int CLASHING = 2;

    private GeneratorUtils() {
    }

    public static String handleImport(Resource resource, Type type, boolean bl) {
        boolean bl2 = true;
        if (type instanceof Array) {
            return GeneratorUtils.handleImport(resource, ((Array)type).getType(), bl) + "[]";
        }
        if (type instanceof TypeParameter && bl2) {
            return GeneratorUtils.handleImport(resource, ((TypeParameter)type).getSuperClass(), bl);
        }
        if (type instanceof AnnotationType || type instanceof ParameterizedType && ((ParameterizedType)type).getDefinition() instanceof AnnotationType) {
            return "@" + GeneratorUtils.handleImport(resource, (JavaClass)type, bl);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            JavaClass javaClass = parameterizedType.getDefinition();
            List list = parameterizedType.getParameters();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(GeneratorUtils.handleImport(resource, javaClass, bl));
            if (list.size() > 0) {
                stringBuffer.append('<');
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Type type2 = (Type)iterator.next();
                    stringBuffer.append(GeneratorUtils.handleImport(resource, type2, bl));
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append('>');
            }
            return stringBuffer.toString();
        }
        if (type instanceof JavaClass) {
            return GeneratorUtils.handleImport(resource, (JavaClass)type, bl);
        }
        return type.getName();
    }

    private static String handleImport(Resource resource, JavaClass javaClass, boolean bl) {
        if (GeneratorUtils.autoImport(resource, javaClass, false, bl)) {
            return DeclarationInfo.getSimpleName((Type)javaClass);
        }
        return javaClass.getName();
    }

    private static int checkImport(JavaClass javaClass, Resource resource) {
        int n = 0;
        String string = javaClass.getSimpleName();
        Iterator iterator = resource.getImports().iterator();
        block0: while (iterator.hasNext()) {
            Object object;
            Import import_ = (Import)iterator.next();
            if (import_.isOnDemand()) {
                if (n != 0) continue;
                object = import_.getImportedElements().iterator();
                while (object.hasNext()) {
                    NamedElement namedElement = (NamedElement)object.next();
                    if (!(namedElement instanceof JavaClass) || !string.equals(((JavaClass)namedElement).getSimpleName()) || namedElement.equals(javaClass)) continue;
                    n = 1;
                    continue block0;
                }
                continue;
            }
            object = import_.getImportedNamespace();
            if (!(object instanceof JavaClass) || !string.equals(((JavaClass)object).getSimpleName()) || object.equals(javaClass) || object.getName().equals(javaClass.getName())) continue;
            return 2;
        }
        return n;
    }

    private static boolean isClassAlreadyImported(JavaClass javaClass, Resource resource, int n) {
        Object object;
        Object object2;
        if (!javaClass.isInner()) {
            object2 = GeneratorUtils.getPackageName((ClassDefinition)javaClass);
            if (("java.lang".equals(object2) || resource.getPackageName().equals(object2)) && n == 0) {
                return true;
            }
            object = resource.getImports().iterator();
            while (object.hasNext()) {
                Import import_ = (Import)object.next();
                if (import_.isOnDemand() && import_.getImportedElements().contains(javaClass) && n == 0) {
                    return true;
                }
                NamedElement namedElement = import_.getImportedNamespace();
                if (!(namedElement instanceof JavaClass) || !namedElement.equals(javaClass) && !namedElement.getName().equals(javaClass.getName()) || n != 0) continue;
                return true;
            }
        }
        object2 = resource.getImports().iterator();
        while (object2.hasNext()) {
            object = (Import)object2.next();
            if (object.isOnDemand() || !javaClass.equals(object.getImportedNamespace())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean autoImport(Resource resource, JavaClass javaClass, boolean bl, boolean bl2) {
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            int n;
            if (resource != null) {
                n = GeneratorUtils.checkImport(javaClass, resource);
                if (n == 2) {
                    boolean bl3 = false;
                    return bl3;
                }
                if (!GeneratorUtils.isClassAlreadyImported(javaClass, resource, n) && !bl2) {
                    GeneratorUtils.addImport((NamedElement)javaClass, resource);
                }
            }
            n = 1;
            return n != 0;
        }
        finally {
            JavaModel.getJavaRepository().endTrans(false);
        }
    }

    private static void addImport(NamedElement namedElement, Resource resource) {
        Import import_;
        String string = namedElement.getName();
        ListIterator<Import> listIterator = resource.getImports().listIterator();
        while (listIterator.hasNext()) {
            import_ = (Import)listIterator.next();
            String string2 = import_.getName();
            if (string2 == null || string.compareTo(string2) >= 0) continue;
            listIterator.previous();
            break;
        }
        import_ = ((JavaModelPackage)resource.refOutermostPackage()).getImport();
        listIterator.add(import_.createImport(string, null, false, namedElement instanceof JavaPackage));
    }

    private static String getPackageName(ClassDefinition classDefinition) {
        String string;
        Resource resource;
        if (classDefinition instanceof UnresolvedClass) {
            String string2 = classDefinition.getName();
            int n = string2.lastIndexOf(46);
            return n < 0 ? "" : string2.substring(0, n);
        }
        if (classDefinition instanceof JavaClass && (resource = classDefinition.getResource()) != null && (string = resource.getPackageName()) != null) {
            return string;
        }
        return "";
    }
}

