/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.jmi.javamodel.ArrayAccess;
import org.netbeans.jmi.javamodel.BehavioralFeature;
import org.netbeans.jmi.javamodel.BooleanLiteral;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.CharLiteral;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ConditionalExpression;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.DoubleLiteral;
import org.netbeans.jmi.javamodel.ErrorInfo;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.FloatLiteral;
import org.netbeans.jmi.javamodel.IntLiteral;
import org.netbeans.jmi.javamodel.Invocation;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.LongLiteral;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MethodInvocation;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.NewClassExpression;
import org.netbeans.jmi.javamodel.NullLiteral;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.PrimaryExpression;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.StringLiteral;
import org.netbeans.jmi.javamodel.ThisExpression;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.VariableAccess;
import org.netbeans.modules.editor.hints.spi.HintsProvider;
import org.netbeans.modules.editor.java.JMIUtils;
import org.netbeans.modules.java.hints.AddCastJavaHint;
import org.netbeans.modules.java.hints.AddThrowsClauseJavaHint;
import org.netbeans.modules.java.hints.CreateFieldJavaHint;
import org.netbeans.modules.java.hints.CreateLocVarJavaHint;
import org.netbeans.modules.java.hints.CreateMethodJavaHint;
import org.netbeans.modules.java.hints.CreateParameterJavaHint;
import org.netbeans.modules.java.hints.DeclarationInfo;
import org.netbeans.modules.java.hints.ImplementMethodJavaHint;
import org.netbeans.modules.java.hints.ImplementMethodJavaHint2;
import org.netbeans.modules.java.hints.ImportJavaHint;
import org.netbeans.modules.java.hints.InitializeVariableHint;
import org.netbeans.modules.java.hints.MakeClassAbstractJavaHint;
import org.netbeans.modules.java.hints.TryWrapperJavaHint;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.internalapi.ParsingListener;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;

public final class JavaHintsProvider
extends HintsProvider
implements ParsingListener {
    private static ErrorManager ERR;
    private static final String INCOMPATIBLE_TYPES = "prob.found.req";
    private static final String CANT_RESOLVE = "cant.resolve";
    private static final String CANT_RESOLVE_LOCATION = "cant.resolve.location";
    private static final String CANT_APPLY_SYMBOL = "cant.apply.symbol";
    private static final String UNREPORTED_EXCEPTION_ERROR = "unreported.exception.need.to.catch.or.throw";
    private static final String VAR_MIGHT_NOT_HAVE_BEEN_INITIALIZED = "var.might.not.have.been.initialized";
    private static final String DOES_NOT_OVERRIDE_ABSTRACT = "does.not.override.abstract";
    private static final String ABSTRACT_CANT_BE_INSTANTIATED = "abstract.cant.be.instantiated";
    private static final String DOESNT_EXIST = "doesnt.exist";
    private static final String KINDNAME_CONSTRUCTOR = "kindname.constructor";
    private static final String KINDNAME_VARIABLE = "kindname.variable";
    private static final String KINDNAME_METHOD = "kindname.method";
    private static final int TabInc = 8;
    private static HintCreator[] creators;
    private static FieldHintCreator[] fieldHintCreators;
    private static MethodHintCreator[] methodHintCreators;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JavaHintsProvider() {
        JavaMetamodel.getManager();
        JavaMetamodel.addParsingListener((ParsingListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getHints(Document document, int n) {
        if (!(document instanceof BaseDocument)) return Collections.EMPTY_LIST;
        try {
            Resource resource;
            JavaMetamodel javaMetamodel;
            ArrayList arrayList;
            block20: {
                BaseDocument baseDocument = (BaseDocument)document;
                int n2 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n) + 1;
                int n3 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)Utilities.getRowStart((BaseDocument)baseDocument, (int)n));
                int n4 = Utilities.getFirstNonWhiteBwd((BaseDocument)baseDocument, (int)Utilities.getRowEnd((BaseDocument)baseDocument, (int)n));
                if (n3 > n4) {
                    return Collections.EMPTY_LIST;
                }
                n = Math.min(Math.max(n, n3), n4);
                arrayList = new ArrayList();
                HashSet<String> hashSet = new HashSet<String>();
                javaMetamodel = JavaMetamodel.getManager();
                resource = null;
                JavaModel.getJavaRepository().beginTrans(false);
                try {
                    String string;
                    ErrorInfo errorInfo;
                    List list;
                    JMIUtils jMIUtils = JMIUtils.get((BaseDocument)baseDocument);
                    resource = jMIUtils.getResource();
                    if (resource == null) {
                        ArrayList arrayList2 = arrayList;
                        return arrayList2;
                    }
                    JavaModel.setClassPath((Resource)resource);
                    if (ERR.isLoggable(1)) {
                        list = resource.getElementByOffset(n);
                        ERR.log("el=" + list);
                    }
                    list = resource.getErrors();
                    org.netbeans.jmi.javamodel.Element element = list.iterator();
                    while (element.hasNext()) {
                        errorInfo = (ErrorInfo)element.next();
                        if (errorInfo.getLineNumber() != n2) continue;
                        string = errorInfo.getDescription();
                        if (ERR.isLoggable(1)) {
                            ERR.log("description = " + string);
                            ERR.log("line = " + errorInfo.getLineNumber());
                            ERR.log("column = " + errorInfo.getColumn());
                        }
                        if (hashSet.contains(string)) continue;
                        hashSet.add(string);
                        for (int i = 0; i < creators.length; ++i) {
                            if (!errorInfo.getErrorId().equals(creators[i].getErrorId())) continue;
                            creators[i].createHint(jMIUtils, resource, document, errorInfo, arrayList);
                        }
                    }
                    element = resource.getElementByOffset(n);
                    if (ERR.isLoggable(1)) {
                        ERR.log("element = " + element);
                    }
                    if (element instanceof Field) {
                        errorInfo = (Field)element;
                        for (int i = 0; i < fieldHintCreators.length; ++i) {
                            fieldHintCreators[i].createHint(jMIUtils, resource, document, (Field)errorInfo, n, arrayList);
                        }
                        break block20;
                    }
                    errorInfo = JavaModelUtil.getDeclaringFeature((org.netbeans.jmi.javamodel.Element)element);
                    if (!(errorInfo instanceof CallableFeature)) break block20;
                    string = (CallableFeature)errorInfo;
                    PositionBounds positionBounds = javaMetamodel.getElementPosition((org.netbeans.jmi.javamodel.Element)string);
                    if (string instanceof Method && positionBounds.getBegin().getOffset() <= n && positionBounds.getEnd().getOffset() >= n) {
                        for (int i = 0; i < methodHintCreators.length; ++i) {
                            methodHintCreators[i].createHint(jMIUtils, resource, document, (Method)string, n, arrayList);
                        }
                    }
                }
                catch (Exception exception) {
                    if (resource == null) throw new RuntimeException(exception);
                    if (!javaMetamodel.isModified(javaMetamodel.getFileObject(resource))) {
                        throw new RuntimeException(exception);
                    }
                }
                finally {
                    JavaModel.getJavaRepository().endTrans();
                }
            }
            if (!javaMetamodel.isModified(javaMetamodel.getFileObject(resource))) return arrayList;
            return Collections.EMPTY_LIST;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return Collections.EMPTY_LIST;
    }

    private static boolean isConstant(Field field, boolean bl) {
        int n = 24;
        if (bl) {
            n |= 1;
        }
        return (field.getModifiers() & n) == n;
    }

    private static boolean isFinal(Field field) {
        return (field.getModifiers() & 0x10) == 16;
    }

    private static void handleUnresolvedHints(JMIUtils jMIUtils, Resource resource, int n, ClassDefinition classDefinition, String string, boolean bl, boolean bl2, boolean bl3, List list) {
        if ((bl || bl2) && classDefinition != null && !JavaHintsProvider.isReadOnly(classDefinition.getResource())) {
            NamedElement namedElement = JavaHintsProvider.getElementByOffset(resource, n, string);
            if (namedElement != null) {
                if (bl) {
                    MultipartId multipartId;
                    Feature feature = JavaModelUtil.getDeclaringFeature((org.netbeans.jmi.javamodel.Element)namedElement);
                    list.add(new CreateFieldJavaHint(namedElement, classDefinition));
                    boolean bl4 = namedElement instanceof MultipartId ? (multipartId = (MultipartId)namedElement).getParent() == null : false;
                    if (feature instanceof BehavioralFeature && bl4) {
                        if (feature instanceof CallableFeature) {
                            list.add(new CreateParameterJavaHint(namedElement));
                        }
                        list.add(new CreateLocVarJavaHint(namedElement));
                    }
                } else if (bl2 && namedElement instanceof Invocation) {
                    list.add(new CreateMethodJavaHint(namedElement, classDefinition));
                }
            }
        } else if (bl3) {
            JavaHintsProvider.addImportVariants(jMIUtils, resource, string, list);
        }
    }

    private static void addImportVariants(JMIUtils jMIUtils, Resource resource, String string, List list) {
        List list2 = JavaHintsProvider.findClasses(jMIUtils, string, JavaHintsProvider.getTopJavaClass(resource));
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass = (JavaClass)iterator.next();
            ImportJavaHint importJavaHint = new ImportJavaHint(resource, javaClass);
            if (list.contains((Object)importJavaHint)) continue;
            list.add(0, importJavaHint);
        }
    }

    private static JavaClass getTopJavaClass(Resource resource) {
        Iterator iterator;
        if (resource != null && (iterator = resource.getClassifiers().iterator()).hasNext()) {
            return (JavaClass)iterator.next();
        }
        return null;
    }

    private static boolean isReadOnly(Resource resource) {
        return resource == null || (resource.getStatus() & Integer.MIN_VALUE) != 0 || !JavaMetamodel.getManager().getFileObject(resource).canWrite();
    }

    public void resourceParsed(Resource resource) {
        DataObject dataObject = JavaMetamodel.getManager().getDataObject(resource);
        if (dataObject != null) {
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            this.firePropertyChangeEvent("refresh", null, editorCookie.getDocument());
        }
    }

    public static List findClasses(JMIUtils jMIUtils, String string, JavaClass javaClass) {
        TreeSet<JavaClass> treeSet = new TreeSet<JavaClass>(jMIUtils.getNaturalMemberNameComparator());
        ClassPath classPath = JavaMetamodel.getManager().getClassPath();
        FileObject[] fileObjectArray = classPath.getRoots();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (!$assertionsDisabled && fileObjectArray[i] == null) {
                throw new AssertionError((Object)"Classpath root is null");
            }
            ClassIndex classIndex = ClassIndex.getIndex((JavaModelPackage)JavaModel.getJavaExtent((FileObject)fileObjectArray[i]));
            if (classIndex == null) {
                ErrorManager.getDefault().log(1, "Index not found for " + fileObjectArray[i]);
                continue;
            }
            Iterator iterator = classIndex.getClassesBySimpleName(string).iterator();
            while (iterator.hasNext()) {
                JavaClass javaClass2 = (JavaClass)iterator.next();
                if (javaClass2.isInner() || !jMIUtils.isAccessible((ClassDefinition)javaClass2, javaClass)) continue;
                treeSet.add(javaClass2);
            }
        }
        return new ArrayList(treeSet);
    }

    public static int getErrorOffset(Document document, ErrorInfo errorInfo) {
        Element element = ((BaseDocument)document).getParagraphElement(0).getParentElement();
        Element element2 = element.getElement(errorInfo.getLineNumber() - 1);
        String string = null;
        int n = element2.getStartOffset();
        try {
            string = document.getText(n, element2.getEndOffset() - n);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
        int n2 = errorInfo.getColumn() - 1;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            n3 = string.charAt(n4) == '\t' ? n3 / 8 * 8 + 8 : ++n3;
            ++n4;
        }
        return n + n4;
    }

    private static NamedElement getElementByOffset(Resource resource, int n, String string) {
        org.netbeans.jmi.javamodel.Element element = resource.getElementByOffset(n);
        int n2 = string.indexOf(40);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        int n3 = 0;
        while (n3 < 2) {
            NamedElement namedElement;
            if (element instanceof NamedElement && string.equals((namedElement = (NamedElement)element).getName())) {
                return namedElement;
            }
            ++n3;
            element = (org.netbeans.jmi.javamodel.Element)element.refImmediateComposite();
        }
        return null;
    }

    static {
        $assertionsDisabled = !JavaHintsProvider.class.desiredAssertionStatus();
        ERR = ErrorManager.getDefault().getInstance("org.netbeans.modules.java.hints");
        creators = new HintCreator[]{new UnreportedExceptionHintCreator(), new IncompatibleTypesHintCreator(), new IncorrectArgumentsHintCreator(), new ImplementAbstractMethodsHintCreator(), new ImplementAbstractMethods2HintCreator(), new InitializeVariableHintCreator(), new UnresolvedSymbolCreator(), new UnresolvedSymbolCreatorNoLocation(), new PackageDoesNotExistCreator()};
        fieldHintCreators = new FieldHintCreator[0];
        methodHintCreators = new MethodHintCreator[0];
    }

    private static class PackageDoesNotExistCreator
    extends HintCreator {
        private PackageDoesNotExistCreator() {
        }

        public String getErrorId() {
            return JavaHintsProvider.DOESNT_EXIST;
        }

        public void createHint(JMIUtils jMIUtils, Resource resource, Document document, ErrorInfo errorInfo, List list) {
            if (JavaHintsProvider.isReadOnly(resource)) {
                return;
            }
            JavaHintsProvider.addImportVariants(jMIUtils, resource, (String)errorInfo.getArguments().get(0), list);
        }
    }

    private static class UnresolvedSymbolCreatorNoLocation
    extends HintCreator {
        private UnresolvedSymbolCreatorNoLocation() {
        }

        public String getErrorId() {
            return JavaHintsProvider.CANT_RESOLVE;
        }

        public void createHint(JMIUtils jMIUtils, Resource resource, Document document, ErrorInfo errorInfo, List list) {
            if (JavaHintsProvider.isReadOnly(resource)) {
                return;
            }
            JavaHintsProvider.addImportVariants(jMIUtils, resource, (String)errorInfo.getArguments().get(1), list);
        }
    }

    private static class UnresolvedSymbolCreator
    extends HintCreator {
        private UnresolvedSymbolCreator() {
        }

        public String getErrorId() {
            return JavaHintsProvider.CANT_RESOLVE_LOCATION;
        }

        public void createHint(JMIUtils jMIUtils, Resource resource, Document document, ErrorInfo errorInfo, List list) {
            int n;
            BaseDocument baseDocument;
            Constructor constructor;
            Object object;
            List list2;
            Object object2;
            Object object3;
            int n2;
            Object object4;
            if (JavaHintsProvider.isReadOnly(resource)) {
                return;
            }
            List list3 = errorInfo.getArguments();
            String string = (String)list3.get(0);
            String string2 = (String)list3.get(1);
            String string3 = (String)list3.get(5);
            if (!JavaHintsProvider.KINDNAME_VARIABLE.equals(string) && !JavaHintsProvider.KINDNAME_CONSTRUCTOR.equals(string)) {
                JavaHintsProvider.addImportVariants(jMIUtils, resource, string2, list);
            }
            JavaClass javaClass = jMIUtils.getExactClass(string3);
            if (JavaHintsProvider.KINDNAME_METHOD.equals(string)) {
                object4 = JavaHintsProvider.getElementByOffset(resource, JavaHintsProvider.getErrorOffset(document, errorInfo), string2);
                if (object4 != null && object4 instanceof MethodInvocation && (n2 = (object3 = (object2 = (MethodInvocation)object4).getParameters()).size()) > 0) {
                    javaClass = this.getParentClass((MethodInvocation)object2);
                    list2 = DeclarationInfo.getMethodsByNameAndParamCount((ClassDefinition)javaClass, string2, n2);
                    object = DeclarationInfo.getContainingClass((org.netbeans.jmi.javamodel.Element)object2);
                    constructor = list2.iterator();
                    while (constructor.hasNext()) {
                        baseDocument = (Method)constructor.next();
                        if (!DeclarationInfo.isFeatureAccessibleFrom((Feature)baseDocument, (ClassDefinition)object, (Expression)object2.getParentClass())) continue;
                        this.checkParamsAndAddHint((List)object3, baseDocument.getParameters(), list);
                    }
                }
            } else if (JavaHintsProvider.KINDNAME_CONSTRUCTOR.equals(string) && (object4 = (NewClassExpression)JavaHintsProvider.getElementByOffset(resource, JavaHintsProvider.getErrorOffset(document, errorInfo), string2)) != null && (n = (object2 = object4.getParameters()).size()) != 0) {
                javaClass = (ClassDefinition)object4.getClassName().getElement();
                List list4 = DeclarationInfo.getConstructorsByParamCount((ClassDefinition)javaClass, n);
                list2 = DeclarationInfo.getContainingClass((org.netbeans.jmi.javamodel.Element)object4);
                object = list4.iterator();
                while (object.hasNext()) {
                    constructor = (Constructor)object.next();
                    if (!DeclarationInfo.isFeatureAccessibleFrom((Feature)constructor, (ClassDefinition)list2, null)) continue;
                    this.checkParamsAndAddHint((List)object2, constructor.getParameters(), list);
                }
            }
            object4 = (String)list3.get(0);
            object2 = (String)list3.get(1);
            object3 = (String)list3.get(2);
            n2 = JavaHintsProvider.KINDNAME_VARIABLE.equals(object4) ? 1 : 0;
            boolean bl = JavaHintsProvider.KINDNAME_METHOD.equals(object4);
            boolean bl2 = false;
            boolean bl3 = false;
            baseDocument = (BaseDocument)document;
            int n3 = JavaHintsProvider.getErrorOffset(document, errorInfo);
            if (n2 != 0) {
                Element element = baseDocument.getParagraphElement(n3);
                String string4 = null;
                try {
                    int n4 = element.getStartOffset();
                    string4 = document.getText(n4, element.getEndOffset() - n4 - 1);
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
                }
                if (string4 != null) {
                    bl2 = string4.indexOf((String)object2 + ".") != -1;
                    boolean bl4 = bl3 = !bl2;
                }
            }
            if (bl3 || bl || bl2) {
                JavaHintsProvider.handleUnresolvedHints(jMIUtils, resource, n3, (ClassDefinition)javaClass, (String)object2, bl3, bl, bl2, list);
            }
        }

        private ClassDefinition getParentClass(MethodInvocation methodInvocation) {
            PrimaryExpression primaryExpression = methodInvocation.getParentClass();
            ClassDefinition classDefinition = primaryExpression != null ? (ClassDefinition)primaryExpression.getType() : JavaModelUtil.getDeclaringFeature((org.netbeans.jmi.javamodel.Element)methodInvocation).getDeclaringClass();
            if (methodInvocation.isHasSuper()) {
                classDefinition = classDefinition.getSuperClass();
            }
            return classDefinition;
        }

        private void checkParamsAndAddHint(List list, List list2, List list3) {
            Expression expression;
            int n = -1;
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                expression = (Expression)list.get(i);
                Parameter parameter = (Parameter)list2.get(i);
                if (DeclarationInfo.isAssignableFrom(parameter.getType(), expression.getType())) continue;
                if (n != -1) {
                    return;
                }
                n = i;
            }
            if (n != -1) {
                Type type = ((Parameter)list2.get(n)).getType();
                expression = (Expression)list.get(n);
                IncompatibleTypesHintCreator.addCastHint(type, expression, list3);
            }
        }
    }

    public static class IncorrectArgumentsHintCreator
    extends HintCreator {
        public String getErrorId() {
            return JavaHintsProvider.CANT_APPLY_SYMBOL;
        }

        public void createHint(JMIUtils jMIUtils, Resource resource, Document document, ErrorInfo errorInfo, List list) {
            List list2 = errorInfo.getArguments();
            String string = (String)list2.get(0);
            int n = string.indexOf(40);
            if (n != -1) {
                string = string.substring(0, n);
            }
            String string2 = (String)list2.get(1);
            String string3 = (String)list2.get(3);
            boolean bl = !string2.endsWith("." + string);
            boolean bl2 = false;
            BaseDocument baseDocument = (BaseDocument)document;
            if (!bl && !bl2) {
                return;
            }
            JavaClass javaClass = jMIUtils.getExactClass(string2);
            if (javaClass == null) {
                return;
            }
            int n2 = JavaHintsProvider.getErrorOffset(document, errorInfo);
            IncorrectArgumentsHintCreator.addCastsOrInvokeMethods(resource, (ClassDefinition)javaClass, document, n2, string, string3, list);
            JavaHintsProvider.handleUnresolvedHints(jMIUtils, resource, n2, (ClassDefinition)javaClass, string, false, bl, bl2, list);
        }

        private static void addCastsOrInvokeMethods(Resource resource, ClassDefinition classDefinition, Document document, int n, String string, String string2, List list) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
            Method method = DeclarationInfo.getMethodByNameAndParamTypeNames(classDefinition, string, stringArray);
            Invocation invocation = (Invocation)JavaHintsProvider.getElementByOffset(resource, n, string);
            if (invocation != null && method != null) {
                Parameter[] parameterArray;
                Expression[] expressionArray = invocation.getParameters().toArray(new Expression[0]);
                if (expressionArray.length != (parameterArray = method.getParameters().toArray(new Parameter[0])).length) {
                    return;
                }
                for (int i = 0; i < expressionArray.length; ++i) {
                    Type type = expressionArray[i].getType();
                    Type type2 = parameterArray[i].getType();
                    if (type == null || type2 == null || type2.getName().equals(type.getName())) continue;
                    IncompatibleTypesHintCreator.addCastHint(type2, expressionArray[i], list);
                }
            }
        }
    }

    private static class ImplementAbstractMethods2HintCreator
    extends HintCreator {
        private ImplementAbstractMethods2HintCreator() {
        }

        public String getErrorId() {
            return JavaHintsProvider.ABSTRACT_CANT_BE_INSTANTIATED;
        }

        public void createHint(JMIUtils jMIUtils, Resource resource, Document document, ErrorInfo errorInfo, List list) {
            JavaClass javaClass;
            if (JavaHintsProvider.isReadOnly(resource)) {
                return;
            }
            if (ERR.isLoggable(1)) {
                ERR.log("pontentially unimplemented methods from: " + errorInfo.getArguments().get(0));
            }
            int n = JavaHintsProvider.getErrorOffset(document, errorInfo);
            NewClassExpression newClassExpression = (NewClassExpression)resource.getElementByOffset(n);
            JavaMetamodel.getManager().setClassPath(JavaModel.getFileObject((Resource)resource), true);
            Type type = ((JavaModelPackage)resource.refImmediatePackage()).getType().resolve((String)errorInfo.getArguments().get(0));
            JavaClass javaClass2 = javaClass = type instanceof JavaClass ? (JavaClass)type : null;
            if (ERR.isLoggable(1)) {
                ERR.log("expression=" + newClassExpression);
                ERR.log("clazz=" + javaClass);
            }
            if (newClassExpression != null && javaClass != null) {
                ArrayList<Method> arrayList = new ArrayList<Method>();
                Iterator iterator = javaClass.getContents().iterator();
                while (iterator.hasNext()) {
                    int n2;
                    Feature feature = (Feature)iterator.next();
                    if (!(feature instanceof Method)) continue;
                    Method method = (Method)feature;
                    if (ERR.isLoggable(1)) {
                        ERR.log("method=" + method);
                    }
                    if (!Modifier.isInterface(n2 = method.getModifiers()) && !Modifier.isAbstract(n2)) continue;
                    if (ERR.isLoggable(1)) {
                        ERR.log("is abstract");
                    }
                    arrayList.add(method);
                }
                if (!arrayList.isEmpty()) {
                    if (ERR.isLoggable(1)) {
                        ERR.log("unimplementedMethods=" + arrayList);
                    }
                    list.add(new ImplementMethodJavaHint2(newClassExpression, arrayList));
                }
            }
        }
    }

    private static class ImplementAbstractMethodsHintCreator
    extends HintCreator {
        private ImplementAbstractMethodsHintCreator() {
        }

        public String getErrorId() {
            return JavaHintsProvider.DOES_NOT_OVERRIDE_ABSTRACT;
        }

        public void createHint(JMIUtils jMIUtils, Resource resource, Document document, ErrorInfo errorInfo, List list) {
            List list2 = errorInfo.getArguments();
            String string = (String)list2.get(0);
            String string2 = (String)list2.get(2);
            if (string2.equals(string)) {
                Type type = JavaModel.getDefaultExtent().getType().resolve(string2);
                if (type instanceof JavaClass) {
                    list.add(new MakeClassAbstractJavaHint((JavaClass)type));
                }
                return;
            }
            JavaMetamodel.getManager().setClassPath(JavaModel.getFileObject((Resource)resource), true);
            int n = JavaHintsProvider.getErrorOffset(document, errorInfo);
            org.netbeans.jmi.javamodel.Element element = resource.getElementByOffset(n);
            if (element != null && element instanceof ClassDefinition) {
                List list3;
                ClassDefinition classDefinition = (ClassDefinition)element;
                String string3 = classDefinition.getName();
                if (string3 == null) {
                    List list4 = classDefinition.getInterfaces();
                    list3 = list4.size() > 0 ? (JavaClass)list4.get(0) : classDefinition.getSuperClass();
                    string3 = list3.getName();
                    string = string2;
                }
                if (string3.equals(string) && !(list3 = DeclarationInfo.getAbstractMethods(classDefinition)).isEmpty()) {
                    list.add(new ImplementMethodJavaHint(classDefinition, list3));
                }
            }
            JavaModel.setClassPath((Resource)resource);
        }
    }

    private static class IncompatibleTypesHintCreator
    extends HintCreator {
        private IncompatibleTypesHintCreator() {
        }

        public String getErrorId() {
            return JavaHintsProvider.INCOMPATIBLE_TYPES;
        }

        public void createHint(JMIUtils jMIUtils, Resource resource, Document document, ErrorInfo errorInfo, List list) {
            int n;
            org.netbeans.jmi.javamodel.Element element;
            if (JavaHintsProvider.isReadOnly(resource)) {
                return;
            }
            if (ERR.isLoggable(1)) {
                ERR.log("potentially missing cast");
            }
            if ((element = resource.getElementByOffset(n = JavaHintsProvider.getErrorOffset(document, errorInfo))) instanceof ConditionalExpression) {
                Type type = DeclarationInfo.computeType(element);
                ConditionalExpression conditionalExpression = (ConditionalExpression)element;
                IncompatibleTypesHintCreator.addCastHint(type, conditionalExpression.getTruePart(), list);
                IncompatibleTypesHintCreator.addCastHint(type, conditionalExpression.getFalsePart(), list);
            } else if (element instanceof Expression) {
                Type type = DeclarationInfo.computeType(element);
                IncompatibleTypesHintCreator.addCastHint(type, (Expression)element, list);
            }
        }

        public static void addCastHint(Type type, Expression expression, List list) {
            Type type2 = expression.getType();
            if (ERR.isLoggable(1)) {
                ERR.log("toType=" + type);
                ERR.log("fromType=" + type2);
            }
            if (type instanceof ClassDefinition && type2 instanceof ClassDefinition) {
                ClassDefinition classDefinition = (ClassDefinition)type;
                ClassDefinition classDefinition2 = (ClassDefinition)type2;
                if (ERR.isLoggable(1)) {
                    ERR.log("toClass=" + classDefinition.getName());
                    ERR.log("fromClass=" + classDefinition2.getName());
                }
                if (!classDefinition2.isSubTypeOf(classDefinition) && DeclarationInfo.canbeCastTo((Type)classDefinition2, (Type)classDefinition)) {
                    list.add(new AddCastJavaHint(IncompatibleTypesHintCreator.getElementName((org.netbeans.jmi.javamodel.Element)expression), classDefinition, expression));
                }
            }
        }

        private static String getElementName(org.netbeans.jmi.javamodel.Element element) {
            String string;
            if (element instanceof Invocation) {
                Invocation invocation = (Invocation)element;
                string = invocation.getName();
                string = invocation.getParameters().isEmpty() ? string + "()" : string + "(...)";
                if (element instanceof NewClassExpression) {
                    string = "new " + string;
                } else if (element instanceof MethodInvocation) {
                    string = "..." + string;
                }
            } else {
                string = element instanceof NamedElement ? "..." + ((NamedElement)element).getName() : (element instanceof ThisExpression ? "this" : (element instanceof StringLiteral ? ((StringLiteral)element).getValue() : (element instanceof BooleanLiteral ? String.valueOf(((BooleanLiteral)element).isValue()) : (element instanceof CharLiteral ? "'" + ((CharLiteral)element).getValue() + "'" : (element instanceof DoubleLiteral ? String.valueOf(((DoubleLiteral)element).getValue()) + "d" : (element instanceof FloatLiteral ? String.valueOf(((FloatLiteral)element).getValue()) + "f" : (element instanceof IntLiteral ? String.valueOf(((IntLiteral)element).getValue()) : (element instanceof LongLiteral ? String.valueOf(((LongLiteral)element).getValue()) + "l" : (element instanceof NullLiteral ? "null" : (element instanceof ArrayAccess ? IncompatibleTypesHintCreator.getElementName((org.netbeans.jmi.javamodel.Element)((ArrayAccess)element).getArray()) + "[]" : "..."))))))))));
            }
            return string;
        }
    }

    private static class UnreportedExceptionHintCreator
    extends HintCreator {
        private UnreportedExceptionHintCreator() {
        }

        public String getErrorId() {
            return JavaHintsProvider.UNREPORTED_EXCEPTION_ERROR;
        }

        public void createHint(JMIUtils jMIUtils, Resource resource, Document document, ErrorInfo errorInfo, List list) {
            CallableFeature callableFeature;
            if (JavaHintsProvider.isReadOnly(resource)) {
                return;
            }
            JavaClass javaClass = jMIUtils.getExactClass((String)errorInfo.getArguments().get(0));
            int n = JavaHintsProvider.getErrorOffset(document, errorInfo);
            org.netbeans.jmi.javamodel.Element element = resource.getElementByOffset(n);
            Feature feature = JavaModelUtil.getDeclaringFeature((org.netbeans.jmi.javamodel.Element)element);
            CallableFeature callableFeature2 = callableFeature = feature instanceof CallableFeature ? (CallableFeature)feature : null;
            if (callableFeature != null) {
                if (javaClass != null && javaClass instanceof JavaClass) {
                    callableFeature = (CallableFeature)feature;
                    list.add(new AddThrowsClauseJavaHint(callableFeature, javaClass));
                }
                try {
                    list.add(new TryWrapperJavaHint(document.createPosition(n), callableFeature));
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                }
            }
        }
    }

    private static class InitializeVariableHintCreator
    extends HintCreator {
        private InitializeVariableHintCreator() {
        }

        public String getErrorId() {
            return JavaHintsProvider.VAR_MIGHT_NOT_HAVE_BEEN_INITIALIZED;
        }

        public void createHint(JMIUtils jMIUtils, Resource resource, Document document, ErrorInfo errorInfo, List list) {
            String string = (String)errorInfo.getArguments().get(0);
            VariableAccess variableAccess = (VariableAccess)JavaHintsProvider.getElementByOffset(resource, JavaHintsProvider.getErrorOffset(document, errorInfo), string);
            if (variableAccess != null && string.equals(variableAccess.getName())) {
                list.add(new InitializeVariableHint(variableAccess));
            }
        }
    }

    private static abstract class MethodHintCreator {
        private MethodHintCreator() {
        }

        public abstract void createHint(JMIUtils var1, Resource var2, Document var3, Method var4, int var5, List var6);
    }

    private static abstract class FieldHintCreator {
        private FieldHintCreator() {
        }

        public abstract void createHint(JMIUtils var1, Resource var2, Document var3, Field var4, int var5, List var6);
    }

    private static abstract class HintCreator {
        private HintCreator() {
        }

        public abstract String getErrorId();

        public abstract void createHint(JMIUtils var1, Resource var2, Document var3, ErrorInfo var4, List var5);
    }
}

