/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.DrawEngineDocView;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FindSupport;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.FixLineSyntaxState;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.LocalBaseAction;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.MacroDialogSupport;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.view.spi.ViewUtilities;
import org.openide.util.NbBundle;

public class ActionFactory {
    static /* synthetic */ Class class$org$netbeans$editor$BaseKit;

    private ActionFactory() {
    }

    private static Fold getLineFold(FoldHierarchy foldHierarchy, int n, int n2, int n3) {
        Fold fold;
        Fold fold2 = FoldUtilities.findOffsetFold((FoldHierarchy)foldHierarchy, (int)n);
        Fold fold3 = FoldUtilities.findNearestFold((FoldHierarchy)foldHierarchy, (int)n2);
        while (fold3 != null && (fold3.getEndOffset() <= n || !fold3.isCollapsed() && fold3.getFoldCount() > 0 && fold3.getStartOffset() + 1 < n) && (fold = FoldUtilities.findNearestFold((FoldHierarchy)foldHierarchy, (int)(fold3.getFoldCount() > 0 ? fold3.getStartOffset() + 1 : fold3.getEndOffset()))) != null && fold.getStartOffset() < n3) {
            if (fold == fold3) {
                return fold3;
            }
            fold3 = fold;
        }
        if (fold3 == null || fold3.getStartOffset() > n3) {
            if (fold2 == null) {
                fold2 = FoldUtilities.findOffsetFold((FoldHierarchy)foldHierarchy, (int)n2);
            }
            return fold2;
        }
        if (fold2 == null) {
            return fold3;
        }
        if (fold2.isCollapsed()) {
            return fold2;
        }
        if (fold2.getEndOffset() > fold3.getEndOffset() && fold3.getEndOffset() > n) {
            return fold3;
        }
        if (fold3.getStartOffset() > fold2.getEndOffset()) {
            return fold2;
        }
        if (fold3.getEndOffset() < n) {
            return fold2;
        }
        return fold3;
    }

    public static class CutToLineBeginOrEndAction
    extends LocalBaseAction {
        private final boolean toLineEnd;

        public CutToLineBeginOrEndAction(boolean bl) {
            super(bl ? "cut-to-line-end" : "cut-to-line-begin", 14);
            this.toLineEnd = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                jTextComponent.getToolkit().beep();
                return;
            }
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            baseDocument.atomicLock();
            try {
                Action action;
                ActionMap actionMap = jTextComponent.getActionMap();
                if (actionMap != null && (action = actionMap.get("cut-to-clipboard")) != null) {
                    int n;
                    Caret caret = jTextComponent.getCaret();
                    int n2 = caret.getDot();
                    int n3 = n = this.toLineEnd ? Utilities.getRowEnd(jTextComponent, n2) : Utilities.getRowStart(jTextComponent, n2);
                    if (this.toLineEnd) {
                        String string = jTextComponent.getText(n2, n - n2);
                        if (n < baseDocument.getLength() && string != null && string.matches("^[\\s]*$")) {
                            ++n;
                        }
                    }
                    caret.moveDot(n);
                    action.actionPerformed(actionEvent);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            finally {
                baseDocument.atomicUnlock();
            }
        }
    }

    public static class StartNewLine
    extends LocalBaseAction {
        public StartNewLine() {
            super("start-new-line", 14);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                jTextComponent.getToolkit().beep();
                return;
            }
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            baseDocument.atomicLock();
            try {
                Caret caret = jTextComponent.getCaret();
                int n = caret.getDot();
                baseDocument.insertString(n, "-", null);
                baseDocument.remove(n, 1);
                int n2 = Utilities.getRowEnd(jTextComponent, caret.getDot());
                int n3 = baseDocument.getFormatter().indentNewLine(baseDocument, n2);
                caret.setDot(n3);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            finally {
                baseDocument.atomicUnlock();
            }
        }
    }

    public static class DumpViewHierarchyAction
    extends LocalBaseAction {
        public DumpViewHierarchyAction() {
            super("dump-view-hierarchy");
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            DrawEngineDocView drawEngineDocView = (DrawEngineDocView)Utilities.getDocumentView(jTextComponent);
            AbstractDocument abstractDocument = (AbstractDocument)jTextComponent.getDocument();
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
            abstractDocument.readLock();
            try {
                foldHierarchy.lock();
                try {
                    System.err.println("FOLD HIERARCHY DUMP:\n" + foldHierarchy);
                }
                finally {
                    foldHierarchy.unlock();
                }
            }
            finally {
                abstractDocument.readUnlock();
            }
            System.err.println("DOCUMENT VIEW: " + System.identityHashCode(drawEngineDocView) + ", " + drawEngineDocView + "\nLINE VIEWS:\n" + drawEngineDocView.childrenToString());
            int n = jTextComponent.getCaretPosition();
            int n2 = drawEngineDocView.getViewIndex(n, Position.Bias.Forward);
            System.err.println("caretOffset=" + n + ", caretViewIndex=" + n2);
            if (n2 >= 0 && n2 < drawEngineDocView.getViewCount()) {
                View view = drawEngineDocView.getView(n2);
                System.err.println("caretView: " + view);
            }
            System.err.println(FixLineSyntaxState.lineInfosToString(abstractDocument));
            ViewUtilities.checkViewHierarchy(drawEngineDocView);
        }
    }

    public static class ExpandAllFolds
    extends LocalBaseAction {
        public ExpandAllFolds() {
            super("expand-all-folds");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
            FoldUtilities.expandAll((FoldHierarchy)foldHierarchy);
        }
    }

    public static class CollapseAllFolds
    extends LocalBaseAction {
        public CollapseAllFolds() {
            super("collapse-all-folds");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
            FoldUtilities.collapseAll((FoldHierarchy)foldHierarchy);
        }
    }

    public static class ExpandFold
    extends LocalBaseAction {
        public ExpandFold() {
            super("expand-fold");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
            int n = jTextComponent.getCaret().getDot();
            foldHierarchy.lock();
            try {
                try {
                    int n2 = javax.swing.text.Utilities.getRowStart(jTextComponent, n);
                    int n3 = javax.swing.text.Utilities.getRowEnd(jTextComponent, n);
                    Fold fold = ActionFactory.getLineFold(foldHierarchy, n, n2, n3);
                    if (fold != null) {
                        foldHierarchy.expand(fold);
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
            finally {
                foldHierarchy.unlock();
            }
        }
    }

    public static class CollapseFold
    extends LocalBaseAction {
        public CollapseFold() {
            super("collapse-fold");
        }

        private boolean dotInFoldArea(JTextComponent jTextComponent, Fold fold, int n) throws BadLocationException {
            int n2 = fold.getStartOffset();
            int n3 = fold.getEndOffset();
            int n4 = javax.swing.text.Utilities.getRowStart(jTextComponent, n2);
            int n5 = javax.swing.text.Utilities.getRowEnd(jTextComponent, n3);
            return n4 <= n && n5 >= n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Fold fold;
            int n;
            FoldHierarchy foldHierarchy;
            block7: {
                foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
                n = jTextComponent.getCaret().getDot();
                foldHierarchy.lock();
                int n2 = javax.swing.text.Utilities.getRowStart(jTextComponent, n);
                int n3 = javax.swing.text.Utilities.getRowEnd(jTextComponent, n);
                fold = FoldUtilities.findNearestFold((FoldHierarchy)foldHierarchy, (int)n2);
                fold = ActionFactory.getLineFold(foldHierarchy, n, n2, n3);
                if (fold != null) break block7;
                foldHierarchy.unlock();
                return;
            }
            try {
                try {
                    if (this.dotInFoldArea(jTextComponent, fold, n)) {
                        foldHierarchy.collapse(fold);
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                foldHierarchy.unlock();
            }
        }
    }

    public static class AnnotationsCyclingAction
    extends LocalBaseAction {
        public AnnotationsCyclingAction() {
            super("annotations-cycling");
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                try {
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
                    int n = Utilities.getLineOffset(baseDocument, caret.getDot());
                    AnnotationDesc annotationDesc = baseDocument.getAnnotations().activateNextAnnotation(n);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }
    }

    public static class ToggleLineNumbersAction
    extends LocalBaseAction {
        static final long serialVersionUID = -3502499718130556526L;
        private JCheckBoxMenuItem item = null;

        public ToggleLineNumbersAction() {
            super("toggle-line-numbers");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            this.toggleLineNumbers();
        }

        public JMenuItem getPopupMenuItem(JTextComponent jTextComponent) {
            this.item = new JCheckBoxMenuItem(NbBundle.getBundle((Class)(class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = ActionFactory.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit)).getString("line-numbers-menuitem"), this.isLineNumbersVisible());
            this.item.addItemListener(new ItemListener(this){
                private final /* synthetic */ ToggleLineNumbersAction this$0;
                {
                    this.this$0 = toggleLineNumbersAction;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    this.this$0.actionPerformed(null, null);
                }
            });
            return this.item;
        }

        protected boolean isLineNumbersVisible() {
            return false;
        }

        protected void toggleLineNumbers() {
        }
    }

    public static class GenerateGutterPopupAction
    extends LocalBaseAction {
        static final long serialVersionUID = -3502499718130556525L;

        public GenerateGutterPopupAction() {
            super("generate-gutter-popup");
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        }

        public JMenuItem getPopupMenuItem(JTextComponent jTextComponent) {
            EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
            try {
                return editorUI.getDocument().getAnnotations().createMenu(Utilities.getKit(jTextComponent), Utilities.getLineOffset(editorUI.getDocument(), jTextComponent.getCaret().getDot()));
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
    }

    public static class InsertDateTimeAction
    extends LocalBaseAction {
        static final long serialVersionUID = 2865619897402L;

        public InsertDateTimeAction() {
            super("insert-date-time", 30);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                try {
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
                    Date date = new Date();
                    String string = simpleDateFormat.format(date);
                    baseDocument.insertString(caret.getDot(), string, null);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class ScrollDownAction
    extends LocalBaseAction {
        public ScrollDownAction() {
            super("scroll-down");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
                Rectangle rectangle = editorUI.getExtentBounds();
                rectangle.y -= editorUI.getLineHeight();
                rectangle.x += editorUI.getTextMargin().left;
                editorUI.scrollRectToVisible(rectangle, 2);
            }
        }
    }

    public static class ScrollUpAction
    extends LocalBaseAction {
        public ScrollUpAction() {
            super("scroll-up");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
                Rectangle rectangle = editorUI.getExtentBounds();
                rectangle.y += editorUI.getLineHeight();
                rectangle.x += editorUI.getTextMargin().left;
                editorUI.scrollRectToVisible(rectangle, 2);
            }
        }
    }

    public static class JumpListPrevComponentAction
    extends LocalBaseAction {
        static final long serialVersionUID = 2032230534727849525L;

        public JumpListPrevComponentAction() {
            super("jump-list-prev-component");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                JumpList.jumpPrevComponent(jTextComponent);
            }
        }
    }

    public static class JumpListNextComponentAction
    extends LocalBaseAction {
        static final long serialVersionUID = -2059070050865876892L;

        public JumpListNextComponentAction() {
            super("jump-list-next-component");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                JumpList.jumpNextComponent(jTextComponent);
            }
        }
    }

    public static class JumpListPrevAction
    extends LocalBaseAction {
        static final long serialVersionUID = 7174907031986424265L;
        PropertyChangeListener pcl;

        public JumpListPrevAction() {
            super("jump-list-prev");
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/edit_previous.png");
            this.pcl = new PropertyChangeListener(this){
                private final /* synthetic */ JumpListPrevAction this$0;
                {
                    this.this$0 = jumpListPrevAction;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.this$0.setEnabled(JumpList.hasPrev());
                }
            };
            JumpList.addPropertyChangeListener(this.pcl);
            this.setEnabled(JumpList.hasPrev());
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                JumpList.jumpPrev(jTextComponent);
            }
        }
    }

    public static class JumpListNextAction
    extends LocalBaseAction {
        static final long serialVersionUID = 6891721278404990446L;
        PropertyChangeListener pcl;

        public JumpListNextAction() {
            super("jump-list-next");
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/edit_next.png");
            this.pcl = new PropertyChangeListener(this){
                private final /* synthetic */ JumpListNextAction this$0;
                {
                    this.this$0 = jumpListNextAction;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.this$0.setEnabled(JumpList.hasNext());
                }
            };
            JumpList.addPropertyChangeListener(this.pcl);
            this.setEnabled(JumpList.hasNext());
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                JumpList.jumpNext(jTextComponent);
            }
        }
    }

    public static class SelectNextParameterAction
    extends LocalBaseAction {
        static final long serialVersionUID = 8045372985336370934L;

        public SelectNextParameterAction() {
            super("select-next-parameter", 34);
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                int n = caret.getDot();
                int n2 = -1;
                try {
                    int n3;
                    if (n > 0 && baseDocument.getChars(n - 1, 1)[0] == ',') {
                        n2 = n;
                    }
                    if (n < baseDocument.getLength()) {
                        n3 = baseDocument.getChars(n, 1)[0];
                        if (n3 == 44) {
                            n2 = n + 1;
                        } else if (n3 == 41) {
                            caret.setDot(n + 1);
                        }
                    }
                    if (n2 >= 0 && (n3 = baseDocument.find(new FinderFactory.CharArrayFwdFinder(new char[]{',', ')'}), n2, -1)) >= 0) {
                        jTextComponent.select(n2, n3);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class SelectIdentifierAction
    extends LocalBaseAction {
        static final long serialVersionUID = -7288216961333147873L;

        public SelectIdentifierAction() {
            super("select-identifier", 2);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    if (caret.isSelectionVisible()) {
                        caret.setSelectionVisible(false);
                    } else {
                        int[] nArray = Utilities.getIdentifierBlock((BaseDocument)jTextComponent.getDocument(), caret.getDot());
                        if (nArray != null) {
                            caret.setDot(nArray[0]);
                            caret.moveDot(nArray[1]);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class LastNonWhiteAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = 4503533041729712917L;

        public LastNonWhiteAction(String string, boolean bl) {
            super(string, 30);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    int n = Utilities.getRowLastNonWhite((BaseDocument)jTextComponent.getDocument(), caret.getDot());
                    if (n >= 0) {
                        if (this.select) {
                            caret.moveDot(n);
                        } else {
                            caret.setDot(n);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class FirstNonWhiteAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = -5888439539790901158L;

        public FirstNonWhiteAction(String string, boolean bl) {
            super(string, 30);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    int n = Utilities.getRowFirstNonWhite((BaseDocument)jTextComponent.getDocument(), caret.getDot());
                    if (n >= 0) {
                        if (this.select) {
                            caret.moveDot(n);
                        } else {
                            caret.setDot(n);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class FormatAction
    extends LocalBaseAction {
        static final long serialVersionUID = -7666172828961171865L;

        public FormatAction() {
            super("format", 14);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                Caret caret = jTextComponent.getCaret();
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                GuardedDocument guardedDocument = baseDocument instanceof GuardedDocument ? (GuardedDocument)baseDocument : null;
                Cursor cursor = jTextComponent.getCursor();
                jTextComponent.setCursor(Cursor.getPredefinedCursor(3));
                baseDocument.atomicLock();
                try {
                    Position position;
                    int n;
                    if (caret.isSelectionVisible()) {
                        n = jTextComponent.getSelectionStart();
                        position = baseDocument.createPosition(jTextComponent.getSelectionEnd());
                    } else {
                        n = 0;
                        position = baseDocument.createPosition(baseDocument.getLength());
                    }
                    int n2 = n;
                    if (guardedDocument != null) {
                        n2 = guardedDocument.getGuardedBlockChain().adjustToBlockEnd(n2);
                    }
                    while (n2 < position.getOffset()) {
                        int n3 = position.getOffset();
                        if (guardedDocument != null && ((n3 = guardedDocument.getGuardedBlockChain().adjustToNextBlockStart(n2)) == -1 || n3 > position.getOffset())) {
                            n3 = position.getOffset();
                        }
                        int n4 = baseDocument.getFormatter().reformat(baseDocument, n2, n3);
                        n2 += n4;
                        if (guardedDocument == null) continue;
                        n2 = guardedDocument.getGuardedBlockChain().adjustToBlockEnd(n2);
                    }
                }
                catch (GuardedException guardedException) {
                    jTextComponent.getToolkit().beep();
                }
                catch (BadLocationException badLocationException) {
                    Utilities.annotateLoggable(badLocationException);
                }
                finally {
                    baseDocument.atomicUnlock();
                    jTextComponent.setCursor(cursor);
                }
            }
        }
    }

    public static class AdjustCaretAction
    extends LocalBaseAction {
        int percentFromWindowTop;
        static final long serialVersionUID = 3223383913531191066L;

        public AdjustCaretAction(String string, int n) {
            super(string);
            this.percentFromWindowTop = n;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Utilities.getEditorUI(jTextComponent).adjustCaret(this.percentFromWindowTop);
            }
        }
    }

    public static class AdjustWindowAction
    extends LocalBaseAction {
        int percentFromWindowTop;
        static final long serialVersionUID = 8864278998999643292L;

        public AdjustWindowAction(String string, int n) {
            super(string);
            this.percentFromWindowTop = n;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Utilities.getEditorUI(jTextComponent).adjustWindow(this.percentFromWindowTop);
            }
        }
    }

    public static class ReindentLineAction
    extends LocalBaseAction {
        static final long serialVersionUID = 1L;

        public ReindentLineAction() {
            super("reindent-line", 14);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                Caret caret = jTextComponent.getCaret();
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                GuardedDocument guardedDocument = baseDocument instanceof GuardedDocument ? (GuardedDocument)baseDocument : null;
                baseDocument.atomicLock();
                try {
                    Position position;
                    int n;
                    int n2 = Utilities.getLineOffset(baseDocument, caret.getDot());
                    if (caret.isSelectionVisible()) {
                        n = jTextComponent.getSelectionStart();
                        position = baseDocument.createPosition(jTextComponent.getSelectionEnd());
                    } else {
                        n = Utilities.getRowStart(baseDocument, caret.getDot());
                        position = baseDocument.createPosition(Utilities.getRowEnd(baseDocument, caret.getDot()));
                    }
                    int n3 = n;
                    if (guardedDocument != null) {
                        n3 = guardedDocument.getGuardedBlockChain().adjustToBlockEnd(n3);
                    }
                    while (n3 < position.getOffset()) {
                        int n4 = position.getOffset();
                        if (guardedDocument != null && ((n4 = guardedDocument.getGuardedBlockChain().adjustToNextBlockStart(n3)) == -1 || n4 > position.getOffset())) {
                            n4 = position.getOffset();
                        }
                        int n5 = baseDocument.getFormatter().reformat(baseDocument, n3, n4);
                        n3 += n5;
                        if (guardedDocument == null) continue;
                        n3 = guardedDocument.getGuardedBlockChain().adjustToBlockEnd(n3);
                    }
                }
                catch (GuardedException guardedException) {
                    jTextComponent.getToolkit().beep();
                }
                catch (BadLocationException badLocationException) {
                    Utilities.annotateLoggable(badLocationException);
                }
                finally {
                    baseDocument.atomicUnlock();
                }
            }
        }
    }

    public static class ShiftLineAction
    extends LocalBaseAction {
        boolean right;
        static final long serialVersionUID = -5124732597493699582L;

        public ShiftLineAction(String string, boolean bl) {
            super(string, 10);
            this.right = bl;
            this.putValue("IconResource", bl ? "org/netbeans/modules/editor/resources/shift_line_right.png" : "org/netbeans/modules/editor/resources/shift_line_left.png");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                try {
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
                    if (caret.isSelectionVisible()) {
                        baseDocument.getFormatter().changeBlockIndent(baseDocument, jTextComponent.getSelectionStart(), jTextComponent.getSelectionEnd(), this.right ? 1 : -1);
                    } else {
                        baseDocument.getFormatter().shiftLine(baseDocument, caret.getDot(), this.right);
                    }
                }
                catch (GuardedException guardedException) {
                    jTextComponent.getToolkit().beep();
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }
    }

    public static class WordMatchAction
    extends LocalBaseAction {
        private boolean direction;
        static final long serialVersionUID = 595571114685133170L;

        public WordMatchAction(String string, boolean bl) {
            super(string, 14);
            this.direction = bl;
            this.putValue("IconResource", bl ? "org/netbeans/modules/editor/resources/next_matching.png" : "org/netbeans/modules/editor/resources/previous_matching.png");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
                Caret caret = jTextComponent.getCaret();
                BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
                if (caret.isSelectionVisible()) {
                    jTextComponent.replaceSelection(null);
                }
                int n = caret.getDot();
                String string = editorUI.getWordMatch().getMatchWord(n, this.direction);
                String string2 = editorUI.getWordMatch().getPreviousWord();
                if (string != null) {
                    baseDocument.atomicLock();
                    try {
                        int n2 = n;
                        if (string2 != null && string2.length() > 0) {
                            baseDocument.remove(n2 -= string2.length(), string2.length());
                        }
                        baseDocument.insertString(n2, string, null);
                    }
                    catch (BadLocationException badLocationException) {
                        jTextComponent.getToolkit().beep();
                    }
                    finally {
                        baseDocument.atomicUnlock();
                    }
                }
            }
        }
    }

    public static class RedoAction
    extends LocalBaseAction {
        static final long serialVersionUID = 6048125996333769202L;

        public RedoAction() {
            super("redo", 30);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                jTextComponent.getToolkit().beep();
                return;
            }
            Document document = jTextComponent.getDocument();
            UndoableEdit undoableEdit = (UndoableEdit)document.getProperty("undo-manager");
            if (jTextComponent != null && undoableEdit != null) {
                try {
                    undoableEdit.redo();
                }
                catch (CannotRedoException cannotRedoException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class UndoAction
    extends LocalBaseAction {
        static final long serialVersionUID = 8628586205035497612L;

        public UndoAction() {
            super("undo", 30);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                jTextComponent.getToolkit().beep();
                return;
            }
            Document document = jTextComponent.getDocument();
            UndoableEdit undoableEdit = (UndoableEdit)document.getProperty("undo-manager");
            if (jTextComponent != null && undoableEdit != null) {
                try {
                    undoableEdit.undo();
                }
                catch (CannotUndoException cannotUndoException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class ToggleHighlightSearchAction
    extends LocalBaseAction {
        static final long serialVersionUID = 4603809175771743200L;

        public ToggleHighlightSearchAction() {
            super("toggle-highlight-search", 32);
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/toggle_highlight.png");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Boolean bl = (Boolean)FindSupport.getFindSupport().getFindProperty("find-highlight-search");
                bl = bl == null || bl == false ? Boolean.TRUE : Boolean.FALSE;
                FindSupport.getFindSupport().putFindProperty("find-highlight-search", bl);
            }
        }
    }

    public static class FindSelectionAction
    extends LocalBaseAction {
        static final long serialVersionUID = -5601618936504699565L;

        public FindSelectionAction() {
            super("find-selection");
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/find_selection.png");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Boolean bl;
                FindSupport findSupport = FindSupport.getFindSupport();
                Caret caret = jTextComponent.getCaret();
                int n = caret.getDot();
                HashMap<String, Object> hashMap = new HashMap<String, Object>(findSupport.getFindProperties());
                String string = null;
                boolean bl2 = false;
                Boolean bl3 = null;
                HashMap<String, Boolean> hashMap2 = (HashMap<String, Boolean>)hashMap.get("revert-map");
                Boolean bl4 = bl = hashMap2 != null ? (Boolean)hashMap2.get("find-whole-words") : null;
                if (caret.isSelectionVisible()) {
                    string = jTextComponent.getSelectedText();
                    bl3 = hashMap.put("find-whole-words", Boolean.FALSE);
                    if (Boolean.FALSE.equals(bl)) {
                        hashMap2.remove("find-whole-words");
                    } else {
                        bl2 = !Boolean.FALSE.equals(bl3);
                    }
                } else {
                    try {
                        string = Utilities.getIdentifier((BaseDocument)jTextComponent.getDocument(), n);
                        bl3 = hashMap.put("find-whole-words", Boolean.TRUE);
                        if (Boolean.TRUE.equals(bl)) {
                            hashMap2.remove("find-whole-words");
                        } else {
                            bl2 = !Boolean.TRUE.equals(bl3);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
                if (string != null) {
                    int n2 = string.indexOf(10);
                    if (n2 >= 0) {
                        string = string.substring(0, n2);
                    }
                    hashMap.put("find-what", string);
                    if (bl2) {
                        hashMap2 = new HashMap<String, Boolean>();
                        hashMap2.put("find-whole-words", bl3 != null ? bl3 : Boolean.FALSE);
                        hashMap.put("revert-map", hashMap2);
                    }
                    findSupport.putFindProperties(hashMap);
                    findSupport.find(null, false);
                }
            }
        }
    }

    public static class FindPreviousAction
    extends LocalBaseAction {
        static final long serialVersionUID = -43746947902694926L;

        public FindPreviousAction() {
            super("find-previous", 30);
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/find_previous.png");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                FindSupport.getFindSupport().find(null, true);
            }
        }
    }

    public static class FindNextAction
    extends LocalBaseAction {
        static final long serialVersionUID = 6878814427731642684L;

        public FindNextAction() {
            super("find-next", 30);
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/find_next.png");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                FindSupport.getFindSupport().find(null, false);
            }
        }
    }

    public static class ChangeCaseAction
    extends LocalBaseAction {
        int changeCaseMode;
        static final long serialVersionUID = 5680212865619897402L;

        public ChangeCaseAction(String string, int n) {
            super(string, 30);
            this.changeCaseMode = n;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                try {
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    if (caret.isSelectionVisible()) {
                        int n = jTextComponent.getSelectionStart();
                        int n2 = jTextComponent.getSelectionEnd();
                        Utilities.changeCase(baseDocument, n, n2 - n, this.changeCaseMode);
                        caret.setSelectionVisible(false);
                        caret.setDot(n2);
                    } else {
                        int n = caret.getDot();
                        Utilities.changeCase(baseDocument, n, 1, this.changeCaseMode);
                        caret.setDot(n + 1);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class AbbrevResetAction
    extends LocalBaseAction {
        static final long serialVersionUID = -2807497346060448395L;

        public AbbrevResetAction() {
            super("abbrev-reset", 4);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        }
    }

    public static class AbbrevExpandAction
    extends LocalBaseAction {
        static final long serialVersionUID = -2124569510083544403L;

        public AbbrevExpandAction() {
            super("abbrev-expand", 26);
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                EditorUI editorUI = ((BaseTextUI)jTextComponent.getUI()).getEditorUI();
                try {
                    editorUI.getAbbrev().checkAndExpand(actionEvent);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class StopMacroRecordingAction
    extends LocalBaseAction {
        static final long serialVersionUID = 1L;

        public StopMacroRecordingAction() {
            super("stop-macro-recording", 64);
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/stop_macro_recording.png");
        }

        protected MacroDialogSupport getMacroDialogSupport(Class clazz) {
            return new MacroDialogSupport(clazz);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                String string = this.stopRecording(jTextComponent);
                if (string == null) {
                    jTextComponent.getToolkit().beep();
                } else {
                    BaseKit baseKit = Utilities.getKit(jTextComponent);
                    MacroDialogSupport macroDialogSupport = this.getMacroDialogSupport(baseKit.getClass());
                    macroDialogSupport.setBody(string);
                    macroDialogSupport.showMacroDialog();
                }
            }
        }
    }

    public static class StartMacroRecordingAction
    extends LocalBaseAction {
        static final long serialVersionUID = 1L;

        public StartMacroRecordingAction() {
            super("start-macro-recording", 64);
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/start_macro_recording.png");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null && !this.startRecording(jTextComponent)) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class RunMacroAction
    extends BaseAction {
        static final long serialVersionUID = 1L;
        static HashSet runningActions = new HashSet();
        private String macroName;

        public RunMacroAction(String string) {
            super("macro-" + string);
            this.macroName = string;
        }

        protected void error(JTextComponent jTextComponent, String string) {
            Utilities.setStatusText(jTextComponent, LocaleSupport.getString(string, "Error in macro: " + string));
            Toolkit.getDefaultToolkit().beep();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (!runningActions.add(this.macroName)) {
                this.error(jTextComponent, "loop");
                return;
            }
            if (jTextComponent == null) {
                return;
            }
            BaseKit baseKit = Utilities.getKit(jTextComponent);
            if (baseKit == null) {
                return;
            }
            Map map = (Map)Settings.getValue(baseKit.getClass(), "macro-map");
            String string = (String)map.get(this.macroName);
            if (string == null) {
                this.error(jTextComponent, "macro-not-found");
                runningActions.remove(this.macroName);
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            try {
                baseDocument.atomicLock();
                for (int i = 0; i < n; ++i) {
                    Object object;
                    Object object2;
                    if (Character.isWhitespace(cArray[i])) continue;
                    if (cArray[i] == '\"') {
                        while (++i < n && cArray[i] != '\"') {
                            char c = cArray[i];
                            if (c == '\\') {
                                if (++i >= n) {
                                    this.error(jTextComponent, "macro-malformed");
                                    return;
                                }
                                c = cArray[i];
                                if (c != '\"' && c != '\\') {
                                    this.error(jTextComponent, "macro-malformed");
                                    return;
                                }
                            }
                            if ((object2 = jTextComponent.getKeymap().getDefaultAction()) == null) continue;
                            object = new ActionEvent(jTextComponent, 0, new String(new char[]{c}));
                            if (object2 instanceof BaseAction) {
                                ((BaseAction)object2).updateComponent(jTextComponent);
                                ((BaseAction)object2).actionPerformed((ActionEvent)object, jTextComponent);
                                continue;
                            }
                            object2.actionPerformed((ActionEvent)object);
                        }
                        continue;
                    }
                    stringBuffer.setLength(0);
                    while (i < n && !Character.isWhitespace(cArray[i])) {
                        char c;
                        if ((c = cArray[i++]) == '\\') {
                            if (i >= n) {
                                this.error(jTextComponent, "macro-malformed");
                                return;
                            }
                            if ((c = cArray[i++]) != '\\' && !Character.isWhitespace(c)) {
                                this.error(jTextComponent, "macro-malformed");
                                return;
                            }
                        }
                        stringBuffer.append(c);
                    }
                    Action action = baseKit.getActionByName(stringBuffer.toString());
                    if (action != null) {
                        object2 = new ActionEvent(jTextComponent, 0, "");
                        if (action instanceof BaseAction) {
                            ((BaseAction)action).updateComponent(jTextComponent);
                            ((BaseAction)action).actionPerformed((ActionEvent)object2, jTextComponent);
                        } else {
                            action.actionPerformed((ActionEvent)object2);
                        }
                        if (!"insert-break".equals(stringBuffer.toString())) continue;
                        object = jTextComponent.getKeymap().getDefaultAction();
                        ActionEvent actionEvent2 = new ActionEvent(jTextComponent, 0, new String(new byte[]{10}));
                        if (object instanceof BaseAction) {
                            ((BaseAction)object).updateComponent(jTextComponent);
                            ((BaseAction)object).actionPerformed(actionEvent2, jTextComponent);
                            continue;
                        }
                        object.actionPerformed(actionEvent2);
                        continue;
                    }
                    this.error(jTextComponent, "macro-unknown-action");
                    return;
                }
            }
            finally {
                baseDocument.atomicUnlock();
                runningActions.remove(this.macroName);
            }
        }
    }

    public static class ToggleTypingModeAction
    extends LocalBaseAction {
        static final long serialVersionUID = -2431132686507799723L;

        public ToggleTypingModeAction() {
            super("toggle-typing-mode");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
                Boolean bl = (Boolean)editorUI.getProperty("overwriteMode");
                bl = bl == null || bl == false ? Boolean.TRUE : Boolean.FALSE;
                editorUI.putProperty("overwriteMode", bl);
            }
        }
    }

    public static class RemoveSelectionAction
    extends LocalBaseAction {
        static final long serialVersionUID = -1419424594746686573L;

        public RemoveSelectionAction() {
            super("remove-selection", 30);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                jTextComponent.replaceSelection(null);
            }
        }
    }

    public static class RemoveLineAction
    extends LocalBaseAction {
        static final long serialVersionUID = -536315497241419877L;

        public RemoveLineAction() {
            super("remove-line", 30);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                Caret caret = jTextComponent.getCaret();
                try {
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int n = caret.getDot();
                    int n2 = Utilities.getRowStart(jTextComponent, n);
                    int n3 = Utilities.getRowEnd(jTextComponent, n);
                    n3 = Math.min(n3 + 1, baseDocument.getLength());
                    baseDocument.remove(n2, n3 - n2);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class RemoveLineBeginAction
    extends LocalBaseAction {
        static final long serialVersionUID = 9193117196412195554L;

        public RemoveLineBeginAction() {
            super("remove-line-begin", 30);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                Caret caret = jTextComponent.getCaret();
                try {
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int n = caret.getDot();
                    int n2 = Utilities.getRowStart(baseDocument, n);
                    if (n == n2) {
                        if (n > 0) {
                            baseDocument.remove(n - 1, 1);
                        }
                    } else {
                        char[] cArray = baseDocument.getChars(n2, n - n2);
                        if (Analyzer.isWhitespace(cArray, 0, cArray.length)) {
                            baseDocument.remove(n2, n - n2);
                        } else {
                            int n3 = Utilities.getRowFirstNonWhite(baseDocument, n2);
                            if (n3 >= 0 && n3 < n) {
                                baseDocument.remove(n3, n - n3);
                            }
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class RemoveWordNextAction
    extends LocalBaseAction {
        public RemoveWordNextAction() {
            super("remove-word-next", 30);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                Caret caret = jTextComponent.getCaret();
                try {
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int n = caret.getDot();
                    int n2 = Utilities.getRowEnd(baseDocument, n);
                    int n3 = Utilities.getNextWord(jTextComponent, n);
                    n3 = n == n2 ? n3 : Math.min(n2, n3);
                    baseDocument.remove(n, n3 - n);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class RemoveWordPreviousAction
    extends LocalBaseAction {
        public RemoveWordPreviousAction() {
            super("remove-word-previous", 30);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                Caret caret = jTextComponent.getCaret();
                try {
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int n = caret.getDot();
                    int n2 = Utilities.getRowStart(baseDocument, n);
                    int n3 = Utilities.getPreviousWord(jTextComponent, n);
                    n3 = n == n2 ? n3 : Math.max(n2, n3);
                    baseDocument.remove(n3, n - n3);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class RemoveTabAction
    extends LocalBaseAction {
        static final long serialVersionUID = -1537748600593395706L;

        public RemoveTabAction() {
            super("remove-tab", 22);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                Caret caret = jTextComponent.getCaret();
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                if (caret.isSelectionVisible()) {
                    try {
                        baseDocument.getFormatter().changeBlockIndent(baseDocument, jTextComponent.getSelectionStart(), jTextComponent.getSelectionEnd(), -1);
                    }
                    catch (GuardedException guardedException) {
                        jTextComponent.getToolkit().beep();
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                } else {
                    try {
                        int n = Utilities.getRowStart(baseDocument, caret.getDot());
                        int n2 = Utilities.getRowFirstNonWhite(baseDocument, caret.getDot());
                        int n3 = Utilities.getRowEnd(baseDocument, caret.getDot());
                        if (n2 == -1 || n2 >= caret.getDot()) {
                            baseDocument.getFormatter().changeBlockIndent(baseDocument, n, n3, -1);
                        }
                    }
                    catch (GuardedException guardedException) {
                        jTextComponent.getToolkit().beep();
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
            }
        }
    }
}

