/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.editor.fold.FoldStateChange;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.editor.AtomicLockEvent;
import org.netbeans.editor.AtomicLockListener;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.DrawLayerFactory;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.openide.util.WeakListeners;

public class BaseCaret
implements Caret,
MouseListener,
MouseMotionListener,
PropertyChangeListener,
DocumentListener,
ActionListener,
SettingsChangeListener,
AtomicLockListener,
FoldHierarchyListener {
    public static final String BLOCK_CARET = "block-caret";
    public static final String LINE_CARET = "line-caret";
    public static final String THIN_LINE_CARET = "thin-line-caret";
    private static final boolean debugCaretFocus;
    private static final boolean debugCaretFocusExtra;
    private ListenerImpl listenerImpl;
    private Rectangle caretBounds;
    protected JTextComponent component;
    Point magicCaretPosition;
    MarkFactory.DrawMark caretMark = new MarkFactory.CaretMark();
    MarkFactory.DrawMark selectionMark = new MarkFactory.DrawMark("caret-layer", null);
    boolean caretVisible;
    boolean blinkVisible;
    boolean selectionVisible;
    protected EventListenerList listenerList = new EventListenerList();
    protected Timer flasher;
    String type;
    boolean italic;
    private int[] xPoints = new int[4];
    private int[] yPoints = new int[4];
    private Action selectWordAction;
    private Action selectLineAction;
    protected ChangeEvent changeEvent;
    protected char[] dotChar = new char[]{' '};
    private boolean overwriteMode;
    private BaseDocument listenDoc;
    protected Font afterCaretFont;
    protected Font beforeCaretFont;
    protected Color textForeColor;
    protected Color textBackColor;
    private transient FocusListener focusListener;
    private transient boolean inAtomicLock;
    private transient boolean modified;
    private transient int undoOffset = -1;
    private transient boolean afterFirstSetDot = false;
    static final long serialVersionUID = -9113841520331402768L;
    private MouseEvent dndArmedEvent = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BaseCaret() {
        this.listenerImpl = new ListenerImpl();
        Settings.addSettingsChangeListener(this);
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        if (settingsChangeEvent != null && "caret-blink-rate".equals(settingsChangeEvent.getSettingName())) {
            JTextComponent jTextComponent = this.component;
            if (jTextComponent == null) {
                return;
            }
            if (settingsChangeEvent.getKitClass() != Utilities.getKitClass(jTextComponent)) {
                return;
            }
            Object object = settingsChangeEvent.getNewValue();
            if (object instanceof Integer) {
                this.setBlinkRate((Integer)object);
            }
        }
        this.updateType();
    }

    void updateType() {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            Color color;
            boolean bl;
            String string;
            Class clazz = Utilities.getKitClass(jTextComponent);
            if (clazz == null) {
                return;
            }
            if (this.overwriteMode) {
                string = SettingsUtil.getString(clazz, "caret-type-overwrite-mode", LINE_CARET);
                bl = SettingsUtil.getBoolean(clazz, "caret-italic-overwrite-mode", false);
                color = BaseCaret.getColor(clazz, "caret-color-overwrite-mode", SettingsDefaults.defaultCaretColorOvwerwriteMode);
            } else {
                string = SettingsUtil.getString(clazz, "caret-type-insert-mode", LINE_CARET);
                bl = SettingsUtil.getBoolean(clazz, "caret-italic-insert-mode", false);
                color = BaseCaret.getColor(clazz, "caret-color-insert-mode", SettingsDefaults.defaultCaretColorInsertMode);
            }
            this.type = string;
            this.italic = bl;
            jTextComponent.setCaretColor(color);
            if (debugCaretFocusExtra) {
                System.err.println("Updating caret color:" + color);
            }
            this.resetBlink();
        }
    }

    private static Color getColor(Class clazz, String string, Color color) {
        Object object = Settings.getValue(clazz, string);
        return object instanceof Color ? (Color)object : color;
    }

    private boolean updateCaretBounds() {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            Rectangle rectangle;
            int n = this.getDot();
            try {
                rectangle = jTextComponent.getUI().modelToView(jTextComponent, n, Position.Bias.Forward);
                BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
                if (baseDocument != null) {
                    baseDocument.getChars(n, this.dotChar, 0, 1);
                }
            }
            catch (BadLocationException badLocationException) {
                rectangle = null;
                Utilities.annotateLoggable(badLocationException);
            }
            if (rectangle != null) {
                this.caretBounds = rectangle;
                return true;
            }
        }
        return false;
    }

    public void install(JTextComponent jTextComponent) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        this.component = jTextComponent;
        this.blinkVisible = true;
        BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
        if (baseDocument != null) {
            this.modelChanged(null, baseDocument);
        }
        this.updateCaretBounds();
        if (this.caretBounds == null) {
            this.component.addComponentListener(this.listenerImpl);
        }
        this.component.addPropertyChangeListener(this);
        this.component.addFocusListener(this.listenerImpl);
        this.component.addMouseListener(this);
        this.component.addMouseMotionListener(this);
        EditorUI editorUI = Utilities.getEditorUI(this.component);
        editorUI.addLayer(new DrawLayerFactory.CaretLayer(), 10000);
        this.caretMark.setEditorUI(editorUI);
        this.selectionMark.setEditorUI(editorUI);
        editorUI.addPropertyChangeListener(this);
        FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
        if (foldHierarchy != null) {
            foldHierarchy.addFoldHierarchyListener((FoldHierarchyListener)this);
        }
        if (this.component.hasFocus()) {
            if (debugCaretFocus || debugCaretFocusExtra) {
                System.err.println("Component has focus, calling BaseCaret.focusGained(); doc=" + this.component.getDocument().getProperty("title"));
            }
            this.listenerImpl.focusGained(null);
        }
        this.dispatchUpdate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deinstall(JTextComponent jTextComponent) {
        this.component = null;
        ListenerImpl listenerImpl = this.listenerImpl;
        synchronized (listenerImpl) {
            if (this.flasher != null) {
                this.setBlinkRate(0);
            }
        }
        Utilities.getEditorUI(jTextComponent).removeLayer("caret-layer");
        jTextComponent.removeMouseMotionListener(this);
        jTextComponent.removeMouseListener(this);
        jTextComponent.removeFocusListener(this.listenerImpl);
        jTextComponent.removePropertyChangeListener(this);
        listenerImpl = FoldHierarchy.get((JTextComponent)jTextComponent);
        if (listenerImpl != null) {
            listenerImpl.removeFoldHierarchyListener(this);
        }
        this.modelChanged(this.listenDoc, null);
    }

    protected void modelChanged(BaseDocument baseDocument, BaseDocument baseDocument2) {
        if (baseDocument != null) {
            if (!$assertionsDisabled && baseDocument != this.listenDoc) {
                throw new AssertionError();
            }
            DocumentUtilities.removeDocumentListener((Document)baseDocument, (DocumentListener)this, (DocumentListenerPriority)DocumentListenerPriority.CARET_UPDATE);
            baseDocument.removeAtomicLockListener(this);
            try {
                this.caretMark.remove();
                this.selectionMark.remove();
            }
            catch (InvalidMarkException invalidMarkException) {
                Utilities.annotateLoggable(invalidMarkException);
            }
            this.listenDoc = null;
        }
        if (baseDocument2 != null) {
            DocumentUtilities.addDocumentListener((Document)baseDocument2, (DocumentListener)this, (DocumentListenerPriority)DocumentListenerPriority.CARET_UPDATE);
            this.listenDoc = baseDocument2;
            baseDocument2.addAtomicLockListener(this);
            try {
                Utilities.insertMark(baseDocument2, this.caretMark, 0);
                Utilities.insertMark(baseDocument2, this.selectionMark, 0);
            }
            catch (InvalidMarkException invalidMarkException) {
                Utilities.annotateLoggable(invalidMarkException);
            }
            catch (BadLocationException badLocationException) {
                Utilities.annotateLoggable(badLocationException);
            }
            this.settingsChange(null);
            Utilities.runInEventDispatchThread(new Runnable(){

                public void run() {
                    BaseCaret.this.updateType();
                }
            });
        }
    }

    public void paint(Graphics graphics) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent == null) {
            return;
        }
        EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
        if (this.caretBounds != null && this.isVisible() && this.blinkVisible) {
            this.paintCustomCaret(graphics);
        }
    }

    protected void paintCustomCaret(Graphics graphics) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
            graphics.setColor(jTextComponent.getCaretColor());
            if (THIN_LINE_CARET.equals(this.type)) {
                int n = this.caretBounds.x;
                if (this.beforeCaretFont != null && this.beforeCaretFont.isItalic() && this.italic) {
                    n = (int)((double)n + Math.tan(this.beforeCaretFont.getItalicAngle()) * (double)this.caretBounds.height);
                }
                graphics.drawLine(n, this.caretBounds.y, this.caretBounds.x, this.caretBounds.y + this.caretBounds.height - 1);
            } else if (BLOCK_CARET.equals(this.type)) {
                if (this.afterCaretFont != null) {
                    graphics.setFont(this.afterCaretFont);
                }
                if (this.afterCaretFont != null && this.afterCaretFont.isItalic() && this.italic) {
                    int n;
                    this.xPoints[0] = n = (int)((double)this.caretBounds.x + Math.tan(this.afterCaretFont.getItalicAngle()) * (double)this.caretBounds.height);
                    this.yPoints[0] = this.caretBounds.y;
                    this.xPoints[1] = n + this.caretBounds.width;
                    this.yPoints[1] = this.caretBounds.y;
                    this.xPoints[2] = this.caretBounds.x + this.caretBounds.width;
                    this.yPoints[2] = this.caretBounds.y + this.caretBounds.height - 1;
                    this.xPoints[3] = this.caretBounds.x;
                    this.yPoints[3] = this.caretBounds.y + this.caretBounds.height - 1;
                    graphics.fillPolygon(this.xPoints, this.yPoints, 4);
                } else {
                    graphics.fillRect(this.caretBounds.x, this.caretBounds.y, this.caretBounds.width, this.caretBounds.height);
                }
                if (!Character.isWhitespace(this.dotChar[0])) {
                    graphics.setColor(Color.white);
                    graphics.drawChars(this.dotChar, 0, 1, this.caretBounds.x, this.caretBounds.y + editorUI.getLineAscent());
                }
            } else {
                int n = 2;
                if (this.beforeCaretFont != null && this.beforeCaretFont.isItalic() && this.italic) {
                    int n2;
                    this.xPoints[0] = n2 = (int)((double)this.caretBounds.x + Math.tan(this.beforeCaretFont.getItalicAngle()) * (double)this.caretBounds.height);
                    this.yPoints[0] = this.caretBounds.y;
                    this.xPoints[1] = n2 + n;
                    this.yPoints[1] = this.caretBounds.y;
                    this.xPoints[2] = this.caretBounds.x + n;
                    this.yPoints[2] = this.caretBounds.y + this.caretBounds.height - 1;
                    this.xPoints[3] = this.caretBounds.x;
                    this.yPoints[3] = this.caretBounds.y + this.caretBounds.height - 1;
                    graphics.fillPolygon(this.xPoints, this.yPoints, 4);
                } else {
                    graphics.fillRect(this.caretBounds.x, this.caretBounds.y, n, this.caretBounds.height - 1);
                }
            }
        }
    }

    void dispatchUpdate(final boolean bl) {
        Utilities.runInEventDispatchThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                BaseDocument baseDocument;
                JTextComponent jTextComponent = BaseCaret.this.component;
                if (jTextComponent != null && (baseDocument = Utilities.getDocument(jTextComponent)) != null) {
                    baseDocument.readLock();
                    try {
                        BaseCaret.this.update(bl);
                    }
                    finally {
                        baseDocument.readUnlock();
                    }
                }
            }
        });
    }

    protected void update(boolean bl) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
            EditorUI editorUI = baseTextUI.getEditorUI();
            BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
            if (baseDocument != null) {
                Rectangle rectangle = this.caretBounds;
                if (rectangle != null) {
                    if (this.italic) {
                        rectangle.width += rectangle.height;
                    }
                    jTextComponent.repaint(rectangle);
                }
                int n = this.getDot();
                if (this.updateCaretBounds() && bl) {
                    JScrollBar jScrollBar;
                    Container container;
                    Serializable serializable;
                    Rectangle rectangle2 = new Rectangle(this.caretBounds);
                    if (rectangle == null && (serializable = jTextComponent.getParent()) instanceof JViewport && (container = ((Component)serializable).getParent()) instanceof JScrollPane && (jScrollBar = ((JScrollPane)container).getHorizontalScrollBar()) != null) {
                        int n2 = jScrollBar.getPreferredSize().height;
                        Dimension dimension = ((JViewport)serializable).getExtentSize();
                        if (dimension.height >= this.caretBounds.height + n2) {
                            rectangle2.height += n2;
                        }
                    }
                    serializable = jTextComponent.getVisibleRect();
                    if (this.caretBounds.y > ((Rectangle)serializable).y + ((Rectangle)serializable).height + this.caretBounds.height || this.caretBounds.y + this.caretBounds.height < ((Rectangle)serializable).y - this.caretBounds.height) {
                        rectangle2.y -= (((Rectangle)serializable).height - this.caretBounds.height) / 2;
                        rectangle2.height = ((Rectangle)serializable).height;
                    }
                    jTextComponent.scrollRectToVisible(rectangle2);
                    this.resetBlink();
                    jTextComponent.repaint(this.caretBounds);
                }
            }
        }
    }

    private void updateSystemSelection() {
        Clipboard clipboard;
        if (this.getDot() != this.getMark() && this.component != null && (clipboard = this.getSystemSelection()) != null) {
            clipboard.setContents(new StringSelection(this.component.getSelectedText()), null);
        }
    }

    private Clipboard getSystemSelection() {
        return this.component.getToolkit().getSystemSelection();
    }

    private void updateJumpList() {
        JumpList.dotMoved(this.component, this.getDot());
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    protected void fireStateChanged() {
        Utilities.runInEventDispatchThread(new Runnable(){

            public void run() {
                Object[] objectArray = BaseCaret.this.listenerList.getListenerList();
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? BaseCaret.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
                    if (BaseCaret.this.changeEvent == null) {
                        BaseCaret.this.changeEvent = new ChangeEvent(BaseCaret.this);
                    }
                    ((ChangeListener)objectArray[i + 1]).stateChanged(BaseCaret.this.changeEvent);
                }
            }
        });
        this.updateSystemSelection();
        this.updateJumpList();
    }

    public final boolean isVisible() {
        return this.caretVisible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setVisibleImpl(boolean bl) {
        Object object;
        boolean bl2 = this.isVisible();
        Object object2 = this;
        synchronized (object2) {
            object = this.listenerImpl;
            synchronized (object) {
                if (this.flasher != null) {
                    if (bl2) {
                        this.flasher.stop();
                    }
                    if (bl) {
                        if (debugCaretFocusExtra) {
                            System.err.println("starting the caret blinking timer: visible=" + bl2 + ", blinkVisible=" + this.blinkVisible);
                        }
                        this.flasher.start();
                    } else {
                        if (debugCaretFocusExtra) {
                            System.err.println("stopping the caret blinking timer");
                        }
                        this.flasher.stop();
                    }
                }
            }
            this.caretVisible = bl;
        }
        object2 = this.component;
        if (object2 != null && this.caretBounds != null) {
            object = this.caretBounds;
            if (this.italic) {
                object = new Rectangle((Rectangle)object);
                ((Rectangle)object).width += ((Rectangle)object).height;
            }
            ((JComponent)object2).repaint((Rectangle)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void resetBlink() {
        boolean bl = this.isVisible();
        ListenerImpl listenerImpl = this.listenerImpl;
        synchronized (listenerImpl) {
            if (this.flasher != null) {
                this.flasher.stop();
                this.blinkVisible = true;
                if (bl) {
                    if (debugCaretFocusExtra) {
                        System.err.println("Reset blinking (caret already visible) - starting the caret blinking timer: visible=" + bl + ", blinkVisible=" + this.blinkVisible);
                    }
                    this.flasher.start();
                } else if (debugCaretFocusExtra) {
                    System.err.println("Reset blinking (caret not visible) - caret blinking timer not started: visible=" + bl + ", blinkVisible=" + this.blinkVisible);
                }
            }
        }
    }

    public void setVisible(final boolean bl) {
        Utilities.runInEventDispatchThread(new Runnable(){

            public void run() {
                BaseCaret.this.setVisibleImpl(bl);
            }
        });
    }

    public final boolean isSelectionVisible() {
        return this.selectionVisible;
    }

    public void setSelectionVisible(boolean bl) {
        if (this.selectionVisible == bl) {
            return;
        }
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            this.selectionVisible = bl;
            if (this.selectionVisible) {
                boolean bl2;
                int n = this.getDot();
                int n2 = this.getMark();
                this.selectionMark.activateLayer = bl2 = n2 < n;
                this.caretMark.activateLayer = !bl2 && n2 != n;
            } else {
                this.caretMark.activateLayer = false;
                this.selectionMark.activateLayer = false;
            }
            BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
            try {
                baseTextUI.getEditorUI().repaintBlock(this.caretMark.getOffset(), this.selectionMark.getOffset());
            }
            catch (BadLocationException badLocationException) {
                Utilities.annotateLoggable(badLocationException);
            }
            catch (InvalidMarkException invalidMarkException) {
                Utilities.annotateLoggable(invalidMarkException);
            }
        }
    }

    public void setMagicCaretPosition(Point point) {
        this.magicCaretPosition = point;
    }

    public final Point getMagicCaretPosition() {
        return this.magicCaretPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setBlinkRate(int n) {
        ListenerImpl listenerImpl = this.listenerImpl;
        synchronized (listenerImpl) {
            if (this.flasher == null && n > 0) {
                this.flasher = new Timer(n, new WeakTimerListener(this));
            }
            if (this.flasher != null) {
                if (n > 0) {
                    if (this.flasher.getDelay() != n) {
                        if (debugCaretFocusExtra) {
                            System.err.println("blink rate:" + n);
                        }
                        this.flasher.setDelay(n);
                    }
                } else {
                    if (debugCaretFocusExtra) {
                        System.err.println("zero rate - don't blink");
                        System.err.println("setting blinkVisible to true and disabling timer");
                    }
                    this.flasher.stop();
                    this.flasher.removeActionListener(this);
                    this.flasher = null;
                    this.blinkVisible = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getBlinkRate() {
        ListenerImpl listenerImpl = this.listenerImpl;
        synchronized (listenerImpl) {
            return this.flasher != null ? this.flasher.getDelay() : 0;
        }
    }

    public int getDot() {
        if (this.component != null) {
            try {
                return this.caretMark.getOffset();
            }
            catch (InvalidMarkException invalidMarkException) {
                // empty catch block
            }
        }
        return 0;
    }

    public int getMark() {
        if (this.component != null) {
            if (this.selectionVisible) {
                try {
                    return this.selectionMark.getOffset();
                }
                catch (InvalidMarkException invalidMarkException) {
                }
            } else {
                return this.getDot();
            }
        }
        return 0;
    }

    public void setDot(int n) {
        this.setDot(n, this.caretBounds, 0);
    }

    public void setDot(int n, boolean bl) {
        this.setDot(n, this.caretBounds, 0, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDot(int n, Rectangle rectangle, int n2, boolean bl) {
        this.afterFirstSetDot = true;
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            boolean bl2;
            block12: {
                this.setSelectionVisible(false);
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                bl2 = false;
                baseDocument.readLock();
                try {
                    if (baseDocument == null || n < 0 || n > baseDocument.getLength()) break block12;
                    bl2 = true;
                    try {
                        Utilities.moveMark(baseDocument, this.caretMark, n);
                        FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
                        foldHierarchy.lock();
                        try {
                            Fold fold = null;
                            while (bl && (fold = FoldUtilities.findCollapsedFold((FoldHierarchy)foldHierarchy, (int)n, (int)n)) != null && fold.getStartOffset() < n && fold.getEndOffset() > n) {
                                foldHierarchy.expand(fold);
                            }
                        }
                        finally {
                            foldHierarchy.unlock();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        throw new IllegalStateException(badLocationException.toString());
                    }
                    catch (InvalidMarkException invalidMarkException) {
                        throw new IllegalStateException(invalidMarkException.toString());
                    }
                }
                finally {
                    baseDocument.readUnlock();
                }
            }
            if (bl2) {
                this.fireStateChanged();
                this.dispatchUpdate(true);
            }
        }
    }

    public void setDot(int n, Rectangle rectangle, int n2) {
        this.setDot(n, rectangle, n2, true);
    }

    public void moveDot(int n) {
        this.moveDot(n, this.caretBounds, 1);
    }

    public void moveDot(int n, Rectangle rectangle, int n2) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            if (baseDocument != null && n >= 0 && n <= baseDocument.getLength()) {
                try {
                    int n3;
                    int n4 = this.getDot();
                    if (n == n4) {
                        return;
                    }
                    if (this.selectionVisible) {
                        n3 = this.selectionMark.getOffset();
                    } else {
                        Utilities.moveMark(baseDocument, this.selectionMark, n4);
                        n3 = n4;
                    }
                    Utilities.moveMark(baseDocument, this.caretMark, n);
                    if (this.selectionVisible) {
                        boolean bl;
                        this.selectionMark.activateLayer = bl = n3 < n;
                        this.caretMark.activateLayer = !bl && n3 != n;
                        Utilities.getEditorUI(jTextComponent).repaintBlock(n4, n);
                        if (n3 == n) {
                            this.setSelectionVisible(false);
                        }
                    } else {
                        this.setSelectionVisible(true);
                    }
                }
                catch (BadLocationException badLocationException) {
                    throw new IllegalStateException(badLocationException.toString());
                }
                catch (InvalidMarkException invalidMarkException) {
                    throw new IllegalStateException(invalidMarkException.toString());
                }
            }
            this.fireStateChanged();
            this.dispatchUpdate(true);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            BaseDocument baseDocument = (BaseDocument)this.component.getDocument();
            BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)documentEvent;
            this.undoOffset = (baseDocumentEvent.isInUndo() || baseDocumentEvent.isInRedo()) && this.component == Utilities.getLastActiveComponent() ? documentEvent.getOffset() + documentEvent.getLength() : -1;
            this.modified = true;
            this.modifiedUpdate();
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            BaseDocumentEvent baseDocumentEvent;
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            if (this.selectionVisible && this.getDot() == this.getMark()) {
                this.setSelectionVisible(false);
            }
            this.undoOffset = ((baseDocumentEvent = (BaseDocumentEvent)documentEvent).isInUndo() || baseDocumentEvent.isInRedo()) && jTextComponent == Utilities.getLastActiveComponent() ? documentEvent.getOffset() : -1;
            this.modified = true;
            this.modifiedUpdate();
        }
    }

    private void modifiedUpdate() {
        if (!this.inAtomicLock) {
            JTextComponent jTextComponent = this.component;
            if (this.modified && jTextComponent != null) {
                if (this.undoOffset >= 0) {
                    this.setDot(this.undoOffset);
                } else {
                    this.fireStateChanged();
                    this.dispatchUpdate(jTextComponent.hasFocus());
                }
                this.modified = false;
            }
        }
    }

    public void atomicLock(AtomicLockEvent atomicLockEvent) {
        this.inAtomicLock = true;
    }

    public void atomicUnlock(AtomicLockEvent atomicLockEvent) {
        this.inAtomicLock = false;
        this.modifiedUpdate();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseClicked(MouseEvent mouseEvent) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (mouseEvent.getClickCount() == 2) {
                    BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
                    int n = baseTextUI.viewToModel(jTextComponent, mouseEvent.getX(), mouseEvent.getY());
                    FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
                    Document document = jTextComponent.getDocument();
                    if (document instanceof AbstractDocument) {
                        AbstractDocument abstractDocument = (AbstractDocument)document;
                        abstractDocument.readLock();
                        try {
                            foldHierarchy.lock();
                            try {
                                Fold fold = FoldUtilities.findCollapsedFold((FoldHierarchy)foldHierarchy, (int)n, (int)n);
                                if (fold != null && fold.getStartOffset() <= n && fold.getEndOffset() >= n) {
                                    foldHierarchy.expand(fold);
                                }
                                if (this.selectWordAction == null) {
                                    this.selectWordAction = ((BaseKit)baseTextUI.getEditorKit(jTextComponent)).getActionByName("select-word");
                                }
                                this.selectWordAction.actionPerformed(null);
                            }
                            finally {
                                foldHierarchy.unlock();
                            }
                        }
                        finally {
                            abstractDocument.readUnlock();
                        }
                    }
                } else if (mouseEvent.getClickCount() == 3) {
                    if (this.selectLineAction == null) {
                        BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
                        this.selectLineAction = ((BaseKit)baseTextUI.getEditorKit(jTextComponent)).getActionByName("select-line");
                    }
                    this.selectLineAction.actionPerformed(null);
                }
            } else if (SwingUtilities.isMiddleMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                if (jTextComponent == null) {
                    return;
                }
                Toolkit toolkit = jTextComponent.getToolkit();
                Clipboard clipboard = this.getSystemSelection();
                if (clipboard == null) {
                    return;
                }
                Transferable transferable = clipboard.getContents(null);
                if (transferable == null) {
                    return;
                }
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                if (baseDocument == null) {
                    return;
                }
                int n = ((BaseTextUI)jTextComponent.getUI()).viewToModel(jTextComponent, mouseEvent.getX(), mouseEvent.getY());
                try {
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    if (string == null) {
                        return;
                    }
                    try {
                        baseDocument.atomicLock();
                        try {
                            baseDocument.insertString(n, string, null);
                            this.setDot(n + string.length());
                        }
                        finally {
                            baseDocument.atomicUnlock();
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void mousePressedImpl(MouseEvent mouseEvent) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            Utilities.getEditorUI(jTextComponent).getWordMatch().clear();
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && !mouseEvent.isPopupTrigger() && (mouseEvent.getModifiers() & 0xC) == 0 || !this.isSelectionVisible()) {
                int n = ((BaseTextUI)jTextComponent.getUI()).viewToModel(jTextComponent, mouseEvent.getX(), mouseEvent.getY());
                if (n >= 0) {
                    if ((mouseEvent.getModifiers() & 1) != 0) {
                        this.moveDot(n);
                    } else {
                        this.setDot(n);
                    }
                    this.setMagicCaretPosition(null);
                }
                if (jTextComponent.isEnabled()) {
                    jTextComponent.requestFocus();
                }
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.dndArmedEvent = null;
        if (this.isDragPossible(mouseEvent) && this.mapDragOperationFromModifiers(mouseEvent) != 0) {
            this.dndArmedEvent = mouseEvent;
            mouseEvent.consume();
            return;
        }
        this.mousePressedImpl(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.dndArmedEvent != null) {
            this.mousePressedImpl(mouseEvent);
        }
        this.dndArmedEvent = null;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected int mapDragOperationFromModifiers(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiersEx();
        if ((n & 0x400) != 1024) {
            return 0;
        }
        return 3;
    }

    protected boolean isDragPossible(MouseEvent mouseEvent) {
        int n;
        Caret caret;
        int n2;
        JTextComponent jTextComponent;
        boolean bl;
        JComponent jComponent = this.getEventComponent(mouseEvent);
        boolean bl2 = jComponent == null ? true : (bl = jComponent.getTransferHandler() != null);
        if (bl && (jTextComponent = (JTextComponent)this.getEventComponent(mouseEvent)).getDragEnabled() && (n2 = (caret = jTextComponent.getCaret()).getDot()) != (n = caret.getMark())) {
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            int n3 = jTextComponent.viewToModel(point);
            int n4 = Math.min(n2, n);
            int n5 = Math.max(n2, n);
            if (n3 >= n4 && n3 < n5) {
                return true;
            }
        }
        return false;
    }

    protected JComponent getEventComponent(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object instanceof JComponent) {
            JComponent jComponent = (JComponent)object;
            return jComponent;
        }
        return null;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.dndArmedEvent != null) {
            mouseEvent.consume();
            return;
        }
        JTextComponent jTextComponent = this.component;
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && jTextComponent != null) {
            int n = ((BaseTextUI)jTextComponent.getUI()).viewToModel(jTextComponent, mouseEvent.getX(), mouseEvent.getY());
            if (n == -1) {
                n = 0;
            }
            if (n >= 0 && (mouseEvent.getModifiers() & 1) == 0) {
                this.moveDot(n);
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JScrollPane jScrollPane;
        JScrollBar jScrollBar;
        Container container;
        String string = propertyChangeEvent.getPropertyName();
        if ("document".equals(string)) {
            BaseDocument baseDocument = propertyChangeEvent.getNewValue() instanceof BaseDocument ? (BaseDocument)propertyChangeEvent.getNewValue() : null;
            this.modelChanged(this.listenDoc, baseDocument);
        } else if ("overwriteMode".equals(string)) {
            Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.overwriteMode = bl != null ? bl : false;
            this.updateType();
        } else if ("ancestor".equals(string) && propertyChangeEvent.getSource() == this.component && (container = this.component.getParent()) instanceof JViewport && (container = container.getParent()) instanceof JScrollPane && (jScrollBar = (jScrollPane = (JScrollPane)container).getHorizontalScrollBar()) != null) {
            jScrollBar.addComponentListener((ComponentListener)WeakListeners.create((Class)ComponentListener.class, (EventListener)this.listenerImpl, (Object)jScrollBar));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            boolean bl = this.blinkVisible = !this.blinkVisible;
            if (this.caretBounds != null) {
                Rectangle rectangle = this.caretBounds;
                if (this.italic) {
                    rectangle = new Rectangle(rectangle);
                    rectangle.width += rectangle.height;
                }
                jTextComponent.repaint(rectangle);
            }
        }
    }

    public void foldHierarchyChanged(FoldHierarchyEvent foldHierarchyEvent) {
        int n = this.getDot();
        int n2 = foldHierarchyEvent.getAddedFoldCount();
        if (n2 > 0) {
            FoldHierarchy foldHierarchy = (FoldHierarchy)foldHierarchyEvent.getSource();
            Fold fold = null;
            while ((fold = FoldUtilities.findCollapsedFold((FoldHierarchy)foldHierarchy, (int)n, (int)n)) != null && fold.getStartOffset() < n && fold.getEndOffset() > n) {
                foldHierarchy.expand(fold);
            }
            for (int i = 0; i < n2; ++i) {
                if (!foldHierarchyEvent.getAddedFold(i).isCollapsed()) continue;
                if (this.afterFirstSetDot) {
                    this.dispatchUpdate(false);
                }
                return;
            }
        } else {
            int n3 = -1;
            if (foldHierarchyEvent.getAffectedStartOffset() <= n && foldHierarchyEvent.getAffectedEndOffset() >= n) {
                for (int i = 0; i < foldHierarchyEvent.getFoldStateChangeCount(); ++i) {
                    Fold fold;
                    FoldStateChange foldStateChange = foldHierarchyEvent.getFoldStateChange(i);
                    if (!foldStateChange.isCollapsedChanged() || !(fold = foldStateChange.getFold()).isCollapsed() || fold.getStartOffset() > n || fold.getEndOffset() < n || fold.getEndOffset() <= n3) continue;
                    n3 = fold.getEndOffset();
                }
                if (n3 > -1) {
                    this.setDot(n3, false);
                }
            }
            this.dispatchUpdate(false);
        }
    }

    static {
        $assertionsDisabled = !BaseCaret.class.desiredAssertionStatus();
        debugCaretFocus = Boolean.getBoolean("netbeans.debug.editor.caret.focus");
        debugCaretFocusExtra = Boolean.getBoolean("netbeans.debug.editor.caret.focus.extra");
    }

    private class ListenerImpl
    extends ComponentAdapter
    implements FocusListener {
        ListenerImpl() {
        }

        public void focusGained(FocusEvent focusEvent) {
            JTextComponent jTextComponent;
            if (debugCaretFocus || debugCaretFocusExtra) {
                System.err.println((debugCaretFocusExtra ? "\n" : "") + "BaseCaret.focusGained(); doc=" + BaseCaret.this.component.getDocument().getProperty("title"));
            }
            if ((jTextComponent = BaseCaret.this.component) != null) {
                BaseCaret.this.updateType();
                if (debugCaretFocusExtra) {
                    System.err.println("going to set caret visible to: " + jTextComponent.isEnabled());
                }
                BaseCaret.this.setVisible(jTextComponent.isEnabled());
            } else if (debugCaretFocusExtra) {
                System.err.println("component is null, caret will not be dislayed");
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (debugCaretFocus || debugCaretFocusExtra) {
                System.err.println((debugCaretFocusExtra ? "\n" : "") + "BaseCaret.focusLost(); doc=" + BaseCaret.this.component.getDocument().getProperty("title") + "\nFOCUS GAINER: " + focusEvent.getOppositeComponent());
                if (debugCaretFocusExtra) {
                    System.err.println("FOCUS EVENT: " + focusEvent);
                }
            }
            BaseCaret.this.setVisible(false);
        }

        public void componentShown(ComponentEvent componentEvent) {
            Component component = componentEvent.getComponent();
            if (component != BaseCaret.this.component) {
                Container container = component.getParent();
                if (BaseCaret.this.caretBounds != null && container instanceof JScrollPane) {
                    Rectangle rectangle = ((JScrollPane)container).getViewport().getViewRect();
                    Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y + rectangle.height, component.getWidth(), component.getHeight());
                    if (rectangle2.intersects(BaseCaret.this.caretBounds)) {
                        BaseCaret.this.dispatchUpdate(true);
                    }
                }
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
            Component component = componentEvent.getComponent();
            if (component == BaseCaret.this.component && BaseCaret.this.caretBounds == null) {
                BaseCaret.this.dispatchUpdate(true);
                if (BaseCaret.this.caretBounds != null) {
                    component.removeComponentListener(this);
                }
            }
        }
    }
}

