/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawEngine;
import org.netbeans.editor.DrawGraphics;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FoldMultiLineView;
import org.netbeans.editor.view.spi.EstimatedSpanView;
import org.netbeans.editor.view.spi.LockView;
import org.netbeans.editor.view.spi.ViewLayoutState;
import org.openide.ErrorManager;

class DrawEngineLineView
extends View
implements ViewLayoutState,
EstimatedSpanView {
    private static final int X_MAJOR_AXIS_BIT = 1;
    private static final int MAJOR_AXIS_PREFERENCE_CHANGED_BIT = 2;
    private static final int MINOR_AXIS_PREFERENCE_CHANGED_BIT = 4;
    private static final int VIEW_SIZE_INVALID_BIT = 8;
    private static final int UPDATE_LAYOUT_PENDING_BIT = 16;
    private static final int ESTIMATED_SPAN_BIT = 32;
    protected static final int LAST_USED_BIT = 32;
    private static final int ANY_INVALID = 14;
    private int statusBits;
    private int viewRawIndex;
    private double layoutMajorAxisRawOffset;
    private float layoutMajorAxisPreferredSpan;
    private float layoutMinorAxisPreferredSpan;
    ViewToModelDG viewToModelDG;

    public DrawEngineLineView(Element element) {
        super(element);
    }

    private int getBaseX(int n) {
        return n + this.getEditorUI().getTextMargin().left;
    }

    private JTextComponent getComponent() {
        return (JTextComponent)this.getContainer();
    }

    private BaseTextUI getBaseTextUI() {
        return (BaseTextUI)this.getComponent().getUI();
    }

    private EditorUI getEditorUI() {
        return this.getBaseTextUI().getEditorUI();
    }

    private ModelToViewDG getModelToViewDG() {
        return new ModelToViewDG();
    }

    private ViewToModelDG getViewToModelDG() {
        if (this.viewToModelDG == null) {
            this.viewToModelDG = new ViewToModelDG();
        }
        return this.viewToModelDG;
    }

    public boolean isEstimatedSpan() {
        return this.isStatusBitsNonZero(32);
    }

    public void setEstimatedSpan(boolean bl) {
        if (this.isEstimatedSpan() != bl) {
            if (bl) {
                this.setStatusBits(32);
            } else {
                this.clearStatusBits(32);
                this.getParent().preferenceChanged(this, true, true);
            }
        }
    }

    protected boolean isFragment() {
        return false;
    }

    private int getEOLffset() {
        return super.getEndOffset() - 1;
    }

    private int getAdjustedEOLOffset() {
        return Math.min(this.getEndOffset(), this.getEOLffset());
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.preferenceChanged(this, true, false);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.preferenceChanged(this, true, false);
    }

    public float getAlignment(int n) {
        return 0.0f;
    }

    public void paint(Graphics graphics, Shape shape) {
        if (!(this.getDocument() instanceof BaseDocument)) {
            return;
        }
        this.setEstimatedSpan(false);
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        int n = this.getStartOffset();
        int n2 = this.getAdjustedEOLOffset();
        try {
            if (this.isFragment()) {
                Rectangle rectangle2 = graphics.getClipBounds();
                Rectangle rectangle3 = new Rectangle(rectangle2);
                Rectangle rectangle4 = this.modelToView(n, shape, Position.Bias.Forward).getBounds();
                Rectangle rectangle5 = this.modelToView(n2, shape, Position.Bias.Forward).getBounds();
                View view = this.getParent();
                if (view instanceof FoldMultiLineView && !this.equals(view.getView(view.getViewCount() - 1))) {
                    rectangle3.width = Math.min(rectangle2.width, rectangle5.x);
                    if (rectangle3.width + rectangle3.x > rectangle5.x) {
                        rectangle3.width -= rectangle3.width + rectangle3.x - rectangle5.x;
                    }
                    graphics.setClip(rectangle3);
                }
                int n3 = rectangle4.x - this.getEditorUI().getTextMargin().left - rectangle.x;
                graphics.translate(-n3, 0);
                DrawEngine.getDrawEngine().draw(this, new DrawGraphics.GraphicsDG(graphics), this.getEditorUI(), n, n2, this.getBaseX(rectangle.x), rectangle.y, Integer.MAX_VALUE);
                graphics.translate(n3, 0);
                graphics.setClip(rectangle2);
            } else {
                JTextComponent jTextComponent = this.getComponent();
                if (jTextComponent != null) {
                    DrawEngine drawEngine = (DrawEngine)jTextComponent.getClientProperty(DrawEngine.PreinitializedDrawEngine.class);
                    if (drawEngine != null) {
                        drawEngine.draw(this, new DrawGraphics.GraphicsDG(graphics), this.getEditorUI(), n, n2, this.getBaseX(rectangle.x), rectangle.y, Integer.MAX_VALUE);
                    } else {
                        DrawEngine.getDrawEngine().draw(this, new DrawGraphics.GraphicsDG(graphics), this.getEditorUI(), n, n2, this.getBaseX(rectangle.x), rectangle.y, Integer.MAX_VALUE);
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public float getPreferredSpan(int n) {
        switch (n) {
            case 1: {
                return this.getEditorUI().getLineHeight();
            }
            case 0: {
                try {
                    int n2 = Math.max(0, this.getEndOffset() - 1);
                    Shape shape = this.modelToView(n2, new Rectangle(), Position.Bias.Forward, false);
                    int n3 = shape.getBounds().x + shape.getBounds().width;
                    return Math.max((float)n3, 1.0f);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }
        return 1.0f;
    }

    private Rectangle getModel2ViewRect(int n, int n2, int n3, int n4, int n5) {
        Rectangle rectangle = new Rectangle();
        rectangle.y = n4;
        if (this.isEstimatedSpan()) {
            rectangle.height = this.getEditorUI().getLineHeight();
            rectangle.x = n3;
            rectangle.width = 1;
        } else {
            try {
                ModelToViewDG modelToViewDG = this.getModelToViewDG();
                modelToViewDG.r = rectangle;
                DrawEngine.getDrawEngine().draw(this, modelToViewDG, this.getEditorUI(), n, n2, n3, n4, n5);
                LockView lockView = LockView.get(this);
                if (lockView != null && lockView.getLockThread() != Thread.currentThread()) {
                    throw new IllegalStateException("View access without view lock");
                }
                modelToViewDG.r = null;
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
            }
        }
        return rectangle;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        return this.modelToView(n, shape, bias, true);
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias, boolean bl) throws BadLocationException {
        Document document;
        if (bl) {
            this.setEstimatedSpan(false);
        }
        if (!((document = this.getDocument()) instanceof BaseDocument)) {
            return new Rectangle();
        }
        BaseDocument baseDocument = (BaseDocument)document;
        if (n < 0 || n > baseDocument.getLength()) {
            throw new BadLocationException("Invalid offset=" + n, n);
        }
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        Rectangle rectangle2 = this.getModel2ViewRect(this.getStartOffset(), this.getAdjustedEOLOffset(), this.getBaseX(rectangle.x), rectangle.y, n);
        return rectangle2;
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        if (this.isEstimatedSpan()) {
            return this.getStartOffset();
        }
        int n = (int)f;
        int n2 = (int)f2;
        if (biasArray != null) {
            biasArray[0] = Position.Bias.Forward;
        }
        int n3 = this.getStartOffset();
        Rectangle rectangle = shape != null ? shape.getBounds() : new Rectangle();
        try {
            int n4 = this.getAdjustedEOLOffset();
            ViewToModelDG viewToModelDG = this.getViewToModelDG();
            viewToModelDG.setTargetX(n);
            viewToModelDG.setEOLOffset(n4);
            DrawEngine.getDrawEngine().draw(this, viewToModelDG, this.getEditorUI(), this.getStartOffset(), n4, this.getBaseX(0) + rectangle.x, rectangle.y, -1);
            n3 = viewToModelDG.getOffset();
            return n3;
        }
        catch (BadLocationException badLocationException) {
            return n3;
        }
    }

    public View createFragment(int n, int n2) {
        Element element = this.getElement();
        return n >= 0 && n >= element.getStartOffset() && n < element.getEndOffset() && n2 > 0 && n2 <= element.getEndOffset() && n2 > element.getStartOffset() && (n != element.getStartOffset() || n2 != element.getEndOffset()) ? new FragmentView(this.getElement(), n - element.getStartOffset(), n2 - n) : this;
    }

    public double getLayoutMajorAxisPreferredSpan() {
        return this.layoutMajorAxisPreferredSpan;
    }

    public float getLayoutMajorAxisPreferredSpanFloat() {
        return this.layoutMajorAxisPreferredSpan;
    }

    protected void setLayoutMajorAxisPreferredSpan(float f) {
        this.layoutMajorAxisPreferredSpan = f;
    }

    public double getLayoutMajorAxisRawOffset() {
        return this.layoutMajorAxisRawOffset;
    }

    public void setLayoutMajorAxisRawOffset(double d) {
        this.layoutMajorAxisRawOffset = d;
    }

    public float getLayoutMinorAxisAlignment() {
        return this.getAlignment(this.getMinorAxis());
    }

    public float getLayoutMinorAxisMaximumSpan() {
        return this.getLayoutMinorAxisPreferredSpan();
    }

    public float getLayoutMinorAxisMinimumSpan() {
        return this.getLayoutMinorAxisPreferredSpan();
    }

    public float getLayoutMinorAxisPreferredSpan() {
        return this.layoutMinorAxisPreferredSpan;
    }

    protected void setLayoutMinorAxisPreferredSpan(float f) {
        this.layoutMinorAxisPreferredSpan = f;
    }

    public View getView() {
        return this;
    }

    public int getViewRawIndex() {
        return this.viewRawIndex;
    }

    public void setViewRawIndex(int n) {
        this.viewRawIndex = n;
    }

    public boolean isFlyweight() {
        return false;
    }

    public ViewLayoutState selectLayoutMajorAxis(int n) {
        if (n == 0) {
            this.setStatusBits(1);
        } else {
            this.clearStatusBits(1);
        }
        return this;
    }

    protected final ViewLayoutState.Parent getLayoutStateParent() {
        View view = this.getView().getParent();
        return view instanceof ViewLayoutState.Parent ? (ViewLayoutState.Parent)((Object)view) : null;
    }

    public void updateLayout() {
        float f;
        if (this.isLayoutValid()) {
            return;
        }
        ViewLayoutState.Parent parent = this.getLayoutStateParent();
        if (parent == null) {
            return;
        }
        if (this.isStatusBitsNonZero(4)) {
            this.clearStatusBits(4);
            int n = this.getMinorAxis();
            if (this.minorAxisUpdateLayout(n)) {
                parent.minorAxisPreferenceChanged(this);
            }
        }
        if (this.isStatusBitsNonZero(2)) {
            this.clearStatusBits(2);
            float f2 = this.getLayoutMajorAxisPreferredSpanFloat();
            f = this.getPreferredSpan(this.getMajorAxis());
            this.setLayoutMajorAxisPreferredSpan(f);
            double d = f - f2;
            if (d != 0.0) {
                parent.majorAxisPreferenceChanged(this, d);
            }
        }
        if (this.isStatusBitsNonZero(8)) {
            float f3;
            this.clearStatusBits(8);
            float f4 = (float)this.getLayoutMajorAxisPreferredSpan();
            float f5 = parent.getMinorAxisSpan(this);
            if (this.isXMajorAxis()) {
                f3 = f4;
                f = f5;
            } else {
                f3 = f5;
                f = f4;
            }
            this.setSize(f3, f);
        }
        this.updateLayout();
    }

    protected boolean minorAxisUpdateLayout(int n) {
        boolean bl = false;
        float f = this.getPreferredSpan(n);
        if (f != this.getLayoutMinorAxisPreferredSpan()) {
            this.setLayoutMinorAxisPreferredSpan(f);
            bl = true;
        }
        return bl;
    }

    public void viewPreferenceChanged(boolean bl, boolean bl2) {
        if (this.isXMajorAxis()) {
            if (bl) {
                this.setStatusBits(2);
            }
            if (bl2) {
                this.setStatusBits(4);
            }
        } else {
            if (bl) {
                this.setStatusBits(4);
            }
            if (bl2) {
                this.setStatusBits(2);
            }
        }
        this.setStatusBits(8);
    }

    public void markViewSizeInvalid() {
        this.setStatusBits(8);
    }

    public boolean isLayoutValid() {
        return !this.isStatusBitsNonZero(14);
    }

    protected final boolean isXMajorAxis() {
        return this.isStatusBitsNonZero(1);
    }

    protected final int getMajorAxis() {
        return this.isXMajorAxis() ? 0 : 1;
    }

    protected final int getMinorAxis() {
        return this.isXMajorAxis() ? 1 : 0;
    }

    protected final int getStatusBits(int n) {
        return this.statusBits & n;
    }

    protected final boolean isStatusBitsNonZero(int n) {
        return this.getStatusBits(n) != 0;
    }

    protected final void setStatusBits(int n) {
        this.statusBits |= n;
    }

    protected final void clearStatusBits(int n) {
        this.statusBits &= ~n;
    }

    static class FragmentView
    extends DrawEngineLineView {
        private Position startPos;
        private Position endPos;

        public FragmentView(Element element, int n, int n2) {
            super(element);
            try {
                Document document = element.getDocument();
                this.startPos = document.createPosition(super.getStartOffset() + n);
                this.endPos = document.createPosition(this.startPos.getOffset() + n2);
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
        }

        protected boolean isFragment() {
            return true;
        }

        public int getStartOffset() {
            return this.startPos.getOffset();
        }

        public int getEndOffset() {
            return this.endPos.getOffset();
        }
    }

    final class ModelToViewDG
    extends DrawGraphics.SimpleDG {
        Rectangle r;

        ModelToViewDG() {
        }

        public boolean targetOffsetReached(int n, char c, int n2, int n3, DrawContext drawContext) {
            this.r.x = n2;
            this.r.y = this.getY();
            this.r.width = n3;
            this.r.height = DrawEngineLineView.this.getEditorUI().getLineHeight();
            return false;
        }
    }

    final class ViewToModelDG
    extends DrawGraphics.SimpleDG {
        int targetX;
        int offset;
        int eolOffset;

        ViewToModelDG() {
        }

        void setTargetX(int n) {
            this.targetX = n;
        }

        void setEOLOffset(int n) {
            this.eolOffset = n;
            this.offset = n;
        }

        int getOffset() {
            return this.offset;
        }

        public boolean targetOffsetReached(int n, char c, int n2, int n3, DrawContext drawContext) {
            if (n <= this.eolOffset) {
                if (n2 + n3 < this.targetX) {
                    this.offset = n;
                    return true;
                }
                this.offset = n;
                if (this.targetX > n2 + n3 / 2) {
                    Document document = DrawEngineLineView.this.getDocument();
                    if (c != '\n' && document != null && n < document.getLength()) {
                        ++this.offset;
                    }
                }
                return false;
            }
            return false;
        }
    }
}

