/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.DocumentUtilities;
import org.netbeans.editor.LineElement;
import org.netbeans.editor.LineRootElement;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxUpdateTokens;

final class FixLineSyntaxState {
    private static final boolean debug = false;
    private final DocumentEvent evt;
    private int syntaxUpdateOffset;
    private List syntaxUpdateTokenList = Collections.EMPTY_LIST;
    static final /* synthetic */ boolean $assertionsDisabled;

    FixLineSyntaxState(DocumentEvent documentEvent) {
        this.evt = documentEvent;
    }

    final int getSyntaxUpdateOffset() {
        return this.syntaxUpdateOffset;
    }

    final List getSyntaxUpdateTokenList() {
        return this.syntaxUpdateTokenList;
    }

    static void invalidateAllSyntaxStateInfos(BaseDocument baseDocument) {
        LineRootElement lineRootElement = FixLineSyntaxState.getLineRoot(baseDocument);
        int n = lineRootElement.getElementCount();
        for (int i = n - 1; i >= 0; --i) {
            LineElement lineElement = (LineElement)lineRootElement.getElement(i);
            lineElement.clearSyntaxStateInfo();
        }
    }

    static void prepareSyntax(BaseDocument baseDocument, Segment segment, Syntax syntax, int n, int n2, boolean bl, boolean bl2) throws BadLocationException {
        int n3;
        if (n < 0 || n2 < 0 || n + n2 > baseDocument.getLength()) {
            throw new BadLocationException("reqPos=" + n + ", reqLen=" + n2 + ", doc.getLength()=" + baseDocument.getLength(), -1);
        }
        LineRootElement lineRootElement = FixLineSyntaxState.getLineRoot(baseDocument);
        int n4 = lineRootElement.getElementIndex(n);
        Element element = lineRootElement.getElement(n4);
        Syntax.StateInfo stateInfo = FixLineSyntaxState.getValidSyntaxStateInfo(baseDocument, n4);
        int n5 = element.getStartOffset();
        int n6 = n3 = stateInfo != null ? stateInfo.getPreScan() : 0;
        if (n3 > n5) {
            n3 = n5;
        }
        int n7 = n - n5;
        baseDocument.getText(n5 - n3, n3 + n7 + n2, segment);
        segment.offset += n3;
        segment.count -= n3;
        syntax.load(stateInfo, segment.array, segment.offset, n7, false, n);
        while (syntax.nextToken() != null) {
        }
        segment.offset += n7;
        segment.count -= n7;
        boolean bl3 = bl2 ? false : bl || n + n2 >= baseDocument.getLength();
        syntax.relocate(segment.array, segment.offset, segment.count, bl3, n + n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Syntax.StateInfo getValidSyntaxStateInfo(BaseDocument baseDocument, int n) throws BadLocationException {
        if (n == 0) {
            return null;
        }
        LineRootElement lineRootElement = FixLineSyntaxState.getLineRoot(baseDocument);
        LineElement lineElement = (LineElement)lineRootElement.getElement(n);
        Syntax.StateInfo stateInfo = lineElement.getSyntaxStateInfo();
        if (n > 0 && stateInfo == null) {
            int n2;
            LineElement lineElement2 = null;
            for (n2 = n - 1; n2 > 0 && (stateInfo = (lineElement2 = (LineElement)lineRootElement.getElement(n2)).getSyntaxStateInfo()) == null; --n2) {
            }
            Segment segment = DocumentUtilities.SEGMENT_CACHE.getSegment();
            try {
                Syntax syntax = baseDocument.getFreeSyntax();
                try {
                    int n3;
                    int n4 = lineElement.getStartOffset();
                    int n5 = 0;
                    if (n2 > 0) {
                        n3 = lineElement2.getStartOffset();
                        n5 = stateInfo.getPreScan();
                    } else {
                        n3 = 0;
                        stateInfo = null;
                    }
                    baseDocument.getText(n3 - n5, n4 - n3 + n5, segment);
                    segment.offset += n5;
                    segment.count -= n5;
                    syntax.load(stateInfo, segment.array, segment.offset, segment.count, false, n4);
                    int n6 = segment.offset + segment.count;
                    do {
                        lineElement2 = (LineElement)lineRootElement.getElement(++n2);
                        int n7 = n3;
                        n3 = lineElement2.getStartOffset();
                        n7 = n3 - n7;
                        syntax.relocate(segment.array, syntax.getOffset(), n7, false, n3);
                        while (syntax.nextToken() != null) {
                        }
                        lineElement2.updateSyntaxStateInfo(syntax);
                    } while (n2 != n);
                }
                finally {
                    baseDocument.releaseSyntax(syntax);
                }
            }
            finally {
                DocumentUtilities.SEGMENT_CACHE.releaseSegment(segment);
            }
        }
        return lineElement.getSyntaxStateInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void update(boolean bl) {
        SyntaxUpdateTokens syntaxUpdateTokens = (SyntaxUpdateTokens)this.evt.getDocument().getProperty(SyntaxUpdateTokens.class);
        if (syntaxUpdateTokens != null) {
            syntaxUpdateTokens.syntaxUpdateStart();
        }
        try {
            this.syntaxUpdateOffset = this.fixSyntaxStateInfos(bl);
            Object var4_3 = null;
            if (syntaxUpdateTokens == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (syntaxUpdateTokens == null) throw throwable;
            this.syntaxUpdateTokenList = Collections.unmodifiableList(new ArrayList(syntaxUpdateTokens.syntaxUpdateEnd()));
            throw throwable;
        }
        this.syntaxUpdateTokenList = Collections.unmodifiableList(new ArrayList(syntaxUpdateTokens.syntaxUpdateEnd()));
    }

    /*
     * Exception decompiling
     */
    private int fixSyntaxStateInfos(boolean var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[UNCONDITIONALDOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static int getTokenSafeOffset(BaseDocument baseDocument, int n) {
        if (n == 0) {
            return n;
        }
        try {
            LineRootElement lineRootElement = FixLineSyntaxState.getLineRoot(baseDocument);
            int n2 = lineRootElement.getElementIndex(n);
            Element element = lineRootElement.getElement(n2);
            int n3 = element.getStartOffset();
            Syntax.StateInfo stateInfo = FixLineSyntaxState.getValidSyntaxStateInfo(baseDocument, n2);
            if (n == n3 && stateInfo.getPreScan() == 0) {
                return n;
            }
            int n4 = lineRootElement.getElementCount();
            while (++n2 < n4) {
                element = lineRootElement.getElement(n2);
                stateInfo = FixLineSyntaxState.getValidSyntaxStateInfo(baseDocument, n2);
                n3 = element.getStartOffset();
                if (n3 - stateInfo.getPreScan() < n) continue;
                return n3;
            }
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalStateException(badLocationException.toString());
        }
        return baseDocument.getLength();
    }

    private static LineRootElement getLineRoot(Document document) {
        return (LineRootElement)((Object)document.getDefaultRootElement());
    }

    private static void checkConsistency(Document document) {
        LineRootElement lineRootElement = FixLineSyntaxState.getLineRoot(document);
        int n = lineRootElement.getElementCount();
        for (int i = 1; i < n; ++i) {
            LineElement lineElement = (LineElement)lineRootElement.getElement(i);
            if (!$assertionsDisabled && lineElement.getSyntaxStateInfo() == null) {
                throw new AssertionError((Object)("Syntax state null at line " + i + " of " + n));
            }
        }
    }

    public static String lineInfosToString(Document document) {
        StringBuffer stringBuffer = new StringBuffer();
        LineRootElement lineRootElement = FixLineSyntaxState.getLineRoot(document);
        int n = lineRootElement.getElementCount();
        for (int i = 0; i < n; ++i) {
            LineElement lineElement = (LineElement)lineRootElement.getElement(i);
            stringBuffer.append("[" + i + "]: lineStartOffset=" + lineElement.getStartOffset() + ", info: " + lineElement.getSyntaxStateInfo() + "\n");
        }
        return stringBuffer.toString();
    }

    UndoableEdit createBeforeLineUndo() {
        return new BeforeLineUndo();
    }

    UndoableEdit createAfterLineUndo() {
        return new AfterLineUndo();
    }

    static {
        $assertionsDisabled = !FixLineSyntaxState.class.desiredAssertionStatus();
    }

    final class AfterLineUndo
    extends AbstractUndoableEdit {
        AfterLineUndo() {
        }

        public void redo() throws CannotRedoException {
            FixLineSyntaxState.this.update(false);
            super.redo();
        }
    }

    final class BeforeLineUndo
    extends AbstractUndoableEdit {
        BeforeLineUndo() {
        }

        FixLineSyntaxState getMaster() {
            return FixLineSyntaxState.this;
        }

        public void undo() throws CannotUndoException {
            FixLineSyntaxState.this.update(true);
            super.undo();
        }
    }
}

