/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleContext;
import javax.swing.undo.UndoableEdit;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.CharSeq;
import org.netbeans.editor.LineElement;
import org.netbeans.lib.editor.util.swing.GapBranchElement;
import org.openide.ErrorManager;

final class LineRootElement
extends GapBranchElement {
    private static final LineElement[] EMPTY_LINE_ELEMENT_ARRAY;
    private static final String NAME = "section";
    private BaseDocument doc;
    private LineElement[] addedLines = EMPTY_LINE_ELEMENT_ARRAY;
    static final /* synthetic */ boolean $assertionsDisabled;

    LineRootElement(BaseDocument baseDocument) {
        this.doc = baseDocument;
        if (!$assertionsDisabled && baseDocument.getLength() != 0) {
            throw new AssertionError((Object)"Cannot start with non-empty document");
        }
        Position position = baseDocument.getStartPosition();
        if (!$assertionsDisabled && position.getOffset() != 0) {
            throw new AssertionError((Object)"Document.getStartPosition() != 0");
        }
        Position position2 = baseDocument.getEndPosition();
        if (!$assertionsDisabled && position2.getOffset() != 1) {
            throw new AssertionError((Object)"Document.getEndPosition() != 1");
        }
        LineElement lineElement = new LineElement(this, position, position2);
        this.replace(0, 0, new Element[]{lineElement});
        if (!$assertionsDisabled && this.getElement(0) == null) {
            throw new AssertionError();
        }
    }

    private int doubleAddedLinesCapacity() {
        int n = this.addedLines.length;
        int n2 = Math.max(4, n * 2);
        LineElement[] lineElementArray = new LineElement[n2];
        System.arraycopy(this.addedLines, 0, lineElementArray, n2 - n, n);
        this.addedLines = lineElementArray;
        return n2 - n;
    }

    public Element getElement(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Invalid line index=" + n + " < 0");
        }
        int n2 = this.getElementCount();
        if (n >= n2) {
            throw new IndexOutOfBoundsException("Invalid line index=" + n + " >= lineCount=" + n2);
        }
        LineElement lineElement = (LineElement)super.getElement(n);
        if (!$assertionsDisabled && lineElement == null) {
            throw new AssertionError();
        }
        return lineElement;
    }

    UndoableEdit insertUpdate(int n, int n2) {
        boolean bl;
        int n3;
        int n4 = n + n2 - 1;
        CharSeq charSeq = this.doc.getText();
        GapBranchElement.Edit edit = null;
        int n5 = -1;
        Element[] elementArray = null;
        int n6 = this.addedLines.length;
        int n7 = n4;
        if (n == 0) {
            n3 = 0;
            bl = false;
        } else {
            n3 = n - 1;
            bl = charSeq.charAt(n3) == '\n';
        }
        try {
            Object object;
            int n8;
            Object object2 = null;
            while (n7 >= n3) {
                if (charSeq.charAt(n7) == '\n') {
                    n8 = 1;
                    if (object2 == null) {
                        n5 = this.getElementIndex(n);
                        object = (LineElement)this.getElement(n5);
                        if (bl) {
                            if (n7 == n4) {
                                elementArray = new Element[]{object};
                                object2 = ((LineElement)object).getEndPosition();
                                n8 = 0;
                            } else {
                                LineElement lineElement = (LineElement)this.getElement(n5 + 1);
                                elementArray = new Element[]{object, lineElement};
                                object2 = lineElement.getEndPosition();
                            }
                        } else {
                            elementArray = new Element[]{object};
                            object2 = ((LineElement)object).getEndPosition();
                        }
                    }
                    if (n8 != 0) {
                        if (n6 == 0) {
                            n6 = this.doubleAddedLinesCapacity();
                        }
                        object = this.doc.createPosition(n7 + 1);
                        this.addedLines[--n6] = new LineElement(this, (Position)object, (Position)object2);
                        object2 = object;
                    }
                }
                --n7;
            }
            if (object2 != null) {
                n8 = this.addedLines.length - n6;
                object = new Element[n8 + 1];
                System.arraycopy(this.addedLines, n6, object, 1, n8);
                object[0] = new LineElement(this, ((LineElement)elementArray[0]).getStartPosition(), (Position)object2);
                this.replace(n5, elementArray.length, (Element[])object);
                edit = new GapBranchElement.Edit((GapBranchElement)this, n5, elementArray, (Element[])object);
            }
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(65536, (Throwable)badLocationException);
        }
        return edit;
    }

    UndoableEdit removeUpdate(int n, int n2) {
        int n3;
        GapBranchElement.Edit edit = null;
        int n4 = n + n2;
        int n5 = this.getElementIndex(n);
        if (n5 != (n3 = this.getElementIndex(n4))) {
            Element[] elementArray = new Element[++n3 - n5];
            this.copyElements(n5, n3, elementArray, 0);
            Element[] elementArray2 = new Element[]{new LineElement(this, ((LineElement)elementArray[0]).getStartPosition(), ((LineElement)elementArray[elementArray.length - 1]).getEndPosition())};
            this.replace(n5, elementArray.length, elementArray2);
            edit = new GapBranchElement.Edit((GapBranchElement)this, n5, elementArray, elementArray2);
        }
        return edit;
    }

    public Document getDocument() {
        return this.doc;
    }

    public Element getParentElement() {
        return null;
    }

    public String getName() {
        return NAME;
    }

    public AttributeSet getAttributes() {
        return StyleContext.getDefaultStyleContext().getEmptySet();
    }

    public int getStartOffset() {
        return 0;
    }

    public int getEndOffset() {
        return this.doc.getLength() + 1;
    }

    public int getElementIndex(int n) {
        if (n == 0) {
            return 0;
        }
        return super.getElementIndex(n);
    }

    private void checkConsistency() {
        int n = this.getElementCount();
        if (!$assertionsDisabled && n <= 0) {
            throw new AssertionError();
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            LineElement lineElement = (LineElement)this.getElement(i);
            if (!$assertionsDisabled && n2 != lineElement.getStartOffset()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && n2 >= lineElement.getEndOffset()) {
                throw new AssertionError((Object)("Line " + i + " of " + n + ": " + this.lineToString(lineElement)));
            }
            n2 = lineElement.getEndOffset();
        }
        if (!$assertionsDisabled && n2 != this.doc.getLength() + 1) {
            throw new AssertionError();
        }
    }

    private String lineToString(Element element) {
        return "<" + element.getStartOffset() + ", " + element.getEndOffset() + ">";
    }

    static {
        $assertionsDisabled = !LineRootElement.class.desiredAssertionStatus();
        EMPTY_LINE_ELEMENT_ARRAY = new LineElement[0];
    }
}

