/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.io.IOException;
import java.io.Reader;
import javax.swing.text.Segment;

public class LineSeparatorConversion {
    private static final int DEFAULT_CONVERSION_BUFFER_SIZE = 16384;

    private LineSeparatorConversion() {
    }

    public static String convertToLineFeed(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        LineSeparatorConversion.convertToLineFeed(string, 0, string.length(), stringBuffer);
        return stringBuffer.toString();
    }

    public static void convertToLineFeed(String string, int n, int n2, StringBuffer stringBuffer) {
        int n3 = n + n2;
        boolean bl = false;
        while (n < n3) {
            char c = string.charAt(n++);
            if (bl && c == '\n') {
                bl = false;
                continue;
            }
            if (c == '\r') {
                stringBuffer.append('\n');
                bl = true;
                continue;
            }
            bl = false;
            stringBuffer.append(c);
        }
    }

    public static String convertFromLineFeed(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        LineSeparatorConversion.convertFromLineFeed(string, 0, string.length(), string2, stringBuffer);
        return stringBuffer.toString();
    }

    public static void convertFromLineFeed(String string, int n, int n2, String string2, StringBuffer stringBuffer) {
        int n3 = string2.length();
        int n4 = n + n2;
        while (n < n4) {
            char c;
            if ((c = string.charAt(n++)) == '\n') {
                for (int i = 0; i < n3; ++i) {
                    stringBuffer.append(string2.charAt(i));
                }
                continue;
            }
            stringBuffer.append(c);
        }
    }

    public static class InitialSeparatorReader
    extends Reader {
        private static final int AFTER_CR_STATUS = -1;
        private static final int INITIAL_STATUS = 0;
        private static final int CR_SEPARATOR = 1;
        private static final int LF_SEPARATOR = 2;
        private static final int CRLF_SEPARATOR = 3;
        private Reader delegate;
        private int status = 0;

        public InitialSeparatorReader(Reader reader) {
            this.delegate = reader;
        }

        public String getInitialSeparator() {
            String string;
            switch (this.status) {
                case 1: {
                    string = "\r";
                    break;
                }
                case 2: {
                    string = "\n";
                    break;
                }
                case 3: {
                    string = "\r\n";
                    break;
                }
                case -1: {
                    string = "\r";
                    break;
                }
                default: {
                    string = "\n";
                }
            }
            return string;
        }

        private void resolveSeparator(char c) {
            block0 : switch (this.status) {
                case 0: {
                    switch (c) {
                        case '\r': {
                            this.status = -1;
                            break;
                        }
                        case '\n': {
                            this.status = 2;
                        }
                    }
                    break;
                }
                case -1: {
                    switch (c) {
                        case '\n': {
                            this.status = 3;
                            break block0;
                        }
                    }
                    this.status = 1;
                    break;
                }
                default: {
                    switch (c) {
                        case '\r': {
                            this.status = -1;
                            break block0;
                        }
                        case '\n': {
                            this.status = 2;
                        }
                    }
                }
            }
        }

        private boolean isSeparatorResolved() {
            return this.status > 0;
        }

        public void close() throws IOException {
            if (this.delegate == null) {
                return;
            }
            this.delegate.close();
            this.delegate = null;
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            if (this.delegate == null) {
                throw new IOException("Reader already closed.");
            }
            int n3 = this.delegate.read(cArray, n, n2);
            int n4 = n + n3;
            while (n < n4 && !this.isSeparatorResolved()) {
                this.resolveSeparator(cArray[n]);
                ++n;
            }
            return n3;
        }

        public int read() throws IOException {
            if (this.delegate == null) {
                throw new IOException("Reader already closed.");
            }
            int n = this.delegate.read();
            if (n != -1 && !this.isSeparatorResolved()) {
                this.resolveSeparator((char)n);
            }
            return n;
        }
    }

    public static class FromLineFeed {
        private Object charArrayOrSequence;
        private int offset;
        private int endOffset;
        private String lineFeedReplace;
        private Segment convertedText;

        public FromLineFeed(char[] cArray, int n, int n2, String string) {
            this(cArray, n, n2, string, 16384);
        }

        public FromLineFeed(char[] cArray, int n, int n2, String string, int n3) {
            this((Object)cArray, n, n2, string, n3);
        }

        public FromLineFeed(String string, int n, int n2, String string2) {
            this(string, n, n2, string2, 16384);
        }

        public FromLineFeed(String string, int n, int n2, String string2, int n3) {
            this((Object)string, n, n2, string2, n3);
        }

        private FromLineFeed(Object object, int n, int n2, String string, int n3) {
            if (n3 < string.length()) {
                throw new IllegalArgumentException("conversionSegmentSize=" + n3 + " < lineFeedReplace.length()=" + string.length());
            }
            this.charArrayOrSequence = object;
            this.offset = n;
            this.endOffset = n + n2;
            this.lineFeedReplace = string;
            this.convertedText = new Segment();
            this.convertedText.array = new char[n3];
        }

        public Segment nextConverted() {
            char[] cArray;
            String string;
            if (this.offset == this.endOffset) {
                return null;
            }
            char[] cArray2 = this.convertedText.array;
            int n = cArray2.length;
            int n2 = 0;
            if (this.charArrayOrSequence instanceof String) {
                string = (String)this.charArrayOrSequence;
                cArray = null;
            } else {
                cArray = (char[])this.charArrayOrSequence;
                string = null;
            }
            int n3 = this.lineFeedReplace.length();
            while (this.offset < this.endOffset && n - n2 >= n3) {
                char c;
                char c2 = c = string != null ? string.charAt(this.offset++) : cArray[this.offset++];
                if (c == '\n') {
                    for (int i = 0; i < n3; ++i) {
                        cArray2[n2++] = this.lineFeedReplace.charAt(i);
                    }
                    continue;
                }
                cArray2[n2++] = c;
            }
            this.convertedText.offset = 0;
            this.convertedText.count = n2;
            return this.convertedText;
        }
    }

    public static class ToLineFeed {
        private Reader reader;
        private Segment convertedText;
        private boolean lastCharCR;

        public ToLineFeed(Reader reader) {
            this(reader, 16384);
        }

        public ToLineFeed(Reader reader, int n) {
            this.reader = reader;
            this.convertedText = new Segment();
            this.convertedText.array = new char[n];
        }

        public Segment nextConverted() throws IOException {
            if (this.reader == null) {
                return null;
            }
            int n = 0;
            int n2 = ToLineFeed.readBuffer(this.reader, this.convertedText.array, n, true);
            if (n2 == 0) {
                this.reader.close();
                this.reader = null;
                return null;
            }
            if (this.lastCharCR && n2 > 0 && this.convertedText.array[n] == '\n') {
                ++n;
                --n2;
            }
            this.convertedText.offset = n;
            this.convertedText.count = n2;
            this.lastCharCR = ToLineFeed.convertSegmentToLineFeed(this.convertedText);
            return this.convertedText;
        }

        private static boolean convertSegmentToLineFeed(Segment segment) {
            char[] cArray = segment.array;
            int n = segment.offset;
            int n2 = n + segment.count;
            boolean bl = false;
            boolean bl2 = false;
            for (int i = n; i < n2; ++i) {
                char c = cArray[i];
                if (bl2 && c == '\n') {
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (c == '\r') {
                    bl2 = true;
                    cArray[n++] = 10;
                    continue;
                }
                bl2 = false;
                if (bl) {
                    cArray[n] = c;
                }
                ++n;
            }
            segment.count = n - segment.offset;
            return bl2;
        }

        private static int readBuffer(Reader reader, char[] cArray, int n, boolean bl) throws IOException {
            int n2;
            int n3 = cArray.length - n;
            int n4 = 0;
            do {
                n2 = 0;
                while (n2 == 0) {
                    n2 = reader.read(cArray, n, n3);
                }
                if (n2 == -1) break;
                n4 += n2;
                n += n2;
            } while (bl && (n3 -= n2) > 0);
            return n4;
        }
    }
}

