/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.MacroSavePanel;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.Settings;
import org.openide.util.NbBundle;

public class MacroDialogSupport
implements ActionListener {
    JButton okButton;
    JButton cancelButton;
    MacroSavePanel panel;
    Dialog macroDialog;
    Class kitClass;

    public MacroDialogSupport(Class clazz) {
        this.kitClass = clazz;
        this.panel = new MacroSavePanel(clazz);
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)BaseKit.class);
        this.okButton = new JButton(resourceBundle.getString("MDS_ok"));
        this.cancelButton = new JButton(resourceBundle.getString("MDS_cancel"));
        this.okButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_MDS_ok"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_MDS_cancel"));
    }

    public void setBody(String string) {
        this.panel.setBody(string);
    }

    public void showMacroDialog() {
        this.macroDialog = DialogSupport.createDialog(NbBundle.getBundle((Class)BaseKit.class).getString("MDS_title"), this.panel, true, new JButton[]{this.okButton, this.cancelButton}, false, 0, 1, this);
        this.macroDialog.pack();
        this.panel.popupNotify();
        this.macroDialog.requestFocus();
        this.macroDialog.show();
    }

    private List getKBList() {
        int n;
        Settings.KitAndValue[] kitAndValueArray = Settings.getValueHierarchy(this.kitClass, "key-bindings");
        List<MultiKeyBinding> list = null;
        for (n = 0; n < kitAndValueArray.length; ++n) {
            if (kitAndValueArray[n].kitClass != this.kitClass) continue;
            list = (List)kitAndValueArray[n].value;
        }
        if (list == null) {
            list = new ArrayList();
        }
        n = list.size();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (e instanceof MultiKeyBinding || e == null) continue;
            JTextComponent.KeyBinding keyBinding = (JTextComponent.KeyBinding)e;
            list.set(i, new MultiKeyBinding(keyBinding.key, keyBinding.actionName));
        }
        return new ArrayList(list);
    }

    private void saveMacro(boolean bl) {
        MultiKeyBinding multiKeyBinding;
        Object object;
        Map map = (Map)Settings.getValue(this.kitClass, "macro-map");
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        hashMap.put(this.panel.getName(), this.panel.getBody());
        Settings.setValue(this.kitClass, "macro-map", hashMap);
        List list = this.panel.getKeySequences();
        List list2 = this.getKBList();
        if (bl) {
            int n;
            object = new ArrayList();
            String string = "macro-" + this.panel.getName();
            for (n = 0; n < list2.size(); ++n) {
                multiKeyBinding = (MultiKeyBinding)list2.get(n);
                if (multiKeyBinding.actionName == null || !multiKeyBinding.actionName.equals(string)) continue;
                object.add(multiKeyBinding);
            }
            for (n = 0; n < object.size(); ++n) {
                list2.remove(object.get(n));
            }
        }
        if (list.size() > 0) {
            object = new String("macro-" + this.panel.getName());
            for (int i = 0; i < list.size(); ++i) {
                KeyStroke[] keyStrokeArray = (KeyStroke[])list.get(i);
                multiKeyBinding = new MultiKeyBinding(keyStrokeArray, (String)object);
                list2.add(multiKeyBinding);
            }
        }
        Settings.setValue(this.kitClass, "key-bindings", list2);
    }

    protected int showConfirmDialog(String string) {
        return JOptionPane.showConfirmDialog(this.panel, MessageFormat.format(NbBundle.getBundle((Class)BaseKit.class).getString("MDS_Overwrite"), this.panel.getName()), NbBundle.getBundle((Class)BaseKit.class).getString("MDS_Warning"), 1, 2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            Map map = (Map)Settings.getValue(this.kitClass, "macro-map");
            if (!map.containsKey(this.panel.getName())) {
                this.saveMacro(false);
            } else {
                int n = this.showConfirmDialog(this.panel.getName());
                if (n == 2 || n == -1) {
                    return;
                }
                if (n == 0) {
                    this.saveMacro(true);
                }
            }
        }
        this.macroDialog.setVisible(false);
        this.macroDialog.dispose();
    }
}

