/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.Mark;
import org.netbeans.editor.MarkBlock;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.Utilities;

public class MarkBlockChain {
    protected MarkBlock chain;
    protected MarkBlock currentBlock;
    protected BaseDocument doc;

    public MarkBlockChain(BaseDocument baseDocument) {
        this.doc = baseDocument;
    }

    public final MarkBlock getChain() {
        return this.chain;
    }

    public int compareBlock(int n, int n2) {
        int n3;
        if (this.currentBlock == null) {
            this.currentBlock = this.chain;
            if (this.currentBlock == null) {
                return 0;
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        MarkBlock markBlock = null;
        int n4 = 0;
        while (true) {
            if (((n3 = this.currentBlock.compare(n, n2)) & 1) != 0) {
                return n3;
            }
            if ((n3 & 0x80) != 0) {
                if (bl2) {
                    if (!bl3 || (n3 & 2) != 0) {
                        return n3;
                    }
                    this.currentBlock = markBlock;
                    return n4;
                }
                if (this.currentBlock.next != null) {
                    bl = true;
                    boolean bl4 = bl3 = (n3 & 2) != 0;
                    if (bl3) {
                        n4 = n3;
                        markBlock = this.currentBlock;
                    }
                    this.currentBlock = this.currentBlock.next;
                    continue;
                }
                return n3;
            }
            if (bl) {
                if (!bl3 || (n3 & 0x11) != 0) {
                    return n3;
                }
                this.currentBlock = markBlock;
                return n4;
            }
            if (this.currentBlock.prev == null) break;
            bl2 = true;
            boolean bl5 = bl3 = (n3 & 2) != 0;
            if (bl3) {
                n4 = n3;
                markBlock = this.currentBlock;
            }
            this.currentBlock = this.currentBlock.prev;
        }
        return n3;
    }

    public void removeEmptyBlocks() {
        try {
            MarkBlock markBlock = this.chain;
            while (markBlock != null) {
                if (markBlock.startMark.getOffset() == markBlock.endMark.getOffset()) {
                    markBlock = this.checkedRemove(markBlock);
                    continue;
                }
                markBlock = markBlock.next;
            }
        }
        catch (InvalidMarkException invalidMarkException) {
            Utilities.annotateLoggable(invalidMarkException);
        }
    }

    protected MarkBlock createBlock(int n, int n2) throws BadLocationException {
        return new MarkBlock(this.doc, this.createBlockStartMark(), this.createBlockEndMark(), n, n2);
    }

    protected Mark createBlockStartMark() {
        return new Mark();
    }

    protected Mark createBlockEndMark() {
        return new Mark();
    }

    private void removeCurrentIfEmpty() {
        try {
            while (this.currentBlock != null && this.currentBlock.startMark.getOffset() >= this.currentBlock.endMark.getOffset()) {
                this.checkedRemove(this.currentBlock);
                this.currentBlock = this.chain;
            }
        }
        catch (InvalidMarkException invalidMarkException) {
            Utilities.annotateLoggable(invalidMarkException);
        }
    }

    public void addBlock(int n, int n2, boolean bl) {
        if (n == n2) {
            return;
        }
        this.removeCurrentIfEmpty();
        try {
            int n3 = this.compareBlock(n, n2) & 0xFFFFFFF3;
            if ((n3 & 0x40) != 0) {
                if (bl && n3 == 66) {
                    this.currentBlock.startMark.move(this.doc, n);
                } else {
                    boolean bl2 = this.currentBlock == this.chain;
                    MarkBlock markBlock = this.currentBlock.insertChain(this.createBlock(n, n2));
                    if (bl2) {
                        this.chain = markBlock;
                    }
                }
            } else if ((n3 & 0x80) != 0) {
                if (bl && n3 == 130) {
                    this.currentBlock.endMark.move(this.doc, n2);
                } else {
                    this.currentBlock.addChain(this.createBlock(n, n2));
                }
            } else if (this.currentBlock == null) {
                this.chain = this.createBlock(n, n2);
            } else {
                this.currentBlock.extendStart(n);
                this.currentBlock.extendEnd(n2);
                MarkBlock markBlock = this.chain;
                while (markBlock != null) {
                    if (markBlock != this.currentBlock) {
                        if (this.currentBlock.extend(markBlock, bl)) {
                            MarkBlock markBlock2 = this.currentBlock;
                            markBlock = this.checkedRemove(markBlock);
                            this.currentBlock = markBlock2;
                            continue;
                        }
                        markBlock = markBlock.next;
                        continue;
                    }
                    markBlock = markBlock.next;
                }
            }
        }
        catch (InvalidMarkException invalidMarkException) {
            Utilities.annotateLoggable(invalidMarkException);
        }
        catch (BadLocationException badLocationException) {
            Utilities.annotateLoggable(badLocationException);
        }
    }

    public void removeBlock(int n, int n2) {
        if (n == n2) {
            return;
        }
        try {
            int n3;
            while (((n3 = this.compareBlock(n, n2)) & 1) != 0) {
                if ((n3 & 8) != 0) {
                    this.checkedRemove(this.currentBlock);
                    continue;
                }
                switch (this.currentBlock.shrink(n, n2)) {
                    case 4129: {
                        int n4 = this.currentBlock.endMark.getOffset();
                        this.currentBlock.endMark.move(this.doc, n);
                        this.currentBlock.addChain(this.createBlock(n2, n4));
                        return;
                    }
                    case 257: 
                    case 1057: {
                        this.currentBlock.startMark.move(this.doc, n2);
                        return;
                    }
                    case 513: 
                    case 2081: {
                        this.currentBlock.endMark.move(this.doc, n);
                        return;
                    }
                }
                this.checkedRemove(this.currentBlock);
            }
        }
        catch (BadLocationException badLocationException) {
            Utilities.annotateLoggable(badLocationException);
        }
        catch (InvalidMarkException invalidMarkException) {
            Utilities.annotateLoggable(invalidMarkException);
        }
    }

    protected MarkBlock checkedRemove(MarkBlock markBlock) {
        boolean bl = markBlock == this.chain;
        markBlock = markBlock.removeChain();
        if (bl) {
            this.chain = markBlock;
        }
        this.currentBlock = null;
        return markBlock;
    }

    public int adjustToBlockEnd(int n) {
        int n2 = this.compareBlock(n, n) & 0xFFFFFFF3;
        if (n2 == 1057 || n2 == 4129) {
            n = this.currentBlock.getEndOffset();
        }
        return n;
    }

    public int adjustToNextBlockStart(int n) {
        MarkBlock markBlock;
        int n2 = this.compareBlock(n, n) & 0xFFFFFFF3;
        n = (n2 & 0x40) != 0 ? this.currentBlock.getStartOffset() : (this.currentBlock != null ? ((markBlock = this.currentBlock.getNext()) != null ? markBlock.getStartOffset() : -1) : -1);
        return n;
    }

    public String toString() {
        return "MarkBlockChain: currentBlock=" + this.currentBlock + "\nblock chain: " + (this.chain != null ? "\n" + this.chain.toStringChain() : " Empty");
    }

    public static class LayerChain
    extends MarkBlockChain {
        private String layerName;

        public LayerChain(BaseDocument baseDocument, String string) {
            super(baseDocument);
            this.layerName = string;
        }

        public final String getLayerName() {
            return this.layerName;
        }

        protected Mark createBlockStartMark() {
            MarkFactory.DrawMark drawMark = new MarkFactory.DrawMark(this.layerName, null);
            drawMark.activateLayer = true;
            return drawMark;
        }

        protected Mark createBlockEndMark() {
            MarkFactory.DrawMark drawMark = new MarkFactory.DrawMark(this.layerName, null, Position.Bias.Backward);
            return drawMark;
        }
    }
}

