/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.HashMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.Segment;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.DocumentUtilities;
import org.netbeans.editor.Finder;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSeg;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.TokenProcessor;

public class SyntaxSupport {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final int MATCH_ARRAY_CACHE_SIZE = 3;
    private HashMap supMap;
    private BaseDocument doc;
    protected boolean tokenNumericIDsValid;
    private int[] tokenBlocks = EMPTY_INT_ARRAY;
    private TokenID[][] lastTokenIDArrays = new TokenID[3][];
    private boolean[][] lastMatchArrays = new boolean[3][];

    public SyntaxSupport(BaseDocument baseDocument) {
        this.doc = baseDocument;
    }

    public final BaseDocument getDocument() {
        return this.doc;
    }

    public synchronized SyntaxSupport get(Class clazz) {
        SyntaxSupport syntaxSupport;
        if (this.supMap == null) {
            this.supMap = new HashMap(11);
        }
        if ((syntaxSupport = (SyntaxSupport)this.supMap.get(clazz)) == null) {
            syntaxSupport = this.createSyntaxSupport(clazz);
            this.supMap.put(clazz, syntaxSupport);
        }
        return syntaxSupport;
    }

    protected SyntaxSupport createSyntaxSupport(Class clazz) {
        if (clazz.isInstance(this)) {
            return this;
        }
        return null;
    }

    private boolean[] getMatchArray(TokenID[] tokenIDArray) {
        int n;
        boolean[] blArray = null;
        for (n = 0; n < 3; ++n) {
            if (tokenIDArray != this.lastTokenIDArrays[n]) continue;
            blArray = this.lastMatchArrays[n];
            break;
        }
        if (blArray == null) {
            int n2;
            int n3 = -1;
            if (tokenIDArray != null) {
                for (n2 = 0; n2 < tokenIDArray.length; ++n2) {
                    if (tokenIDArray[n2].getNumericID() <= n3) continue;
                    n3 = tokenIDArray[n2].getNumericID();
                }
            }
            blArray = new boolean[n3 + 1];
            for (n2 = 0; n2 < tokenIDArray.length; ++n2) {
                blArray[tokenIDArray[n2].getNumericID()] = true;
            }
        }
        if (n > 0) {
            n = Math.min(n, 2);
            System.arraycopy(this.lastTokenIDArrays, 0, this.lastTokenIDArrays, 1, n);
            System.arraycopy(this.lastMatchArrays, 0, this.lastMatchArrays, 1, n);
            this.lastTokenIDArrays[0] = tokenIDArray;
            this.lastMatchArrays[0] = blArray;
        }
        return blArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getTokenBlocks(int n, int n2, TokenID[] tokenIDArray) throws BadLocationException {
        this.doc.readLock();
        try {
            SyntaxSupport syntaxSupport = this;
            synchronized (syntaxSupport) {
                boolean[] blArray = this.tokenNumericIDsValid ? this.getMatchArray(tokenIDArray) : null;
                int n3 = 0;
                if (n > n2) {
                    int n4 = n;
                    n = n2;
                    n2 = n4;
                }
                SyntaxSeg.Slot slot = SyntaxSeg.getFreeSlot();
                Syntax syntax = this.doc.getFreeSyntax();
                try {
                    this.doc.prepareSyntax(slot, syntax, n, n2 - n, true, false);
                    int n5 = syntax.getPreScan();
                    int n6 = n - n5;
                    int n7 = -1;
                    boolean bl = true;
                    while (bl) {
                        boolean bl2;
                        TokenID tokenID = syntax.nextToken();
                        if (tokenID == null) {
                            bl = false;
                            continue;
                        }
                        boolean bl3 = bl2 = tokenID != null && n6 + syntax.getTokenLength() > n;
                        if (bl2) {
                            int n8;
                            if (blArray != null) {
                                n8 = tokenID.getNumericID();
                                bl2 = n8 < blArray.length && blArray[n8];
                            } else {
                                bl2 = false;
                                for (n8 = 0; n8 < tokenIDArray.length; ++n8) {
                                    if (tokenID != tokenIDArray[n8]) continue;
                                    bl2 = true;
                                    break;
                                }
                            }
                        }
                        if (bl2) {
                            if (n7 < 0) {
                                n7 = Math.max(n6, n);
                            }
                        } else if (n7 >= 0) {
                            this.tokenBlocks = this.addTokenBlock(this.tokenBlocks, n3, n7, n6);
                            n3 += 2;
                            n7 = -1;
                        }
                        n6 += syntax.getTokenLength();
                    }
                    if (n7 >= 0) {
                        this.tokenBlocks = this.addTokenBlock(this.tokenBlocks, n3, n7, n2);
                        n3 += 2;
                    }
                }
                finally {
                    this.doc.releaseSyntax(syntax);
                    SyntaxSeg.releaseSlot(slot);
                }
                int[] nArray = new int[n3];
                System.arraycopy(this.tokenBlocks, 0, nArray, 0, n3);
                int[] nArray2 = nArray;
                return nArray2;
            }
        }
        finally {
            this.doc.readUnlock();
        }
    }

    private int[] addTokenBlock(int[] nArray, int n, int n2, int n3) {
        if (nArray.length < n + 2) {
            int[] nArray2 = new int[Math.max(2, nArray.length * 2)];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        nArray[n++] = n2;
        nArray[n] = n3;
        return nArray;
    }

    public int findInsideBlocks(Finder finder, int n, int n2, int[] nArray) throws BadLocationException {
        boolean bl;
        boolean bl2 = bl = n <= n2;
        if (bl) {
            for (int i = 0; i < nArray.length; i += 2) {
                int n3 = this.doc.find(finder, nArray[i], nArray[i + 1]);
                if (n3 < 0) continue;
                return n3;
            }
        } else {
            for (int i = nArray.length - 2; i >= 0; i -= 2) {
                int n4 = this.doc.find(finder, nArray[i + 1], nArray[i]);
                if (n4 < 0) continue;
                return n4;
            }
        }
        return -1;
    }

    public int findOutsideBlocks(Finder finder, int n, int n2, int[] nArray) throws BadLocationException {
        boolean bl;
        boolean bl2 = bl = n <= n2;
        if (bl) {
            int n3 = this.doc.find(finder, n, nArray.length > 0 ? nArray[0] : n2);
            if (n3 >= 0) {
                return n3;
            }
            for (int i = 2; i <= nArray.length; i += 2) {
                n3 = this.doc.find(finder, nArray[i - 1], i >= nArray.length ? n2 : nArray[i]);
                if (n3 < 0) continue;
                return n3;
            }
        } else {
            int n4 = this.doc.find(finder, n, nArray.length > 0 ? nArray[nArray.length - 1] : n2);
            if (n4 >= 0) {
                return n4;
            }
            for (int i = nArray.length - 2; i >= 0; i -= 2) {
                n4 = this.doc.find(finder, nArray[i], i == 0 ? n2 : nArray[i - 1]);
                if (n4 < 0) continue;
                return n4;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSyntax(Syntax syntax, int n, int n2, boolean bl, boolean bl2) throws BadLocationException {
        this.doc.readLock();
        try {
            Segment segment = DocumentUtilities.SEGMENT_CACHE.getSegment();
            try {
                int n3 = this.doc.getLength();
                this.doc.prepareSyntax(segment, syntax, n, 0, bl, bl2);
                int n4 = syntax.getPreScan();
                char[] cArray = this.doc.getChars(n - n4, n2 - n + n4);
                boolean bl3 = bl2 ? false : bl || n2 == n3;
                syntax.relocate(cArray, n4, n2 - n, bl3, n2);
            }
            finally {
                DocumentUtilities.SEGMENT_CACHE.releaseSegment(segment);
            }
        }
        finally {
            this.doc.readUnlock();
        }
    }

    public boolean isIdentifier(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (this.doc.isIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tokenizeText(TokenProcessor tokenProcessor, int n, int n2, boolean bl) throws BadLocationException {
        Syntax syntax = null;
        this.doc.readLock();
        try {
            Segment segment = DocumentUtilities.SEGMENT_CACHE.getSegment();
            try {
                syntax = this.doc.getFreeSyntax();
                int n3 = this.doc.getLength();
                this.doc.prepareSyntax(segment, syntax, n, n2 - n, bl, false);
                int n4 = syntax.getPreScan();
                tokenProcessor.nextBuffer(segment.array, syntax.getOffset(), n2 - n, n, n4, syntax.lastBuffer);
                int n5 = n - syntax.getOffset();
                boolean bl2 = true;
                while (bl2) {
                    int n6;
                    int n7;
                    TokenID tokenID = syntax.nextToken();
                    TokenContextPath tokenContextPath = syntax.getTokenContextPath();
                    if (tokenID == null) {
                        n7 = tokenProcessor.eot(syntax.tokenOffset);
                        if ((n7 = Math.min(n7, n3 - n2)) == 0) {
                            bl2 = false;
                            continue;
                        }
                        n4 = syntax.getPreScan();
                        this.doc.getText(n2 - n4, n4 + n7, segment);
                        n6 = bl || n2 + n7 >= n3 ? 1 : 0;
                        syntax.relocate(segment.array, segment.offset + n4, n7, n6 != 0, n2 + n7);
                        tokenProcessor.nextBuffer(segment.array, syntax.getOffset(), n7, n2, n4, n6 != 0);
                        n5 = n2 - syntax.getOffset();
                        n2 += n7;
                        continue;
                    }
                    n7 = syntax.getTokenLength();
                    n6 = syntax.getTokenOffset();
                    if (n5 + n6 + n7 <= n || tokenProcessor.token(tokenID, tokenContextPath, n6, n7)) continue;
                    bl2 = false;
                }
            }
            finally {
                DocumentUtilities.SEGMENT_CACHE.releaseSegment(segment);
            }
            Object var17_16 = null;
            if (syntax != null) {
                this.doc.releaseSyntax(syntax);
            }
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            if (syntax != null) {
                this.doc.releaseSyntax(syntax);
            }
            this.doc.readUnlock();
            throw throwable;
        }
        this.doc.readUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tokenizeText(TokenProcessor tokenProcessor, String string) {
        Syntax syntax = null;
        try {
            syntax = this.doc.getFreeSyntax();
            char[] cArray = string.toCharArray();
            syntax.load(null, cArray, 0, cArray.length, true, -1);
            boolean bl = true;
            while (bl) {
                TokenID tokenID = syntax.nextToken();
                TokenContextPath tokenContextPath = syntax.getTokenContextPath();
                if (tokenID == null) {
                    tokenProcessor.eot(syntax.tokenOffset);
                    bl = false;
                    continue;
                }
                if (tokenProcessor.token(tokenID, tokenContextPath, syntax.getTokenOffset(), syntax.getTokenLength())) continue;
                bl = false;
            }
            Object var9_8 = null;
            if (syntax != null) {
                this.doc.releaseSyntax(syntax);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (syntax != null) {
                this.doc.releaseSyntax(syntax);
            }
            throw throwable;
        }
    }

    public TokenItem getTokenChain(int n) throws BadLocationException {
        if (this.doc.getLength() <= n) {
            return null;
        }
        return null;
    }

    protected boolean isAbbrevDisabled(int n) {
        return false;
    }
}

