/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawEngineDocView;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Finder;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.ImplementationProvider;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.Mark;
import org.netbeans.editor.Registry;
import org.netbeans.editor.StatusBar;
import org.netbeans.editor.SyntaxSupport;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class Utilities {
    private static final String WRONG_POSITION_LOCALE = "wrong_position";
    public static final int CASE_UPPER = 0;
    public static final int CASE_LOWER = 1;
    public static final int CASE_SWITCH = 2;
    private static TextAction focusedComponentAction;
    private static final boolean isLoggable;

    private Utilities() {
    }

    public static int getRowStart(JTextComponent jTextComponent, int n) throws BadLocationException {
        Rectangle rectangle = jTextComponent.modelToView(n);
        if (rectangle == null) {
            return -1;
        }
        EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
        if (editorUI != null) {
            return jTextComponent.viewToModel(new Point(editorUI.textLeftMarginWidth, rectangle.y));
        }
        return -1;
    }

    public static int getRowStart(BaseDocument baseDocument, int n) throws BadLocationException {
        return Utilities.getRowStart(baseDocument, n, 0);
    }

    public static int getRowStart(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        Utilities.checkOffsetValid(baseDocument, n);
        if (n2 != 0) {
            Element element = baseDocument.getParagraphElement(0).getParentElement();
            int n3 = element.getElementIndex(n);
            if ((n3 += n2) < 0 || n3 >= element.getElementCount()) {
                return -1;
            }
            return element.getElement(n3).getStartOffset();
        }
        return baseDocument.getParagraphElement(n).getStartOffset();
    }

    public static int getRowFirstNonWhite(BaseDocument baseDocument, int n) throws BadLocationException {
        Utilities.checkOffsetValid(baseDocument, n);
        Element element = baseDocument.getParagraphElement(n);
        return Utilities.getFirstNonWhiteFwd(baseDocument, element.getStartOffset(), element.getEndOffset() - 1);
    }

    public static int getRowLastNonWhite(BaseDocument baseDocument, int n) throws BadLocationException {
        Utilities.checkOffsetValid(baseDocument, n);
        Element element = baseDocument.getParagraphElement(n);
        return Utilities.getFirstNonWhiteBwd(baseDocument, element.getEndOffset() - 1, element.getStartOffset());
    }

    public static int getRowIndent(BaseDocument baseDocument, int n) throws BadLocationException {
        if ((n = Utilities.getRowFirstNonWhite(baseDocument, n)) == -1) {
            return -1;
        }
        return baseDocument.getVisColFromPos(n);
    }

    public static int getRowIndent(BaseDocument baseDocument, int n, boolean bl) throws BadLocationException {
        int n2 = Utilities.getRowFirstNonWhite(baseDocument, n);
        if (n2 == -1) {
            n2 = Utilities.getFirstNonWhiteRow(baseDocument, n, bl);
            if (n2 == -1) {
                return -1;
            }
            if ((n2 = Utilities.getRowFirstNonWhite(baseDocument, n2)) == -1) {
                return -1;
            }
        }
        return baseDocument.getVisColFromPos(n2);
    }

    public static int getRowEnd(JTextComponent jTextComponent, int n) throws BadLocationException {
        Rectangle rectangle = jTextComponent.modelToView(n);
        if (rectangle == null) {
            return -1;
        }
        return jTextComponent.viewToModel(new Point(Integer.MAX_VALUE, rectangle.y));
    }

    public static int getRowEnd(BaseDocument baseDocument, int n) throws BadLocationException {
        Utilities.checkOffsetValid(baseDocument, n);
        return baseDocument.getParagraphElement(n).getEndOffset() - 1;
    }

    private static int findBestSpan(JTextComponent jTextComponent, int n, int n2, int n3) throws BadLocationException {
        if (n == n2) {
            return n2;
        }
        int n4 = n;
        int n5 = n2;
        while (n4 <= n5) {
            int n6;
            if (n5 - n4 < 3) {
                n6 = Integer.MAX_VALUE;
                int n7 = -1;
                for (int i = n4; i <= n5; ++i) {
                    Rectangle rectangle = jTextComponent.modelToView(i);
                    if (Math.abs(n3 - rectangle.x) >= n6) continue;
                    n6 = Math.abs(n3 - rectangle.x);
                    n7 = i;
                }
                return n7;
            }
            n6 = (n4 + n5) / 2;
            Rectangle rectangle = jTextComponent.modelToView(n6);
            if (rectangle.x > n3) {
                n5 = n6;
                continue;
            }
            if (rectangle.x < n3) {
                n4 = n6;
                continue;
            }
            return n6;
        }
        return n;
    }

    public static int getPositionAbove(JTextComponent jTextComponent, int n, int n2) throws BadLocationException {
        int n3;
        int n4;
        int n5 = Utilities.getRowStart(jTextComponent, n);
        int n6 = jTextComponent.getUI().getNextVisualPositionFrom(jTextComponent, n5, null, 7, null);
        if (n2 == 0x7FFFFFFE) {
            return n6;
        }
        EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
        if (editorUI == null) {
            return n;
        }
        Rectangle rectangle = jTextComponent.modelToView(n6);
        if (rectangle == null) {
            return n;
        }
        if (n2 == editorUI.textLeftMarginWidth) {
            return Utilities.getRowStart(jTextComponent, n6);
        }
        int n7 = jTextComponent.viewToModel(new Point(Math.max(editorUI.textLeftMarginWidth, n2 + 2 * rectangle.width), rectangle.y));
        Rectangle rectangle2 = jTextComponent.modelToView(n7);
        if (rectangle2 == null || rectangle2.x < n2) {
            n7 = n6;
        }
        if ((rectangle2 = jTextComponent.modelToView(n4 = jTextComponent.viewToModel(new Point(Math.max(editorUI.textLeftMarginWidth, n2 - 2 * rectangle.width), rectangle.y)))) == null && rectangle2.x > n2) {
            n4 = Utilities.getRowStart(jTextComponent, n7);
        }
        if ((n3 = Utilities.findBestSpan(jTextComponent, n4, n7, n2)) < jTextComponent.getDocument().getLength()) {
            int n8 = n3 + 1;
            int n9 = jTextComponent.getUI().getNextVisualPositionFrom(jTextComponent, n8, Position.Bias.Backward, 7, null);
            if (n9 < n3 && n9 >= 0) {
                return n9;
            }
        }
        return n3;
    }

    public static int getPositionBelow(JTextComponent jTextComponent, int n, int n2) throws BadLocationException {
        int n3;
        int n4;
        int n5 = Utilities.getRowEnd(jTextComponent, n) + 1;
        Rectangle rectangle = jTextComponent.modelToView(n5);
        if (rectangle == null) {
            return n;
        }
        EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
        if (editorUI != null && n2 == editorUI.textLeftMarginWidth) {
            return n5;
        }
        int n6 = jTextComponent.viewToModel(new Point(Math.min(Integer.MAX_VALUE, rectangle.x + n2 - 2 * rectangle.width), rectangle.y));
        Rectangle rectangle2 = jTextComponent.modelToView(n6);
        if (rectangle2 != null && rectangle2.x > n2) {
            n6 = n5;
        }
        if ((rectangle2 = jTextComponent.modelToView(n4 = jTextComponent.viewToModel(new Point(Math.min(Integer.MAX_VALUE, rectangle.x + n2 + 2 * rectangle.width), rectangle.y)))) != null && rectangle2.x < n2) {
            n4 = Utilities.getRowEnd(jTextComponent, n6);
        }
        if ((n3 = Utilities.findBestSpan(jTextComponent, n6, n4, n2)) > 0) {
            int n7 = n3 - 1;
            int n8 = jTextComponent.getUI().getNextVisualPositionFrom(jTextComponent, n7, Position.Bias.Forward, 3, null);
            if (n8 > n3 && n8 <= jTextComponent.getDocument().getLength()) {
                rectangle2 = jTextComponent.modelToView(n8);
                if (rectangle2 == null) {
                    return n8;
                }
                int n9 = rectangle2.x;
                int n10 = jTextComponent.getUI().getNextVisualPositionFrom(jTextComponent, n8, Position.Bias.Backward, 7, null);
                rectangle2 = jTextComponent.modelToView(n10);
                if (rectangle2 == null) {
                    return n8;
                }
                int n11 = rectangle2.x;
                if (Math.abs(n11 - n2) > Math.abs(n9 - n2)) {
                    return n8;
                }
                return n10;
            }
        }
        return n3;
    }

    public static int getWordStart(JTextComponent jTextComponent, int n) throws BadLocationException {
        return Utilities.getWordStart((BaseDocument)jTextComponent.getDocument(), n);
    }

    public static int getWordStart(BaseDocument baseDocument, int n) throws BadLocationException {
        return baseDocument.find(new FinderFactory.PreviousWordBwdFinder(baseDocument, false, true), n, 0);
    }

    public static int getWordEnd(JTextComponent jTextComponent, int n) throws BadLocationException {
        return Utilities.getWordEnd((BaseDocument)jTextComponent.getDocument(), n);
    }

    public static int getWordEnd(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = baseDocument.find(new FinderFactory.NextWordFwdFinder(baseDocument, false, true), n, -1);
        return n2 > 0 ? n2 : baseDocument.getLength();
    }

    public static int getNextWord(JTextComponent jTextComponent, int n) throws BadLocationException {
        int n2 = Utilities.getNextWord((BaseDocument)jTextComponent.getDocument(), n);
        int n3 = -1;
        if (n2 > 0) {
            n3 = jTextComponent.getUI().getNextVisualPositionFrom(jTextComponent, n2 - 1, null, 3, null);
        }
        return n3 == -1 ? n2 : n3;
    }

    public static int getNextWord(BaseDocument baseDocument, int n) throws BadLocationException {
        Finder finder = (Finder)baseDocument.getProperty("next-word-finder");
        n = baseDocument.find(finder, n, -1);
        if (n < 0) {
            n = baseDocument.getLength();
        }
        return n;
    }

    public static int getPreviousWord(JTextComponent jTextComponent, int n) throws BadLocationException {
        int n2 = Utilities.getPreviousWord((BaseDocument)jTextComponent.getDocument(), n);
        int n3 = jTextComponent.getUI().getNextVisualPositionFrom(jTextComponent, n2, null, 7, null);
        if (n3 == 0 && n2 == 0) {
            return 0;
        }
        return n3 + 1 == n2 ? n2 : n3 + 1;
    }

    public static int getPreviousWord(BaseDocument baseDocument, int n) throws BadLocationException {
        Finder finder = (Finder)baseDocument.getProperty("previous-word-finder");
        n = baseDocument.find(finder, n, 0);
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public static int getFirstWhiteFwd(BaseDocument baseDocument, int n) throws BadLocationException {
        return Utilities.getFirstWhiteFwd(baseDocument, n, -1);
    }

    public static int getFirstWhiteFwd(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        return baseDocument.find(new FinderFactory.WhiteFwdFinder(baseDocument), n, n2);
    }

    public static int getFirstNonWhiteFwd(BaseDocument baseDocument, int n) throws BadLocationException {
        return Utilities.getFirstNonWhiteFwd(baseDocument, n, -1);
    }

    public static int getFirstNonWhiteFwd(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        return baseDocument.find(new FinderFactory.NonWhiteFwdFinder(baseDocument), n, n2);
    }

    public static int getFirstWhiteBwd(BaseDocument baseDocument, int n) throws BadLocationException {
        return Utilities.getFirstWhiteBwd(baseDocument, n, 0);
    }

    public static int getFirstWhiteBwd(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        return baseDocument.find(new FinderFactory.WhiteBwdFinder(baseDocument), n, n2);
    }

    public static int getFirstNonWhiteBwd(BaseDocument baseDocument, int n) throws BadLocationException {
        return Utilities.getFirstNonWhiteBwd(baseDocument, n, 0);
    }

    public static int getFirstNonWhiteBwd(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        return baseDocument.find(new FinderFactory.NonWhiteBwdFinder(baseDocument), n, n2);
    }

    public static int getLineOffset(BaseDocument baseDocument, int n) throws BadLocationException {
        Utilities.checkOffsetValid(n, baseDocument.getLength() + 1);
        Element element = baseDocument.getParagraphElement(0).getParentElement();
        return element.getElementIndex(n);
    }

    public static int getRowStartFromLineOffset(BaseDocument baseDocument, int n) {
        Element element = baseDocument.getParagraphElement(0).getParentElement();
        if (n < 0 || n >= element.getElementCount()) {
            return -1;
        }
        return element.getElement(n).getStartOffset();
    }

    public static int getVisualColumn(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = baseDocument.getLength();
        if (n == n2 + 1) {
            n = n2;
        }
        return baseDocument.getVisColFromPos(n);
    }

    public static String getIdentifier(BaseDocument baseDocument, int n) throws BadLocationException {
        int[] nArray = Utilities.getIdentifierBlock(baseDocument, n);
        return nArray != null ? baseDocument.getText(nArray[0], nArray[1] - nArray[0]) : null;
    }

    public static int[] getIdentifierBlock(JTextComponent jTextComponent, int n) throws BadLocationException {
        int n2;
        String string = null;
        int[] nArray = null;
        Document document = jTextComponent.getDocument();
        int n3 = javax.swing.text.Utilities.getWordStart(jTextComponent, n);
        if (n3 >= 0 && (n2 = javax.swing.text.Utilities.getWordEnd(jTextComponent, n3)) >= 0) {
            string = document.getText(n3, n2 - n3);
            nArray = new int[]{n3, n2};
            String string2 = string.trim();
            if (string2.length() == 0 || string2.length() == 1 && !Character.isJavaIdentifierPart(string2.charAt(0))) {
                int n4 = javax.swing.text.Utilities.getPreviousWord(jTextComponent, n);
                if (n == javax.swing.text.Utilities.getWordEnd(jTextComponent, n4)) {
                    nArray = new int[]{n4, n};
                }
            } else if (string != null && string.length() != 0 && string.indexOf(".") != -1) {
                int n5 = n - n3;
                int n6 = string.substring(0, n5).lastIndexOf(".");
                n6 = n6 == -1 ? 0 : n6 + 1;
                int n7 = string.indexOf(".", n5);
                n7 = n7 == -1 ? string.length() : n7;
                nArray = new int[]{n3 + n6, n3 + n7};
            }
        }
        return nArray;
    }

    public static int[] getIdentifierBlock(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2;
        int[] nArray = null;
        int n3 = Utilities.getWordStart(baseDocument, n);
        if (n3 >= 0 && (n2 = Utilities.getWordEnd(baseDocument, n3)) >= 0) {
            String string = baseDocument.getText(n3, n2 - n3);
            if (baseDocument.getSyntaxSupport().isIdentifier(string)) {
                nArray = new int[]{n3, n2};
            } else {
                string = Utilities.getWord(baseDocument, n);
                if (baseDocument.getSyntaxSupport().isIdentifier(string)) {
                    nArray = new int[]{n, n + string.length()};
                }
            }
        }
        return nArray;
    }

    public static String getWord(JTextComponent jTextComponent, int n) throws BadLocationException {
        int[] nArray = Utilities.getIdentifierBlock(jTextComponent, n);
        Document document = jTextComponent.getDocument();
        return nArray != null ? document.getText(nArray[0], nArray[1] - nArray[0]) : null;
    }

    public static int[] getSelectionOrIdentifierBlock(JTextComponent jTextComponent, int n) throws BadLocationException {
        Document document = jTextComponent.getDocument();
        Caret caret = jTextComponent.getCaret();
        int[] nArray = caret.isSelectionVisible() ? new int[]{jTextComponent.getSelectionStart(), jTextComponent.getSelectionEnd()} : (document instanceof BaseDocument ? Utilities.getIdentifierBlock((BaseDocument)document, caret.getDot()) : Utilities.getIdentifierBlock(jTextComponent, n));
        return nArray;
    }

    public static int[] getSelectionOrIdentifierBlock(JTextComponent jTextComponent) {
        try {
            return Utilities.getSelectionOrIdentifierBlock(jTextComponent, jTextComponent.getCaret().getDot());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public static String getIdentifierBefore(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getWordStart(baseDocument, n);
        if (n2 != -1) {
            String string = new String(baseDocument.getChars(n2, n - n2), 0, n - n2);
            if (baseDocument.getSyntaxSupport().isIdentifier(string)) {
                return string;
            }
        }
        return null;
    }

    public static String getSelectionOrIdentifier(JTextComponent jTextComponent, int n) throws BadLocationException {
        String string;
        Document document = jTextComponent.getDocument();
        Caret caret = jTextComponent.getCaret();
        if (caret.isSelectionVisible() && (string = jTextComponent.getSelectedText()) != null) {
            return string;
        }
        string = document instanceof BaseDocument ? Utilities.getIdentifier((BaseDocument)document, caret.getDot()) : Utilities.getWord(jTextComponent, n);
        return string;
    }

    public static String getSelectionOrIdentifier(JTextComponent jTextComponent) {
        try {
            return Utilities.getSelectionOrIdentifier(jTextComponent, jTextComponent.getCaret().getDot());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public static String getWord(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getWordEnd(baseDocument, n);
        if (n2 != -1) {
            return new String(baseDocument.getChars(n, n2 - n), 0, n2 - n);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean changeCase(BaseDocument baseDocument, int n, int n2, int n3) throws BadLocationException {
        int n4;
        char[] cArray = baseDocument.getChars(n, n2);
        char[] cArray2 = (char[])cArray.clone();
        block8: for (n4 = 0; n4 < cArray.length; ++n4) {
            switch (n3) {
                case 0: {
                    cArray2[n4] = Character.toUpperCase(cArray[n4]);
                    continue block8;
                }
                case 1: {
                    cArray2[n4] = Character.toLowerCase(cArray[n4]);
                    continue block8;
                }
                case 2: {
                    if (Character.isUpperCase(cArray[n4])) {
                        cArray2[n4] = Character.toLowerCase(cArray[n4]);
                        continue block8;
                    }
                    if (!Character.isLowerCase(cArray[n4])) continue block8;
                    cArray2[n4] = Character.toUpperCase(cArray[n4]);
                }
            }
        }
        for (n4 = 0; n4 < cArray.length; ++n4) {
            if (cArray[n4] == cArray2[n4]) continue;
            baseDocument.atomicLock();
            try {
                baseDocument.remove(n, cArray.length);
                baseDocument.insertString(n, new String(cArray2), null);
            }
            finally {
                baseDocument.atomicUnlock();
            }
            return true;
        }
        return false;
    }

    public static boolean isRowEmpty(BaseDocument baseDocument, int n) throws BadLocationException {
        Element element = baseDocument.getParagraphElement(n);
        return element.getStartOffset() + 1 == element.getEndOffset();
    }

    public static int getFirstNonEmptyRow(BaseDocument baseDocument, int n, boolean bl) throws BadLocationException {
        while (n != -1 && Utilities.isRowEmpty(baseDocument, n)) {
            n = Utilities.getRowStart(baseDocument, n, bl ? 1 : -1);
        }
        return n;
    }

    public static boolean isRowWhite(BaseDocument baseDocument, int n) throws BadLocationException {
        Element element = baseDocument.getParagraphElement(n);
        return (n = baseDocument.find(new FinderFactory.NonWhiteFwdFinder(baseDocument), element.getStartOffset(), element.getEndOffset() - 1)) == -1;
    }

    public static int getFirstNonWhiteRow(BaseDocument baseDocument, int n, boolean bl) throws BadLocationException {
        if (Utilities.isRowWhite(baseDocument, n)) {
            n = bl ? Utilities.getFirstNonWhiteFwd(baseDocument, n) : Utilities.getFirstNonWhiteBwd(baseDocument, n);
        }
        return n;
    }

    public static int reformat(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        return baseDocument.getFormatter().reformat(baseDocument, n, n2);
    }

    public static void reformatLine(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowStart(baseDocument, n);
        int n3 = Utilities.getRowEnd(baseDocument, n);
        Utilities.reformat(baseDocument, n2, n3);
    }

    public static int getRowCount(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        if (n > n2) {
            return 0;
        }
        Element element = baseDocument.getParagraphElement(0).getParentElement();
        return element.getElementIndex(n2) - element.getElementIndex(n) + 1;
    }

    public static int getRowCount(BaseDocument baseDocument) {
        return baseDocument.getParagraphElement(0).getParentElement().getElementCount();
    }

    public static String getTabInsertString(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getVisualColumn(baseDocument, n);
        Formatter formatter = baseDocument.getFormatter();
        boolean bl = formatter.expandTabs();
        if (bl) {
            int n3 = formatter.getSpacesPerTab();
            int n4 = (n2 + n3) / n3 * n3 - n2;
            return new String(Analyzer.getSpacesBuffer(n4), 0, n4);
        }
        return "\t";
    }

    public static int getNextTabColumn(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getVisualColumn(baseDocument, n);
        int n3 = baseDocument.getFormatter().getSpacesPerTab();
        return (n2 + n3) / n3 * n3;
    }

    public static void setStatusText(JTextComponent jTextComponent, String string) {
        StatusBar statusBar = Utilities.getEditorUI(jTextComponent).getStatusBar();
        if (statusBar != null) {
            statusBar.setText("main", string);
        }
    }

    public static void setStatusText(JTextComponent jTextComponent, String string, Coloring coloring) {
        StatusBar statusBar = Utilities.getEditorUI(jTextComponent).getStatusBar();
        if (statusBar != null) {
            statusBar.setText("main", string, coloring);
        }
    }

    public static void setStatusBoldText(JTextComponent jTextComponent, String string) {
        StatusBar statusBar = Utilities.getEditorUI(jTextComponent).getStatusBar();
        if (statusBar != null) {
            statusBar.setBoldText("main", string);
        }
    }

    public static String getStatusText(JTextComponent jTextComponent) {
        StatusBar statusBar = Utilities.getEditorUI(jTextComponent).getStatusBar();
        return statusBar != null ? statusBar.getText("main") : null;
    }

    public static void clearStatusText(JTextComponent jTextComponent) {
        Utilities.setStatusText(jTextComponent, "");
    }

    public static void insertMark(BaseDocument baseDocument, Mark mark, int n) throws BadLocationException, InvalidMarkException {
        mark.insert(baseDocument, n);
    }

    public static void moveMark(BaseDocument baseDocument, Mark mark, int n) throws BadLocationException, InvalidMarkException {
        mark.move(baseDocument, n);
    }

    public static void returnFocus() {
        JTextComponent jTextComponent = Utilities.getLastActiveComponent();
        if (jTextComponent != null) {
            Utilities.requestFocus(jTextComponent);
        }
    }

    public static void requestFocus(JTextComponent jTextComponent) {
        if (jTextComponent != null && !ImplementationProvider.getDefault().activateComponent(jTextComponent)) {
            Frame frame = EditorUI.getParentFrame(jTextComponent);
            if (frame != null) {
                frame.requestFocus();
            }
            jTextComponent.requestFocus();
        }
    }

    public static void runInEventDispatchThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static String debugPosition(BaseDocument baseDocument, int n) {
        String string;
        if (n >= 0) {
            try {
                int n2 = Utilities.getLineOffset(baseDocument, n) + 1;
                int n3 = Utilities.getVisualColumn(baseDocument, n) + 1;
                string = String.valueOf(n2) + ":" + String.valueOf(n3);
            }
            catch (BadLocationException badLocationException) {
                string = NbBundle.getBundle((Class)BaseKit.class).getString(WRONG_POSITION_LOCALE) + ' ' + n + " > " + baseDocument.getLength();
            }
        } else {
            string = String.valueOf(n);
        }
        return string;
    }

    public static String offsetToLineColumnString(BaseDocument baseDocument, int n) {
        return String.valueOf(n) + "[" + Utilities.debugPosition(baseDocument, n) + "]";
    }

    public static String debugDocument(Document document) {
        return "<" + System.identityHashCode(document) + ", title='" + document.getProperty("title") + "', stream='" + document.getProperty("stream") + ", " + document.toString() + ">";
    }

    public static void performAction(Action action, ActionEvent actionEvent, JTextComponent jTextComponent) {
        if (action instanceof BaseAction) {
            ((BaseAction)action).actionPerformed(actionEvent, jTextComponent);
        } else {
            action.actionPerformed(actionEvent);
        }
    }

    public static JTextComponent getLastActiveComponent() {
        return Registry.getMostActiveComponent();
    }

    public static JTextComponent getFocusedComponent() {
        class FocusedComponentAction
        extends TextAction {
            FocusedComponentAction() {
                super("focused-component");
            }

            JTextComponent getFocusedComponent2() {
                return this.getFocusedComponent();
            }

            public void actionPerformed(ActionEvent actionEvent) {
            }
        }
        if (focusedComponentAction == null) {
            focusedComponentAction = new FocusedComponentAction();
        }
        return ((FocusedComponentAction)focusedComponentAction).getFocusedComponent2();
    }

    public static EditorUI getEditorUI(JTextComponent jTextComponent) {
        TextUI textUI = jTextComponent.getUI();
        return textUI instanceof BaseTextUI ? ((BaseTextUI)textUI).getEditorUI() : null;
    }

    public static BaseKit getKit(JTextComponent jTextComponent) {
        if (jTextComponent == null) {
            return null;
        }
        EditorKit editorKit = jTextComponent.getUI().getEditorKit(jTextComponent);
        return editorKit instanceof BaseKit ? (BaseKit)editorKit : null;
    }

    public static Class getKitClass(JTextComponent jTextComponent) {
        return jTextComponent != null ? jTextComponent.getUI().getEditorKit(jTextComponent).getClass() : null;
    }

    public static BaseDocument getDocument(JTextComponent jTextComponent) {
        Document document = jTextComponent.getDocument();
        return document instanceof BaseDocument ? (BaseDocument)document : null;
    }

    public static SyntaxSupport getSyntaxSupport(JTextComponent jTextComponent) {
        Document document = jTextComponent.getDocument();
        return document instanceof BaseDocument ? ((BaseDocument)document).getSyntaxSupport() : null;
    }

    public static View getRootView(JTextComponent jTextComponent, Class clazz) {
        View view = null;
        TextUI textUI = jTextComponent.getUI();
        if (textUI != null) {
            for (view = textUI.getRootView(jTextComponent); view != null && !clazz.isInstance(view) && view.getViewCount() == 1; view = view.getView(0)) {
            }
        }
        return view;
    }

    public static View getDocumentView(JTextComponent jTextComponent) {
        return Utilities.getRootView(jTextComponent, DrawEngineDocView.class);
    }

    public static String keySequenceToString(KeyStroke[] keyStrokeArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(Utilities.keyStrokeToString(keyStrokeArray[i]));
        }
        return stringBuffer.toString();
    }

    public static String keyStrokeToString(KeyStroke keyStroke) {
        String string;
        String string2 = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
        String string3 = string = keyStroke.getKeyCode() == 0 ? String.valueOf(keyStroke.getKeyChar()) : Utilities.getKeyText(keyStroke.getKeyCode());
        if (string2.length() > 0) {
            return string2 + '+' + string;
        }
        return string;
    }

    private static String getKeyText(int n) {
        String string = KeyEvent.getKeyText(n);
        if (string != null) {
            switch (n) {
                case 225: {
                    string = Utilities.prefixNumpad(string, 40);
                    break;
                }
                case 226: {
                    string = Utilities.prefixNumpad(string, 37);
                    break;
                }
                case 227: {
                    string = Utilities.prefixNumpad(string, 39);
                    break;
                }
                case 224: {
                    string = Utilities.prefixNumpad(string, 38);
                }
            }
        }
        return string;
    }

    private static String prefixNumpad(String string, int n) {
        if (string.equals(KeyEvent.getKeyText(n))) {
            string = NbBundle.getBundle((Class)BaseKit.class).getString("key-prefix-numpad") + string;
        }
        return string;
    }

    private static void checkOffsetValid(Document document, int n) throws BadLocationException {
        Utilities.checkOffsetValid(n, document.getLength());
    }

    private static void checkOffsetValid(int n, int n2) throws BadLocationException {
        if (n < 0 || n > n2) {
            throw new BadLocationException("Invalid offset=" + n + " not within <0, " + n2 + ">", n);
        }
    }

    public static void annotateLoggable(Throwable throwable) {
        if (isLoggable) {
            ErrorManager.getDefault().notify(1, throwable);
        }
    }

    static {
        isLoggable = ErrorManager.getDefault().isLoggable(1);
    }
}

