/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintStream;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;
import org.netbeans.editor.ext.CompletionPane;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.CompletionView;
import org.netbeans.editor.ext.ExtCompletionPane;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.JDCPopupPanel;
import org.netbeans.editor.ext.JavaDocPane;
import org.netbeans.editor.ext.ListCompletionView;
import org.netbeans.editor.ext.ScrollCompletionPane;
import org.netbeans.editor.ext.ScrollJavaDocPane;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class Completion
implements PropertyChangeListener,
SettingsChangeListener,
ActionListener {
    protected ExtEditorUI extEditorUI;
    private CompletionQuery query;
    private CompletionQuery.Result lastResult;
    private boolean keyPressed = false;
    private CompletionView view;
    private ExtCompletionPane pane;
    private JavaDocPane javaDocPane;
    private JDCPopupPanel jdcPopupPanel;
    private boolean autoPopup;
    private int autoPopupDelay;
    private int refreshDelay;
    private boolean instantSubstitution;
    Timer timer;
    Timer docChangeTimer;
    private DocumentListener docL;
    private CaretListener caretL;
    private PropertyChangeListener docChangeL;
    private int caretPos = -1;
    private static RequestProcessor serializingRequestProcessor;
    private static final String PROP_DEBUG_COMPLETION = "editor.debug.completion";
    private static final boolean DEBUG_COMPLETION;
    private CancelableRunnable cancellable = new CancelableRunnable(){

        public void run() {
        }
    };
    public boolean provokedByAutoPopup;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Completion(ExtEditorUI extEditorUI) {
        this.extEditorUI = extEditorUI;
        this.timer = new Timer(0, new WeakTimerListener(this));
        this.timer.setRepeats(false);
        this.docChangeTimer = new Timer(0, new WeakTimerListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Completion.this.refreshImpl(false);
            }
        }));
        this.docChangeTimer.setRepeats(false);
        class CompletionDocumentListener
        implements DocumentListener {
            CompletionDocumentListener() {
            }

            private void processTimer() {
                Completion.this.docChangeTimer.stop();
                Completion.this.setKeyPressed(true);
                Completion.this.invalidateLastResult();
                Completion.this.docChangeTimer.setInitialDelay(Completion.this.refreshDelay);
                Completion.this.docChangeTimer.setDelay(Completion.this.refreshDelay);
                Completion.this.docChangeTimer.start();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                Completion.trace("ENTRY insertUpdate");
                this.processTimer();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                Completion.trace("ENTRY removeUpdate");
                this.processTimer();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        }
        this.docL = new CompletionDocumentListener();
        class CompletionCaretListener
        implements CaretListener {
            CompletionCaretListener() {
            }

            public void caretUpdate(CaretEvent caretEvent) {
                Completion.trace("ENTRY caretUpdate");
                if (!Completion.this.isPaneVisible()) {
                    Completion.this.cancelRequestImpl();
                } else {
                    Completion.this.refreshImpl(true);
                }
            }
        }
        this.caretL = new CompletionCaretListener();
        Settings.addSettingsChangeListener(this);
        Object object = extEditorUI.getComponentLock();
        synchronized (object) {
            JTextComponent jTextComponent = extEditorUI.getComponent();
            if (jTextComponent != null) {
                this.propertyChange(new PropertyChangeEvent(extEditorUI, "component", null, jTextComponent));
            }
            extEditorUI.addPropertyChangeListener(this);
        }
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        Class clazz = Utilities.getKitClass(this.extEditorUI.getComponent());
        if (clazz != null) {
            this.autoPopup = SettingsUtil.getBoolean(clazz, "completion-auto-popup", ExtSettingsDefaults.defaultCompletionAutoPopup);
            this.autoPopupDelay = SettingsUtil.getInteger(clazz, "completion-auto-popup-delay", ExtSettingsDefaults.defaultCompletionAutoPopupDelay);
            this.refreshDelay = SettingsUtil.getInteger(clazz, "completion-refresh-delay", ExtSettingsDefaults.defaultCompletionRefreshDelay);
            this.instantSubstitution = SettingsUtil.getBoolean(clazz, "completion-instant-substitution", ExtSettingsDefaults.defaultCompletionInstantSubstitution);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("component".equals(string)) {
            JTextComponent jTextComponent = (JTextComponent)propertyChangeEvent.getNewValue();
            if (jTextComponent != null) {
                this.settingsChange(null);
                BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
                if (baseDocument != null) {
                    baseDocument.addDocumentListener(this.docL);
                }
                jTextComponent.addCaretListener(this.caretL);
            } else {
                this.setPaneVisible(false);
                jTextComponent = (JTextComponent)propertyChangeEvent.getOldValue();
                BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
                if (baseDocument != null) {
                    baseDocument.removeDocumentListener(this.docL);
                }
                if (jTextComponent != null) {
                    jTextComponent.removeCaretListener(this.caretL);
                }
            }
        } else if ("document".equals(string)) {
            if (propertyChangeEvent.getOldValue() instanceof BaseDocument) {
                ((BaseDocument)propertyChangeEvent.getOldValue()).removeDocumentListener(this.docL);
            }
            if (propertyChangeEvent.getNewValue() instanceof BaseDocument) {
                ((BaseDocument)propertyChangeEvent.getNewValue()).addDocumentListener(this.docL);
            }
        }
    }

    public CompletionPane getPane() {
        return this.getExtPane();
    }

    public ExtCompletionPane getExtPane() {
        if (this.pane == null) {
            this.pane = new ScrollCompletionPane(this.extEditorUI);
        }
        return this.pane;
    }

    protected CompletionView createView() {
        return new ListCompletionView();
    }

    public final CompletionView getView() {
        if (this.view == null) {
            this.view = this.createView();
        }
        return this.view;
    }

    protected CompletionQuery createQuery() {
        return null;
    }

    public final CompletionQuery getQuery() {
        if (this.query == null) {
            this.query = this.createQuery();
        }
        return this.query;
    }

    public JavaDocPane getJavaDocPane() {
        if (this.javaDocPane == null) {
            this.javaDocPane = new ScrollJavaDocPane(this.extEditorUI);
        }
        return this.javaDocPane;
    }

    public final JDCPopupPanel getJDCPopupPanelIfExists() {
        return this.jdcPopupPanel;
    }

    public JDCPopupPanel getJDCPopupPanel() {
        if (this.jdcPopupPanel == null) {
            this.jdcPopupPanel = new JDCPopupPanel(this.extEditorUI, this.getExtPane(), this);
        }
        return this.jdcPopupPanel;
    }

    public final synchronized CompletionQuery.Result getLastResult() {
        return this.lastResult;
    }

    public final synchronized void invalidateLastResult() {
        this.currentTask().cancel();
        this.lastResult = null;
        this.caretPos = -1;
    }

    private synchronized void setKeyPressed(boolean bl) {
        this.keyPressed = bl;
    }

    private synchronized boolean isKeyPressed() {
        return this.keyPressed;
    }

    public synchronized Object getSelectedValue() {
        int n;
        if (this.lastResult != null && (n = this.getView().getSelectedIndex()) >= 0 && n < this.lastResult.getData().size()) {
            return this.lastResult.getData().get(n);
        }
        return null;
    }

    public boolean isAutoPopupEnabled() {
        return this.autoPopup;
    }

    public boolean isPaneVisible() {
        return this.pane != null && this.pane.isVisible();
    }

    public void setPaneVisible(boolean bl) {
        Completion.trace("ENTRY setPaneVisible " + bl);
        if (bl) {
            if (this.extEditorUI.getComponent() != null) {
                this.popupImpl(false);
            }
        } else if (this.pane != null) {
            this.cancelRequestImpl();
            this.invalidateLastResult();
            this.getJDCPopupPanel().setCompletionVisible(false);
            this.caretPos = -1;
        }
    }

    public void completionCancel() {
        Completion.trace("ENTRY completionCancel");
        if (this.pane != null) {
            this.cancelRequestImpl();
            this.invalidateLastResult();
            this.caretPos = -1;
        }
    }

    public void refresh(boolean bl) {
        Completion.trace("ENTRY refresh " + bl);
        this.refreshImpl(bl);
    }

    private synchronized void refreshImpl(boolean bl) {
        if (!this.isPaneVisible()) {
            return;
        }
        class RefreshTask
        implements Runnable {
            private final boolean batch;

            RefreshTask(boolean bl) {
                this.batch = bl;
            }

            public void run() {
                if (Completion.this.isPaneVisible()) {
                    Completion.this.timer.stop();
                    if (this.batch) {
                        Completion.this.timer.setInitialDelay(Completion.this.refreshDelay);
                        Completion.this.timer.setDelay(Completion.this.refreshDelay);
                        Completion.this.timer.start();
                    } else {
                        Completion.this.actionPerformed(null);
                    }
                }
            }
        }
        SwingUtilities.invokeLater(new RefreshTask(bl));
    }

    public void popup(boolean bl) {
        Completion.trace("ENTRY popup " + bl);
        this.popupImpl(bl);
    }

    private synchronized void popupImpl(boolean bl) {
        if (this.isPaneVisible()) {
            this.refreshImpl(bl);
        } else {
            this.timer.stop();
            if (bl) {
                this.timer.setInitialDelay(this.autoPopupDelay);
                this.timer.setDelay(this.autoPopupDelay);
                this.timer.start();
            } else {
                this.actionPerformed(null);
            }
        }
    }

    public void cancelRequest() {
        Completion.trace("ENTRY cancelRequest");
        this.cancelRequestImpl();
    }

    private synchronized void cancelRequestImpl() {
        this.timer.stop();
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (this.jdcPopupPanel == null) {
            this.extEditorUI.getCompletionJavaDoc();
        }
        JTextComponent jTextComponent = this.extEditorUI.getComponent();
        BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
        if (jTextComponent != null && baseDocument != null) {
            this.provokedByAutoPopup = actionEvent != null;
            try {
                if (this.caretPos != -1 && Utilities.getRowStart(jTextComponent, jTextComponent.getCaret().getDot()) != Utilities.getRowStart(jTextComponent, this.caretPos) && jTextComponent.getCaret().getDot() - this.caretPos > 0) {
                    this.getJDCPopupPanel().setCompletionVisible(false);
                    this.caretPos = -1;
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.caretPos = jTextComponent.getCaret().getDot();
            this.currentTask().cancel();
            boolean bl = this.getQuery() instanceof CompletionQuery.SupportsSpeculativeInvocation;
            RequestProcessor requestProcessor = bl ? RequestProcessor.getDefault() : this.getSerialiazingRequestProcessor();
            class PendingTask
            extends CancelableRunnable {
                PendingTask() {
                }

                public void run() {
                    if (this.cancelled()) {
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ PendingTask this$1;
                        {
                            this.this$1 = pendingTask;
                        }

                        public void run() {
                            if (this.this$1.cancelled()) {
                                return;
                            }
                            Completion.access$600(PendingTask.access$500(this.this$1));
                        }
                    });
                }

                static /* synthetic */ Completion access$500(PendingTask pendingTask) {
                    return pendingTask.Completion.this;
                }
            }
            PendingTask pendingTask = new PendingTask();
            class QueryTask
            extends CancelableRunnable {
                private final CancelableRunnable wait;
                private final boolean isPaneVisible;
                private final /* synthetic */ JTextComponent val$component;

                public QueryTask(CancelableRunnable cancelableRunnable, boolean bl, JTextComponent jTextComponent) {
                    this.val$component = jTextComponent;
                    this.wait = cancelableRunnable;
                    this.isPaneVisible = bl;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    if (this.cancelled()) {
                        return;
                    }
                    try {
                        try {
                            Completion.this.performQuery(this.val$component);
                        }
                        catch (ThreadDeath threadDeath) {
                            throw threadDeath;
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                            Object var3_2 = null;
                            this.wait.cancel();
                            if (this.cancelled()) {
                                return;
                            }
                            SwingUtilities.invokeLater(new Runnable(this){
                                private final /* synthetic */ QueryTask this$1;
                                {
                                    this.this$1 = queryTask;
                                }

                                public void run() {
                                    if (this.this$1.cancelled()) {
                                        return;
                                    }
                                    CompletionQuery.Result result = Completion.access$900(QueryTask.access$800(this.this$1));
                                    if (result != null && Completion.access$1000(QueryTask.access$800(this.this$1)) && result.getData().size() == 1 && !QueryTask.access$1100(this.this$1) && QueryTask.access$800(this.this$1).instantSubstitution(Completion.access$1200(QueryTask.access$800(this.this$1)))) {
                                        QueryTask.access$800(this.this$1).setPaneVisible(false);
                                        return;
                                    }
                                    QueryTask.access$800(this.this$1).performResults();
                                }
                            });
                            return;
                        }
                        Object var3_1 = null;
                        this.wait.cancel();
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        this.wait.cancel();
                        if (this.cancelled()) {
                            return;
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                    if (this.cancelled()) {
                        return;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }

                void cancel() {
                    super.cancel();
                    this.wait.cancel();
                }

                static /* synthetic */ Completion access$800(QueryTask queryTask) {
                    return queryTask.Completion.this;
                }

                static /* synthetic */ boolean access$1100(QueryTask queryTask) {
                    return queryTask.isPaneVisible;
                }
            }
            QueryTask queryTask = new QueryTask(pendingTask, this.getPane().isVisible(), jTextComponent);
            this.currentTask(queryTask);
            if (!this.provokedByAutoPopup) {
                RequestProcessor.getDefault().post((Runnable)pendingTask, 100);
            }
            requestProcessor.post((Runnable)queryTask);
        }
    }

    private void performWait() {
        this.getPane().setTitle(NbBundle.getBundle((Class)BaseKit.class).getString("ext.Completion.wait"));
        this.getView().setResult(null);
        if (this.isPaneVisible()) {
            this.getJDCPopupPanel().refresh();
        } else {
            this.getJDCPopupPanel().setCompletionVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performQuery(JTextComponent jTextComponent) {
        BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
        long l = System.currentTimeMillis();
        try {
            this.lastResult = this.getQuery().query(jTextComponent, this.caretPos, baseDocument.getSyntaxSupport());
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            Completion.trace("performQuery took " + (System.currentTimeMillis() - l) + "ms");
            this.setKeyPressed(false);
            throw throwable;
        }
        Completion.trace("performQuery took " + (System.currentTimeMillis() - l) + "ms");
        this.setKeyPressed(false);
    }

    protected void performResults() {
        CompletionQuery.Result result = this.lastResult;
        if (result != null) {
            if (this.instantSubstitution && result.getData().size() == 1 && !this.isPaneVisible() && this.instantSubstitution(this.caretPos)) {
                return;
            }
            this.getPane().setTitle(result.getTitle());
            this.getView().setResult(result);
            if (this.isPaneVisible()) {
                this.getJDCPopupPanel().refresh();
            } else {
                this.getJDCPopupPanel().setCompletionVisible(true);
            }
        } else {
            this.getJDCPopupPanel().setCompletionVisible(false);
            if (!this.isKeyPressed()) {
                this.caretPos = -1;
            } else {
                this.setKeyPressed(false);
            }
        }
    }

    public boolean instantSubstitution(int n) {
        Completion.trace("ENTRY instantSubstitution " + n);
        return this.instantSubstitutionImpl(n);
    }

    private synchronized boolean instantSubstitutionImpl(int n) {
        if (this.getLastResult() == null) {
            return false;
        }
        JTextComponent jTextComponent = this.extEditorUI.getComponent();
        try {
            int[] nArray;
            if (jTextComponent != null && ((nArray = Utilities.getIdentifierBlock(jTextComponent, n)) == null || nArray[1] == n)) {
                return this.getLastResult().substituteText(0, false);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    public synchronized boolean substituteText(boolean bl) {
        Completion.trace("ENTRY substituteText " + bl);
        if (this.lastResult != null) {
            int n = this.getView().getSelectedIndex();
            if (n >= 0) {
                this.lastResult.substituteText(n, bl);
            }
            return true;
        }
        return false;
    }

    public synchronized boolean substituteSimpleText() {
        return false;
    }

    public synchronized boolean substituteCommonText() {
        Completion.trace("ENTRY substituteCommonText");
        if (this.lastResult != null) {
            int n = this.getView().getSelectedIndex();
            if (n >= 0) {
                this.lastResult.substituteCommonText(n);
            }
            return true;
        }
        return false;
    }

    private void currentTask(CancelableRunnable cancelableRunnable) {
        this.cancellable = cancelableRunnable;
    }

    private CancelableRunnable currentTask() {
        return this.cancellable;
    }

    private synchronized RequestProcessor getSerialiazingRequestProcessor() {
        if (serializingRequestProcessor == null) {
            serializingRequestProcessor = new RequestProcessor("editor.completion", 1);
        }
        return serializingRequestProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void trace(String string) {
        if (DEBUG_COMPLETION && Boolean.getBoolean(PROP_DEBUG_COMPLETION)) {
            PrintStream printStream = System.err;
            synchronized (printStream) {
                System.err.println(string);
            }
        }
    }

    static /* synthetic */ void access$600(Completion completion) {
        completion.performWait();
    }

    static /* synthetic */ CompletionQuery.Result access$900(Completion completion) {
        return completion.lastResult;
    }

    static /* synthetic */ boolean access$1000(Completion completion) {
        return completion.instantSubstitution;
    }

    static /* synthetic */ int access$1200(Completion completion) {
        return completion.caretPos;
    }

    static {
        DEBUG_COMPLETION = Boolean.getBoolean(PROP_DEBUG_COMPLETION);
    }

    abstract class CancelableRunnable
    implements Runnable {
        private boolean cancelled = false;

        CancelableRunnable() {
        }

        boolean cancelled() {
            return this.cancelled;
        }

        void cancel() {
            this.cancelled = true;
        }
    }
}

