/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.ExtCaret;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.editor.ext.FindDialogSupport;
import org.netbeans.editor.ext.GotoDialogSupport;
import org.netbeans.editor.ext.KeyEventBlocker;
import org.netbeans.editor.ext.ToolTipSupport;
import org.openide.util.NbBundle;

public class ExtKit
extends BaseKit {
    public static final String buildPopupMenuAction = "build-popup-menu";
    public static final String showPopupMenuAction = "show-popup-menu";
    public static final String buildToolTipAction = "build-tool-tip";
    public static final String findAction = "find";
    public static final String replaceAction = "replace";
    public static final String gotoAction = "goto";
    public static final String gotoDeclarationAction = "goto-declaration";
    public static final String gotoSourceAction = "goto-source";
    public static final String gotoSuperImplementationAction = "goto-super-implementation";
    public static final String gotoHelpAction = "goto-help";
    public static final String matchBraceAction = "match-brace";
    public static final String selectionMatchBraceAction = "selection-match-brace";
    public static final String toggleCaseIdentifierBeginAction = "toggle-case-identifier-begin";
    public static final String codeSelectAction = "code-select";
    public static final String escapeAction = "escape";
    public static final String completionShowAction = "completion-show";
    public static final String documentationShowAction = "documentation-show";
    public static final String completionTooltipShowAction = "tooltip-show";
    public static final String commentAction = "comment";
    public static final String uncommentAction = "uncomment";
    public static final String toggleToolbarAction = "toggle-toolbar";
    public static final String TRIMMED_TEXT = "trimmed-text";
    private static FindDialogSupport findDialogSupport;
    private static FindAction findActionDef;
    private static ReplaceAction replaceActionDef;
    private static GotoAction gotoActionDef;
    private static final boolean debugPopupMenu;
    static /* synthetic */ Class class$org$netbeans$editor$BaseKit;

    public Caret createCaret() {
        return new ExtCaret();
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument baseDocument) {
        return new ExtSyntaxSupport(baseDocument);
    }

    public Completion createCompletion(ExtEditorUI extEditorUI) {
        return null;
    }

    public CompletionJavaDoc createCompletionJavaDoc(ExtEditorUI extEditorUI) {
        return null;
    }

    protected EditorUI createEditorUI() {
        return new ExtEditorUI();
    }

    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new BuildPopupMenuAction(), new ShowPopupMenuAction(), new BuildToolTipAction(), findActionDef, replaceActionDef, gotoActionDef, new ToggleCaseIdentifierBeginAction(), new MatchBraceAction(matchBraceAction, false), new MatchBraceAction(selectionMatchBraceAction, true), new ExtDefaultKeyTypedAction(), new CompletionShowAction(), new DocumentationShowAction(), new CompletionTooltipShowAction()};
        return TextAction.augmentList(super.createActions(), actionArray);
    }

    static {
        findActionDef = new FindAction();
        replaceActionDef = new ReplaceAction();
        gotoActionDef = new GotoAction();
        debugPopupMenu = Boolean.getBoolean("netbeans.debug.editor.popup.menu");
    }

    public static class ExtDeleteCharAction
    extends BaseKit.DeleteCharAction {
        public ExtDeleteCharAction(String string, boolean bl) {
            super(string, bl);
        }
    }

    public static class CompletionTooltipShowAction
    extends BaseKitLocalizedAction {
        public CompletionTooltipShowAction() {
            super(ExtKit.completionTooltipShowAction);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        }
    }

    public static class DocumentationShowAction
    extends BaseKitLocalizedAction {
        public DocumentationShowAction() {
            super(ExtKit.documentationShowAction);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        }
    }

    public static class CompletionShowAction
    extends BaseKitLocalizedAction {
        static final long serialVersionUID = 1050644925893851146L;

        public CompletionShowAction() {
            super(ExtKit.completionShowAction);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        }
    }

    public static class ExtDefaultKeyTypedAction
    extends BaseKit.DefaultKeyTypedAction {
        static final long serialVersionUID = 5273032708909044812L;

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            String string = actionEvent.getActionCommand();
            int n = actionEvent.getModifiers();
            if (string == null || !string.equals(" ") || n != 2) {
                Caret caret = jTextComponent.getCaret();
                if (caret instanceof ExtCaret) {
                    ((ExtCaret)caret).requestMatchBraceUpdateSync();
                }
                super.actionPerformed(actionEvent, jTextComponent);
            }
            if (jTextComponent != null && actionEvent != null && string != null && string.length() == 1 && (n & 8) == 0 && (n & 2) == 0) {
                this.checkIndentHotChars(jTextComponent, string);
                this.checkCompletion(jTextComponent, string);
            }
        }

        protected void checkIndentHotChars(JTextComponent jTextComponent, String string) {
            BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
            if (baseDocument != null) {
                ExtFormatter extFormatter;
                int[] nArray;
                Caret caret = jTextComponent.getCaret();
                Formatter formatter = baseDocument.getFormatter();
                if (formatter instanceof ExtFormatter && (nArray = (extFormatter = (ExtFormatter)formatter).getReformatBlock(jTextComponent, string)) != null) {
                    try {
                        nArray[0] = Utilities.getRowStart(baseDocument, nArray[0]);
                        nArray[1] = Utilities.getRowEnd(baseDocument, nArray[1]);
                        extFormatter.reformat(baseDocument, nArray[0], nArray[1], true);
                    }
                    catch (BadLocationException badLocationException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        protected void checkCompletion(JTextComponent jTextComponent, String string) {
            Completion completion = ExtUtilities.getCompletion(jTextComponent);
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
            if (completion != null && string.length() > 0) {
                if (!completion.isPaneVisible()) {
                    if (completion.isAutoPopupEnabled()) {
                        int n = extSyntaxSupport.checkCompletion(jTextComponent, string, false);
                        if (n == 0) {
                            completion.popup(true);
                        } else if (n == 1) {
                            completion.cancelRequest();
                        }
                    }
                } else {
                    int n = extSyntaxSupport.checkCompletion(jTextComponent, string, true);
                    switch (n) {
                        case 4: {
                            completion.setPaneVisible(false);
                            break;
                        }
                        case 2: {
                            completion.refresh(false);
                            break;
                        }
                        case 3: {
                            completion.refresh(true);
                        }
                    }
                }
            }
        }
    }

    public static class EscapeAction
    extends BaseKitLocalizedAction {
        public EscapeAction() {
            super(ExtKit.escapeAction);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                ExtUtilities.getExtEditorUI(jTextComponent).hidePopupMenu();
            }
        }
    }

    public static class UncommentAction
    extends BaseKitLocalizedAction {
        static final long serialVersionUID = -7005758666529862034L;
        private String lineCommentString;

        public UncommentAction(String string) {
            super(ExtKit.uncommentAction);
            this.lineCommentString = string;
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/uncomment.png");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            block12: {
                if (jTextComponent != null) {
                    if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                        jTextComponent.getToolkit().beep();
                        return;
                    }
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int n = this.lineCommentString.length();
                    try {
                        if (caret.isSelectionVisible()) {
                            int n2 = Utilities.getRowFirstNonWhite(baseDocument, jTextComponent.getSelectionStart());
                            int n3 = jTextComponent.getSelectionEnd();
                            baseDocument.atomicLock();
                            try {
                                if (n3 > 0 && Utilities.getRowStart(baseDocument, n3) == n3) {
                                    --n3;
                                }
                                int n4 = n2;
                                for (int i = Utilities.getRowCount(baseDocument, n2, n3); i > 0; --i) {
                                    if (Utilities.getRowEnd(baseDocument, n4) - n4 >= n && baseDocument.getText(n4, n).equals(this.lineCommentString)) {
                                        baseDocument.remove(n4, n);
                                    }
                                    n4 = Utilities.getRowFirstNonWhite(baseDocument, Utilities.getRowStart(baseDocument, n4, 1));
                                }
                                break block12;
                            }
                            finally {
                                baseDocument.atomicUnlock();
                            }
                        }
                        int n5 = Utilities.getRowFirstNonWhite(baseDocument, caret.getDot());
                        if (Utilities.getRowEnd(baseDocument, n5) - n5 >= n && baseDocument.getText(n5, n).equals(this.lineCommentString)) {
                            baseDocument.remove(n5, n);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        jTextComponent.getToolkit().beep();
                    }
                }
            }
        }
    }

    public static class CommentAction
    extends BaseKitLocalizedAction {
        static final long serialVersionUID = -1422954906554289179L;
        private String lineCommentString;

        public CommentAction(String string) {
            super(ExtKit.commentAction);
            this.lineCommentString = string;
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/comment.png");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            block10: {
                if (jTextComponent != null) {
                    if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                        jTextComponent.getToolkit().beep();
                        return;
                    }
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    try {
                        if (caret.isSelectionVisible()) {
                            int n = Utilities.getRowStart(baseDocument, jTextComponent.getSelectionStart());
                            int n2 = jTextComponent.getSelectionEnd();
                            baseDocument.atomicLock();
                            try {
                                if (n2 > 0 && Utilities.getRowStart(baseDocument, n2) == n2) {
                                    --n2;
                                }
                                int n3 = n;
                                for (int i = Utilities.getRowCount(baseDocument, n, n2); i > 0; --i) {
                                    baseDocument.insertString(n3, this.lineCommentString, null);
                                    n3 = Utilities.getRowStart(baseDocument, n3, 1);
                                }
                                break block10;
                            }
                            finally {
                                baseDocument.atomicUnlock();
                            }
                        }
                        baseDocument.insertString(Utilities.getRowStart(baseDocument, jTextComponent.getSelectionStart()), this.lineCommentString, null);
                    }
                    catch (BadLocationException badLocationException) {
                        jTextComponent.getToolkit().beep();
                    }
                }
            }
        }
    }

    public static class PrefixMakerAction
    extends BaseKitLocalizedAction {
        static final long serialVersionUID = -2305157963664484920L;
        private String prefix;
        private String[] prefixGroup;

        public PrefixMakerAction(String string, String string2, String[] stringArray) {
            super(string);
            this.prefix = string2;
            this.prefixGroup = stringArray;
            String string3 = null;
            if ("get".equals(string2)) {
                string3 = "org/netbeans/modules/editor/resources/var_get.gif";
            } else if ("set".equals(string2)) {
                string3 = "org/netbeans/modules/editor/resources/var_set.gif";
            } else if ("is".equals(string2)) {
                string3 = "org/netbeans/modules/editor/resources/var_is.gif";
            }
            if (string3 != null) {
                this.putValue("IconResource", string3);
            }
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                int n = jTextComponent.getCaret().getDot();
                try {
                    int[] nArray = Utilities.getIdentifierBlock(baseDocument, n);
                    if (nArray == null) {
                        jTextComponent.getToolkit().beep();
                        return;
                    }
                    String string = baseDocument.getText(nArray[0], nArray[1] - nArray[0]);
                    if (string.startsWith(this.prefix) && Character.isUpperCase(string.charAt(this.prefix.length()))) {
                        return;
                    }
                    for (int i = 0; i < this.prefixGroup.length; ++i) {
                        String string2 = this.prefixGroup[i];
                        if (!string.startsWith(string2) || string.length() <= string2.length() || !Character.isUpperCase(string.charAt(string2.length()))) continue;
                        baseDocument.remove(nArray[0], string2.length());
                        baseDocument.insertString(nArray[0], this.prefix, null);
                        return;
                    }
                    Utilities.changeCase(baseDocument, nArray[0], 1, 0);
                    baseDocument.insertString(nArray[0], this.prefix, null);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class CodeSelectAction
    extends BaseKitLocalizedAction {
        static final long serialVersionUID = 4033474080778585860L;

        public CodeSelectAction() {
            super(ExtKit.codeSelectAction);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        }
    }

    public static class MatchBraceAction
    extends BaseKitLocalizedAction {
        boolean select;
        static final long serialVersionUID = -184887499045886231L;

        public MatchBraceAction(String string, boolean bl) {
            super(string, 14);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                try {
                    int[] nArray;
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
                    int n = caret.getDot();
                    ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
                    if (n > 0 && (nArray = extSyntaxSupport.findMatchingBlock(n - 1, false)) != null) {
                        if (this.select) {
                            caret.moveDot(nArray[1]);
                        } else {
                            caret.setDot(nArray[1]);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class ToggleCaseIdentifierBeginAction
    extends BaseKitLocalizedAction {
        static final long serialVersionUID = 584392193824931979L;

        ToggleCaseIdentifierBeginAction() {
            super(ExtKit.toggleCaseIdentifierBeginAction, 30);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                try {
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int[] nArray = Utilities.getIdentifierBlock(baseDocument, caret.getDot());
                    if (nArray != null) {
                        Utilities.changeCase(baseDocument, nArray[0], 1, 2);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class GotoDeclarationAction
    extends BaseKitLocalizedAction {
        static final long serialVersionUID = -6440495023918097760L;

        public GotoDeclarationAction() {
            super(ExtKit.gotoDeclarationAction, 142);
            String string = NbBundle.getBundle((Class)(class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = ExtKit.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit)).getString("goto-declaration-trimmed");
            this.putValue(ExtKit.TRIMMED_TEXT, string);
            this.putValue("PopupMenuText", string);
        }

        public boolean gotoDeclaration(JTextComponent jTextComponent) {
            try {
                int n;
                Caret caret = jTextComponent.getCaret();
                int n2 = caret.getDot();
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                int[] nArray = Utilities.getIdentifierBlock(baseDocument, n2);
                ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
                if (nArray != null && (n = extSyntaxSupport.findDeclarationPosition(baseDocument.getText(nArray), nArray[1])) >= 0) {
                    caret.setDot(n);
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return false;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                this.gotoDeclaration(jTextComponent);
            }
        }
    }

    public static class GotoAction
    extends BaseKitLocalizedAction {
        static final long serialVersionUID = 8425585413146373256L;

        public GotoAction() {
            super(ExtKit.gotoAction, 14);
            String string = NbBundle.getBundle((Class)(class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = ExtKit.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit)).getString("goto_trimmed");
            this.putValue(ExtKit.TRIMMED_TEXT, string);
            this.putValue("PopupMenuText", string);
        }

        protected int getOffsetFromLine(BaseDocument baseDocument, int n) {
            return Utilities.getRowStartFromLineOffset(baseDocument, n);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                new GotoDialogSupport().showGotoDialog(new KeyEventBlocker(jTextComponent, false));
            }
        }
    }

    public static class ReplaceAction
    extends BaseKitLocalizedAction {
        static final long serialVersionUID = 1828017436079834384L;

        public ReplaceAction() {
            super(ExtKit.replaceAction, 78);
        }

        public FindDialogSupport getSupport() {
            return FindDialogSupport.getFindDialogSupport();
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                this.getSupport().showReplaceDialog(new KeyEventBlocker(jTextComponent, true));
            }
        }
    }

    public static class FindAction
    extends BaseKitLocalizedAction {
        static final long serialVersionUID = 719554648887497427L;

        public FindAction() {
            super(ExtKit.findAction, 78);
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/find");
        }

        public FindDialogSupport getSupport() {
            return FindDialogSupport.getFindDialogSupport();
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                this.getSupport().showFindDialog(new KeyEventBlocker(jTextComponent, false));
            }
        }
    }

    public static class BuildToolTipAction
    extends BaseAction {
        static final long serialVersionUID = -2701131863705941250L;

        public BuildToolTipAction() {
            super(ExtKit.buildToolTipAction, 64);
            this.putValue("no-keybinding", Boolean.TRUE);
            this.putValue("ShortDescription", "");
        }

        protected String buildText(JTextComponent jTextComponent) {
            ToolTipSupport toolTipSupport = ExtUtilities.getExtEditorUI(jTextComponent).getToolTipSupport();
            return toolTipSupport != null ? jTextComponent.getToolTipText(toolTipSupport.getLastMouseEvent()) : jTextComponent.getToolTipText();
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            ToolTipSupport toolTipSupport;
            if (jTextComponent != null && (toolTipSupport = ExtUtilities.getExtEditorUI(jTextComponent).getToolTipSupport()) != null) {
                toolTipSupport.setToolTipText(this.buildText(jTextComponent));
            }
        }
    }

    public static class ShowPopupMenuAction
    extends BaseKitLocalizedAction {
        static final long serialVersionUID = 4257043398248915291L;

        public ShowPopupMenuAction() {
            super(ExtKit.showPopupMenuAction, 64);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                try {
                    ExtEditorUI extEditorUI;
                    int n = jTextComponent.getCaret().getDot();
                    Rectangle rectangle = jTextComponent.getUI().modelToView(jTextComponent, n);
                    if (rectangle != null && (extEditorUI = ExtUtilities.getExtEditorUI(jTextComponent)) != null) {
                        extEditorUI.showPopupMenu(rectangle.x, rectangle.y + rectangle.height);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class BuildPopupMenuAction
    extends BaseKitLocalizedAction {
        static final long serialVersionUID = 4257043398248915291L;

        public BuildPopupMenuAction() {
            super(ExtKit.buildPopupMenuAction, 64);
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (debugPopupMenu) {
                    System.err.println("POPUP CREATION START <<<<<");
                }
                JPopupMenu jPopupMenu = this.buildPopupMenu(jTextComponent);
                if (debugPopupMenu) {
                    System.err.println("POPUP CREATION END >>>>>");
                }
                ExtUtilities.getExtEditorUI(jTextComponent).setPopupMenu(jPopupMenu);
            }
        }

        protected JPopupMenu createPopupMenu(JTextComponent jTextComponent) {
            return new JPopupMenu();
        }

        protected JPopupMenu buildPopupMenu(JTextComponent jTextComponent) {
            JPopupMenu jPopupMenu = this.createPopupMenu(jTextComponent);
            EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
            List list = (List)Settings.getValue(Utilities.getKitClass(jTextComponent), editorUI == null || editorUI.hasExtComponent() ? "popup-menu-action-name-list" : "dialog-popup-menu-action-name-list");
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.addAction(jTextComponent, jPopupMenu, string);
                }
            }
            return jPopupMenu;
        }

        protected void addAction(JTextComponent jTextComponent, JPopupMenu jPopupMenu, String string) {
            Action action = Utilities.getKit(jTextComponent).getActionByName(string);
            if (action != null) {
                String string2;
                JMenuItem jMenuItem = null;
                if (action instanceof BaseAction) {
                    jMenuItem = ((BaseAction)action).getPopupMenuItem(jTextComponent);
                }
                if (jMenuItem == null && (string2 = this.getItemText(jTextComponent, string, action)) != null) {
                    Object object;
                    jMenuItem = new JMenuItem(string2);
                    jMenuItem.addActionListener(action);
                    Keymap keymap = jTextComponent.getKeymap();
                    if (keymap != null && (object = keymap.getKeyStrokesForAction(action)) != null && ((KeyStroke[])object).length > 0) {
                        jMenuItem.setAccelerator(object[0]);
                    }
                    jMenuItem.setEnabled(action.isEnabled());
                    object = action.getValue("helpID");
                    if (object != null && object instanceof String) {
                        jMenuItem.putClientProperty("HelpID", object);
                    }
                }
                if (jMenuItem != null) {
                    this.debugPopupMenuItem(jMenuItem, action);
                    jPopupMenu.add(jMenuItem);
                }
            } else if (string == null && jPopupMenu.getComponentCount() > 0) {
                this.debugPopupMenuItem(null, null);
                jPopupMenu.addSeparator();
            }
        }

        protected final void debugPopupMenuItem(JMenuItem jMenuItem, Action action) {
            if (debugPopupMenu) {
                StringBuffer stringBuffer = new StringBuffer("POPUP: ");
                if (jMenuItem != null) {
                    stringBuffer.append('\"');
                    stringBuffer.append(jMenuItem.getText());
                    stringBuffer.append('\"');
                    if (!jMenuItem.isVisible()) {
                        stringBuffer.append(", INVISIBLE");
                    }
                    if (action != null) {
                        stringBuffer.append(", action=");
                        stringBuffer.append(action.getClass().getName());
                    }
                } else {
                    stringBuffer.append("--Separator--");
                }
                System.err.println(stringBuffer.toString());
            }
        }

        protected String getItemText(JTextComponent jTextComponent, String string, Action action) {
            String string2 = action instanceof BaseAction ? ((BaseAction)action).getPopupMenuText(jTextComponent) : string;
            return string2;
        }
    }

    private static abstract class BaseKitLocalizedAction
    extends BaseAction {
        public BaseKitLocalizedAction(String string) {
            super(string);
        }

        public BaseKitLocalizedAction(String string, int n) {
            super(string, n);
        }

        protected Class getShortDescriptionBundleClass() {
            return class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = ExtKit.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit;
        }
    }
}

