/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.DrawLayerFactory;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FindSupport;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.FindDialogPanel;
import org.netbeans.editor.ext.KeyEventBlocker;
import org.openide.util.NbBundle;

public class FindDialogSupport
extends WindowAdapter
implements ActionListener {
    private static Object dialogLock = new Object();
    private static boolean isReplaceDialog = false;
    private static JButton[] findButtons;
    private static JButton[] findDialogButtons;
    private static JButton[] replaceDialogButtons;
    private static FindPanel findPanel;
    private static Dialog findDialog;
    private int caretPosition;
    private static FindDialogSupport singleton;
    private static PropertyChangeListener historyChangeListener;
    private boolean findPerformed = false;
    private static int xPos;
    private static int yPos;
    private static boolean dialogInvokedViaKeystroke;

    public static FindDialogSupport getFindDialogSupport() {
        if (singleton == null) {
            singleton = new FindDialogSupport();
        }
        return singleton;
    }

    private FindDialogSupport() {
    }

    private void createFindButtons() {
        if (findButtons == null) {
            ResourceBundle resourceBundle = NbBundle.getBundle((Class)BaseKit.class);
            findButtons = new JButton[]{new JButton(resourceBundle.getString("find-button-find")), new JButton(resourceBundle.getString("find-button-replace")), new JButton(resourceBundle.getString("find-button-replace-all")), new JButton(resourceBundle.getString("find-button-cancel"))};
            findButtons[0].setMnemonic(resourceBundle.getString("find-button-find-mnemonic").charAt(0));
            findButtons[1].setMnemonic(resourceBundle.getString("find-button-replace-mnemonic").charAt(0));
            findButtons[2].setMnemonic(resourceBundle.getString("find-button-replace-all-mnemonic").charAt(0));
            findButtons[0].getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_find-button-find"));
            findButtons[1].getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_find-button-replace"));
            findButtons[2].getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_find-button-replace-all"));
            findButtons[3].getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_find-button-cancel"));
            findDialogButtons = new JButton[2];
            FindDialogSupport.findDialogButtons[0] = findButtons[0];
            FindDialogSupport.findDialogButtons[1] = findButtons[3];
            replaceDialogButtons = new JButton[4];
            FindDialogSupport.replaceDialogButtons[0] = findButtons[0];
            FindDialogSupport.replaceDialogButtons[1] = findButtons[1];
            FindDialogSupport.replaceDialogButtons[2] = findButtons[2];
            FindDialogSupport.replaceDialogButtons[3] = findButtons[3];
        }
    }

    private void createFindPanel() {
        if (findPanel == null) {
            findPanel = new FindPanel();
        }
    }

    private Dialog createFindDialog(JPanel jPanel, JButton[] jButtonArray, ActionListener actionListener) {
        Dialog dialog = DialogSupport.createDialog(isReplaceDialog ? NbBundle.getBundle((Class)BaseKit.class).getString("replace-title") : NbBundle.getBundle((Class)BaseKit.class).getString("find-title"), jPanel, false, jButtonArray, true, 0, isReplaceDialog ? 3 : 1, actionListener);
        return dialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showFindDialogImpl(boolean bl, KeyEventBlocker keyEventBlocker) {
        dialogInvokedViaKeystroke = true;
        Object object = dialogLock;
        synchronized (object) {
            if (findDialog != null && isReplaceDialog != bl) {
                xPos = FindDialogSupport.findDialog.getLocation().x;
                yPos = FindDialogSupport.findDialog.getLocation().y;
                findDialog.dispose();
                findDialog = null;
            }
            if (findDialog == null) {
                isReplaceDialog = bl;
                this.createFindButtons();
                this.createFindPanel();
                findPanel.changeVisibility(bl);
                findDialog = this.createFindDialog(findPanel, bl ? replaceDialogButtons : findDialogButtons, this);
                findDialog.addWindowListener(this);
                ((JDialog)findDialog).getRootPane().setFocusable(false);
                if (xPos > Integer.MIN_VALUE) {
                    findDialog.setLocation(xPos, yPos);
                }
            }
        }
        findDialog.pack();
        findPanel.init(bl, keyEventBlocker);
        findDialog.setVisible(true);
        findPanel.showNotify();
        this.updateCaretPosition();
    }

    private void updateCaretPosition() {
        JTextComponent jTextComponent = Utilities.getLastActiveComponent();
        if (jTextComponent != null) {
            this.caretPosition = jTextComponent.getCaret().getDot();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.findPerformed = false;
        this.createFindPanel();
        FindDialogSupport.findPanel.initBlockSearch();
        this.updateCaretPosition();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        Map map = findPanel.getFindProps();
        JTextComponent jTextComponent = Utilities.getLastActiveComponent();
        if (jTextComponent != null) {
            boolean bl = this.getBooleanProp("find-block-search", map);
            if (bl && !this.findPerformed) {
                int n;
                Integer n2 = (Integer)map.get("find-block-search-start");
                int n3 = n2 == null ? -1 : n2;
                Position position = (Position)map.get("find-block-search-end");
                int n4 = n = position != null ? position.getOffset() : -1;
                if (n3 >= 0 && n > 0) {
                    jTextComponent.select(n3, n);
                }
            } else {
                EditorUI editorUI = ((BaseTextUI)jTextComponent.getUI()).getEditorUI();
                DrawLayerFactory.IncSearchLayer incSearchLayer = (DrawLayerFactory.IncSearchLayer)editorUI.findLayer("inc-search-layer");
                if (incSearchLayer != null && incSearchLayer.isEnabled()) {
                    int n = incSearchLayer.getOffset();
                    int n5 = incSearchLayer.getLength();
                    if (n5 > 0) {
                        jTextComponent.select(n, n + n5);
                    }
                }
            }
        }
        FindSupport.getFindSupport().incSearchReset();
        findPanel.resetBlockSearch();
        KeyEventBlocker keyEventBlocker = FindDialogSupport.findPanel.getBlocker();
        if (keyEventBlocker != null) {
            keyEventBlocker.stopBlocking(false);
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.hideDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowClosed(WindowEvent windowEvent) {
        Object object = dialogLock;
        synchronized (object) {
            if (findDialog != null) {
                xPos = FindDialogSupport.findDialog.getLocation().x;
                yPos = FindDialogSupport.findDialog.getLocation().y;
            }
        }
        object = findPanel.getFindProps();
        FindSupport.getFindSupport().incSearchReset();
        findPanel.resetBlockSearch();
        FindSupport.getFindSupport().setBlockSearchHighlight(0, 0);
        object.put("find-block-search", Boolean.FALSE);
        object.put("find-block-search-start", new Integer(0));
        object.put("find-block-search-end", null);
        FindSupport.getFindSupport().putFindProperties((Map)object);
        KeyEventBlocker keyEventBlocker = FindDialogSupport.findPanel.getBlocker();
        if (keyEventBlocker != null) {
            keyEventBlocker.stopBlocking(false);
        }
        Utilities.returnFocus();
    }

    public void showFindDialog(KeyEventBlocker keyEventBlocker) {
        this.showFindDialogImpl(false, keyEventBlocker);
    }

    public void showReplaceDialog(KeyEventBlocker keyEventBlocker) {
        this.showFindDialogImpl(true, keyEventBlocker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideDialog() {
        Object object = dialogLock;
        synchronized (object) {
            if (findDialog != null) {
                xPos = FindDialogSupport.findDialog.getLocation().x;
                yPos = FindDialogSupport.findDialog.getLocation().y;
                findDialog.dispose();
            }
            findDialog = null;
        }
    }

    private Vector getHistoryVector() {
        ArrayList arrayList = FindSupport.getFindSupport().getHistory();
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        boolean bl = (Boolean)findPanel.getFindProps().get("find-reg-exp");
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            FindSupport.SearchPatternWrapper searchPatternWrapper = (FindSupport.SearchPatternWrapper)arrayList.get(i);
            String string = searchPatternWrapper.getSearchExpression();
            if (bl != searchPatternWrapper.isRegExp() || vector.contains(string)) continue;
            vector.add(string);
        }
        return vector;
    }

    private boolean getBooleanProp(String string, Map map) {
        Boolean bl = (Boolean)map.get(string);
        return bl != null ? bl : false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (findButtons == null) {
            return;
        }
        Object object = actionEvent.getSource();
        FindSupport findSupport = FindSupport.getFindSupport();
        Map map = findPanel.getFindProps();
        FindSupport.SearchPatternWrapper searchPatternWrapper = new FindSupport.SearchPatternWrapper((String)map.get("find-what"), this.getBooleanProp("find-whole-words", map), this.getBooleanProp("find-match-case", map), this.getBooleanProp("find-reg-exp", map));
        if (object == findButtons[0]) {
            findSupport.addToHistory(searchPatternWrapper);
            findSupport.putFindProperties(map);
            findSupport.find(null, false);
            this.updateCaretPosition();
            this.findPerformed = true;
        } else if (object == findButtons[1]) {
            findSupport.addToHistory(searchPatternWrapper);
            findPanel.updateReplaceHistory();
            findSupport.putFindProperties(map);
            try {
                if (findSupport.replace(null, false)) {
                    findSupport.find(null, false);
                }
            }
            catch (GuardedException guardedException) {
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            this.updateCaretPosition();
            this.findPerformed = true;
        } else if (object == findButtons[2]) {
            findSupport.addToHistory(searchPatternWrapper);
            findPanel.updateReplaceHistory();
            findSupport.putFindProperties(map);
            findSupport.replaceAll(null);
            this.findPerformed = true;
        } else if (object == findButtons[3]) {
            this.hideDialog();
        }
    }

    private int getBlockEndOffset() {
        Position position = (Position)FindSupport.getFindSupport().getFindProperties().get("find-block-search-end");
        return position != null ? position.getOffset() : -1;
    }

    static {
        findDialog = null;
        singleton = null;
        xPos = Integer.MIN_VALUE;
        yPos = Integer.MIN_VALUE;
    }

    private class FindPanel
    extends FindDialogPanel
    implements ItemListener,
    KeyListener,
    ActionListener,
    FocusListener {
        private Map findProps = Collections.synchronizedMap(new HashMap(20));
        private Map objToProps = Collections.synchronizedMap(new HashMap(20));
        private DefaultComboBoxModel findHistory = new DefaultComboBoxModel();
        private DefaultComboBoxModel replaceHistory = new DefaultComboBoxModel();
        private KeyEventBlocker blocker;
        private int blockSearchStartPos = 0;
        private int blockSearchEndPos = 0;

        FindPanel() {
            this.objToProps.put(this.findWhat, "find-what");
            this.objToProps.put(this.replaceWith, "find-replace-with");
            this.objToProps.put(this.highlightSearch, "find-highlight-search");
            this.objToProps.put(this.incSearch, "find-inc-search");
            this.objToProps.put(this.matchCase, "find-match-case");
            this.objToProps.put(this.wholeWords, "find-whole-words");
            this.objToProps.put(this.regExp, "find-reg-exp");
            this.objToProps.put(this.bwdSearch, "find-backward-search");
            this.objToProps.put(this.wrapSearch, "find-wrap-search");
            this.objToProps.put(this.blockSearch, "find-block-search");
            this.findProps.putAll(FindSupport.getFindSupport().getFindProperties());
            this.revertMap();
            this.findWhat.setModel(this.findHistory);
            this.findWhat.getEditor().setItem(this.getProperty(this.findWhat));
            this.replaceWith.setModel(this.replaceHistory);
            this.replaceWith.getEditor().setItem(this.getProperty(this.replaceWith));
            this.highlightSearch.setSelected(this.getBooleanProperty(this.highlightSearch));
            this.incSearch.setSelected(this.getBooleanProperty(this.incSearch));
            this.matchCase.setSelected(this.getBooleanProperty(this.matchCase));
            this.wholeWords.setSelected(this.getBooleanProperty(this.wholeWords));
            this.regExp.setSelected(this.getBooleanProperty(this.regExp));
            this.bwdSearch.setSelected(this.getBooleanProperty(this.bwdSearch));
            this.wrapSearch.setSelected(this.getBooleanProperty(this.wrapSearch));
            this.findWhat.getEditor().getEditorComponent().addKeyListener(this);
            this.findWhat.addActionListener(this);
            this.replaceWith.getEditor().getEditorComponent().addKeyListener(this);
            this.replaceWith.addActionListener(this);
            this.highlightSearch.addItemListener(this);
            this.incSearch.addItemListener(this);
            this.matchCase.addItemListener(this);
            this.wholeWords.addItemListener(this);
            this.regExp.addItemListener(this);
            this.bwdSearch.addItemListener(this);
            this.wrapSearch.addItemListener(this);
            this.blockSearch.addItemListener(this);
            historyChangeListener = new PropertyChangeListener(this){
                private final /* synthetic */ FindPanel this$1;
                {
                    this.this$1 = findPanel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent == null || !"find-history-changed-prop".equals(propertyChangeEvent.getPropertyName())) {
                        return;
                    }
                    this.this$1.updateFindHistory();
                }
            };
            FindSupport.getFindSupport().addPropertyChangeListener(historyChangeListener);
        }

        protected Map getFindProps() {
            return this.findProps;
        }

        private KeyEventBlocker getBlocker() {
            return this.blocker;
        }

        private void putProperty(Object object, Object object2) {
            String string = (String)this.objToProps.get(object);
            if (string != null) {
                this.findProps.put(string, object2);
            }
        }

        private Object getProperty(Object object) {
            String string = (String)this.objToProps.get(object);
            return string != null ? this.findProps.get(string) : null;
        }

        private boolean getBooleanProperty(Object object) {
            Object object2 = this.getProperty(object);
            return object2 != null ? (Boolean)object2 : false;
        }

        protected void changeVisibility(boolean bl) {
            this.replaceWith.setVisible(bl);
            this.replaceWithLabel.setVisible(bl);
        }

        public void resetBlockSearch() {
            this.blockSearch.setSelected(false);
            this.blockSearch.setEnabled(false);
            this.findProps.put("find-block-search", Boolean.FALSE);
            this.findProps.put("find-block-search-start", new Integer(0));
            this.findProps.put("find-block-search-end", null);
            this.blockSearchStartPos = 0;
            this.blockSearchEndPos = 0;
            FindSupport.getFindSupport().setBlockSearchHighlight(0, 0);
            FindSupport.getFindSupport().putFindProperties(this.findProps);
        }

        private void initBlockSearch() {
            JTextComponent jTextComponent = Utilities.getLastActiveComponent();
            String string = null;
            int n = 0;
            int n2 = 0;
            boolean bl = false;
            if (jTextComponent != null) {
                n = jTextComponent.getSelectionStart();
                n2 = jTextComponent.getSelectionEnd();
                Document document = jTextComponent.getDocument();
                if (document instanceof BaseDocument) {
                    BaseDocument baseDocument = (BaseDocument)document;
                    try {
                        int n3 = Utilities.getLineOffset(baseDocument, n);
                        int n4 = Utilities.getLineOffset(baseDocument, n2);
                        if (n4 > n3) {
                            bl = true;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                FindDialogSupport.this.caretPosition = this.bwdSearch.isSelected() ? jTextComponent.getSelectionEnd() : jTextComponent.getSelectionStart();
                if (!bl && dialogInvokedViaKeystroke) {
                    dialogInvokedViaKeystroke = false;
                    string = jTextComponent.getSelectedText();
                    if (string != null) {
                        int n5 = string.indexOf(10);
                        if (n5 >= 0) {
                            string = string.substring(0, n5);
                        }
                        this.findWhat.getEditor().setItem(string);
                        this.changeFindWhat(true);
                    }
                }
                this.blockSearchStartPos = bl ? n : 0;
                this.blockSearchEndPos = bl ? n2 : 0;
                try {
                    this.blockSearch.setEnabled(bl);
                    this.blockSearch.setSelected(bl);
                    this.findProps.put("find-block-search", bl);
                    this.findProps.put("find-block-search-start", new Integer(this.blockSearchStartPos));
                    int n6 = FindDialogSupport.this.getBlockEndOffset();
                    if (n6 < 0) {
                        this.findProps.put("find-block-search-end", document.createPosition(this.blockSearchEndPos));
                    } else {
                        this.blockSearchEndPos = n6;
                    }
                    FindSupport.getFindSupport().setBlockSearchHighlight(this.blockSearchStartPos, this.blockSearchEndPos);
                }
                catch (BadLocationException badLocationException) {
                    this.blockSearch.setSelected(false);
                    this.findProps.put("find-block-search", Boolean.FALSE);
                    this.findProps.put("find-block-search-start", null);
                }
            }
        }

        protected void init(boolean bl, KeyEventBlocker keyEventBlocker) {
            this.blocker = keyEventBlocker;
            this.findHistory.setSelectedItem(null);
            this.replaceHistory.setSelectedItem(null);
            this.findWhat.getEditor().getEditorComponent().addFocusListener(this);
            if (bl) {
                this.replaceWith.getEditor().getEditorComponent().addFocusListener(this);
            }
            this.findProps.putAll(FindSupport.getFindSupport().getFindProperties());
            this.revertMap();
            this.highlightSearch.setSelected(this.getBooleanProperty(this.highlightSearch));
            this.incSearch.setSelected(this.getBooleanProperty(this.incSearch));
            this.matchCase.setSelected(this.getBooleanProperty(this.matchCase));
            this.wholeWords.setSelected(this.getBooleanProperty(this.wholeWords));
            boolean bl2 = this.getBooleanProperty(this.regExp);
            this.regExp.setSelected(bl2);
            this.wholeWords.setEnabled(!bl2);
            this.incSearch.setEnabled(!bl2);
            this.bwdSearch.setSelected(this.getBooleanProperty(this.bwdSearch));
            this.wrapSearch.setSelected(this.getBooleanProperty(this.wrapSearch));
            this.findHistory = new DefaultComboBoxModel(FindDialogSupport.this.getHistoryVector());
            this.findWhat.setModel(this.findHistory);
        }

        protected void showNotify() {
            boolean bl = this.findWhat.getEditor().getEditorComponent().requestFocusInWindow();
            if (!bl) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ FindPanel this$1;
                    {
                        this.this$1 = findPanel;
                    }

                    public void run() {
                        this.this$1.findWhat.getEditor().getEditorComponent().requestFocusInWindow();
                    }
                });
            }
        }

        private void updateHistory(JComboBox jComboBox, DefaultComboBoxModel defaultComboBoxModel) {
            Object object = jComboBox.getEditor().getItem();
            if (object != null && !object.equals("")) {
                defaultComboBoxModel.removeElement(object);
                defaultComboBoxModel.insertElementAt(object, 0);
                defaultComboBoxModel.setSelectedItem(null);
            }
            jComboBox.getEditor().setItem(object);
        }

        protected void updateFindHistory() {
            Object object = this.findWhat.getEditor().getItem();
            this.findHistory = new DefaultComboBoxModel(FindDialogSupport.this.getHistoryVector());
            this.findWhat.setModel(this.findHistory);
            if (object != null) {
                this.findWhat.getEditor().setItem(object);
            }
        }

        protected void updateReplaceHistory() {
            this.updateHistory(this.replaceWith, this.replaceHistory);
        }

        private void revertMap() {
            Object v = this.findProps.get("revert-map");
            if (!(v instanceof Map)) {
                return;
            }
            Map map = (Map)v;
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                boolean bl;
                String string = (String)iterator.next();
                Object v2 = this.findProps.get(string);
                boolean bl2 = bl = v2 != null ? (Boolean)v2 : false;
                if (bl != (Boolean)map.get(string)) {
                    // empty if block
                }
                this.findProps.put(string, bl ? Boolean.FALSE : Boolean.TRUE);
            }
            this.findProps.put("revert-map", null);
        }

        private void changeFindWhat(boolean bl) {
            Object object = this.getProperty(this.findWhat);
            Object object2 = this.findWhat.getEditor().getItem();
            if (object == null && object2 != null && !object2.equals("") || object != null && !object.equals(object2)) {
                this.putProperty(this.findWhat, object2);
                if (bl) {
                    FindDialogSupport.this.findPerformed = FindSupport.getFindSupport().incSearch(this.getFindProps(), FindDialogSupport.this.caretPosition);
                }
            }
        }

        private void changeReplaceWith() {
            Object object = this.getProperty(this.replaceWith);
            Object object2 = this.replaceWith.getEditor().getItem();
            if (object == null && object2 != null && !object2.equals("") || object != null && !object.equals(object2)) {
                this.putProperty(this.replaceWith, object2);
            }
        }

        private void postChangeCombos(boolean bl) {
            SwingUtilities.invokeLater(new Runnable(this, bl){
                private final /* synthetic */ boolean val$performIncSearch;
                private final /* synthetic */ FindPanel this$1;
                {
                    this.this$1 = findPanel;
                    this.val$performIncSearch = bl;
                }

                public void run() {
                    FindPanel.access$800(this.this$1, this.val$performIncSearch);
                    FindPanel.access$900(this.this$1);
                }
            });
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                keyEvent.consume();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                keyEvent.consume();
            } else if (keyEvent.getKeyCode() == 155) {
                this.postChangeCombos(true);
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                findButtons[0].doClick(20);
                keyEvent.consume();
                ((JComboBox)((JTextField)keyEvent.getSource()).getParent()).hidePopup();
            } else {
                this.postChangeCombos(true);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            JTextComponent jTextComponent;
            boolean bl;
            Boolean bl2;
            Boolean bl3 = bl2 = itemEvent.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
            if (itemEvent.getItem() == this.bwdSearch && this.blockSearch.isEnabled() && this.blockSearch.isSelected()) {
                bl = bl2;
                jTextComponent = Utilities.getLastActiveComponent();
                if (jTextComponent != null) {
                    jTextComponent.getCaret().setDot(bl ? this.blockSearchEndPos : this.blockSearchStartPos);
                    FindDialogSupport.this.updateCaretPosition();
                }
            }
            if (itemEvent.getItem() == this.regExp) {
                bl = bl2 == false;
                this.incSearch.setEnabled(bl);
                this.wholeWords.setEnabled(bl);
            }
            if (itemEvent.getItem() == this.blockSearch) {
                bl = bl2;
                if (bl) {
                    if (this.blockSearchStartPos <= 0 && this.blockSearchEndPos <= 0) {
                        this.initBlockSearch();
                    } else {
                        jTextComponent = Utilities.getLastActiveComponent();
                        if (jTextComponent != null) {
                            jTextComponent.getCaret().setDot(this.bwdSearch.isSelected() ? this.blockSearchEndPos : this.blockSearchStartPos);
                            FindDialogSupport.this.updateCaretPosition();
                        }
                    }
                    FindSupport.getFindSupport().setBlockSearchHighlight(this.blockSearchStartPos, this.blockSearchEndPos);
                } else {
                    FindSupport.getFindSupport().putFindProperty("find-block-search", Boolean.FALSE);
                    FindSupport.getFindSupport().setBlockSearchHighlight(0, 0);
                }
            }
            this.putProperty(itemEvent.getSource(), bl2);
            if (itemEvent.getItem() == this.regExp) {
                this.updateFindHistory();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.postChangeCombos(false);
        }

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() instanceof JTextField) {
                ((JTextField)focusEvent.getSource()).selectAll();
                if (this.blocker != null) {
                    this.blocker.stopBlocking();
                }
            }
            ((JComponent)focusEvent.getSource()).removeFocusListener(this);
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        static /* synthetic */ void access$800(FindPanel findPanel, boolean bl) {
            findPanel.changeFindWhat(bl);
        }

        static /* synthetic */ void access$900(FindPanel findPanel) {
            findPanel.changeReplaceWith();
        }
    }
}

