/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.view;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.view.spi.EstimatedSpanView;
import org.netbeans.editor.view.spi.ViewInsets;
import org.netbeans.editor.view.spi.ViewLayoutState;
import org.netbeans.lib.editor.util.swing.ElementUtilities;
import org.netbeans.lib.editor.view.GapBoxViewChildren;
import org.netbeans.lib.editor.view.SimpleViewLayoutState;
import org.netbeans.lib.editor.view.ViewUtilitiesImpl;

public class GapBoxView
extends View
implements ViewLayoutState.Parent,
ViewLayoutState,
EstimatedSpanView {
    private static final boolean debugRebuild = Boolean.getBoolean("netbeans.debug.editor.view.rebuild");
    private static final int X_MAJOR_AXIS_BIT = 1;
    private static final int MAJOR_AXES_ORTHOGONAL_BIT = 2;
    private static final int MAJOR_AXIS_PREFERENCE_CHANGED_BIT = 4;
    private static final int MINOR_AXIS_PREFERENCE_CHANGED_BIT = 8;
    private static final int CHILDREN_LAYOUT_NECESSARY_BIT = 16;
    private static final int REPAINT_PENDING_BIT = 32;
    private static final int REPAINT_TILL_END_BIT = 64;
    private static final int ESTIMATED_SPAN_BIT = 128;
    private static final int UPDATE_LAYOUT_IN_PROGRESS = 256;
    private static final int ACTIVE_LAYOUT_STATE = 512;
    private static final int LAYOUT_STATE_X_MAJOR_AXIS_BIT = 1024;
    private static final int LAYOUT_STATE_VIEW_SIZE_INVALID_BIT = 2048;
    protected static final int GAP_BOX_VIEW_LAST_USED_STATUS_BIT = 2048;
    private static final int LAYOUT_STATE_ANY_INVALID = 2092;
    private int statusBits;
    private GapBoxViewChildren children;
    private double layoutStateMajorAxisRawOffset;
    private int viewRawIndex;
    private float lastMajorAxisPreferredSpan;
    private float lastMinorAxisPreferredSpan;
    private float minorAxisAssignedSpan;

    public GapBoxView(Element element, int n) {
        super(element);
        if (n == 0) {
            this.setStatusBits(1);
        }
    }

    public float getPreferredSpan(int n) {
        return n == this.getMajorAxis() ? (float)this.getMajorAxisPreferredSpan() : this.getMinorAxisPreferredSpan();
    }

    public float getMinimumSpan(int n) {
        return this.getPreferredSpan(n);
    }

    public float getMaximumSpan(int n) {
        return this.getPreferredSpan(n);
    }

    public float getAlignment(int n) {
        return 0.0f;
    }

    public ViewInsets getInsets() {
        return null;
    }

    final double getMajorAxisPreferredSpan() {
        return this.children != null ? this.children.getMajorAxisPreferredSpan() + (double)this.getMajorAxisInsetSpan() : (double)this.lastMajorAxisPreferredSpan;
    }

    final float getMinorAxisPreferredSpan() {
        return this.children != null ? this.children.getMinorAxisPreferredSpan() + this.getMinorAxisInsetSpan() : this.lastMinorAxisPreferredSpan;
    }

    final float getMinorAxisAssignedSpan() {
        return this.minorAxisAssignedSpan;
    }

    public final int getMajorAxis() {
        return this.isXMajorAxis() ? 0 : 1;
    }

    public final int getMinorAxis() {
        return this.isXMajorAxis() ? 1 : 0;
    }

    final boolean isXMajorAxis() {
        return this.isStatusBitsNonZero(1);
    }

    final boolean isMajorAxesOrthogonal() {
        return this.isStatusBitsNonZero(2);
    }

    public int getViewCount() {
        return this.getChildren().getChildCount();
    }

    public View getView(int n) {
        return this.getChild(n).getView();
    }

    public void replace(int n, int n2, View[] viewArray) {
        if (n2 < 0) {
            throw new IllegalArgumentException("length=" + n2 + " < 0");
        }
        if (n2 == 0 && (viewArray == null || viewArray.length == 0)) {
            return;
        }
        GapBoxViewChildren gapBoxViewChildren = this.getChildren();
        gapBoxViewChildren.replace(n, n2, viewArray);
    }

    protected int getReplaceEstimatedThreshold() {
        return Integer.MAX_VALUE;
    }

    public final boolean isEstimatedSpan() {
        return this.isStatusBitsNonZero(128);
    }

    public void setEstimatedSpan(boolean bl) {
        if (this.isEstimatedSpan() != bl) {
            if (bl) {
                this.setStatusBits(128);
            } else {
                int n;
                this.clearStatusBits(128);
                if (this.children != null && (n = this.getViewCount()) > 0) {
                    this.resetEstimatedSpan(0, n);
                }
            }
        }
    }

    protected void resetEstimatedSpan(int n, int n2) {
        while (--n2 >= 0) {
            ViewLayoutState viewLayoutState = this.getChild(n);
            View view = viewLayoutState.getView();
            if (view instanceof EstimatedSpanView) {
                ((EstimatedSpanView)((Object)view)).setEstimatedSpan(false);
            }
            ++n;
        }
    }

    public void rebuild(int n, int n2) {
        if (n2 != 0) {
            int n3;
            int n4 = n == 0 ? -1 : this.getView(n - 1).getEndOffset();
            int n5 = this.getViewCount();
            int n6 = Math.min(n + n2, n5);
            int n7 = n3 = n6 == n5 ? -1 : this.getView(n6).getStartOffset();
            if (debugRebuild) {
                System.err.println("GapBoxView.rebuild(): index=" + n + ", count=" + n2 + ", so=" + n4 + ", eo=" + n3);
            }
            this.reloadChildren(n, n2, n4, n3);
        }
    }

    public void offsetRebuild(int n, int n2) {
        int n3;
        int n4 = ViewUtilitiesImpl.findLowerViewIndex(this, n, false);
        if (n4 == -1) {
            n4 = 0;
            n3 = 0;
        } else {
            n3 = ViewUtilitiesImpl.findUpperViewIndex(this, n2, true) - n4 + 1;
        }
        this.rebuild(n4, n3);
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view != null) {
            if (view instanceof ViewLayoutState.Parent) {
                this.setStatusBits(512);
            } else {
                this.clearStatusBits(512);
            }
            this.getChildren();
        } else {
            this.releaseChildren();
            this.clearStatusBits(512);
        }
    }

    public final boolean isActiveLayoutState() {
        return this.isStatusBitsNonZero(512);
    }

    protected GapBoxViewChildren getChildren() {
        if (this.children == null) {
            this.children = this.createChildren();
            View view = this.getParent();
            if (view != null) {
                this.reloadChildren(0, 0, -1, -1);
            }
        }
        return this.children;
    }

    protected final GapBoxViewChildren getChildrenNull() {
        return this.children;
    }

    public void releaseChildren() {
        if (this.children != null) {
            this.unloadChildren();
            this.children.unload();
            this.children = null;
        }
    }

    public final View getView() {
        return this;
    }

    public ViewLayoutState selectLayoutMajorAxis(int n) {
        if (n == 0) {
            this.setStatusBits(1024);
        } else {
            this.clearStatusBits(1024);
        }
        if (n == this.getMajorAxis()) {
            this.clearStatusBits(2);
        } else {
            this.setStatusBits(2);
        }
        return this;
    }

    public boolean isFlyweight() {
        return false;
    }

    public void updateLayout() {
        double d;
        if (this.isLayoutValid()) {
            return;
        }
        if (this.isStatusBitsNonZero(256)) {
            return;
        }
        this.setStatusBits(256);
        View view = this.getParent();
        if (view == null) {
            return;
        }
        ViewLayoutState.Parent parent = view instanceof ViewLayoutState.Parent ? (ViewLayoutState.Parent)((Object)view) : null;
        this.children.childrenUpdateLayout();
        if (this.isChildrenLayoutNecessary()) {
            this.resetChildrenLayoutNecessary();
            this.children.childrenLayout();
        }
        boolean bl = false;
        boolean bl2 = this.isMajorAxisPreferenceChanged();
        boolean bl3 = this.isMinorAxisPreferenceChanged();
        this.resetAxesPreferenceChanged();
        if (bl2 && this.children != null && (d = this.updateLastMajorAxisPreferredSpan()) != 0.0 && parent != null) {
            if (this.isMajorAxesOrthogonal()) {
                parent.minorAxisPreferenceChanged(this);
            } else {
                parent.majorAxisPreferenceChanged(this, d);
                bl = true;
            }
        }
        if (bl3 && this.children != null && (d = this.updateLastMinorAxisPreferredSpan()) != 0.0 && parent != null) {
            if (this.isMajorAxesOrthogonal()) {
                parent.majorAxisPreferenceChanged(this, d);
                bl = true;
            } else {
                parent.minorAxisPreferenceChanged(this);
            }
        }
        if (bl2 || bl3 || !this.isActiveLayoutState()) {
            boolean bl4 = false;
            boolean bl5 = false;
            if (this.isXMajorAxis()) {
                bl4 = bl2;
                bl5 = bl3;
            } else {
                bl4 = bl3;
                bl5 = bl2;
            }
            view.preferenceChanged(this, bl4, bl5);
        }
        if (this.isStatusBitsNonZero(2048)) {
            this.clearStatusBits(2048);
            if (parent != null) {
                float f;
                float f2;
                float f3 = this.getPreferredSpan(this.getLayoutStateMajorAxis());
                float f4 = parent.getMinorAxisSpan(this);
                if (this.isXLayoutStateMajorAxis()) {
                    f2 = f3;
                    f = f4;
                } else {
                    f2 = f4;
                    f = f3;
                }
                this.setSize(f2, f);
            }
        }
        if (this.children != null && this.isRepaintPending()) {
            if (!bl) {
                this.processRepaint(parent);
            }
            this.resetRepaintPending();
        }
        this.clearStatusBits(256);
        this.updateLayout();
    }

    protected void updateLayout(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape) {
    }

    public void layoutInvalid(ViewLayoutState viewLayoutState) {
        int n = this.children.getChildIndexNoCheck(viewLayoutState);
        this.children.markLayoutInvalid(n, 1);
    }

    protected void markLayoutInvalid() {
        if (this.isActiveLayoutState()) {
            ((ViewLayoutState.Parent)((Object)this.getParent())).layoutInvalid(this);
        } else {
            this.directUpdateLayout();
        }
    }

    protected void directUpdateLayout() {
        this.updateLayout();
    }

    protected void processRepaint(ViewLayoutState.Parent parent) {
        if (parent != null) {
            float f;
            float f2;
            double d;
            double d2;
            int n = this.children.getFirstRepaintChildIndex();
            double d3 = this.children.getMajorAxisOffset(n);
            if (this.isRepaintTillEnd() || n >= this.getViewCount()) {
                if (this.isMajorAxesOrthogonal()) {
                    d2 = 0.0;
                    d = 0.0;
                    f2 = (float)d3;
                    f = 0.0f;
                } else {
                    d2 = d3;
                    d = 0.0;
                    f2 = 0.0f;
                    f = 0.0f;
                }
            } else {
                double d4 = this.getChild(n).getLayoutMajorAxisPreferredSpan();
                if (this.isMajorAxesOrthogonal()) {
                    d2 = 0.0;
                    d = 0.0;
                    f2 = (float)d3;
                    f = (float)d4;
                } else {
                    d2 = d3;
                    d = d4;
                    f2 = 0.0f;
                    f = 0.0f;
                }
            }
            parent.repaint(this, d2, d, f2, f);
        } else {
            Container container = this.getContainer();
            if (container != null) {
                container.repaint();
            }
        }
    }

    protected boolean markRepaint(int n, boolean bl) {
        boolean bl2 = false;
        if (this.children != null) {
            int n2 = this.children.getFirstRepaintChildIndex();
            if (!this.isRepaintTillEnd()) {
                if (n2 == -1) {
                    bl2 = true;
                    this.markRepaintPending();
                    this.children.setFirstRepaintChildIndex(n);
                    if (bl) {
                        this.setStatusBits(64);
                    }
                } else if (n2 != n) {
                    if (n < n2) {
                        bl2 = true;
                        this.children.setFirstRepaintChildIndex(n);
                    }
                    this.setStatusBits(64);
                } else if (bl) {
                    this.setStatusBits(64);
                }
            } else if (n < n2) {
                bl2 = true;
                this.children.setFirstRepaintChildIndex(n);
            }
        }
        return bl2;
    }

    public final boolean isRepaintPending() {
        return this.isStatusBitsNonZero(32);
    }

    protected final void markRepaintPending() {
        this.setStatusBits(32);
    }

    protected void resetRepaintPending() {
        if (this.children != null) {
            this.children.setFirstRepaintChildIndex(-1);
        }
        this.clearStatusBits(96);
    }

    public final boolean isRepaintTillEnd() {
        return this.isStatusBitsNonZero(64);
    }

    protected boolean isLayoutMinorAxisPreferenceChanged(boolean bl) {
        double d = bl ? this.updateLastMajorAxisPreferredSpan() : this.updateLastMinorAxisPreferredSpan();
        return d != 0.0;
    }

    private double updateLastMinorAxisPreferredSpan() {
        float f = this.children.getMinorAxisPreferredSpan();
        double d = f - this.lastMinorAxisPreferredSpan;
        this.lastMinorAxisPreferredSpan = f;
        return d;
    }

    private double updateLastMajorAxisPreferredSpan() {
        double d = this.children.getMajorAxisPreferredSpan();
        double d2 = d - (double)this.lastMajorAxisPreferredSpan;
        this.lastMajorAxisPreferredSpan = (float)d;
        return d2;
    }

    public boolean isLayoutValid() {
        return !this.isStatusBitsNonZero(2092) && (this.children == null || this.children.getUpdateLayoutChildCount() == 0);
    }

    public double getLayoutMajorAxisPreferredSpan() {
        return this.isMajorAxesOrthogonal() ? (double)this.lastMinorAxisPreferredSpan : (double)this.lastMajorAxisPreferredSpan;
    }

    public float getLayoutMinorAxisPreferredSpan() {
        return this.isMajorAxesOrthogonal() ? this.lastMajorAxisPreferredSpan : this.lastMinorAxisPreferredSpan;
    }

    public float getLayoutMinorAxisMinimumSpan() {
        return this.getLayoutMinorAxisPreferredSpan();
    }

    public float getLayoutMinorAxisMaximumSpan() {
        return this.getLayoutMinorAxisPreferredSpan();
    }

    public float getLayoutMinorAxisAlignment() {
        return this.getAlignment(this.getLayoutStateMinorAxis());
    }

    public double getLayoutMajorAxisRawOffset() {
        return this.layoutStateMajorAxisRawOffset;
    }

    public void setLayoutMajorAxisRawOffset(double d) {
        this.layoutStateMajorAxisRawOffset = d;
    }

    protected final ViewLayoutState.Parent getLayoutStateParent() {
        View view = this.getParent();
        return view instanceof ViewLayoutState.Parent ? (ViewLayoutState.Parent)((Object)view) : null;
    }

    protected final boolean isXLayoutStateMajorAxis() {
        return this.isStatusBitsNonZero(1024);
    }

    protected final int getLayoutStateMajorAxis() {
        return this.isStatusBitsNonZero(1024) ? 0 : 1;
    }

    protected final int getLayoutStateMinorAxis() {
        return this.isStatusBitsNonZero(1024) ? 1 : 0;
    }

    public int getViewRawIndex() {
        return this.viewRawIndex;
    }

    public void setViewRawIndex(int n) {
        this.viewRawIndex = n;
    }

    public void viewPreferenceChanged(boolean bl, boolean bl2) {
        this.markViewSizeInvalid();
    }

    public void markViewSizeInvalid() {
        this.setStatusBits(2048);
    }

    public void majorAxisPreferenceChanged(ViewLayoutState viewLayoutState, double d) {
        int n = this.getChildIndexNoCheck(viewLayoutState);
        if (d != 0.0) {
            this.markRepaint(n, true);
            this.children.majorAxisPreferenceChanged(viewLayoutState, n, d);
        } else {
            this.markRepaint(n, false);
        }
    }

    public void minorAxisPreferenceChanged(ViewLayoutState viewLayoutState) {
        int n = this.getChildIndexNoCheck(viewLayoutState);
        this.markRepaint(n, false);
        this.children.minorAxisPreferenceChanged(viewLayoutState, n);
    }

    public float getMinorAxisSpan(ViewLayoutState viewLayoutState) {
        return this.getChildren().getMinorAxisSpan(viewLayoutState);
    }

    public void repaint(ViewLayoutState viewLayoutState, double d, double d2, float f, float f2) {
        int n = this.getChildIndexNoCheck(viewLayoutState);
        this.markRepaint(n, false);
    }

    public final boolean isChildrenLayoutNecessary() {
        return this.isStatusBitsNonZero(16);
    }

    public final void markChildrenLayoutNecessary() {
        this.setStatusBits(16);
    }

    final void resetChildrenLayoutNecessary() {
        this.clearStatusBits(16);
    }

    public void preferenceChanged(View view, boolean bl, boolean bl2) {
        if (view == null) {
            this.getParent().preferenceChanged(this, bl, bl2);
        } else {
            int n = view instanceof ViewLayoutState ? this.getChildIndexNoCheck((ViewLayoutState)((Object)view)) : this.getViewIndex(view.getStartOffset());
            ViewLayoutState viewLayoutState = this.getChild(n);
            if (viewLayoutState.getView() != view) {
                int n2;
                for (n2 = this.getViewCount() - 1; n2 >= 0 && this.getView(n2) != view; --n2) {
                }
                if (n2 == -1) {
                    throw new IllegalArgumentException("childView=" + view + " not child of view " + this);
                }
                throw new IllegalStateException("Internal error. Child expected at index=" + n + " but found at index=" + n2);
            }
            viewLayoutState.viewPreferenceChanged(bl, bl2);
            this.children.markLayoutInvalid(n, 1);
        }
    }

    public void setSize(float f, float f2) {
        float f3;
        float f4;
        if (this.isXMajorAxis()) {
            f4 = f;
            f3 = f2;
        } else {
            f4 = f2;
            f3 = f;
        }
        this.setSpanOnMajorAxis(f4);
        this.setSpanOnMinorAxis(f3);
    }

    protected void setSpanOnMajorAxis(float f) {
    }

    protected void setSpanOnMinorAxis(float f) {
        if (f != this.minorAxisAssignedSpan) {
            int n;
            this.minorAxisAssignedSpan = f;
            if (!this.isEstimatedSpan() && !this.isChildrenResizeDisabled() && (n = this.getViewCount()) != 0) {
                this.markSizeInvalid(0, n);
            }
        }
    }

    protected void markSizeInvalid(int n, int n2) {
        while (--n2 >= 0) {
            ViewLayoutState viewLayoutState = this.getChild(n);
            if (!viewLayoutState.isFlyweight()) {
                viewLayoutState.markViewSizeInvalid();
            }
            ++n;
        }
        this.children.markLayoutInvalid(n, n2);
    }

    protected boolean isChildrenResizeDisabled() {
        return false;
    }

    public Shape getChildAllocation(int n, Shape shape) {
        if (shape == null) {
            return null;
        }
        Rectangle rectangle = this.reallocate(shape);
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        this.getChildren().getChildCoreAllocation(n, rectangle);
        rectangle.x += n2;
        rectangle.y += n3;
        ViewInsets viewInsets = this.getInsets();
        if (viewInsets != null) {
            rectangle.x = (int)((float)rectangle.x + viewInsets.getLeft());
            rectangle.y = (int)((float)rectangle.y + viewInsets.getRight());
        }
        return rectangle;
    }

    public int getViewIndexAtPoint(float f, float f2, Shape shape) {
        Rectangle rectangle = this.reallocate(shape);
        f -= (float)rectangle.x;
        f2 -= (float)rectangle.y;
        ViewInsets viewInsets = this.getInsets();
        if (viewInsets != null) {
            f -= viewInsets.getLeft();
            f2 -= viewInsets.getRight();
        }
        return this.getChildren().getChildIndexAtCorePoint(f, f2);
    }

    public int getViewIndex(int n, Position.Bias bias) {
        if (bias == Position.Bias.Backward) {
            --n;
        }
        return this.getViewIndex(n);
    }

    public int getViewIndex(int n) {
        return ViewUtilitiesImpl.findViewIndexBounded(this, n);
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = this.reallocate(shape);
        this.getChildren().paintChildren(graphics, rectangle);
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        Shape shape2;
        int n2 = this.getViewIndex(n, bias);
        if (n2 >= 0) {
            Shape shape3 = this.getChildAllocation(n2, shape);
            ViewLayoutState viewLayoutState = this.getChild(n2);
            View view = viewLayoutState.getView();
            shape2 = view.modelToView(n, shape3, bias);
        } else {
            shape2 = null;
        }
        return shape2;
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        int n;
        int n2 = this.getViewIndexAtPoint(f, f2, shape);
        if ((n2 = Math.max(n2, 0)) < this.getViewCount()) {
            Shape shape2 = this.getChildAllocation(n2, shape);
            ViewLayoutState viewLayoutState = this.getChild(n2);
            View view = viewLayoutState.getView();
            n = view.viewToModel(f, f2, shape2, biasArray);
        } else {
            int n3 = this.getEndOffset();
            Document document = this.getDocument();
            n = document != null && document.getLength() < n3 ? document.getLength() : n3;
        }
        return n;
    }

    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        return ViewUtilitiesImpl.getNextVisualPositionFrom(this, n, bias, shape, n2, biasArray);
    }

    protected final ViewLayoutState getChild(int n) {
        return this.getChildren().getChild(n);
    }

    protected final int getChildIndex(ViewLayoutState viewLayoutState) {
        return this.getChildren().getChildIndex(viewLayoutState);
    }

    protected final int getChildIndexNoCheck(ViewLayoutState viewLayoutState) {
        return this.getChildren().getChildIndexNoCheck(viewLayoutState);
    }

    protected GapBoxViewChildren createChildren() {
        return new GapBoxViewChildren(this);
    }

    protected boolean useCustomReloadChildren() {
        return this.getElement() == null;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        if (this.children == null && this.getParent() == null) {
            return;
        }
        if (this.useCustomReloadChildren()) {
            this.customInsertUpdate(documentEvent, shape, viewFactory);
        } else {
            super.insertUpdate(documentEvent, shape, viewFactory);
        }
    }

    protected void customInsertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        int[] nArray = this.getInsertUpdateRebuildOffsetRange(documentEvent);
        if (nArray != null) {
            this.offsetRebuild(nArray[0], nArray[1]);
        } else {
            this.forwardUpdate(null, documentEvent, shape, viewFactory);
        }
    }

    protected int[] getInsertUpdateRebuildOffsetRange(DocumentEvent documentEvent) {
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(documentEvent.getDocument().getDefaultRootElement());
        if (elementChange == null) {
            return null;
        }
        int n = documentEvent.getOffset();
        int n2 = n + documentEvent.getLength();
        int[] nArray = new int[]{n, n2};
        Element[] elementArray = elementChange.getChildrenAdded();
        ElementUtilities.updateOffsetRange((Element[])elementArray, (int[])nArray);
        Element[] elementArray2 = elementChange.getChildrenRemoved();
        ElementUtilities.updateOffsetRange((Element[])elementArray2, (int[])nArray);
        return nArray;
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        if (this.children == null && this.getParent() == null) {
            return;
        }
        if (this.useCustomReloadChildren()) {
            this.customRemoveUpdate(documentEvent, shape, viewFactory);
        } else {
            super.removeUpdate(documentEvent, shape, viewFactory);
        }
    }

    protected void customRemoveUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        int[] nArray = this.getRemoveUpdateRebuildOffsetRange(documentEvent);
        if (nArray != null) {
            this.offsetRebuild(nArray[0], nArray[1]);
        } else {
            this.forwardUpdate(null, documentEvent, shape, viewFactory);
        }
    }

    protected int[] getRemoveUpdateRebuildOffsetRange(DocumentEvent documentEvent) {
        int n;
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(documentEvent.getDocument().getDefaultRootElement());
        if (elementChange == null) {
            return null;
        }
        int n2 = n = documentEvent.getOffset();
        int[] nArray = new int[]{n, n2};
        Element[] elementArray = elementChange.getChildrenAdded();
        ElementUtilities.updateOffsetRange((Element[])elementArray, (int[])nArray);
        Element[] elementArray2 = elementChange.getChildrenRemoved();
        ElementUtilities.updateOffsetRange((Element[])elementArray2, (int[])nArray);
        return nArray;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        if (this.children == null && this.getParent() == null) {
            return;
        }
        super.changedUpdate(documentEvent, shape, viewFactory);
    }

    protected void reloadChildren(int n, int n2, int n3, int n4) {
        if (this.useCustomReloadChildren()) {
            if (n3 == -1) {
                n3 = this.getStartOffset();
            }
            if (n4 == -1) {
                n4 = this.getEndOffset();
            }
            this.customReloadChildren(n, n2, n3, n4);
        } else {
            int n5;
            Element element = this.getElement();
            if (n3 == -1) {
                n5 = 0;
            } else {
                if (n == 0 ? n3 != this.getStartOffset() : n3 != this.getView(n - 1).getEndOffset()) {
                    throw new IllegalArgumentException("Invalid startOffset=" + n3);
                }
                n5 = n;
            }
            int n6 = n4 == -1 ? element.getElementCount() : element.getElementIndex(n4 - 1) + 1;
            this.elementReloadChildren(n, n2, n6 - n5);
        }
    }

    protected void elementReloadChildren(int n, int n2, int n3) {
        Element element = this.getElement();
        View[] viewArray = null;
        ViewFactory viewFactory = this.getViewFactory();
        if (viewFactory != null) {
            viewArray = new View[n3];
            for (int i = 0; i < n3; ++i) {
                viewArray[i] = viewFactory.create(element.getElement(n + i));
            }
        }
        this.replace(n, n2, viewArray);
    }

    protected void customReloadChildren(int n, int n2, int n3, int n4) {
        View[] viewArray = null;
        ViewFactory viewFactory = this.getViewFactory();
        if (viewFactory != null) {
            int n5;
            Element element = this.getElement();
            int n6 = element.getElementCount();
            int n7 = n5 = element != null ? element.getElementIndex(n3) : -1;
            if (n5 >= n6) {
                return;
            }
            ArrayList<View> arrayList = new ArrayList<View>();
            int n8 = this.getViewCount();
            while (n3 < n4) {
                View view = this.createCustomView(viewFactory, n3, n4, n5);
                if (view == null) {
                    throw new IllegalStateException("No view created for area (" + n3 + ", " + n4 + ")");
                }
                arrayList.add(view);
                int n9 = view.getEndOffset();
                while (n9 > n4 && n + n2 < n8) {
                    n4 = this.getView(n + n2).getEndOffset();
                    ++n2;
                    if (!debugRebuild) continue;
                    System.err.println("GapBoxView.customReloadChildren(): Increased removeLength to " + n2 + ", eo=" + n4);
                }
                Element element2 = element.getElement(n5);
                while (element2.getEndOffset() <= n9 && ++n5 != n6) {
                    element2 = element.getElement(n5);
                }
                n3 = n9;
            }
            viewArray = new View[arrayList.size()];
            arrayList.toArray(viewArray);
        }
        this.replace(n, n2, viewArray);
    }

    protected View createCustomView(ViewFactory viewFactory, int n, int n2, int n3) {
        return null;
    }

    protected void unloadChildren() {
    }

    protected ViewLayoutState createChild(View view) {
        ViewLayoutState viewLayoutState = view instanceof ViewLayoutState ? (ViewLayoutState)((Object)view) : this.createDefaultChild(view);
        return viewLayoutState;
    }

    protected ViewLayoutState createDefaultChild(View view) {
        return new SimpleViewLayoutState(view);
    }

    protected final boolean isMajorAxisPreferenceChanged() {
        return this.isStatusBitsNonZero(4);
    }

    protected void markMajorAxisPreferenceChanged() {
        this.setStatusBits(4);
    }

    protected final boolean isMinorAxisPreferenceChanged() {
        return this.isStatusBitsNonZero(8);
    }

    protected void markMinorAxisPreferenceChanged() {
        this.setStatusBits(8);
    }

    protected final void resetAxesPreferenceChanged() {
        this.clearStatusBits(12);
    }

    protected final float getInsetSpan(int n) {
        ViewInsets viewInsets = this.getInsets();
        return viewInsets != null ? (n == 0 ? viewInsets.getLeftRight() : viewInsets.getTopBottom()) : 0.0f;
    }

    protected final float getMajorAxisInsetSpan() {
        ViewInsets viewInsets = this.getInsets();
        return viewInsets != null ? (this.isXMajorAxis() ? viewInsets.getLeftRight() : viewInsets.getTopBottom()) : 0.0f;
    }

    protected final float getMinorAxisInsetSpan() {
        ViewInsets viewInsets = this.getInsets();
        return viewInsets != null ? (this.isXMajorAxis() ? viewInsets.getTopBottom() : viewInsets.getLeftRight()) : 0.0f;
    }

    protected final int getStatusBits(int n) {
        return this.statusBits & n;
    }

    protected final boolean isStatusBitsNonZero(int n) {
        return this.getStatusBits(n) != 0;
    }

    protected final void setStatusBits(int n) {
        this.statusBits |= n;
    }

    protected final void clearStatusBits(int n) {
        this.statusBits &= ~n;
    }

    protected Rectangle reallocate(Shape shape) {
        Rectangle rectangle = shape.getBounds();
        this.setSize(rectangle.width, rectangle.height);
        return rectangle;
    }

    public int getStartOffset(int n) {
        return this.getChildren().getChildStartOffset(n);
    }

    public int getEndOffset(int n) {
        return this.getChildren().getChildEndOffset(n);
    }

    public String childToString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendChildToStringBuffer(stringBuffer, n, 0);
        return stringBuffer.toString();
    }

    public void appendChildToStringBuffer(StringBuffer stringBuffer, int n, int n2) {
        ViewLayoutState viewLayoutState = this.getChild(n);
        View view = viewLayoutState.getView();
        Document document = this.getDocument();
        boolean bl = viewLayoutState.isFlyweight();
        boolean bl2 = view instanceof EstimatedSpanView && ((EstimatedSpanView)((Object)view)).isEstimatedSpan();
        boolean bl3 = viewLayoutState.isLayoutValid();
        double d = this.children.getMajorAxisOffset(n);
        boolean bl4 = !bl && this.getChildIndexNoCheck(viewLayoutState) != n;
        boolean bl5 = false;
        stringBuffer.append(bl ? (char)'F' : 'R');
        stringBuffer.append(':');
        if (bl4) {
            stringBuffer.append(" WRONG-INDEX=" + this.getChildIndexNoCheck(viewLayoutState));
        }
        if (bl5) {
            stringBuffer.append("rI=" + viewLayoutState.getViewRawIndex());
        }
        stringBuffer.append('<');
        GapBoxView.appendOffsetInfo(stringBuffer, document, view.getStartOffset());
        stringBuffer.append(',');
        GapBoxView.appendOffsetInfo(stringBuffer, document, view.getEndOffset());
        stringBuffer.append('>');
        stringBuffer.append(", major=").append(viewLayoutState.getLayoutMajorAxisPreferredSpan());
        stringBuffer.append("(off=").append(d);
        if (bl5) {
            stringBuffer.append('(').append(viewLayoutState.getLayoutMajorAxisRawOffset()).append(')');
        }
        stringBuffer.append("), minor[pref=").append(viewLayoutState.getLayoutMinorAxisPreferredSpan());
        stringBuffer.append(", min=").append(viewLayoutState.getLayoutMinorAxisMinimumSpan());
        stringBuffer.append(", max=").append(viewLayoutState.getLayoutMinorAxisMaximumSpan());
        stringBuffer.append("] ");
        stringBuffer.append(bl2 ? "E" : "");
        stringBuffer.append(bl3 ? "" : "I");
        if (view instanceof GapBoxView) {
            stringBuffer.append("\n");
            GapBoxView.appendSpaces(stringBuffer, n2 + 4);
            stringBuffer.append("VIEW: ");
            stringBuffer.append(view.toString());
            stringBuffer.append(((GapBoxView)view).childrenToString(n2 + 4));
        }
    }

    private static void appendOffsetInfo(StringBuffer stringBuffer, Document document, int n) {
        stringBuffer.append(n);
        stringBuffer.append('[');
        stringBuffer.append(Utilities.debugPosition((BaseDocument)document, n));
        stringBuffer.append(']');
    }

    private static void appendSpaces(StringBuffer stringBuffer, int n) {
        while (--n >= 0) {
            stringBuffer.append(' ');
        }
    }

    public String childrenToString() {
        return this.childrenToString(0);
    }

    public String childrenToString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.getViewCount();
        int n3 = Integer.toString(n2).length();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append('\n');
            String string = Integer.toString(i);
            GapBoxView.appendSpaces(stringBuffer, n + (n3 - string.length()));
            stringBuffer.append('[');
            stringBuffer.append(string);
            stringBuffer.append("]: ");
            this.appendChildToStringBuffer(stringBuffer, i, n);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "lastMajorAxisPreferredSpan=" + this.lastMajorAxisPreferredSpan + ", lastMinorAxisPreferredSpan=" + this.lastMinorAxisPreferredSpan + ", minorAxisAssignedSpan=" + this.getMinorAxisAssignedSpan();
    }
}

