/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.Abbrev;
import org.netbeans.editor.Acceptor;
import org.netbeans.editor.AcceptorFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.lib.editor.codetemplates.AbbrevExpander;
import org.netbeans.lib.editor.codetemplates.AbbrevSettings;
import org.netbeans.lib.editor.codetemplates.CodeTemplateAbbrevExpander;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.openide.ErrorManager;

final class AbbrevDetection
implements SettingsChangeListener,
DocumentListener,
PropertyChangeListener,
KeyListener {
    private static final String ABBREV_IGNORE_MODIFICATION_DOC_PROPERTY = "abbrev-ignore-modification";
    private static final AbbrevExpander[] abbrevExpanders = new AbbrevExpander[]{new CodeTemplateAbbrevExpander()};
    private JTextComponent component;
    private Document doc;
    private Position abbrevEndPosition;
    private StringBuffer abbrevChars = new StringBuffer();
    private Acceptor expandAcceptor;
    private Acceptor resetAcceptor;

    public static AbbrevDetection get(JTextComponent jTextComponent) {
        AbbrevDetection abbrevDetection = (AbbrevDetection)jTextComponent.getClientProperty(AbbrevDetection.class);
        if (abbrevDetection == null) {
            abbrevDetection = new AbbrevDetection(jTextComponent);
            jTextComponent.putClientProperty(AbbrevDetection.class, abbrevDetection);
        }
        return abbrevDetection;
    }

    private AbbrevDetection(JTextComponent jTextComponent) {
        this.component = jTextComponent;
        this.doc = jTextComponent.getDocument();
        if (this.doc != null) {
            this.doc.addDocumentListener(this);
        }
        Settings.addSettingsChangeListener((SettingsChangeListener)this);
        this.settingsChange(null);
        jTextComponent.addKeyListener(this);
        jTextComponent.addPropertyChangeListener(this);
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        Document document = this.doc;
        Class clazz = document instanceof BaseDocument ? ((BaseDocument)document).getKitClass() : BaseKit.class;
        this.expandAcceptor = SettingsUtil.getAcceptor((Class)clazz, (String)"abbrev-expand-acceptor", (Acceptor)AcceptorFactory.FALSE);
        this.resetAcceptor = SettingsUtil.getAcceptor((Class)clazz, (String)"abbrev-reset-acceptor", (Acceptor)AcceptorFactory.TRUE);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this.isIgnoreModification()) {
            if (DocumentUtilities.isTypingModification((DocumentEvent)documentEvent) && !this.isAbbrevDisabled()) {
                int n = documentEvent.getOffset();
                int n2 = documentEvent.getLength();
                this.appendTypedText(n, n2);
            } else {
                this.resetAbbrevChars();
            }
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (!this.isIgnoreModification()) {
            if (DocumentUtilities.isTypingModification((DocumentEvent)documentEvent) && !this.isAbbrevDisabled()) {
                int n = documentEvent.getOffset();
                int n2 = documentEvent.getLength();
                this.removeAbbrevText(n, n2);
            } else {
                this.resetAbbrevChars();
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("document".equals(propertyChangeEvent.getPropertyName())) {
            if (this.doc != null) {
                this.doc.removeDocumentListener(this);
            }
            this.doc = this.component.getDocument();
            if (this.doc != null) {
                this.doc.addDocumentListener(this);
            }
            this.settingsChange(null);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.checkExpansionKeystroke(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.checkExpansionKeystroke(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.checkExpansionKeystroke(keyEvent);
    }

    private boolean isIgnoreModification() {
        return Boolean.TRUE.equals(this.doc.getProperty(ABBREV_IGNORE_MODIFICATION_DOC_PROPERTY));
    }

    private boolean isAbbrevDisabled() {
        return Abbrev.isAbbrevDisabled((JTextComponent)this.component);
    }

    private void checkExpansionKeystroke(KeyEvent keyEvent) {
        KeyStroke keyStroke = AbbrevSettings.getDefaultExpansionKeyStroke();
        if (this.abbrevEndPosition != null && this.component != null && this.component.getCaretPosition() == this.abbrevEndPosition.getOffset()) {
            Document document = this.component.getDocument();
            String string = (String)document.getProperty("mimeType");
            if (string != null) {
                keyStroke = AbbrevSettings.get(string).getExpandKeyStroke();
            }
            if (keyStroke.equals(KeyStroke.getKeyStrokeForEvent(keyEvent)) && this.expand()) {
                keyEvent.consume();
            }
        }
    }

    private CharSequence getAbbrevText() {
        return this.abbrevChars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetAbbrevChars() {
        StringBuffer stringBuffer = this.abbrevChars;
        synchronized (stringBuffer) {
            this.abbrevChars.setLength(0);
            this.abbrevEndPosition = null;
        }
    }

    private void appendTypedText(int n, int n2) {
        if (this.abbrevEndPosition == null || n + n2 != this.abbrevEndPosition.getOffset()) {
            this.resetAbbrevChars();
        }
        if (this.abbrevEndPosition == null) {
            try {
                if (n == 0 || this.resetAcceptor.accept(this.doc.getText(n - 1, 1).charAt(0))) {
                    this.abbrevEndPosition = this.doc.createPosition(n + n2);
                }
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
        }
        if (this.abbrevEndPosition != null) {
            try {
                String string = this.doc.getText(n, n2);
                boolean bl = true;
                for (int i = string.length() - 1; i >= 0; --i) {
                    if (!this.resetAcceptor.accept(string.charAt(i))) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    this.abbrevChars.append(string);
                } else {
                    this.resetAbbrevChars();
                }
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
                this.resetAbbrevChars();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAbbrevText(int n, int n2) {
        StringBuffer stringBuffer = this.abbrevChars;
        synchronized (stringBuffer) {
            if (this.abbrevEndPosition != null) {
                if (n == this.abbrevEndPosition.getOffset() && this.abbrevChars.length() >= n2) {
                    this.abbrevChars.setLength(this.abbrevChars.length() - n2);
                } else {
                    this.resetAbbrevChars();
                }
            }
        }
    }

    public boolean expand() {
        CharSequence charSequence = this.getAbbrevText();
        int n = this.abbrevEndPosition.getOffset();
        for (int i = 0; i < abbrevExpanders.length; ++i) {
            if (!abbrevExpanders[i].expand(this.component, n - charSequence.length(), charSequence)) continue;
            this.resetAbbrevChars();
            return true;
        }
        return false;
    }
}

