/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.KeyStroke;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.CodeTemplateSettings;
import org.netbeans.modules.editor.options.BaseOptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

final class AbbrevSettings
implements LookupListener {
    private static final KeyStroke DEFAULT_EXPANSION_KEYSTROKE = KeyStroke.getKeyStroke(' ');
    private static final Map mimeType2settings = new HashMap();
    private Lookup.Result codeTemplateSettingsLookupResult;
    private KeyStroke expandKeyStroke;

    public static synchronized AbbrevSettings get(String string) {
        AbbrevSettings abbrevSettings = (AbbrevSettings)mimeType2settings.get(string);
        if (abbrevSettings == null) {
            abbrevSettings = new AbbrevSettings(string);
            mimeType2settings.put(string, abbrevSettings);
        }
        return abbrevSettings;
    }

    public static KeyStroke getDefaultExpansionKeyStroke() {
        return DEFAULT_EXPANSION_KEYSTROKE;
    }

    AbbrevSettings(String string) {
        MimeLookup mimeLookup = MimeLookup.getMimeLookup((String)string);
        this.codeTemplateSettingsLookupResult = mimeLookup.lookup(new Lookup.Template(CodeTemplateSettings.class));
        this.codeTemplateSettingsLookupResult.addLookupListener((LookupListener)WeakListeners.create((Class)LookupListener.class, (EventListener)((Object)this), (Object)mimeLookup));
        this.resultChanged(null);
    }

    public KeyStroke getExpandKeyStroke() {
        KeyStroke keyStroke = BaseOptions.getCodeTemplateExpandKey();
        if (keyStroke == null) {
            keyStroke = AbbrevSettings.getDefaultExpansionKeyStroke();
        }
        keyStroke = this.patchExpandKeystroke(keyStroke);
        return keyStroke;
    }

    public String getExpandKeyStrokeText() {
        KeyStroke keyStroke = this.getExpandKeyStroke();
        String string = keyStroke.equals(KeyStroke.getKeyStroke(' ')) ? "SPACE" : (keyStroke.equals(KeyStroke.getKeyStroke(new Character(' '), 1)) ? "Shift-SPACE" : (keyStroke.equals(KeyStroke.getKeyStroke(9, 0)) ? "TAB" : (keyStroke.equals(KeyStroke.getKeyStroke(10, 0)) ? "ENTER" : keyStroke.toString())));
        return string;
    }

    public void resultChanged(LookupEvent lookupEvent) {
    }

    private KeyStroke patchExpandKeystroke(KeyStroke keyStroke) {
        if (keyStroke.equals(KeyStroke.getKeyStroke(32, 0))) {
            keyStroke = KeyStroke.getKeyStroke(' ');
        } else if (keyStroke.equals(KeyStroke.getKeyStroke(32, 1))) {
            keyStroke = KeyStroke.getKeyStroke(new Character(' '), 1);
        } else if (keyStroke.equals(KeyStroke.getKeyStroke(9, 0)) || keyStroke.equals(KeyStroke.getKeyStroke(10, 0))) {
            // empty if block
        }
        return keyStroke;
    }
}

