/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Abbrev;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.codetemplates.CodeTemplateCompletionItem;
import org.netbeans.lib.editor.codetemplates.CodeTemplateManagerOperation;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

public final class CodeTemplateCompletionProvider
implements CompletionProvider {
    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        return CodeTemplateCompletionProvider.isAbbrevDisabled(jTextComponent) ? null : new AsyncCompletionTask((AsyncCompletionQuery)new Query(), jTextComponent);
    }

    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        return 0;
    }

    private static boolean isAbbrevDisabled(JTextComponent jTextComponent) {
        return Abbrev.isAbbrevDisabled((JTextComponent)jTextComponent);
    }

    private static final class Query
    extends AsyncCompletionQuery
    implements ChangeListener {
        private String identifierBeforeCursor;

        private Query() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            Object object;
            CodeTemplateManagerOperation codeTemplateManagerOperation = CodeTemplateManagerOperation.get(document);
            this.identifierBeforeCursor = null;
            if (document instanceof AbstractDocument) {
                object = (AbstractDocument)document;
                ((AbstractDocument)object).readLock();
                try {
                    if (object instanceof BaseDocument) {
                        this.identifierBeforeCursor = Utilities.getIdentifierBefore((BaseDocument)((BaseDocument)object), (int)n);
                    }
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    ((AbstractDocument)object).readUnlock();
                }
            }
            codeTemplateManagerOperation.waitLoaded();
            object = this.identifierBeforeCursor != null ? codeTemplateManagerOperation.findByParametrizedText(this.identifierBeforeCursor, true) : Collections.EMPTY_LIST;
            ArrayList<CodeTemplateCompletionItem> arrayList = new ArrayList<CodeTemplateCompletionItem>(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                CodeTemplate codeTemplate = (CodeTemplate)iterator.next();
                arrayList.add(new CodeTemplateCompletionItem(codeTemplate));
            }
            completionResultSet.addAllItems(arrayList);
            completionResultSet.finish();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(ChangeEvent changeEvent) {
            Query query = this;
            synchronized (query) {
                this.notify();
            }
        }
    }
}

