/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.awt.Color;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.MarkFactory;
import org.netbeans.lib.editor.codetemplates.CodeTemplateInsertHandler;
import org.netbeans.lib.editor.codetemplates.CodeTemplateParameterImpl;
import org.netbeans.lib.editor.codetemplates.SyncDocumentRegion;
import org.netbeans.lib.editor.util.swing.MutablePositionRegion;

final class CodeTemplateDrawLayer
extends DrawLayer.AbstractLayer {
    public static final String NAME = "code-template-draw-layer";
    public static final int VISIBILITY = 5000;
    private static final Coloring COLORING = new Coloring(null, null, new Color(138, 191, 236));
    private static int instanceCounter;
    private CodeTemplateParameterImpl paramImpl;
    private CodeTemplateInsertHandler handler;
    private int regionIndex;
    private Position regionStartPosition;
    private Position regionEndPosition;
    private boolean colorBackground;
    private Coloring coloring;
    private boolean textFramePropertyAssigned;

    CodeTemplateDrawLayer(CodeTemplateParameterImpl codeTemplateParameterImpl) {
        super(NAME + instanceCounter++);
        this.paramImpl = codeTemplateParameterImpl;
        this.handler = codeTemplateParameterImpl.getHandler();
    }

    public void init(DrawContext drawContext) {
        this.coloring = null;
        JTextComponent jTextComponent = drawContext.getEditorUI().getComponent();
        this.regionStartPosition = null;
        if (jTextComponent != null) {
            if (this.handler.getActiveMasterImpl() == this.paramImpl) {
                this.colorBackground = true;
                int n = drawContext.getStartOffset();
                this.regionIndex = 0;
                SyncDocumentRegion syncDocumentRegion = this.paramImpl.getRegion();
                int n2 = syncDocumentRegion.getRegionCount();
                while (this.regionIndex < n2) {
                    MutablePositionRegion mutablePositionRegion = syncDocumentRegion.getSortedRegion(this.regionIndex);
                    Position position = mutablePositionRegion.getStartPosition();
                    if (n <= position.getOffset()) {
                        this.regionStartPosition = position;
                        this.regionEndPosition = mutablePositionRegion.getEndPosition();
                        this.setNextActivityChangeOffset(this.regionStartPosition.getOffset());
                        break;
                    }
                    ++this.regionIndex;
                }
            } else {
                this.colorBackground = false;
            }
        }
    }

    public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
        if (this.regionStartPosition != null) {
            int n = this.regionStartPosition.getOffset();
            int n2 = this.regionEndPosition.getOffset();
            int n3 = drawContext.getFragmentOffset();
            SyncDocumentRegion syncDocumentRegion = this.paramImpl.getRegion();
            if (n3 == n && n != n2) {
                if (n == syncDocumentRegion.getFirstRegionStartOffset()) {
                    JTextComponent jTextComponent = drawContext.getEditorUI().getComponent();
                    jTextComponent.putClientProperty("text-frame-start-position", this.regionStartPosition);
                    jTextComponent.putClientProperty("text-frame-end-position", this.regionEndPosition);
                    this.textFramePropertyAssigned = true;
                }
                this.coloring = this.colorBackground ? COLORING : null;
                this.setNextActivityChangeOffset(n2);
            } else if (n3 == n2) {
                Object object;
                this.coloring = null;
                ++this.regionIndex;
                if (this.regionIndex < syncDocumentRegion.getRegionCount()) {
                    object = syncDocumentRegion.getSortedRegion(this.regionIndex);
                    this.regionStartPosition = object.getStartPosition();
                    this.regionEndPosition = object.getEndPosition();
                    this.setNextActivityChangeOffset(this.regionStartPosition.getOffset());
                } else {
                    this.regionStartPosition = null;
                    this.regionEndPosition = null;
                }
                object = drawContext.getEditorUI().getComponent();
                this.resetTextFrameProperties((JTextComponent)object);
            }
            return true;
        }
        return false;
    }

    void resetTextFrameProperties(JTextComponent jTextComponent) {
        if (this.textFramePropertyAssigned) {
            jTextComponent.putClientProperty("text-frame-start-position", null);
            jTextComponent.putClientProperty("text-frame-end-position", null);
            this.textFramePropertyAssigned = false;
        }
    }

    public void updateContext(DrawContext drawContext) {
        if (this.coloring != null) {
            this.coloring.apply(drawContext);
        }
    }
}

