/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.codetemplates.CodeTemplateDrawLayer;
import org.netbeans.lib.editor.codetemplates.CodeTemplateOverrideAction;
import org.netbeans.lib.editor.codetemplates.CodeTemplateParameterImpl;
import org.netbeans.lib.editor.codetemplates.CodeTemplateSpiPackageAccessor;
import org.netbeans.lib.editor.codetemplates.ParametrizedTextParser;
import org.netbeans.lib.editor.codetemplates.SyncDocumentRegion;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateInsertRequest;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateParameter;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessor;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessorFactory;
import org.netbeans.lib.editor.util.swing.MutablePositionRegion;
import org.openide.ErrorManager;

public final class CodeTemplateInsertHandler
implements DocumentListener,
KeyListener {
    private static final Object EDITING_TEMPLATE_DOC_PROPERTY;
    private final CodeTemplate codeTemplate;
    private final JTextComponent component;
    private final List processors;
    private String parametrizedText;
    private ParametrizedTextParser parametrizedTextParser;
    private String insertText;
    private List allParameters;
    private List allParametersUnmodifiable;
    private List masters;
    private List mastersUnmodifiable;
    private List editableMasters;
    private CodeTemplateInsertRequest request;
    private boolean inserted;
    private boolean released;
    private Position caretPosition;
    private int activeMasterIndex;
    private ActionMap componentOrigActionMap;
    private List drawLayers;
    private Document doc;
    private boolean nestedTemplateExpanding;
    private CodeTemplateParameterImpl apiSetValueParamImpl;
    private int lastActiveRegionStartOffset;
    private int lastActiveRegionEndOffset;
    private boolean activeMasterModified;
    private boolean syncingDocModification;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CodeTemplateInsertHandler(CodeTemplate codeTemplate, JTextComponent jTextComponent, Collection collection) {
        this.codeTemplate = codeTemplate;
        this.component = jTextComponent;
        CodeTemplateInsertRequest.class.getClass().getName();
        this.request = CodeTemplateSpiPackageAccessor.get().createInsertRequest(this);
        this.processors = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CodeTemplateProcessorFactory codeTemplateProcessorFactory = (CodeTemplateProcessorFactory)iterator.next();
            this.processors.add(codeTemplateProcessorFactory.createProcessor(this.request));
        }
        this.setParametrizedText(codeTemplate.getParametrizedText());
    }

    public CodeTemplate getCodeTemplate() {
        return this.codeTemplate;
    }

    public JTextComponent getComponent() {
        return this.component;
    }

    public CodeTemplateInsertRequest getRequest() {
        return this.request;
    }

    public synchronized boolean isInserted() {
        return this.inserted;
    }

    private synchronized void markInserted() {
        this.inserted = true;
    }

    public synchronized boolean isReleased() {
        return this.released;
    }

    public String getParametrizedText() {
        return this.parametrizedText;
    }

    public void setParametrizedText(String string) {
        this.parametrizedText = string;
        this.parseParametrizedText();
    }

    public String getInsertText() {
        this.checkInsertTextBuilt();
        return this.insertText;
    }

    public List getAllParameters() {
        return this.allParametersUnmodifiable;
    }

    public List getMasterParameters() {
        return this.mastersUnmodifiable;
    }

    public void processTemplate() {
        Iterator iterator = this.processors.iterator();
        while (iterator.hasNext()) {
            CodeTemplateProcessor codeTemplateProcessor = (CodeTemplateProcessor)iterator.next();
            codeTemplateProcessor.updateDefaultValues();
        }
        this.insertTemplate();
        this.installActions();
    }

    void checkInsertTextBuilt() {
        if (this.insertText == null) {
            this.insertText = this.buildInsertText();
        }
    }

    void resetCachedInsertText() {
        this.insertText = null;
    }

    CodeTemplateParameter getActiveMaster() {
        return this.activeMasterIndex < this.editableMasters.size() ? (CodeTemplateParameter)this.editableMasters.get(this.activeMasterIndex) : null;
    }

    CodeTemplateParameterImpl getActiveMasterImpl() {
        CodeTemplateParameter codeTemplateParameter = this.getActiveMaster();
        return codeTemplateParameter != null ? CodeTemplateInsertHandler.paramImpl(codeTemplateParameter) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insertTemplate() {
        this.doc = this.component.getDocument();
        this.nestedTemplateExpanding = Boolean.TRUE.equals(this.doc.getProperty(EDITING_TEMPLATE_DOC_PROPERTY));
        String string = this.getInsertText();
        if (this.doc instanceof BaseDocument) {
            ((BaseDocument)this.doc).atomicLock();
        }
        try {
            block13: {
                try {
                    CodeTemplateParameter codeTemplateParameter;
                    int n;
                    Caret caret = this.component.getCaret();
                    if (caret.isSelectionVisible()) {
                        n = this.component.getSelectionStart();
                        int n2 = this.component.getSelectionEnd() - n;
                        this.doc.remove(n, n2);
                    }
                    n = this.component.getCaretPosition();
                    this.doc.insertString(n, string, null);
                    BaseDocument baseDocument = this.request.getMasterParameters().iterator();
                    while (baseDocument.hasNext()) {
                        codeTemplateParameter = (CodeTemplateParameter)baseDocument.next();
                        if ("cursor".equals(codeTemplateParameter.getName())) {
                            this.caretPosition = this.doc.createPosition(n + codeTemplateParameter.getInsertTextOffset());
                            continue;
                        }
                        ArrayList arrayList = new ArrayList(4);
                        this.addParameterRegion(arrayList, codeTemplateParameter, this.doc, n);
                        Object object = codeTemplateParameter.getSlaves().iterator();
                        while (object.hasNext()) {
                            CodeTemplateParameter codeTemplateParameter2 = (CodeTemplateParameter)object.next();
                            this.addParameterRegion(arrayList, codeTemplateParameter2, this.doc, n);
                        }
                        object = new SyncDocumentRegion(this.doc, arrayList);
                        CodeTemplateInsertHandler.paramImpl(codeTemplateParameter).setRegion((SyncDocumentRegion)object);
                    }
                    if (this.caretPosition == null) {
                        this.caretPosition = this.doc.createPosition(n + string.length());
                    }
                    if (this.parametrizedText.indexOf(10) == -1 || !(this.doc instanceof BaseDocument) || (codeTemplateParameter = (baseDocument = (BaseDocument)this.doc).getFormatter()) == null) break block13;
                    codeTemplateParameter.reformat(baseDocument, n, n + string.length());
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                    Object var10_12 = null;
                    if (this.doc instanceof BaseDocument) {
                        ((BaseDocument)this.doc).atomicUnlock();
                    }
                    this.markInserted();
                    return;
                }
            }
            Object var10_11 = null;
            if (this.doc instanceof BaseDocument) {
                ((BaseDocument)this.doc).atomicUnlock();
            }
            this.markInserted();
            return;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (this.doc instanceof BaseDocument) {
                ((BaseDocument)this.doc).atomicUnlock();
            }
            this.markInserted();
            throw throwable;
        }
    }

    public void installActions() {
        if (!this.nestedTemplateExpanding && this.editableMasters.size() > 0) {
            this.doc.putProperty(EDITING_TEMPLATE_DOC_PROPERTY, Boolean.TRUE);
            if (this.doc instanceof BaseDocument) {
                ((BaseDocument)this.doc).setPostModificationDocumentListener((DocumentListener)this);
                this.updateLastRegionBounds();
            }
            this.componentOrigActionMap = CodeTemplateOverrideAction.installOverrideActionMap(this.component, this);
            EditorUI editorUI = Utilities.getEditorUI((JTextComponent)this.component);
            this.drawLayers = new ArrayList(this.editableMasters.size());
            Iterator iterator = this.editableMasters.iterator();
            while (iterator.hasNext()) {
                CodeTemplateParameterImpl codeTemplateParameterImpl = CodeTemplateInsertHandler.paramImpl((CodeTemplateParameter)iterator.next());
                CodeTemplateDrawLayer codeTemplateDrawLayer = new CodeTemplateDrawLayer(codeTemplateParameterImpl);
                this.drawLayers.add(codeTemplateDrawLayer);
                editorUI.addLayer((DrawLayer)codeTemplateDrawLayer, 5000);
            }
            this.component.addKeyListener(this);
            this.tabUpdate();
        } else {
            this.forceCaretPosition();
            this.release();
        }
    }

    public void defaultKeyTypedAction(ActionEvent actionEvent, Action action) {
        action.actionPerformed(actionEvent);
    }

    public void tabAction(ActionEvent actionEvent, Action action) {
        this.checkNotifyParameterUpdate();
        this.activeMasterIndex = this.activeMasterIndex < this.editableMasters.size() ? ++this.activeMasterIndex : 0;
        this.tabUpdate();
    }

    public void shiftTabAction(ActionEvent actionEvent) {
        this.checkNotifyParameterUpdate();
        this.activeMasterIndex = this.activeMasterIndex > 0 ? --this.activeMasterIndex : this.editableMasters.size();
        this.tabUpdate();
    }

    public void enterAction(ActionEvent actionEvent) {
        this.checkNotifyParameterUpdate();
        this.forceCaretPosition();
        this.release();
    }

    void undoAction(ActionEvent actionEvent) {
    }

    void redoAction(ActionEvent actionEvent) {
    }

    public String getDocParameterValue(CodeTemplateParameterImpl codeTemplateParameterImpl) {
        String string;
        if (!$assertionsDisabled && codeTemplateParameterImpl.isSlave()) {
            throw new AssertionError();
        }
        SyncDocumentRegion syncDocumentRegion = codeTemplateParameterImpl.getRegion();
        if (!$assertionsDisabled && syncDocumentRegion == null) {
            throw new AssertionError();
        }
        int n = syncDocumentRegion.getFirstRegionStartOffset();
        int n2 = syncDocumentRegion.getFirstRegionLength();
        try {
            string = this.doc.getText(n, n2);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
            string = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDocParameterValue(CodeTemplateParameterImpl codeTemplateParameterImpl, String string) {
        if (!$assertionsDisabled && codeTemplateParameterImpl == this.getActiveMasterImpl()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && codeTemplateParameterImpl.isSlave()) {
            throw new AssertionError();
        }
        SyncDocumentRegion syncDocumentRegion = codeTemplateParameterImpl.getRegion();
        if (!$assertionsDisabled && syncDocumentRegion == null) {
            throw new AssertionError();
        }
        int n = syncDocumentRegion.getFirstRegionStartOffset();
        int n2 = syncDocumentRegion.getFirstRegionLength();
        this.apiSetValueParamImpl = codeTemplateParameterImpl;
        try {
            String string2 = this.doc.getText(n, n2);
            if (!string2.equals(string)) {
                this.doc.remove(n, n2);
                this.doc.insertString(n, string, null);
                syncDocumentRegion.sync(string.length());
                codeTemplateParameterImpl.setValue(string, false);
            }
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
        finally {
            this.apiSetValueParamImpl = null;
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        int n;
        int n2 = documentEvent.getOffset();
        if (n2 + (n = documentEvent.getLength()) == this.caretPosition.getOffset()) {
            try {
                this.caretPosition = this.doc.createPosition(n2);
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
        }
        if (!this.syncingDocModification) {
            this.syncingDocModification = true;
            this.syncInsert(documentEvent);
            this.syncingDocModification = false;
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (!this.syncingDocModification) {
            this.syncingDocModification = true;
            this.syncRemove(documentEvent);
            this.syncingDocModification = false;
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (KeyStroke.getKeyStroke(27, 0).equals(KeyStroke.getKeyStrokeForEvent(keyEvent))) {
            this.release();
            keyEvent.consume();
        } else if (KeyStroke.getKeyStroke(10, 0).equals(KeyStroke.getKeyStrokeForEvent(keyEvent)) && this.getActiveMaster() == null) {
            this.checkNotifyParameterUpdate();
            this.release();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void forceCaretPosition() {
        this.component.setCaretPosition(this.caretPosition.getOffset());
    }

    private void notifyParameterUpdate(CodeTemplateParameter codeTemplateParameter, boolean bl) {
        Iterator iterator = this.processors.iterator();
        while (iterator.hasNext()) {
            CodeTemplateProcessor codeTemplateProcessor = (CodeTemplateProcessor)iterator.next();
            codeTemplateProcessor.parameterValueChanged(codeTemplateParameter, bl);
        }
    }

    private void checkNotifyParameterUpdate() {
        if (this.activeMasterModified) {
            this.activeMasterModified = false;
            this.notifyParameterUpdate(this.getActiveMaster(), false);
        }
    }

    private void parseParametrizedText() {
        this.allParameters = new ArrayList(2);
        this.allParametersUnmodifiable = Collections.unmodifiableList(this.allParameters);
        this.masters = new ArrayList(2);
        this.mastersUnmodifiable = Collections.unmodifiableList(this.masters);
        this.editableMasters = new ArrayList(2);
        this.parametrizedTextParser = new ParametrizedTextParser(this, this.parametrizedText);
        this.parametrizedTextParser.parse();
    }

    void notifyParameterParsed(CodeTemplateParameterImpl codeTemplateParameterImpl) {
        this.allParameters.add(codeTemplateParameterImpl.getParameter());
        this.checkSlave(codeTemplateParameterImpl.getParameter());
    }

    private void checkSlave(CodeTemplateParameter codeTemplateParameter) {
        Iterator iterator = this.getMasterParameters().iterator();
        while (iterator.hasNext()) {
            CodeTemplateParameter codeTemplateParameter2 = (CodeTemplateParameter)iterator.next();
            if (!codeTemplateParameter2.getName().equals(codeTemplateParameter.getName())) continue;
            CodeTemplateInsertHandler.paramImpl(codeTemplateParameter).markSlave(codeTemplateParameter2);
            return;
        }
        this.masters.add(codeTemplateParameter);
        if (codeTemplateParameter.isEditable()) {
            this.editableMasters.add(codeTemplateParameter);
        }
    }

    private static CodeTemplateParameterImpl paramImpl(CodeTemplateParameter codeTemplateParameter) {
        return CodeTemplateSpiPackageAccessor.get().getImpl(codeTemplateParameter);
    }

    private void tabUpdate() {
        if (this.activeMasterIndex == this.editableMasters.size()) {
            this.forceCaretPosition();
        } else {
            this.updateLastRegionBounds();
            SyncDocumentRegion syncDocumentRegion = this.getActiveMasterImpl().getRegion();
            this.component.select(syncDocumentRegion.getFirstRegionStartOffset(), syncDocumentRegion.getFirstRegionEndOffset());
        }
        this.requestRepaint();
    }

    private void requestRepaint() {
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        Object object = this.editableMasters.iterator();
        while (object.hasNext()) {
            SyncDocumentRegion syncDocumentRegion = CodeTemplateInsertHandler.paramImpl((CodeTemplateParameter)object.next()).getRegion();
            n = Math.min(n, syncDocumentRegion.getSortedRegion(0).getStartOffset());
            n2 = Math.max(n2, syncDocumentRegion.getSortedRegion(syncDocumentRegion.getRegionCount() - 1).getEndOffset());
        }
        object = this.getComponent();
        if (n2 != 0) {
            ((JTextComponent)object).getUI().damageRange((JTextComponent)object, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        CodeTemplateProcessor codeTemplateProcessor;
        Object object = this;
        synchronized (object) {
            if (this.released) {
                return;
            }
            this.released = true;
        }
        if (!this.nestedTemplateExpanding && this.editableMasters.size() > 0) {
            if (this.doc instanceof BaseDocument) {
                ((BaseDocument)this.doc).setPostModificationDocumentListener(null);
            }
            this.doc.putProperty(EDITING_TEMPLATE_DOC_PROPERTY, Boolean.FALSE);
            this.component.removeKeyListener(this);
            object = this.getComponent();
            ((JComponent)object).setActionMap(this.componentOrigActionMap);
            codeTemplateProcessor = Utilities.getEditorUI((JTextComponent)object);
            if (codeTemplateProcessor != null) {
                Iterator iterator = this.drawLayers.iterator();
                while (iterator.hasNext()) {
                    DrawLayer drawLayer = (DrawLayer)iterator.next();
                    codeTemplateProcessor.removeLayer(drawLayer.getName());
                }
            }
            ((JComponent)object).putClientProperty("text-frame-start-position", null);
            ((JComponent)object).putClientProperty("text-frame-end-position", null);
            this.requestRepaint();
        }
        object = this.processors.iterator();
        while (object.hasNext()) {
            codeTemplateProcessor = (CodeTemplateProcessor)object.next();
            codeTemplateProcessor.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncInsert(DocumentEvent documentEvent) {
        int n = documentEvent.getOffset();
        int n2 = documentEvent.getLength();
        CodeTemplateParameterImpl codeTemplateParameterImpl = this.getActiveMasterImpl();
        if (this.apiSetValueParamImpl == null && codeTemplateParameterImpl != null) {
            SyncDocumentRegion syncDocumentRegion = codeTemplateParameterImpl.getRegion();
            if (this.isManagedInsert(n)) {
                this.doc.putProperty("abbrev-ignore-modification", Boolean.TRUE);
                try {
                    syncDocumentRegion.sync(n == this.lastActiveRegionStartOffset ? n2 : 0);
                }
                finally {
                    this.doc.putProperty("abbrev-ignore-modification", Boolean.FALSE);
                }
                codeTemplateParameterImpl.setValue(this.getDocParameterValue(codeTemplateParameterImpl), false);
                codeTemplateParameterImpl.markUserModified();
                this.notifyParameterUpdate(codeTemplateParameterImpl.getParameter(), true);
            } else {
                this.release();
            }
        }
        this.updateLastRegionBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncRemove(DocumentEvent documentEvent) {
        CodeTemplateParameterImpl codeTemplateParameterImpl = this.getActiveMasterImpl();
        if (this.apiSetValueParamImpl == null && codeTemplateParameterImpl != null) {
            SyncDocumentRegion syncDocumentRegion = codeTemplateParameterImpl.getRegion();
            if (this.isManagedRemove(documentEvent.getOffset(), documentEvent.getLength())) {
                this.doc.putProperty("abbrev-ignore-modification", Boolean.TRUE);
                try {
                    syncDocumentRegion.sync(0);
                }
                finally {
                    this.doc.putProperty("abbrev-ignore-modification", Boolean.FALSE);
                }
                codeTemplateParameterImpl.setValue(this.getDocParameterValue(codeTemplateParameterImpl), false);
                codeTemplateParameterImpl.markUserModified();
                this.notifyParameterUpdate(codeTemplateParameterImpl.getParameter(), true);
            } else {
                this.release();
            }
        }
        this.updateLastRegionBounds();
    }

    private void updateLastRegionBounds() {
        CodeTemplateParameterImpl codeTemplateParameterImpl = this.getActiveMasterImpl();
        if (codeTemplateParameterImpl != null) {
            SyncDocumentRegion syncDocumentRegion = codeTemplateParameterImpl.getRegion();
            this.lastActiveRegionStartOffset = syncDocumentRegion.getFirstRegionStartOffset();
            this.lastActiveRegionEndOffset = syncDocumentRegion.getFirstRegionEndOffset();
        } else {
            this.lastActiveRegionStartOffset = -1;
            this.lastActiveRegionEndOffset = -1;
        }
    }

    private boolean isManagedInsert(int n) {
        return n >= this.lastActiveRegionStartOffset && n <= this.lastActiveRegionEndOffset;
    }

    private boolean isManagedRemove(int n, int n2) {
        return n >= this.lastActiveRegionStartOffset && n + n2 <= this.lastActiveRegionEndOffset;
    }

    private void addParameterRegion(List list, CodeTemplateParameter codeTemplateParameter, Document document, int n) throws BadLocationException {
        int n2 = n + codeTemplateParameter.getInsertTextOffset();
        BaseDocument baseDocument = (BaseDocument)document;
        Position position = baseDocument.createPosition(n2);
        Position position2 = document.createPosition(n2 + codeTemplateParameter.getValue().length());
        MutablePositionRegion mutablePositionRegion = new MutablePositionRegion(position, position2);
        list.add(mutablePositionRegion);
    }

    private String buildInsertText() {
        return this.parametrizedTextParser.buildInsertText(this.allParameters);
    }

    static {
        $assertionsDisabled = !CodeTemplateInsertHandler.class.desiredAssertionStatus();
        EDITING_TEMPLATE_DOC_PROPERTY = "processing-code-template";
    }
}

