/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.lib.editor.util.swing.MutablePositionRegion;
import org.netbeans.lib.editor.util.swing.PositionRegion;
import org.openide.ErrorManager;

public final class SyncDocumentRegion {
    private Document doc;
    private List regions;
    private List sortedRegions;
    private boolean regionsSortPerformed;

    public SyncDocumentRegion(Document document, List list) {
        this.doc = document;
        this.regions = list;
        this.regionsSortPerformed = PositionRegion.isRegionsSorted((List)list);
        if (this.regionsSortPerformed) {
            this.sortedRegions = list;
        } else {
            this.sortedRegions = new ArrayList(list);
            Collections.sort(this.sortedRegions, PositionRegion.getComparator());
        }
    }

    public int getRegionCount() {
        return this.regions.size();
    }

    public MutablePositionRegion getRegion(int n) {
        return (MutablePositionRegion)this.regions.get(n);
    }

    public int getFirstRegionStartOffset() {
        return this.getRegion(0).getStartOffset();
    }

    public int getFirstRegionEndOffset() {
        return this.getRegion(0).getEndOffset();
    }

    public int getFirstRegionLength() {
        return this.getFirstRegionEndOffset() - this.getFirstRegionStartOffset();
    }

    public MutablePositionRegion getSortedRegion(int n) {
        return (MutablePositionRegion)this.sortedRegions.get(n);
    }

    public void sync(int n) {
        String string;
        if (n != 0) {
            string = this.getRegion(0);
            try {
                Position position = this.doc.createPosition(string.getStartOffset() - n);
                string.setStartPosition(position);
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
        }
        if ((string = this.getFirstRegionText()) != null) {
            int n2 = this.getRegionCount();
            for (int i = 1; i < n2; ++i) {
                MutablePositionRegion mutablePositionRegion = this.getRegion(i);
                int n3 = mutablePositionRegion.getStartOffset();
                int n4 = mutablePositionRegion.getEndOffset() - n3;
                try {
                    if (!string.equals(this.doc.getText(n3, n4))) {
                        this.doc.remove(n3, n4);
                        if (string.length() > 0) {
                            this.doc.insertString(n3, string, null);
                        }
                    }
                    Position position = this.doc.createPosition(n3);
                    mutablePositionRegion.setStartPosition(position);
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                }
            }
        }
    }

    private String getFirstRegionText() {
        return this.getRegionText(0);
    }

    private String getRegionText(int n) {
        try {
            MutablePositionRegion mutablePositionRegion = this.getRegion(n);
            int n2 = mutablePositionRegion.getStartOffset();
            int n3 = mutablePositionRegion.getEndOffset() - n2;
            return this.doc.getText(n2, n3);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
            return null;
        }
    }
}

