/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.cookies;

import java.io.IOException;
import java.io.StringReader;
import org.netbeans.api.xml.parsers.SAXEntityParser;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.xml.schema.cookies.ShareableInputSource;
import org.netbeans.modules.xml.schema.cookies.Util;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class ValidateSchemaSupport
extends ValidateXMLSupport {
    public ValidateSchemaSupport(InputSource inputSource) {
        super(inputSource);
    }

    protected XMLReader createParser(boolean bl) {
        XMLReader xMLReader = super.createParser(bl);
        if (xMLReader == null) {
            return null;
        }
        if (bl) {
            try {
                if (!xMLReader.getFeature("http://apache.org/xml/features/validation/schema")) {
                    return null;
                }
                xMLReader.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
                return new SchemaChecker(xMLReader);
            }
            catch (SAXException sAXException) {
                return null;
            }
        }
        return xMLReader;
    }

    private static class SchemaChecker
    extends SAXEntityParser {
        private static String SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
        private String ns = null;

        public SchemaChecker(XMLReader xMLReader) {
            super(xMLReader);
        }

        protected InputSource wrapInputSource(InputSource inputSource) {
            String string = this.getTargetNamespace();
            String string2 = inputSource.getSystemId();
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = "http://www.w3.org/2001/XMLSchema-instance";
            stringBuffer.append("<schemaWrapper xmlns:xsi='" + string3 + "' ");
            if (string != null) {
                stringBuffer.append("xmlns='" + string + "' ");
                stringBuffer.append("xsi:schemaLocation='" + string + " " + string2 + "'/>");
            } else {
                stringBuffer.append("xsi:noNamespaceSchemaLocation='" + string2 + "'/>");
            }
            StringReader stringReader = new StringReader(stringBuffer.toString());
            InputSource inputSource2 = new InputSource();
            inputSource2.setCharacterStream(stringReader);
            return inputSource2;
        }

        protected boolean propagateException(SAXParseException sAXParseException) {
            if (super.propagateException(sAXParseException)) {
                String string = sAXParseException.getMessage();
                if (string == null) {
                    return true;
                }
                if (this.getTargetNamespace() == null || string.indexOf(this.getTargetNamespace()) < 0) {
                    return string.indexOf("schemaWrapper") < 0;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parse(InputSource inputSource) throws SAXException, IOException {
            ShareableInputSource shareableInputSource = ShareableInputSource.create(inputSource);
            try {
                this.ns = this.parseForTargetNamespace(shareableInputSource);
                shareableInputSource.reset();
                super.parse((InputSource)shareableInputSource);
            }
            finally {
                shareableInputSource.closeAll();
            }
        }

        private String getTargetNamespace() {
            return this.ns;
        }

        private String parseForTargetNamespace(InputSource inputSource) throws SAXException, IOException {
            try {
                XMLReader xMLReader = XMLUtil.createXMLReader((boolean)false, (boolean)true);
                EntityResolver entityResolver = UserCatalog.getDefault().getEntityResolver();
                if (entityResolver != null) {
                    xMLReader.setEntityResolver(entityResolver);
                }
                TargetNSScanner targetNSScanner = new TargetNSScanner();
                xMLReader.setContentHandler(targetNSScanner);
                xMLReader.setErrorHandler(targetNSScanner);
                xMLReader.parse(inputSource);
            }
            catch (Stop stop) {
                return stop.getNamespace();
            }
            return null;
        }

        private static class Stop
        extends SAXException {
            Stop(String string) {
                super(string);
            }

            String getNamespace() {
                return this.getMessage();
            }
        }

        private class TargetNSScanner
        extends DefaultHandler {
            private TargetNSScanner() {
            }

            public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                if ("schema".equals(string2) && SCHEMA_NS.equals(string)) {
                    String string4 = attributes.getValue("targetNamespace");
                    throw new Stop(string4);
                }
                throw new SAXException(Util.THIS.getString("MSG_missing_schema"));
            }
        }
    }
}

