/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xsd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.xml.xsd.AbstractResultNode;
import org.netbeans.modules.xml.xsd.Type;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

class SchemaElement
extends AbstractResultNode
implements Element {
    protected final String namespaceURI;
    protected final String qname;
    protected final Attributes attributes;
    protected final List subelements;
    private String prefix;
    private String schemaPrefix;

    protected SchemaElement() {
        this.namespaceURI = null;
        this.qname = null;
        this.attributes = null;
        this.subelements = null;
        this.schemaPrefix = null;
    }

    protected SchemaElement(String string, String string2, Attributes attributes, String string3) {
        this.namespaceURI = string;
        this.qname = string2;
        this.attributes = attributes == null ? null : new AttributesImpl(attributes);
        this.subelements = new ArrayList();
        this.schemaPrefix = string3;
    }

    public static final SchemaElement createSchemaElement(String string, String string2, Attributes attributes, String string3) {
        String string4 = null;
        String string5 = null;
        if (string3 == null) {
            string4 = "simpleType";
            string5 = "complexType";
        } else {
            string4 = string3 + ':' + "simpleType";
            string5 = string3 + ':' + "complexType";
        }
        if (string2.equalsIgnoreCase(string4) || string2.equalsIgnoreCase(string5)) {
            return new Type(string, string2, attributes, string3);
        }
        return new SchemaElement(string, string2, attributes, string3);
    }

    public final void addSubelement(SchemaElement schemaElement) {
        this.subelements.add(schemaElement);
    }

    public final Iterator getSubelements() {
        return this.subelements.iterator();
    }

    public final boolean isComposite() {
        String string = this.getSchemaPrefix() == null ? "sequence" : this.getSchemaPrefix() + ':' + "sequence";
        return this instanceof Type || this.getQname().equalsIgnoreCase(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("SchemaElement ").append(this.qname);
        if (this.attributes != null) {
            stringBuffer.append("Attrs size: " + this.attributes.getLength());
            for (int i = 0; i < this.attributes.getLength(); ++i) {
                stringBuffer.append("\n Attr[" + i + "] localname: " + this.attributes.getLocalName(i) + " qname: " + this.attributes.getQName(i) + " value: " + this.attributes.getValue(i) + " URI: " + this.attributes.getURI(i) + " type: " + this.attributes.getType(i));
            }
        }
        return stringBuffer.toString();
    }

    public String getQname() {
        return this.qname;
    }

    public Attributes getSAXAttributes() {
        return this.attributes;
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeName() {
        String string = this.getSAXAttributes().getValue("name");
        if (this.prefix != null) {
            string = this.prefix + ':' + string;
        }
        return string;
    }

    public String getTagName() {
        return this.getNodeName();
    }

    public void setPrefix(String string) throws DOMException {
        this.prefix = string;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSchemaPrefix() {
        return this.schemaPrefix;
    }

    public void setSchemaPrefix(String string) {
        this.schemaPrefix = string;
    }
}

