/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.awt.UndoRedo;
import org.openide.text.AnnotationProvider;
import org.openide.text.CloneableEditor;
import org.openide.text.EditorSupportLineSet;
import org.openide.text.EnhancedChangeEvent;
import org.openide.text.FilterDocument;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;
import org.openide.text.PrintSettings;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.UserQuestionException;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;

public abstract class CloneableEditorSupport
extends CloneableOpenSupport {
    public static final String EDITOR_MODE = "editor";
    private static final String PROP_PANE = "CloneableEditorSupport.Pane";
    private static final int DOCUMENT_NO = 0;
    private static final int DOCUMENT_LOADING = 1;
    private static final int DOCUMENT_READY = 2;
    private static final int DOCUMENT_RELOADING = 3;
    private static final ThreadLocal LOCAL_LOAD_TASK = new ThreadLocal();
    private static final ErrorManager ERR = ErrorManager.getDefault().getInstance("org.openide.text.CloneableEditorSupport");
    private static final boolean ERR_LOG = ERR.isLoggable(1);
    private boolean inUserQuestionExceptionHandler;
    private Task prepareTask;
    private EditorKit kit;
    private StyledDocument doc;
    private String mimeType;
    private Listener listener;
    private UndoRedo.Manager undoRedo;
    private Line.Set lineSet;
    private boolean printing;
    private final Object LOCK_PRINTING = new Object();
    private PositionRef.Manager positionManager;
    private HashSet listeners;
    private transient Reference lastSelected;
    private long lastSaveTime;
    private boolean reloadDialogOpened;
    private PropertyChangeSupport propertyChangeSupport;
    private Lookup lookup;
    private boolean alreadyModified;
    private boolean revertingUndoOrReloading;
    private boolean justRevertedToNotModified;
    private int documentStatus = 0;
    private Throwable prepareDocumentRuntimeException;
    private WeakHashMap lineSetWHM;
    private boolean annotationsLoaded;
    private boolean externallyModified;

    public CloneableEditorSupport(Env env) {
        this(env, Lookup.EMPTY);
    }

    public CloneableEditorSupport(Env env, Lookup lookup) {
        super((CloneableOpenSupport.Env)env);
        this.lookup = lookup;
    }

    protected abstract String messageSave();

    protected abstract String messageName();

    protected String messageHtmlName() {
        return null;
    }

    protected String documentID() {
        return this.messageName();
    }

    protected abstract String messageToolTip();

    protected String messageLine(Line line) {
        return NbBundle.getMessage((Class)Line.class, (String)"FMT_CESLineDisplayName", (Object)this.messageName(), (Object)new Integer(line.getLineNumber() + 1));
    }

    final Env cesEnv() {
        return (Env)this.env;
    }

    final EditorKit cesKit() {
        return this.kit;
    }

    protected final synchronized UndoRedo.Manager getUndoRedo() {
        if (this.undoRedo == null) {
            this.undoRedo = this.createUndoRedoManager();
        }
        return this.undoRedo;
    }

    final synchronized PositionRef.Manager getPositionManager() {
        if (this.positionManager == null) {
            this.positionManager = new PositionRef.Manager(this);
        }
        return this.positionManager;
    }

    void ensureAnnotationsLoaded() {
        if (!this.annotationsLoaded) {
            this.annotationsLoaded = true;
            Line.Set set = this.getLineSet();
            Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(AnnotationProvider.class));
            Iterator iterator = result.allInstances().iterator();
            while (iterator.hasNext()) {
                AnnotationProvider annotationProvider = (AnnotationProvider)iterator.next();
                annotationProvider.annotate(set, this.lookup);
            }
        }
    }

    private void askUserAndDoOpen(UserQuestionException userQuestionException) {
        while (userQuestionException != null) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)userQuestionException.getLocalizedMessage(), 0);
            confirmation.setOptions(new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION});
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (NotifyDescriptor.OK_OPTION.equals(object)) {
                try {
                    userQuestionException.confirmed();
                }
                catch (IOException iOException) {
                    ERR.notify((Throwable)iOException);
                    return;
                }
            } else {
                return;
            }
            userQuestionException = null;
            try {
                this.getListener().loadExc = null;
                this.prepareTask = null;
                this.documentStatus = 0;
                this.openDocument();
                super.open();
            }
            catch (UserQuestionException userQuestionException2) {
                userQuestionException = userQuestionException2;
            }
            catch (IOException iOException) {
                ERR.notify(1, (Throwable)iOException);
            }
        }
    }

    public void open() {
        try {
            if (this.getListener().loadExc instanceof UserQuestionException) {
                this.getListener().loadExc = null;
                this.prepareTask = null;
                this.documentStatus = 0;
            }
            this.openDocument();
            super.open();
        }
        catch (UserQuestionException userQuestionException) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.askUserAndDoOpen(userQuestionException);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CloneableEditorSupport.this.askUserAndDoOpen(userQuestionException);
                    }
                });
            }
        }
        catch (IOException iOException) {
            ERR.notify(1, (Throwable)iOException);
        }
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(propertyChangeListener);
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        this.getPropertyChangeSupport().firePropertyChange(string, object, object2);
    }

    private synchronized PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport((Object)this);
        }
        return this.propertyChangeSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task prepareDocument() {
        Object object = this.getLock();
        synchronized (object) {
            switch (this.documentStatus) {
                case 0: {
                    this.documentStatus = 1;
                    return this.prepareDocument(false);
                }
            }
            if (this.prepareTask == null) {
                throw new IllegalStateException();
            }
            return this.prepareTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task prepareDocument(boolean bl) {
        if (this.prepareTask != null) {
            return this.prepareTask;
        }
        try {
            this.env.removePropertyChangeListener((PropertyChangeListener)this.getListener());
            this.env.addPropertyChangeListener((PropertyChangeListener)this.getListener());
            this.kit = this.createEditorKit();
            if (this.doc == null) {
                this.doc = this.createStyledDocument(this.kit);
            }
            final StyledDocument styledDocument = this.doc;
            this.prepareTask = RequestProcessor.getDefault().post(new Runnable(){
                private boolean runningInAtomicLock;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    if (!this.runningInAtomicLock) {
                        this.runningInAtomicLock = true;
                        NbDocument.runAtomic(styledDocument, this);
                        return;
                    }
                    Object object = CloneableEditorSupport.this.getLock();
                    synchronized (object) {
                        block15: {
                            Object object2;
                            if (CloneableEditorSupport.this.documentStatus == 0) {
                                return;
                            }
                            if (CloneableEditorSupport.this.doc != styledDocument) {
                                return;
                            }
                            CloneableEditorSupport.this.prepareDocumentRuntimeException = null;
                            int n = 0;
                            try {
                                try {
                                    CloneableEditorSupport.this.getListener().run();
                                    CloneableEditorSupport.this.documentStatus = 2;
                                    CloneableEditorSupport.this.fireDocumentChange(CloneableEditorSupport.this.doc, false);
                                    n = 2;
                                    CloneableEditorSupport.this.doc.addUndoableEditListener((UndoableEditListener)CloneableEditorSupport.this.getUndoRedo());
                                }
                                catch (DelegateIOExc delegateIOExc) {
                                    CloneableEditorSupport.this.prepareDocumentRuntimeException = delegateIOExc;
                                    CloneableEditorSupport.this.prepareTask = null;
                                    Object var5_4 = null;
                                    Object object4 = CloneableEditorSupport.this.getLock();
                                    synchronized (object4) {
                                        CloneableEditorSupport.this.documentStatus = n;
                                        CloneableEditorSupport.this.getLock().notifyAll();
                                        break block15;
                                    }
                                }
                                catch (RuntimeException runtimeException) {
                                    CloneableEditorSupport.this.prepareDocumentRuntimeException = runtimeException;
                                    CloneableEditorSupport.this.prepareTask = null;
                                    ERR.notify((Throwable)runtimeException);
                                    throw runtimeException;
                                }
                                catch (Error error) {
                                    CloneableEditorSupport.this.prepareDocumentRuntimeException = error;
                                    CloneableEditorSupport.this.prepareTask = null;
                                    ERR.notify((Throwable)error);
                                    throw error;
                                }
                                Object var5_3 = null;
                                object2 = CloneableEditorSupport.this.getLock();
                            }
                            catch (Throwable throwable) {
                                Object var5_5 = null;
                                Object object3 = CloneableEditorSupport.this.getLock();
                                synchronized (object3) {
                                    CloneableEditorSupport.this.documentStatus = n;
                                    CloneableEditorSupport.this.getLock().notifyAll();
                                    throw throwable;
                                }
                            }
                            synchronized (object2) {
                                CloneableEditorSupport.this.documentStatus = n;
                                CloneableEditorSupport.this.getLock().notifyAll();
                            }
                        }
                        return;
                    }
                }
            });
        }
        catch (RuntimeException runtimeException) {
            Object object = this.getLock();
            synchronized (object) {
                this.prepareDocumentRuntimeException = runtimeException;
                this.documentStatus = 0;
                this.getLock().notifyAll();
            }
            throw runtimeException;
        }
        return this.prepareTask;
    }

    final void addRemoveDocListener(Document document, boolean bl) {
        if (Boolean.TRUE.equals(document.getProperty("supportsModificationListener"))) {
            if (bl) {
                document.putProperty("modificationListener", this.getListener());
            } else {
                document.putProperty("modificationListener", null);
            }
        } else if (bl) {
            document.addDocumentListener(this.getListener());
        } else {
            document.removeDocumentListener(this.getListener());
        }
    }

    private void clearDocument() {
        NbDocument.runAtomic(this.doc, new Runnable(){

            public void run() {
                try {
                    CloneableEditorSupport.this.addRemoveDocListener(CloneableEditorSupport.this.doc, false);
                    CloneableEditorSupport.this.doc.remove(0, CloneableEditorSupport.this.doc.getLength());
                    CloneableEditorSupport.this.addRemoveDocListener(CloneableEditorSupport.this.doc, true);
                }
                catch (BadLocationException badLocationException) {
                    ERR.notify(1, (Throwable)badLocationException);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyledDocument openDocument() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            return this.openDocumentCheckIOE();
        }
    }

    private StyledDocument openDocumentCheckIOE() throws IOException {
        StyledDocument styledDocument = this.openDocumentImpl();
        IOException iOException = this.getListener().checkLoadException();
        if (iOException != null) {
            throw iOException;
        }
        return styledDocument;
    }

    private StyledDocument openDocumentImpl() throws IOException, InterruptedIOException {
        switch (this.documentStatus) {
            case 0: {
                this.documentStatus = 1;
                this.prepareDocument(false);
                return this.openDocumentImpl();
            }
            case 2: 
            case 3: {
                return this.doc;
            }
        }
        try {
            this.getLock().wait();
        }
        catch (InterruptedException interruptedException) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(interruptedException);
        }
        if (this.prepareDocumentRuntimeException != null) {
            if (this.prepareDocumentRuntimeException instanceof DelegateIOExc) {
                throw (IOException)this.prepareDocumentRuntimeException.getCause();
            }
            if (this.prepareDocumentRuntimeException instanceof Error) {
                throw (Error)this.prepareDocumentRuntimeException;
            }
            throw (RuntimeException)this.prepareDocumentRuntimeException;
        }
        return this.openDocumentImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyledDocument getDocument() {
        Object object = this.getLock();
        synchronized (object) {
            switch (this.documentStatus) {
                case 0: {
                    return null;
                }
            }
            if (LOCAL_LOAD_TASK.get() != null) {
                return this.doc;
            }
            try {
                return this.openDocumentCheckIOE();
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }

    public boolean isModified() {
        return this.cesEnv().isModified();
    }

    public void saveDocument() throws IOException {
        if (!this.cesEnv().isModified()) {
            return;
        }
        if (this.lastSaveTime != -1L) {
            this.externallyModified = false;
            this.cesEnv().getTime();
            if (this.externallyModified) {
                return;
            }
        }
        StyledDocument styledDocument = this.getDocument();
        class SaveAsReader
        implements Runnable {
            private boolean doMarkAsUnmodified;
            private IOException ex;
            private final /* synthetic */ StyledDocument val$myDoc;

            SaveAsReader(StyledDocument styledDocument) {
                this.val$myDoc = styledDocument;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    block11: {
                        BufferedOutputStream bufferedOutputStream = null;
                        long l = CloneableEditorSupport.this.lastSaveTime;
                        try {
                            try {
                                CloneableEditorSupport.this.setLastSaveTime(-1L);
                                bufferedOutputStream = new BufferedOutputStream(CloneableEditorSupport.this.cesEnv().outputStream());
                                CloneableEditorSupport.this.saveFromKitToStream(this.val$myDoc, CloneableEditorSupport.this.kit, bufferedOutputStream);
                                ((OutputStream)bufferedOutputStream).close();
                                bufferedOutputStream = null;
                                ERR.log("Save ok, assign new time, while old was: " + l);
                                CloneableEditorSupport.this.setLastSaveTime(System.currentTimeMillis());
                                this.doMarkAsUnmodified = true;
                                ERR.log("doMarkAsUnmodified");
                            }
                            catch (BadLocationException badLocationException) {
                                ERR.notify((Throwable)badLocationException);
                                Object var6_5 = null;
                                if (CloneableEditorSupport.this.lastSaveTime == -1L) {
                                    ERR.log("restoring old save time");
                                    CloneableEditorSupport.this.setLastSaveTime(l);
                                }
                                if (bufferedOutputStream != null) {
                                    ((OutputStream)bufferedOutputStream).close();
                                }
                                break block11;
                            }
                            Object var6_4 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_6 = null;
                            if (CloneableEditorSupport.this.lastSaveTime == -1L) {
                                ERR.log("restoring old save time");
                                CloneableEditorSupport.this.setLastSaveTime(l);
                            }
                            if (bufferedOutputStream == null) throw throwable;
                            ((OutputStream)bufferedOutputStream).close();
                            throw throwable;
                        }
                        if (CloneableEditorSupport.this.lastSaveTime == -1L) {
                            ERR.log("restoring old save time");
                            CloneableEditorSupport.this.setLastSaveTime(l);
                        }
                        if (bufferedOutputStream != null) {
                            ((OutputStream)bufferedOutputStream).close();
                        }
                    }
                    CloneableEditorSupport.this.getUndoRedo().undoableEditHappened(new UndoableEditEvent(this, new BeforeSaveEdit(CloneableEditorSupport.this.lastSaveTime)));
                    CloneableEditorSupport.this.updateLineSet(true);
                    return;
                }
                catch (IOException iOException) {
                    this.ex = iOException;
                }
            }

            public void after() throws IOException {
                if (this.doMarkAsUnmodified) {
                    CloneableEditorSupport.this.callNotifyUnmodified();
                }
                if (this.ex != null) {
                    throw this.ex;
                }
            }
        }
        SaveAsReader saveAsReader = new SaveAsReader(styledDocument);
        styledDocument.render(saveAsReader);
        saveAsReader.after();
    }

    public JEditorPane[] getOpenedPanes() {
        LinkedList<JEditorPane> linkedList = new LinkedList<JEditorPane>();
        Enumeration enumeration = this.allEditors.getComponents();
        while (enumeration.hasMoreElements()) {
            CloneableTopComponent cloneableTopComponent = (CloneableTopComponent)enumeration.nextElement();
            Pane pane = (Pane)cloneableTopComponent.getClientProperty((Object)PROP_PANE);
            if (pane == null && cloneableTopComponent instanceof Pane) {
                pane = (Pane)cloneableTopComponent;
            }
            if (pane != null) {
                JEditorPane jEditorPane = pane.getEditorPane();
                if (jEditorPane == null) continue;
                if (this.getLastSelected() == pane) {
                    linkedList.addFirst(jEditorPane);
                    continue;
                }
                linkedList.add(jEditorPane);
                continue;
            }
            throw new IllegalStateException("No reference to Pane. Please file a bug against openide/text");
        }
        return linkedList.isEmpty() ? null : linkedList.toArray(new JEditorPane[linkedList.size()]);
    }

    final Pane getLastSelected() {
        Reference reference = this.lastSelected;
        return reference == null ? null : (Pane)reference.get();
    }

    final void setLastSelected(Pane pane) {
        this.lastSelected = new WeakReference<Pane>(pane);
    }

    public Line.Set getLineSet() {
        return this.updateLineSet(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final WeakHashMap findWeakHashMap() {
        Object object = this.LOCK_PRINTING;
        synchronized (object) {
            if (this.lineSetWHM != null) {
                return this.lineSetWHM;
            }
            this.lineSetWHM = new WeakHashMap();
            return this.lineSetWHM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void print() {
        Object object2 = this.LOCK_PRINTING;
        synchronized (object2) {
            if (this.printing) {
                return;
            }
            this.printing = true;
        }
        try {
            block19: {
                try {
                    object2 = PrinterJob.getPrinterJob();
                    Object object = NbDocument.findPageable(this.openDocument());
                    if (object instanceof Pageable) {
                        ((PrinterJob)object2).setPageable((Pageable)object);
                    } else {
                        PageFormat pageFormat = PrintSettings.getPageFormat((PrinterJob)object2);
                        ((PrinterJob)object2).setPrintable((Printable)object, pageFormat);
                    }
                    if (!((PrinterJob)object2).printDialog()) break block19;
                    ((PrinterJob)object2).print();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    CloneableEditorSupport.notifyProblem(fileNotFoundException, "CTL_Bad_File");
                    Object var5_9 = null;
                    Object object = this.LOCK_PRINTING;
                    synchronized (object) {
                        this.printing = false;
                        return;
                    }
                }
                catch (IOException iOException) {
                    ERR.notify((Throwable)iOException);
                    Object var5_10 = null;
                    Object object5 = this.LOCK_PRINTING;
                    synchronized (object5) {
                        this.printing = false;
                        return;
                    }
                }
                catch (PrinterAbortException printerAbortException) {
                    CloneableEditorSupport.notifyProblem(printerAbortException, "CTL_Printer_Abort");
                    Object var5_11 = null;
                    Object object6 = this.LOCK_PRINTING;
                    synchronized (object6) {
                        this.printing = false;
                        return;
                    }
                }
                catch (PrinterException printerException) {
                    CloneableEditorSupport.notifyProblem(printerException, "EXC_Printer_Problem");
                    Object var5_12 = null;
                    Object object7 = this.LOCK_PRINTING;
                    synchronized (object7) {
                        this.printing = false;
                        return;
                    }
                }
            }
            Object var5_8 = null;
            Object object = this.LOCK_PRINTING;
            synchronized (object) {
                this.printing = false;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_13 = null;
            Object object8 = this.LOCK_PRINTING;
            synchronized (object8) {
                this.printing = false;
                throw throwable;
            }
        }
    }

    private static void notifyProblem(Exception exception, String string) {
        String string2 = NbBundle.getMessage((Class)CloneableEditorSupport.class, (String)string, (Object)exception.getLocalizedMessage());
        ERR.annotate((Throwable)exception, string2);
        ERR.notify(256, (Throwable)exception);
    }

    protected CloneableTopComponent createCloneableTopComponent() {
        this.prepareDocument();
        Pane pane = this.createPane();
        pane.getComponent().putClientProperty((Object)PROP_PANE, (Object)pane);
        return pane.getComponent();
    }

    protected Pane createPane() {
        CloneableEditor cloneableEditor = this.createCloneableEditor();
        this.initializeCloneableEditor(cloneableEditor);
        return cloneableEditor;
    }

    protected Component wrapEditorComponent(Component component) {
        return component;
    }

    protected boolean canClose() {
        if (this.cesEnv().isModified()) {
            class SafeAWTAccess
            implements Runnable {
                boolean running;
                boolean finished;
                int ret;

                SafeAWTAccess() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    SafeAWTAccess safeAWTAccess;
                    SafeAWTAccess safeAWTAccess2 = this;
                    synchronized (safeAWTAccess2) {
                        this.running = true;
                        this.notifyAll();
                    }
                    try {
                        this.ret = CloneableEditorSupport.this.canCloseImpl();
                        Object var4_3 = null;
                        safeAWTAccess = this;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        SafeAWTAccess safeAWTAccess3 = this;
                        synchronized (safeAWTAccess3) {
                            this.finished = true;
                            this.notifyAll();
                        }
                        throw throwable;
                    }
                    synchronized (safeAWTAccess) {
                        this.finished = true;
                        this.notifyAll();
                    }
                }

                public synchronized void waitForResult() throws InterruptedException {
                    if (!this.running) {
                        this.wait(10000L);
                    }
                    if (!this.running) {
                        throw new InterruptedException("Waiting 10s for AWT and nothing! Exiting to prevent deadlock");
                    }
                    while (!this.finished) {
                        this.wait();
                    }
                }
            }
            SafeAWTAccess safeAWTAccess = new SafeAWTAccess();
            if (SwingUtilities.isEventDispatchThread()) {
                safeAWTAccess.run();
            } else {
                SwingUtilities.invokeLater(safeAWTAccess);
                try {
                    safeAWTAccess.waitForResult();
                }
                catch (InterruptedException interruptedException) {
                    ERR.notify(1, (Throwable)interruptedException);
                    return false;
                }
            }
            if (safeAWTAccess.ret == 0) {
                return false;
            }
            if (safeAWTAccess.ret == 1) {
                try {
                    this.saveDocument();
                }
                catch (IOException iOException) {
                    ERR.notify((Throwable)iOException);
                    return false;
                }
            }
        }
        return true;
    }

    private int canCloseImpl() {
        String string = this.messageSave();
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)CloneableEditorSupport.class);
        JButton jButton = new JButton(resourceBundle.getString("CTL_Save"));
        jButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Save"));
        jButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CTL_Save"));
        JButton jButton2 = new JButton(resourceBundle.getString("CTL_Discard"));
        jButton2.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Discard"));
        jButton2.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CTL_Discard"));
        jButton2.setMnemonic(resourceBundle.getString("CTL_Discard_Mnemonic").charAt(0));
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, resourceBundle.getString("LBL_SaveFile_Title"), 1, 3, new Object[]{jButton, jButton2, NotifyDescriptor.CANCEL_OPTION}, (Object)jButton);
        Object object = DialogDisplayer.getDefault().notify(notifyDescriptor);
        if (NotifyDescriptor.CANCEL_OPTION.equals(object) || NotifyDescriptor.CLOSED_OPTION.equals(object)) {
            return 0;
        }
        if (jButton.equals(object)) {
            return 1;
        }
        return -1;
    }

    public boolean isDocumentLoaded() {
        return this.documentStatus != 0;
    }

    public void setMIMEType(String string) {
        this.mimeType = string;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            this.listeners = new HashSet(8);
        }
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (this.listeners != null) {
            this.listeners.remove(changeListener);
        }
    }

    public final PositionRef createPositionRef(int n, Position.Bias bias) {
        return new PositionRef(this.getPositionManager(), n, bias);
    }

    protected CloneableEditor createCloneableEditor() {
        return new CloneableEditor(this);
    }

    protected void initializeCloneableEditor(CloneableEditor cloneableEditor) {
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        return new CESUndoRedoManager(this);
    }

    public InputStream getInputStream() throws IOException {
        StyledDocument styledDocument = this.getDocument();
        if (styledDocument == null) {
            return this.cesEnv().inputStream();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.saveFromKitToStream(styledDocument, this.kit, byteArrayOutputStream);
        }
        catch (BadLocationException badLocationException) {
            ERR.notify(1, (Throwable)badLocationException);
            throw (IllegalStateException)new IllegalStateException(badLocationException.getMessage()).initCause(badLocationException);
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    protected void saveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        editorKit.write(outputStream, (Document)styledDocument, 0, styledDocument.getLength());
    }

    protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        editorKit.read(inputStream, (Document)styledDocument, 0);
    }

    protected Task reloadDocument() {
        if (ERR_LOG) {
            ERR.log("reloadDocument in " + Thread.currentThread());
        }
        if (this.doc != null) {
            NbDocument.runAtomic(this.doc, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    Object object;
                    int n;
                    int[] nArray;
                    CloneableEditorSupport.this.doc.removeUndoableEditListener((UndoableEditListener)CloneableEditorSupport.this.getUndoRedo());
                    JEditorPane[] jEditorPaneArray = CloneableEditorSupport.this.getOpenedPanes();
                    if (jEditorPaneArray != null) {
                        nArray = new int[jEditorPaneArray.length];
                        for (n = 0; n < jEditorPaneArray.length; ++n) {
                            nArray[n] = jEditorPaneArray[n].getCaretPosition();
                        }
                    } else {
                        nArray = new int[]{};
                    }
                    CloneableEditorSupport.this.documentStatus = 3;
                    CloneableEditorSupport.this.prepareDocumentRuntimeException = null;
                    n = 0;
                    try {
                        try {
                            CloneableEditorSupport.this.getPositionManager().documentClosed();
                            CloneableEditorSupport.this.updateLineSet(true);
                            CloneableEditorSupport.this.fireDocumentChange(CloneableEditorSupport.this.doc, true);
                            ERR.log("clearDocument");
                            CloneableEditorSupport.this.clearDocument();
                            CloneableEditorSupport.this.prepareTask = new Task((Runnable)CloneableEditorSupport.this.getListener());
                            if (ERR_LOG) {
                                ERR.log("new prepare task: " + CloneableEditorSupport.this.prepareTask);
                            }
                            CloneableEditorSupport.this.prepareTask.run();
                            ERR.log("prepareTask finished");
                            CloneableEditorSupport.this.documentStatus = 2;
                            CloneableEditorSupport.this.fireDocumentChange(CloneableEditorSupport.this.doc, false);
                            n = 2;
                        }
                        catch (RuntimeException runtimeException) {
                            CloneableEditorSupport.this.prepareDocumentRuntimeException = runtimeException;
                            CloneableEditorSupport.this.prepareTask = null;
                            ERR.notify((Throwable)runtimeException);
                            throw runtimeException;
                        }
                        catch (Error error) {
                            CloneableEditorSupport.this.prepareDocumentRuntimeException = error;
                            CloneableEditorSupport.this.prepareTask = null;
                            ERR.notify((Throwable)error);
                            throw error;
                        }
                        Object var6_4 = null;
                        object = CloneableEditorSupport.this.getLock();
                    }
                    catch (Throwable throwable) {
                        Object var6_5 = null;
                        Object object2 = CloneableEditorSupport.this.getLock();
                        synchronized (object2) {
                            CloneableEditorSupport.this.documentStatus = n;
                            CloneableEditorSupport.this.getLock().notifyAll();
                            throw throwable;
                        }
                    }
                    synchronized (object) {
                        CloneableEditorSupport.this.documentStatus = n;
                        CloneableEditorSupport.this.getLock().notifyAll();
                    }
                    ERR.log("post-reload task posting to AWT");
                    Runnable runtimeException = new Runnable(this, jEditorPaneArray, nArray){
                        private final /* synthetic */ JEditorPane[] val$panes;
                        private final /* synthetic */ int[] val$carets;
                        private final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$panes = jEditorPaneArray;
                            this.val$carets = nArray;
                        }

                        public void run() {
                            if (CloneableEditorSupport.access$300(4.access$1400(this.this$1)) == null) {
                                return;
                            }
                            if (this.val$panes != null) {
                                for (int i = 0; i < this.val$panes.length; ++i) {
                                    int n = this.val$panes[i].getDocument().getLength();
                                    if (this.val$carets[i] > n) {
                                        this.val$carets[i] = n;
                                    }
                                    this.val$panes[i].setCaretPosition(this.val$carets[i]);
                                }
                            }
                            CloneableEditorSupport.access$800().log("task-discardAllEdits");
                            4.access$1400(this.this$1).getUndoRedo().discardAllEdits();
                            CloneableEditorSupport.access$800().log("task-undoableEditHappened");
                            4.access$1400(this.this$1).getUndoRedo().undoableEditHappened(new UndoableEditEvent((Object)((Object)4.access$1400(this.this$1)), 4.access$1400(this.this$1).new BeforeSaveEdit(CloneableEditorSupport.access$900(4.access$1400(this.this$1)))));
                            CloneableEditorSupport.access$800().log("task-check already modified");
                            if (4.access$1400(this.this$1).isAlreadyModified()) {
                                CloneableEditorSupport.access$800().log("task-callNotifyUnmodified");
                                4.access$1400(this.this$1).callNotifyUnmodified();
                            }
                            4.access$1400(this.this$1).updateLineSet(true);
                            CloneableEditorSupport.access$800().log("task-addUndoableEditListener");
                            CloneableEditorSupport.access$300(4.access$1400(this.this$1)).addUndoableEditListener((UndoableEditListener)4.access$1400(this.this$1).getUndoRedo());
                        }
                    };
                    if (CloneableEditorSupport.this.doc != null) {
                        ERR.log("Posting the AWT runnable: " + runtimeException);
                        SwingUtilities.invokeLater(runtimeException);
                        ERR.log("Posted in " + Thread.currentThread());
                    }
                }

                static /* synthetic */ CloneableEditorSupport access$1400(4 var0) {
                    return var0.CloneableEditorSupport.this;
                }
            });
            return this.prepareTask;
        }
        return this.prepareDocument();
    }

    protected EditorKit createEditorKit() {
        if (this.kit != null) {
            return this.kit;
        }
        if (this.mimeType != null) {
            this.kit = JEditorPane.createEditorKitForContentType(this.mimeType);
        } else {
            String string = this.cesEnv().getMimeType();
            this.kit = JEditorPane.createEditorKitForContentType(string);
        }
        if (this.isDumbKit(this.kit)) {
            this.kit = JEditorPane.createEditorKitForContentType("text/plain");
        }
        if (this.isDumbKit(this.kit)) {
            this.kit = new PlainEditorKit();
        }
        return this.kit;
    }

    private boolean isDumbKit(EditorKit editorKit) {
        if (editorKit == null) {
            return true;
        }
        String string = editorKit.getClass().getName();
        return string.equals("javax.swing.text.DefaultEditorKit") || string.equals("javax.swing.JEditorPane$PlainEditorKit") || string.equals("javax.swing.text.html.HTMLEditorKit");
    }

    protected StyledDocument createStyledDocument(EditorKit editorKit) {
        StyledDocument styledDocument = CloneableEditorSupport.createNetBeansDocument(editorKit.createDefaultDocument());
        styledDocument.putProperty("mimeType", this.mimeType != null ? this.mimeType : this.cesEnv().getMimeType());
        return styledDocument;
    }

    protected void notifyUnmodified() {
        this.env.unmarkModified();
        this.updateTitles();
    }

    final boolean callNotifyModified() {
        if (!this.isAlreadyModified() && !this.revertingUndoOrReloading) {
            this.setAlreadyModified(true);
            if (!this.notifyModified()) {
                this.setAlreadyModified(false);
                this.revertingUndoOrReloading = true;
                this.revertPreviousOrUpcomingUndo();
                this.revertingUndoOrReloading = false;
                return false;
            }
        }
        return true;
    }

    final void callNotifyUnmodified() {
        this.setAlreadyModified(false);
        this.notifyUnmodified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean notifyModified() {
        boolean bl = true;
        try {
            this.env.markModified();
        }
        catch (UserQuestionException userQuestionException) {
            CloneableEditorSupport cloneableEditorSupport = this;
            synchronized (cloneableEditorSupport) {
                if (!this.inUserQuestionExceptionHandler) {
                    this.inUserQuestionExceptionHandler = true;
                    RequestProcessor.getDefault().post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)userQuestionException.getLocalizedMessage(), 0);
                            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                            if (NotifyDescriptor.OK_OPTION.equals(object)) {
                                try {
                                    userQuestionException.confirmed();
                                }
                                catch (IOException iOException) {
                                    ERR.notify((Throwable)iOException);
                                }
                            }
                            CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupport.this;
                            synchronized (cloneableEditorSupport) {
                                CloneableEditorSupport.this.inUserQuestionExceptionHandler = false;
                            }
                        }
                    });
                }
            }
            bl = false;
        }
        catch (IOException iOException) {
            String string = null;
            if (iOException.getMessage() != iOException.getLocalizedMessage()) {
                string = iOException.getLocalizedMessage();
            } else {
                ErrorManager.Annotation[] annotationArray = ERR.findAnnotations((Throwable)iOException);
                if (annotationArray != null) {
                    for (int i = 0; i < annotationArray.length; ++i) {
                        if (annotationArray[i].getLocalizedMessage() == null) continue;
                        string = annotationArray[i].getLocalizedMessage();
                        break;
                    }
                }
            }
            if (string != null) {
                StatusDisplayer.getDefault().setStatusText(string);
            }
            bl = false;
        }
        if (!bl) {
            return false;
        }
        this.updateTitles();
        return true;
    }

    private void revertPreviousOrUpcomingUndo() {
        UndoRedo.Manager manager = this.getUndoRedo();
        Listener listener = this.getListener();
        if (Boolean.TRUE.equals(this.getDocument().getProperty("supportsModificationListener"))) {
            SearchBeforeModificationEdit searchBeforeModificationEdit = new SearchBeforeModificationEdit();
            try {
                while (true) {
                    searchBeforeModificationEdit.delegate = null;
                    manager.undoableEditHappened(new UndoableEditEvent(this.getDocument(), searchBeforeModificationEdit));
                    if (searchBeforeModificationEdit.delegate instanceof BeforeModificationEdit) {
                        if (searchBeforeModificationEdit.delegate == null) break;
                        manager.undo();
                    }
                    if (searchBeforeModificationEdit.delegate instanceof BeforeSaveEdit) break;
                    manager.undo();
                }
            }
            catch (CannotUndoException cannotUndoException) {}
        } else {
            listener.setUndoTask(new Runnable(){

                public void run() {
                    CloneableEditorSupport.this.undoAll();
                }
            });
            manager.addChangeListener((ChangeListener)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void undoAll() {
        StyledDocument styledDocument = this.doc;
        if (styledDocument == null) {
            return;
        }
        UndoRedo.Manager manager = this.getUndoRedo();
        this.addRemoveDocListener(styledDocument, false);
        try {
            if (manager.canUndo()) {
                Toolkit.getDefaultToolkit().beep();
                manager.undo();
            }
        }
        catch (CannotUndoException cannotUndoException) {
            ERR.notify(1, (Throwable)cannotUndoException);
        }
        finally {
            this.addRemoveDocListener(styledDocument, true);
        }
    }

    protected void notifyClosed() {
        this.closeDocument();
    }

    boolean isEnvReadOnly() {
        return false;
    }

    final StyledDocument getDocumentHack() {
        return this.doc;
    }

    final Lookup getLookup() {
        return this.lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Line.Set updateLineSet(boolean bl) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.lineSet != null && !bl) {
                return this.lineSet;
            }
            Line.Set set = this.lineSet;
            this.lineSet = this.doc == null || this.documentStatus == 3 ? new EditorSupportLineSet.Closed(this) : new EditorSupportLineSet(this, this.doc);
            return this.lineSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadDocument(EditorKit editorKit, StyledDocument styledDocument) throws IOException {
        Exception exception;
        Exception exception2 = null;
        try {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.cesEnv().inputStream());
                try {
                    this.loadFromStreamToKit(styledDocument, bufferedInputStream, editorKit);
                }
                finally {
                    ((InputStream)bufferedInputStream).close();
                }
                Object var7_9 = null;
                if (exception2 == null) return;
                exception = exception2;
            }
            catch (UserQuestionException userQuestionException) {
                throw userQuestionException;
            }
            catch (IOException iOException) {
                exception2 = iOException;
                throw iOException;
            }
            catch (Exception exception4) {
                exception2 = exception4;
                Object var7_10 = null;
                if (exception2 == null) return;
                Exception exception5 = exception2;
                SwingUtilities.invokeLater(new Runnable(exception5){
                    private final /* synthetic */ Throwable val$tmp;
                    {
                        this.val$tmp = throwable;
                    }

                    public void run() {
                        ERR.annotate(this.val$tmp, NbBundle.getMessage((Class)(class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = CloneableEditorSupport.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport), (String)"EXC_LoadDocument", (Object)CloneableEditorSupport.this.messageName()));
                        ERR.notify(this.val$tmp);
                    }
                });
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (exception2 == null) throw throwable;
            Exception exception3 = exception2;
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    protected boolean close(boolean bl) {
        if (!super.close(bl)) {
            return false;
        }
        this.notifyClosed();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDocument() {
        Object object = this.getLock();
        synchronized (object) {
            switch (this.documentStatus) {
                case 0: {
                    return;
                }
            }
            this.doCloseDocument();
            return;
        }
    }

    private void doCloseDocument() {
        this.prepareTask = null;
        this.cesEnv().removePropertyChangeListener(this.getListener());
        this.callNotifyUnmodified();
        if (this.doc != null) {
            this.doc.removeUndoableEditListener((UndoableEditListener)this.getUndoRedo());
            this.addRemoveDocListener(this.doc, false);
        }
        if (this.positionManager != null) {
            this.positionManager.documentClosed();
            this.documentStatus = 0;
            this.fireDocumentChange(this.doc, true);
        }
        this.documentStatus = 0;
        this.doc = null;
        this.kit = null;
        this.getUndoRedo().discardAllEdits();
        this.updateLineSet(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReload(boolean bl) {
        StyledDocument styledDocument;
        Object object = this.getLock();
        synchronized (object) {
            if (this.documentStatus != 2) {
                return;
            }
            styledDocument = this.doc;
        }
        if (!bl && !this.reloadDialogOpened) {
            object = NbBundle.getMessage((Class)CloneableEditorSupport.class, (String)"FMT_External_change", (Object)styledDocument.getProperty("title"));
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation(object, 0);
            this.reloadDialogOpened = true;
            try {
                Object object2 = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (NotifyDescriptor.YES_OPTION.equals(object2)) {
                    bl = true;
                }
            }
            finally {
                this.reloadDialogOpened = false;
            }
        }
        object = this.getLock();
        synchronized (object) {
            if (this.documentStatus != 2) {
                return;
            }
            if (bl) {
                this.reloadDocument();
            }
        }
    }

    private static StyledDocument createNetBeansDocument(Document document) {
        if (document instanceof StyledDocument) {
            return (StyledDocument)document;
        }
        return new FilterDocument(document);
    }

    private final void fireDocumentChange(StyledDocument styledDocument, boolean bl) {
        this.fireStateChangeEvent(styledDocument, bl);
        this.firePropertyChange("document", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fireStateChangeEvent(StyledDocument styledDocument, boolean bl) {
        if (this.listeners != null) {
            HashSet hashSet;
            EnhancedChangeEvent enhancedChangeEvent = new EnhancedChangeEvent((Object)this, styledDocument, bl);
            Object object = this;
            synchronized (object) {
                hashSet = (HashSet)this.listeners.clone();
            }
            object = hashSet.iterator();
            while (object.hasNext()) {
                ChangeListener changeListener = (ChangeListener)object.next();
                changeListener.stateChanged(enhancedChangeEvent);
            }
        }
    }

    protected void updateTitles() {
        Enumeration enumeration = this.allEditors.getComponents();
        while (enumeration.hasMoreElements()) {
            CloneableTopComponent cloneableTopComponent = (CloneableTopComponent)enumeration.nextElement();
            Pane pane = (Pane)cloneableTopComponent.getClientProperty((Object)PROP_PANE);
            if (pane == null && cloneableTopComponent instanceof Pane) {
                pane = (Pane)cloneableTopComponent;
            }
            if (pane != null) {
                pane.updateName();
                continue;
            }
            throw new IllegalStateException("No reference to Pane. Please file a bug against openide/text");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pane openPane() {
        Pane pane = null;
        boolean bl = false;
        Object object = this.getLock();
        synchronized (object) {
            pane = this.getAnyEditor();
            if (pane == null) {
                String string = this.messageOpening();
                if (string != null) {
                    StatusDisplayer.getDefault().setStatusText(string);
                }
                this.prepareDocument();
                pane = this.createPane();
                pane.getComponent().putClientProperty((Object)PROP_PANE, (Object)pane);
                pane.getComponent().setReference(this.allEditors);
                bl = true;
            }
        }
        pane.getComponent().open();
        if (bl) {
            object = this.messageOpened();
            if (object == null) {
                object = "";
            }
            StatusDisplayer.getDefault().setStatusText((String)object);
        }
        return pane;
    }

    private Pane getAnyEditor() {
        CloneableTopComponent cloneableTopComponent = this.allEditors.getArbitraryComponent();
        if (cloneableTopComponent == null) {
            return null;
        }
        Pane pane = (Pane)cloneableTopComponent.getClientProperty((Object)PROP_PANE);
        if (pane != null) {
            return pane;
        }
        if (cloneableTopComponent instanceof Pane) {
            return (Pane)cloneableTopComponent;
        }
        Enumeration enumeration = this.allEditors.getComponents();
        if (enumeration.hasMoreElements()) {
            cloneableTopComponent = (CloneableTopComponent)enumeration.nextElement();
            pane = (Pane)cloneableTopComponent.getClientProperty((Object)PROP_PANE);
            if (pane != null) {
                return pane;
            }
            if (cloneableTopComponent instanceof Pane) {
                return (Pane)cloneableTopComponent;
            }
            throw new IllegalStateException("No reference to Pane. Please file a bug against openide/text");
        }
        return null;
    }

    protected final Pane openAt(PositionRef positionRef, int n) {
        Pane pane = this.openPane();
        Task task = this.prepareDocument();
        pane.ensureVisible();
        class Selector
        implements TaskListener,
        Runnable {
            private final /* synthetic */ Pane val$e;
            private final /* synthetic */ int val$column;
            private final /* synthetic */ PositionRef val$pos;

            Selector(Pane pane, int n, PositionRef positionRef) {
                this.val$e = pane;
                this.val$column = n;
                this.val$pos = positionRef;
            }

            public void taskFinished(Task task) {
                SwingUtilities.invokeLater(this);
                task.removeTaskListener((TaskListener)this);
            }

            public void run() {
                int n;
                JEditorPane jEditorPane = this.val$e.getEditorPane();
                if (jEditorPane == null) {
                    return;
                }
                StyledDocument styledDocument = CloneableEditorSupport.this.getDocument();
                if (styledDocument == null) {
                    return;
                }
                Caret caret = jEditorPane.getCaret();
                if (caret == null) {
                    return;
                }
                if (this.val$column >= 0) {
                    Element element = NbDocument.findLineRootElement(styledDocument);
                    n = (element = element.getElement(element.getElementIndex(this.val$pos.getOffset()))).getStartOffset() + this.val$column;
                    if (n > element.getEndOffset()) {
                        n = element.getEndOffset();
                    }
                } else {
                    n = this.val$pos.getOffset();
                }
                caret.setDot(n);
            }
        }
        task.addTaskListener((TaskListener)new Selector(pane, n, positionRef));
        return pane;
    }

    final Object getLock() {
        return this.allEditors;
    }

    private Listener getListener() {
        if (this.listener == null) {
            this.listener = new Listener();
        }
        return this.listener;
    }

    void howToReproduceDeadlock40766(boolean bl) {
    }

    final void setLastSaveTime(long l) {
        ERR.log("Setting new lastSaveTime to " + l);
        this.lastSaveTime = l;
    }

    final boolean isAlreadyModified() {
        return this.alreadyModified;
    }

    final void setAlreadyModified(boolean bl) {
        if (ERR_LOG) {
            ERR.notify(1, (Throwable)new Exception("Setting to modified: " + bl));
        }
        this.alreadyModified = bl;
    }

    static /* synthetic */ boolean access$1802(CloneableEditorSupport cloneableEditorSupport, boolean bl) {
        cloneableEditorSupport.revertingUndoOrReloading = bl;
        return cloneableEditorSupport.revertingUndoOrReloading;
    }

    static /* synthetic */ void access$1900(CloneableEditorSupport cloneableEditorSupport, boolean bl) {
        cloneableEditorSupport.checkReload(bl);
    }

    private static final class DelegateIOExc
    extends IllegalStateException {
        public DelegateIOExc(IOException iOException) {
            super(iOException.getMessage());
            this.initCause(iOException);
        }
    }

    private static final class CESUndoRedoManager
    extends UndoRedo.Manager {
        private CloneableEditorSupport support;

        public CESUndoRedoManager(CloneableEditorSupport cloneableEditorSupport) {
            this.support = cloneableEditorSupport;
            super.setLimit(1000);
        }

        public void redo() throws CannotRedoException {
            StyledDocument styledDocument = this.support.getDocument();
            if (styledDocument == null) {
                throw new CannotRedoException();
            }
            this.support.justRevertedToNotModified = false;
            new RenderUndo(0, styledDocument);
            if (this.support.justRevertedToNotModified && this.support.isAlreadyModified()) {
                this.support.callNotifyUnmodified();
            }
        }

        public void undo() throws CannotUndoException {
            StyledDocument styledDocument = this.support.getDocument();
            if (styledDocument == null) {
                throw new CannotUndoException();
            }
            this.support.justRevertedToNotModified = false;
            new RenderUndo(1, styledDocument);
            if (this.support.justRevertedToNotModified && this.support.isAlreadyModified()) {
                this.support.callNotifyUnmodified();
            }
        }

        public boolean canRedo() {
            StyledDocument styledDocument = this.support.getDocument();
            return (CESUndoRedoManager)this.new RenderUndo((int)2, (StyledDocument)styledDocument).booleanResult;
        }

        public boolean canUndo() {
            StyledDocument styledDocument = this.support.getDocument();
            return (CESUndoRedoManager)this.new RenderUndo((int)3, (StyledDocument)styledDocument).booleanResult;
        }

        public int getLimit() {
            StyledDocument styledDocument = this.support.getDocument();
            return (CESUndoRedoManager)this.new RenderUndo((int)4, (StyledDocument)styledDocument).intResult;
        }

        public void discardAllEdits() {
            StyledDocument styledDocument = this.support.getDocument();
            new RenderUndo(5, styledDocument);
        }

        public void setLimit(int n) {
            StyledDocument styledDocument = this.support.getDocument();
            new RenderUndo(6, styledDocument, n);
        }

        public boolean canUndoOrRedo() {
            StyledDocument styledDocument = this.support.getDocument();
            return (CESUndoRedoManager)this.new RenderUndo((int)7, (StyledDocument)styledDocument).booleanResult;
        }

        public String getUndoOrRedoPresentationName() {
            StyledDocument styledDocument = this.support.getDocument();
            return (CESUndoRedoManager)this.new RenderUndo((int)8, (StyledDocument)styledDocument).stringResult;
        }

        public String getRedoPresentationName() {
            StyledDocument styledDocument = this.support.getDocument();
            return (CESUndoRedoManager)this.new RenderUndo((int)9, (StyledDocument)styledDocument).stringResult;
        }

        public String getUndoPresentationName() {
            StyledDocument styledDocument = this.support.getDocument();
            return (CESUndoRedoManager)this.new RenderUndo((int)10, (StyledDocument)styledDocument).stringResult;
        }

        public void undoOrRedo() throws CannotUndoException, CannotRedoException {
            StyledDocument styledDocument = this.support.getDocument();
            if (styledDocument == null) {
                throw new CannotUndoException();
            }
            this.support.justRevertedToNotModified = false;
            new RenderUndo(11, styledDocument);
            if (this.support.justRevertedToNotModified && this.support.isAlreadyModified()) {
                this.support.callNotifyUnmodified();
            }
        }

        private final class RenderUndo
        implements Runnable {
            private final int type;
            public boolean booleanResult;
            public int intResult;
            public String stringResult;

            public RenderUndo(int n, StyledDocument styledDocument) {
                this(n, styledDocument, 0);
            }

            public RenderUndo(int n, StyledDocument styledDocument, int n2) {
                this.type = n;
                this.intResult = n2;
                if (styledDocument instanceof NbDocument.WriteLockable) {
                    ((NbDocument.WriteLockable)((Object)styledDocument)).runAtomic(this);
                } else {
                    this.run();
                }
            }

            public void run() {
                switch (this.type) {
                    case 0: {
                        CESUndoRedoManager.super.redo();
                        break;
                    }
                    case 1: {
                        CESUndoRedoManager.super.undo();
                        break;
                    }
                    case 2: {
                        this.booleanResult = CESUndoRedoManager.super.canRedo();
                        break;
                    }
                    case 3: {
                        this.booleanResult = CESUndoRedoManager.super.canUndo();
                        break;
                    }
                    case 4: {
                        this.intResult = CESUndoRedoManager.super.getLimit();
                        break;
                    }
                    case 5: {
                        CESUndoRedoManager.super.discardAllEdits();
                        break;
                    }
                    case 6: {
                        CESUndoRedoManager.super.setLimit(this.intResult);
                        break;
                    }
                    case 7: {
                        CESUndoRedoManager.super.canUndoOrRedo();
                        break;
                    }
                    case 8: {
                        this.stringResult = CESUndoRedoManager.super.getUndoOrRedoPresentationName();
                        break;
                    }
                    case 9: {
                        this.stringResult = CESUndoRedoManager.super.getRedoPresentationName();
                        break;
                    }
                    case 10: {
                        this.stringResult = CESUndoRedoManager.super.getUndoPresentationName();
                        break;
                    }
                    case 11: {
                        CESUndoRedoManager.super.undoOrRedo();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown type: " + this.type);
                    }
                }
            }
        }
    }

    private class SearchBeforeModificationEdit
    extends FilterUndoableEdit {
        SearchBeforeModificationEdit() {
        }

        public boolean replaceEdit(UndoableEdit undoableEdit) {
            if (this.delegate == null) {
                this.delegate = undoableEdit;
                return true;
            }
            return false;
        }
    }

    private class BeforeModificationEdit
    extends FilterUndoableEdit {
        private long saveTime;

        BeforeModificationEdit(long l, UndoableEdit undoableEdit) {
            this.saveTime = l;
            this.delegate = undoableEdit;
            ErrorManager errorManager = ERR;
            ERR;
            if (errorManager.isLoggable(1)) {
                ERR.notify(1, (Throwable)new Exception("new BeforeModificationEdit(" + l + ")"));
            }
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            if (this.delegate == null && !(undoableEdit instanceof SearchBeforeModificationEdit)) {
                this.delegate = undoableEdit;
                return true;
            }
            return false;
        }

        public void undo() {
            super.undo();
            boolean bl = this.saveTime == CloneableEditorSupport.this.lastSaveTime;
            ERR.log("Comparing saveTime and lastSaveTime: " + this.saveTime + "==" + CloneableEditorSupport.this.lastSaveTime + " is " + bl);
            if (bl) {
                CloneableEditorSupport.this.justRevertedToNotModified = true;
            }
        }
    }

    private class BeforeSaveEdit
    extends FilterUndoableEdit {
        private long saveTime;

        BeforeSaveEdit(long l) {
            this.saveTime = l;
        }

        public boolean replaceEdit(UndoableEdit undoableEdit) {
            if (this.delegate == null) {
                this.delegate = undoableEdit;
                return true;
            }
            return false;
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            if (!(undoableEdit instanceof BeforeModificationEdit) && !(undoableEdit instanceof SearchBeforeModificationEdit)) {
                CloneableEditorSupport.this.getUndoRedo().addEdit((UndoableEdit)new BeforeModificationEdit(this.saveTime, undoableEdit));
                return true;
            }
            return false;
        }

        public void redo() {
            super.redo();
            if (this.saveTime == CloneableEditorSupport.this.lastSaveTime) {
                CloneableEditorSupport.this.justRevertedToNotModified = true;
            }
        }

        public boolean isSignificant() {
            return this.delegate != null;
        }
    }

    private class FilterUndoableEdit
    implements UndoableEdit {
        protected UndoableEdit delegate;

        FilterUndoableEdit() {
        }

        public void undo() throws CannotUndoException {
            if (this.delegate != null) {
                this.delegate.undo();
            }
        }

        public boolean canUndo() {
            if (this.delegate != null) {
                return this.delegate.canUndo();
            }
            return false;
        }

        public void redo() throws CannotRedoException {
            if (this.delegate != null) {
                this.delegate.redo();
            }
        }

        public boolean canRedo() {
            if (this.delegate != null) {
                return this.delegate.canRedo();
            }
            return false;
        }

        public void die() {
            if (this.delegate != null) {
                this.delegate.die();
            }
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            if (this.delegate != null) {
                return this.delegate.addEdit(undoableEdit);
            }
            return false;
        }

        public boolean replaceEdit(UndoableEdit undoableEdit) {
            if (this.delegate != null) {
                return this.delegate.replaceEdit(undoableEdit);
            }
            return false;
        }

        public boolean isSignificant() {
            if (this.delegate != null) {
                return this.delegate.isSignificant();
            }
            return true;
        }

        public String getPresentationName() {
            if (this.delegate != null) {
                return this.delegate.getPresentationName();
            }
            return "";
        }

        public String getUndoPresentationName() {
            if (this.delegate != null) {
                return this.delegate.getUndoPresentationName();
            }
            return "";
        }

        public String getRedoPresentationName() {
            if (this.delegate != null) {
                return this.delegate.getRedoPresentationName();
            }
            return "";
        }
    }

    private final class Listener
    implements ChangeListener,
    DocumentListener,
    PropertyChangeListener,
    Runnable,
    VetoableChangeListener {
        private boolean revertModifiedFlag;
        private IOException loadExc;
        private Runnable undoTask;

        Listener() {
        }

        public IOException checkLoadException() {
            IOException iOException = this.loadExc;
            return iOException;
        }

        public void setUndoTask(Runnable runnable) {
            this.undoTask = runnable;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            CloneableEditorSupport.this.getUndoRedo().removeChangeListener((ChangeListener)this);
            this.undoTask.run();
            this.undoTask = null;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if ("modified".equals(propertyChangeEvent.getPropertyName())) {
                if (Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                    boolean bl = CloneableEditorSupport.this.isAlreadyModified();
                    if (!CloneableEditorSupport.this.callNotifyModified()) {
                        throw new PropertyVetoException("Not allowed", propertyChangeEvent);
                    }
                    this.revertModifiedFlag = !bl;
                } else if (this.revertModifiedFlag) {
                    CloneableEditorSupport.this.callNotifyUnmodified();
                }
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            CloneableEditorSupport.this.callNotifyModified();
            this.revertModifiedFlag = false;
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            CloneableEditorSupport.this.callNotifyModified();
            this.revertModifiedFlag = false;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("time".equals(propertyChangeEvent.getPropertyName())) {
                Date date = (Date)propertyChangeEvent.getNewValue();
                ERR.log("PROP_TIME new value: " + date);
                ERR.log("       lastSaveTime: " + CloneableEditorSupport.this.lastSaveTime);
                boolean bl = CloneableEditorSupport.this.lastSaveTime != -1L && (date == null || date.getTime() > CloneableEditorSupport.this.lastSaveTime);
                ERR.log("             reload: " + bl);
                if (bl) {
                    CloneableEditorSupport.this.externallyModified = true;
                    SwingUtilities.invokeLater(new Runnable(this, date){
                        boolean inWriteAccess;
                        private final /* synthetic */ Date val$time;
                        private final /* synthetic */ Listener this$1;
                        {
                            this.this$1 = listener;
                            this.val$time = date;
                        }

                        public void run() {
                            if (!this.inWriteAccess) {
                                this.inWriteAccess = true;
                                StyledDocument styledDocument = CloneableEditorSupport.access$300(Listener.access$1700(this.this$1));
                                if (styledDocument == null) {
                                    return;
                                }
                                CloneableEditorSupport.access$1802(Listener.access$1700(this.this$1), true);
                                NbDocument.runAtomic(styledDocument, this);
                                CloneableEditorSupport.access$1802(Listener.access$1700(this.this$1), false);
                                return;
                            }
                            CloneableEditorSupport.access$1900(Listener.access$1700(this.this$1), this.val$time == null || !Listener.access$1700(this.this$1).isModified());
                        }
                    });
                }
            }
            if ("modified".equals(propertyChangeEvent.getPropertyName())) {
                CloneableEditorSupport.this.firePropertyChange("modified", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }

        public void run() {
            CloneableEditorSupport.this.addRemoveDocListener(CloneableEditorSupport.this.doc, false);
            try {
                this.loadExc = null;
                LOCAL_LOAD_TASK.set(Boolean.TRUE);
                CloneableEditorSupport.this.loadDocument(CloneableEditorSupport.this.kit, CloneableEditorSupport.this.doc);
            }
            catch (IOException iOException) {
                this.loadExc = iOException;
                throw new DelegateIOExc(iOException);
            }
            finally {
                LOCAL_LOAD_TASK.set(null);
            }
            CloneableEditorSupport.this.getPositionManager().documentOpened(CloneableEditorSupport.this.doc);
            CloneableEditorSupport.this.updateLineSet(true);
            CloneableEditorSupport.this.setLastSaveTime(System.currentTimeMillis());
            CloneableEditorSupport.this.getUndoRedo().undoableEditHappened(new UndoableEditEvent(this, new BeforeSaveEdit(CloneableEditorSupport.this.lastSaveTime)));
            CloneableEditorSupport.this.addRemoveDocListener(CloneableEditorSupport.this.doc, true);
        }

        static /* synthetic */ CloneableEditorSupport access$1700(Listener listener) {
            return listener.CloneableEditorSupport.this;
        }
    }

    private static final class PlainEditorKit
    extends DefaultEditorKit
    implements ViewFactory {
        static final long serialVersionUID = -5788777967029507963L;

        PlainEditorKit() {
        }

        public Object clone() {
            return new PlainEditorKit();
        }

        public ViewFactory getViewFactory() {
            return this;
        }

        public View create(Element element) {
            return new WrappedPlainView(element);
        }

        public void install(JEditorPane jEditorPane) {
            super.install(jEditorPane);
            jEditorPane.setFont(new Font("Monospaced", 0, jEditorPane.getFont().getSize() + 1));
        }
    }

    public static interface Pane {
        public JEditorPane getEditorPane();

        public CloneableTopComponent getComponent();

        public void updateName();

        public void ensureVisible();
    }

    public static interface Env
    extends CloneableOpenSupport.Env {
        public static final String PROP_TIME = "time";

        public InputStream inputStream() throws IOException;

        public OutputStream outputStream() throws IOException;

        public Date getTime();

        public String getMimeType();
    }
}

