/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.openide.ErrorManager;
import org.openide.text.Annotation;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DocumentLine;
import org.openide.text.EnhancedChangeEvent;
import org.openide.text.LazyLines;
import org.openide.text.Line;
import org.openide.text.LineListener;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public abstract class DocumentLine
extends Line {
    private static WeakHashMap assigned = new WeakHashMap(5);
    static final long serialVersionUID = 3213776466939427487L;
    protected PositionRef pos;
    private boolean breakpoint;
    private transient boolean error;
    private transient boolean current;
    private transient LR listener;
    private transient DocumentListener docL;
    private List lineParts = new ArrayList(3);
    static /* synthetic */ Class class$org$openide$text$DocumentLine;

    public DocumentLine(Lookup lookup, PositionRef positionRef) {
        super(lookup);
        this.pos = positionRef;
    }

    void init() {
        this.listener = new LR();
        this.pos.getCloneableEditorSupport().addChangeListener(WeakListeners.change((ChangeListener)this.listener, (Object)((Object)this.pos.getCloneableEditorSupport())));
    }

    public int getLineNumber() {
        try {
            return this.pos.getLine();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public abstract void show(int var1, int var2);

    public void setBreakpoint(boolean bl) {
        if (this.breakpoint != bl) {
            this.breakpoint = bl;
            this.refreshState();
        }
    }

    public boolean isBreakpoint() {
        return this.breakpoint;
    }

    public void markError() {
        DocumentLine documentLine = this.registerLine(1, this);
        if (documentLine != null) {
            documentLine.error = false;
            documentLine.refreshState();
        }
        this.error = true;
        this.refreshState();
    }

    public void unmarkError() {
        this.error = false;
        this.registerLine(1, null);
        this.refreshState();
    }

    public void markCurrentLine() {
        DocumentLine documentLine = this.registerLine(0, this);
        if (documentLine != null) {
            documentLine.current = false;
            documentLine.refreshState();
        }
        this.current = true;
        this.refreshState();
    }

    public void unmarkCurrentLine() {
        this.current = false;
        this.registerLine(0, null);
        this.refreshState();
    }

    synchronized void refreshState() {
        StyledDocument styledDocument = this.pos.getCloneableEditorSupport().getDocument();
        if (styledDocument != null) {
            if (this.docL != null) {
                styledDocument.removeDocumentListener(this.docL);
            }
            if (this.error) {
                NbDocument.markError(styledDocument, this.pos.getOffset());
                this.docL = WeakListeners.document((DocumentListener)this.listener, (Object)styledDocument);
                styledDocument.addDocumentListener(this.docL);
                return;
            }
            if (this.current) {
                NbDocument.markCurrent(styledDocument, this.pos.getOffset());
                return;
            }
            if (this.breakpoint) {
                NbDocument.markBreakpoint(styledDocument, this.pos.getOffset());
                return;
            }
            NbDocument.markNormal(styledDocument, this.pos.getOffset());
            return;
        }
    }

    public int hashCode() {
        return ((Object)((Object)this.pos.getCloneableEditorSupport())).hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DocumentLine) {
            DocumentLine documentLine = (DocumentLine)object;
            if (documentLine.pos.getCloneableEditorSupport() == this.pos.getCloneableEditorSupport()) {
                return documentLine.getLineNumber() == this.getLineNumber();
            }
        }
        return false;
    }

    private DocumentLine registerLine(int n, DocumentLine documentLine) {
        DocumentLine documentLine2;
        CloneableEditorSupport cloneableEditorSupport = this.pos.getCloneableEditorSupport();
        DocumentLine[] documentLineArray = (DocumentLine[])assigned.get((Object)cloneableEditorSupport);
        if (documentLineArray != null) {
            documentLine2 = documentLineArray[n];
        } else {
            documentLineArray = new DocumentLine[2];
            assigned.put(cloneableEditorSupport, documentLineArray);
            documentLine2 = null;
        }
        documentLineArray[n] = documentLine;
        return documentLine2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.pos);
        objectOutputStream.writeBoolean(this.breakpoint);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pos = (PositionRef)objectInputStream.readObject();
        this.setBreakpoint(objectInputStream.readBoolean());
        this.lineParts = new ArrayList(3);
    }

    Object readResolve() throws ObjectStreamException {
        return this.pos.getCloneableEditorSupport().getLineSet().registerLine(this);
    }

    protected void addAnnotation(Annotation annotation) {
        super.addAnnotation(annotation);
        StyledDocument styledDocument = this.pos.getCloneableEditorSupport().getDocument();
        if (styledDocument == null) {
            return;
        }
        this.pos.getCloneableEditorSupport().prepareDocument().waitFinished();
        try {
            if (!annotation.isInDocument()) {
                annotation.setInDocument(true);
                FindAnnotationPosition findAnnotationPosition = new FindAnnotationPosition(styledDocument, this.pos.getPosition());
                styledDocument.render(findAnnotationPosition);
                NbDocument.addAnnotation(styledDocument, findAnnotationPosition.getAnnotationPosition(), -1, annotation);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(4096, (Throwable)iOException);
        }
    }

    protected void removeAnnotation(Annotation annotation) {
        super.removeAnnotation(annotation);
        StyledDocument styledDocument = this.pos.getCloneableEditorSupport().getDocument();
        if (styledDocument == null) {
            return;
        }
        this.pos.getCloneableEditorSupport().prepareDocument().waitFinished();
        if (annotation.isInDocument()) {
            annotation.setInDocument(false);
            NbDocument.removeAnnotation(styledDocument, annotation);
        }
    }

    void attachDetachAnnotations(StyledDocument styledDocument, boolean bl) {
        int n;
        Object object;
        Position position = null;
        if (!bl) {
            try {
                position = this.pos.getPosition();
                object = new FindAnnotationPosition(styledDocument, position);
                styledDocument.render((Runnable)object);
                position = ((FindAnnotationPosition)object).getAnnotationPosition();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(4096, (Throwable)iOException);
            }
        }
        object = this.getAnnotations();
        for (n = 0; n < object.size(); ++n) {
            Annotation annotation = (Annotation)object.get(n);
            if (!bl) {
                if (annotation.isInDocument()) continue;
                annotation.setInDocument(true);
                NbDocument.addAnnotation(styledDocument, position, -1, annotation);
                continue;
            }
            if (!annotation.isInDocument()) continue;
            annotation.setInDocument(false);
            NbDocument.removeAnnotation(styledDocument, annotation);
        }
        for (n = 0; n < this.lineParts.size(); ++n) {
            ((Part)this.lineParts.get(n)).attachDetachAnnotations(styledDocument, bl);
        }
    }

    public String getText() {
        final StyledDocument styledDocument = this.pos.getCloneableEditorSupport().getDocument();
        if (styledDocument == null) {
            return null;
        }
        final String[] stringArray = new String[1];
        styledDocument.render(new Runnable(){

            public void run() {
                int n = DocumentLine.this.getLineNumber();
                int n2 = NbDocument.findLineOffset(styledDocument, n);
                int n3 = n + 1 >= NbDocument.findLineRootElement(styledDocument).getElementCount() ? styledDocument.getLength() : NbDocument.findLineOffset(styledDocument, n + 1);
                try {
                    stringArray[0] = styledDocument.getText(n2, n3 - n2);
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify(4096, (Throwable)badLocationException);
                    stringArray[0] = null;
                }
            }
        });
        return stringArray[0];
    }

    void addLinePart(Part part) {
        this.lineParts.add(part);
    }

    void moveLinePart(Part part, DocumentLine documentLine) {
        this.lineParts.remove(part);
        documentLine.addLinePart(part);
        part.changeLine(documentLine);
    }

    void notifyChange(DocumentEvent documentEvent, Set set, StyledDocument styledDocument) {
        Position position;
        int n = 0;
        while (n < this.lineParts.size()) {
            Part part = (Part)this.lineParts.get(n);
            part.handleDocumentChange(documentEvent);
            if (NbDocument.findLineNumber(styledDocument, part.getOffset()) != part.getLine().getLineNumber()) {
                DocumentLine documentLine = (DocumentLine)set.getCurrent(NbDocument.findLineNumber(styledDocument, part.getOffset()));
                this.moveLinePart(part, documentLine);
                continue;
            }
            ++n;
        }
        try {
            position = this.pos.getPosition();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(4096, (Throwable)iOException);
            position = null;
        }
        if (position != null) {
            int n2 = NbDocument.findLineOffset(styledDocument, NbDocument.findLineNumber(styledDocument, position.getOffset()));
            CloneableEditorSupport cloneableEditorSupport = this.pos.getCloneableEditorSupport();
            this.pos = new PositionRef(cloneableEditorSupport.getPositionManager(), n2, Position.Bias.Forward);
            List list = this.getAnnotations();
            int n3 = list.size();
            if (n3 > 0) {
                try {
                    position = this.pos.getPosition();
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException();
                }
                for (int i = 0; i < n3; ++i) {
                    Annotation annotation = (Annotation)list.get(i);
                    if (annotation.isInDocument()) {
                        annotation.setInDocument(false);
                        NbDocument.removeAnnotation(cloneableEditorSupport.getDocument(), annotation);
                    }
                    if (annotation.isInDocument()) continue;
                    annotation.setInDocument(true);
                    NbDocument.addAnnotation(cloneableEditorSupport.getDocument(), position, -1, annotation);
                }
            }
        }
    }

    void notifyMove() {
        this.updatePositionRef();
        for (int i = 0; i < this.lineParts.size(); ++i) {
            ((Part)this.lineParts.get(i)).firePropertyChange("line", null, null);
        }
    }

    private void updatePositionRef() {
    }

    public static abstract class Set
    extends Line.Set {
        final LineListener listener;
        private List list;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Set(StyledDocument styledDocument) {
            this(styledDocument, null);
        }

        Set(StyledDocument styledDocument, CloneableEditorSupport cloneableEditorSupport) {
            this.listener = new LineListener(styledDocument, cloneableEditorSupport);
        }

        void linesChanged(int n, int n2, DocumentEvent documentEvent) {
            List list = this.getLinesFromRange(n, n2);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Line line = (Line)iterator.next();
                line.firePropertyChange("text", null, null);
                if (!(line instanceof DocumentLine)) continue;
                ((DocumentLine)line).notifyChange(documentEvent, this, this.listener.doc);
            }
        }

        void linesMoved(int n, int n2) {
            List list = this.getLinesFromRange(n, n2);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Line line = (Line)iterator.next();
                line.firePropertyChange("lineNumber", null, null);
                if (!(line instanceof DocumentLine)) continue;
                ((DocumentLine)line).notifyMove();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List getLinesFromRange(int n, int n2) {
            ArrayList<Line> arrayList = new ArrayList<Line>(10);
            WeakHashMap weakHashMap = this.findWeakHashMap();
            synchronized (weakHashMap) {
                Iterator iterator = this.findWeakHashMap().keySet().iterator();
                while (iterator.hasNext()) {
                    Line line = (Line)iterator.next();
                    int n3 = line.getLineNumber();
                    if (n > n3 || n3 > n2) continue;
                    arrayList.add(line);
                }
            }
            return arrayList;
        }

        public synchronized List getLines() {
            if (this.list == null) {
                this.list = new LazyLines(this);
            }
            return this.list;
        }

        public Line getOriginal(int n) throws IndexOutOfBoundsException {
            int n2 = this.listener.getLine(n);
            int n3 = NbDocument.findLineOffset(this.listener.doc, n2);
            return this.safelyRegisterLine(this.createLine(n3));
        }

        public int getOriginalLineNumber(Line line) {
            Line line2 = this.findLine(line);
            if (line2 != null) {
                return this.listener.getOld(line2.getLineNumber());
            }
            return -1;
        }

        public Line getCurrent(int n) throws IndexOutOfBoundsException {
            int n2 = NbDocument.findLineOffset(this.listener.doc, n);
            return this.safelyRegisterLine(this.createLine(n2));
        }

        protected abstract Line createLine(int var1);

        private Line safelyRegisterLine(Line line) {
            if (!$assertionsDisabled && line == null) {
                throw new AssertionError();
            }
            class DocumentRenderer
            implements Runnable {
                public Line result;
                private final /* synthetic */ Line val$line;
                private final /* synthetic */ Set this$0;

                DocumentRenderer(Set set, Line line) {
                    this.this$0 = set;
                    this.val$line = line;
                }

                public void run() {
                    this.result = Set.access$101(this.this$0, this.val$line);
                }
            }
            DocumentRenderer documentRenderer = new DocumentRenderer(this, line);
            this.listener.doc.render(documentRenderer);
            return documentRenderer.result;
        }

        static /* synthetic */ Line access$101(Set set, Line line) {
            return super.registerLine(line);
        }

        static {
            $assertionsDisabled = !(class$org$openide$text$DocumentLine == null ? (class$org$openide$text$DocumentLine = DocumentLine.class$("org.openide.text.DocumentLine")) : class$org$openide$text$DocumentLine).desiredAssertionStatus();
        }
    }

    private final class LR
    implements Runnable,
    ChangeListener,
    DocumentListener {
        private static final int REFRESH = 0;
        private static final int UNMARK = 1;
        private static final int ATTACH_DETACH = 2;
        private int actionId;
        private EnhancedChangeEvent ev;

        public LR() {
        }

        public LR(int n) {
            this.actionId = n;
        }

        public LR(EnhancedChangeEvent enhancedChangeEvent) {
            this.actionId = 2;
            this.ev = enhancedChangeEvent;
        }

        public void run() {
            switch (this.actionId) {
                case 0: {
                    DocumentLine.this.refreshState();
                    break;
                }
                case 1: {
                    DocumentLine.this.unmarkError();
                    break;
                }
                case 2: {
                    DocumentLine.this.attachDetachAnnotations(this.ev.getDocument(), this.ev.isClosingDocument());
                    this.ev = null;
                }
            }
        }

        private void invoke(int n) {
            new LR(n).run();
        }

        private void invoke(EnhancedChangeEvent enhancedChangeEvent) {
            new LR(enhancedChangeEvent).run();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.invoke(0);
            this.invoke((EnhancedChangeEvent)changeEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.invoke(1);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.invoke(1);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    static class Part
    extends Line.Part {
        private PositionRef position;
        private Line line;
        private int length;
        private int previousOffset;

        public Part(Line line, PositionRef positionRef, int n) {
            this.position = positionRef;
            this.line = line;
            this.previousOffset = positionRef.getOffset();
            this.length = this.limitLength(n);
        }

        private int limitLength(int n) {
            StyledDocument styledDocument = this.position.getCloneableEditorSupport().getDocument();
            int n2 = this.position.getOffset() + n;
            if (n2 > styledDocument.getLength()) {
                n2 = styledDocument.getLength();
            }
            if (n2 < this.position.getOffset()) {
                return 0;
            }
            try {
                String string = styledDocument.getText(this.position.getOffset(), n2 - this.position.getOffset());
                int n3 = string.indexOf(10);
                return n3 == -1 ? string.length() : n3 + 1;
            }
            catch (BadLocationException badLocationException) {
                IllegalStateException illegalStateException = new IllegalStateException(badLocationException.getMessage());
                illegalStateException.initCause(badLocationException);
                throw illegalStateException;
            }
        }

        public int getColumn() {
            try {
                return this.position.getColumn();
            }
            catch (IOException iOException) {
                return 0;
            }
        }

        public int getLength() {
            return this.length;
        }

        public Line getLine() {
            return this.line;
        }

        int getOffset() {
            return this.position.getOffset();
        }

        void changeLine(Line line) {
            this.line = line;
            this.firePropertyChange("lineNumber", null, line);
        }

        protected void addAnnotation(Annotation annotation) {
            super.addAnnotation(annotation);
            StyledDocument styledDocument = this.position.getCloneableEditorSupport().getDocument();
            if (styledDocument == null) {
                return;
            }
            this.position.getCloneableEditorSupport().prepareDocument().waitFinished();
            try {
                if (!annotation.isInDocument()) {
                    annotation.setInDocument(true);
                    NbDocument.addAnnotation(styledDocument, this.position.getPosition(), this.length, annotation);
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(4096, (Throwable)iOException);
            }
        }

        protected void removeAnnotation(Annotation annotation) {
            super.removeAnnotation(annotation);
            StyledDocument styledDocument = this.position.getCloneableEditorSupport().getDocument();
            if (styledDocument == null) {
                return;
            }
            this.position.getCloneableEditorSupport().prepareDocument().waitFinished();
            if (annotation.isInDocument()) {
                annotation.setInDocument(false);
                NbDocument.removeAnnotation(styledDocument, annotation);
            }
        }

        public String getText() {
            StyledDocument styledDocument = this.position.getCloneableEditorSupport().getDocument();
            if (styledDocument == null) {
                return null;
            }
            String[] stringArray = new String[1];
            styledDocument.render(new Runnable(this, styledDocument, stringArray){
                private final /* synthetic */ StyledDocument val$doc;
                private final /* synthetic */ String[] val$retStringArray;
                private final /* synthetic */ Part this$0;
                {
                    this.this$0 = part;
                    this.val$doc = styledDocument;
                    this.val$retStringArray = stringArray;
                }

                public void run() {
                    try {
                        int n = Part.access$000(this.this$0).getOffset();
                        this.val$retStringArray[0] = n >= this.val$doc.getLength() ? "" : this.val$doc.getText(Part.access$000(this.this$0).getOffset(), this.this$0.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        ErrorManager.getDefault().notify(4096, (Throwable)badLocationException);
                        this.val$retStringArray[0] = null;
                    }
                }
            });
            return stringArray[0];
        }

        void attachDetachAnnotations(StyledDocument styledDocument, boolean bl) {
            List list = this.getAnnotations();
            for (int i = 0; i < list.size(); ++i) {
                Annotation annotation = (Annotation)list.get(i);
                if (!bl) {
                    try {
                        if (annotation.isInDocument()) continue;
                        annotation.setInDocument(true);
                        NbDocument.addAnnotation(styledDocument, this.position.getPosition(), this.getLength(), annotation);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(4096, (Throwable)iOException);
                    }
                    continue;
                }
                if (!annotation.isInDocument()) continue;
                annotation.setInDocument(false);
                NbDocument.removeAnnotation(styledDocument, annotation);
            }
        }

        void handleDocumentChange(DocumentEvent documentEvent) {
            if (documentEvent.getType().equals(DocumentEvent.EventType.INSERT) && documentEvent.getOffset() >= this.previousOffset && documentEvent.getOffset() < this.previousOffset + this.getLength()) {
                this.firePropertyChange("text", null, null);
            }
            if (documentEvent.getType().equals(DocumentEvent.EventType.REMOVE) && (documentEvent.getOffset() >= this.previousOffset && documentEvent.getOffset() < this.previousOffset + this.getLength() || documentEvent.getOffset() < this.previousOffset && documentEvent.getOffset() + documentEvent.getLength() > this.previousOffset)) {
                this.length = this.limitLength(this.length);
                this.firePropertyChange("text", null, null);
            }
            if ((documentEvent.getType().equals(DocumentEvent.EventType.INSERT) || documentEvent.getType().equals(DocumentEvent.EventType.REMOVE)) && documentEvent.getOffset() < this.previousOffset) {
                this.firePropertyChange("column", null, null);
            }
            this.previousOffset = this.position.getOffset();
        }

        static /* synthetic */ PositionRef access$000(Part part) {
            return part.position;
        }
    }

    private static final class FindAnnotationPosition
    implements Runnable {
        private StyledDocument doc;
        private Position annoPos;

        FindAnnotationPosition(StyledDocument styledDocument, Position position) {
            this.doc = styledDocument;
            this.annoPos = position;
        }

        public void run() {
            int n;
            int n2 = this.annoPos.getOffset();
            if (n2 != (n = this.doc.getParagraphElement(n2).getStartOffset())) {
                try {
                    this.annoPos = this.doc.createPosition(n);
                }
                catch (BadLocationException badLocationException) {
                    throw new IllegalArgumentException();
                }
            }
        }

        Position getAnnotationPosition() {
            return this.annoPos;
        }
    }
}

