/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.io.Writer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.openide.ServiceType;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public abstract class IndentEngine
extends ServiceType {
    static final long serialVersionUID = -8548906260608507035L;
    private static HashMap map = new HashMap(7);
    private static IndentEngine INSTANCE = null;
    static /* synthetic */ Class class$org$openide$text$IndentEngine$Default;

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public abstract int indentLine(Document var1, int var2);

    public abstract int indentNewLine(Document var1, int var2);

    public abstract Writer createWriter(Document var1, int var2, Writer var3);

    protected boolean acceptMimeType(String string) {
        return false;
    }

    public static synchronized void register(String string, IndentEngine indentEngine) {
        map.put(string, indentEngine);
    }

    public static Enumeration indentEngines() {
        return Collections.enumeration(Lookup.getDefault().lookup(new Lookup.Template(IndentEngine.class)).allInstances());
    }

    public static synchronized IndentEngine find(String string) {
        IndentEngine indentEngine;
        Enumeration enumeration = IndentEngine.indentEngines();
        while (enumeration.hasMoreElements()) {
            indentEngine = (IndentEngine)((Object)enumeration.nextElement());
            if (!indentEngine.acceptMimeType(string)) continue;
            return indentEngine;
        }
        indentEngine = (IndentEngine)((Object)map.get(string));
        if (indentEngine != null) {
            return indentEngine;
        }
        return IndentEngine.getDefault();
    }

    public static IndentEngine find(Document document) {
        Object object = document.getProperty("indentEngine");
        if (object instanceof IndentEngine) {
            return (IndentEngine)((Object)object);
        }
        object = document.getProperty("mimeType");
        String string = object instanceof String ? (String)object : "text/plain";
        return IndentEngine.find(string);
    }

    public static synchronized IndentEngine getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new Default();
        }
        return INSTANCE;
    }

    private static final class Default
    extends IndentEngine {
        private static final long serialVersionUID = 4493180326470838469L;

        Default() {
        }

        public int indentLine(Document document, int n) {
            return n;
        }

        public int indentNewLine(Document document, int n) {
            try {
                document.insertString(n, "\n", null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return n + 1;
        }

        public Writer createWriter(Document document, int n, Writer writer) {
            return writer;
        }

        protected boolean acceptMimeType(String string) {
            return true;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$openide$text$IndentEngine$Default == null ? (class$org$openide$text$IndentEngine$Default = IndentEngine.class$("org.openide.text.IndentEngine$Default")) : class$org$openide$text$IndentEngine$Default);
        }
    }
}

