/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.TransferHandler;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.openide.text.ActiveEditorDrop;

final class QuietEditorPane
extends JEditorPane {
    static final int FIRE = 1;
    static final int PAINT = 2;
    static final int ALL = 3;
    private int lastPosition = -1;
    int working = 1;
    private int fontHeight;
    private int charWidth;
    static /* synthetic */ Class class$javax$swing$JComponent;
    static /* synthetic */ Class class$java$awt$datatransfer$Transferable;

    static DataFlavor constructActiveEditorDropFlavor() {
        try {
            return new DataFlavor("text/active_editor_flavor;class=org.openide.text.ActiveEditorDrop", "Active Editor Flavor", QuietEditorPane.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
    }

    public QuietEditorPane() {
        this.setFontHeightWidth(this.getFont());
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.setFontHeightWidth(this.getFont());
    }

    private void setFontHeightWidth(Font font) {
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.fontHeight = fontMetrics.getHeight();
        this.charWidth = fontMetrics.charWidth('m');
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return this.fontHeight;
            }
            case 0: {
                return this.charWidth;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    public void setDocument(Document document) {
        super.setDocument(document);
        if (document != null) {
            TransferHandler transferHandler = this.getTransferHandler();
            DelegatingTransferHandler delegatingTransferHandler = new DelegatingTransferHandler(transferHandler);
            this.setTransferHandler(delegatingTransferHandler);
        }
    }

    public void setWorking(int n) {
        this.working = n;
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        if ((this.working & 1) != 0) {
            super.firePropertyChange(string, object, object2);
        }
    }

    public void setCaret(Caret caret) {
        Caret caret2;
        if (caret == null && (caret2 = this.getCaret()) != null) {
            this.lastPosition = caret2.getDot();
        }
        super.setCaret(caret);
    }

    int getLastPosition() {
        return this.lastPosition;
    }

    public void revalidate() {
        if ((this.working & 2) != 0) {
            super.revalidate();
        }
    }

    public void repaint() {
        if ((this.working & 2) != 0) {
            super.repaint();
        }
    }

    private class DelegatingTransferHandler
    extends TransferHandler {
        TransferHandler delegator;

        public DelegatingTransferHandler(TransferHandler transferHandler) {
            this.delegator = transferHandler;
        }

        public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
            this.delegator.exportAsDrag(jComponent, inputEvent, n);
        }

        public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
            this.delegator.exportToClipboard(jComponent, clipboard, n);
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            try {
                Object object;
                if (transferable.isDataFlavorSupported(ActiveEditorDrop.FLAVOR) && (object = transferable.getTransferData(ActiveEditorDrop.FLAVOR)) instanceof ActiveEditorDrop && jComponent instanceof JTextComponent) {
                    return ((ActiveEditorDrop)object).handleTransfer((JTextComponent)jComponent);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return this.delegator.importData(jComponent, transferable);
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (dataFlavorArray[i] != ActiveEditorDrop.FLAVOR) continue;
                return true;
            }
            return this.delegator.canImport(jComponent, dataFlavorArray);
        }

        public int getSourceActions(JComponent jComponent) {
            return this.delegator.getSourceActions(jComponent);
        }

        public Icon getVisualRepresentation(Transferable transferable) {
            return this.delegator.getVisualRepresentation(transferable);
        }

        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            try {
                Method method = this.delegator.getClass().getDeclaredMethod("exportDone", class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = QuietEditorPane.class$("javax.swing.JComponent")) : class$javax$swing$JComponent, class$java$awt$datatransfer$Transferable == null ? (class$java$awt$datatransfer$Transferable = QuietEditorPane.class$("java.awt.datatransfer.Transferable")) : class$java$awt$datatransfer$Transferable, Integer.TYPE);
                method.setAccessible(true);
                method.invoke((Object)this.delegator, jComponent, transferable, new Integer(n));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }

        protected Transferable createTransferable(JComponent jComponent) {
            try {
                Method method = this.delegator.getClass().getDeclaredMethod("createTransferable", class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = QuietEditorPane.class$("javax.swing.JComponent")) : class$javax$swing$JComponent);
                method.setAccessible(true);
                return (Transferable)method.invoke((Object)this.delegator, jComponent);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            return null;
        }
    }
}

