/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.text.MessageFormat;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.apache.tools.ant.module.AntSettings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.execution.NbClassPath;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.NbBundle;

public final class AntCustomizer
extends JPanel
implements ActionListener {
    private JTextField tfAntHome = new JTextField();
    private JButton bAntHome = new JButton();
    private JCheckBox cbSaveFiles = new JCheckBox();
    private JCheckBox cbReuseOutput = new JCheckBox();
    private JCheckBox cbAlwaysShowOutput = new JCheckBox();
    private JComboBox cbVerbosity = new JComboBox();
    private JButton bProperties = new JButton();
    private JButton bClasspath = new JButton();
    protected JLabel lAntVersion = new JLabel();
    private NbClassPath classpath;
    private Properties properties;
    private boolean changed = false;
    private boolean listen = false;
    private File originalAntHome;
    private boolean initialized = false;

    public AntCustomizer() {
        this.tfAntHome.setColumns(30);
        AntCustomizer.loc(this.bAntHome, "Ant_Home_Button");
        this.bAntHome.addActionListener(this);
        AntCustomizer.loc(this.cbSaveFiles, "Save_Files");
        this.cbSaveFiles.setBackground(Color.white);
        this.cbReuseOutput.setBackground(Color.white);
        AntCustomizer.loc(this.cbReuseOutput, "Reuse_Output");
        AntCustomizer.loc(this.cbAlwaysShowOutput, "Always_Show_Output");
        this.cbAlwaysShowOutput.setBackground(Color.white);
        this.cbVerbosity.addItem(NbBundle.getMessage((Class)AntCustomizer.class, (String)"LBL_verbosity_warn"));
        this.cbVerbosity.addItem(NbBundle.getMessage((Class)AntCustomizer.class, (String)"LBL_verbosity_info"));
        this.cbVerbosity.addItem(NbBundle.getMessage((Class)AntCustomizer.class, (String)"LBL_verbosity_verbose"));
        this.cbVerbosity.addItem(NbBundle.getMessage((Class)AntCustomizer.class, (String)"LBL_verbosity_debug"));
        AntCustomizer.loc(this.bProperties, "Properties_Button");
        this.bProperties.addActionListener(this);
        AntCustomizer.loc(this.bClasspath, "Classpath_Button");
        this.bClasspath.addActionListener(this);
        this.cbSaveFiles.addActionListener(this);
        this.cbReuseOutput.addActionListener(this);
        this.cbAlwaysShowOutput.addActionListener(this);
        this.cbVerbosity.addActionListener(this);
        FormLayout formLayout = new FormLayout("p:g", "p, 3dlu, p, 3dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)this);
        CellConstraints cellConstraints = new CellConstraints();
        CellConstraints cellConstraints2 = new CellConstraints();
        FormLayout formLayout2 = new FormLayout("p, 5dlu, p:g, 5dlu, p", "p, 5dlu, p, 5dlu, p, 5dlu, p, 5dlu, p, 5dlu, p");
        PanelBuilder panelBuilder2 = new PanelBuilder(formLayout2);
        panelBuilder2.addLabel(AntCustomizer.loc("Ant_Home"), cellConstraints2.xy(1, 1), (Component)this.tfAntHome, cellConstraints.xy(3, 1));
        panelBuilder2.add((Component)this.bAntHome, cellConstraints.xy(5, 1));
        panelBuilder2.add((Component)this.lAntVersion, cellConstraints2.xyw(3, 3, 3));
        panelBuilder2.add((Component)this.cbSaveFiles, cellConstraints.xy(3, 5));
        panelBuilder2.add((Component)this.cbReuseOutput, cellConstraints.xy(3, 7));
        panelBuilder2.add((Component)this.cbAlwaysShowOutput, cellConstraints.xy(3, 9));
        panelBuilder2.addLabel(AntCustomizer.loc("Verbosity"), cellConstraints2.xy(1, 11), (Component)this.cbVerbosity, cellConstraints.xy(3, 11, "l, d"));
        panelBuilder2.getPanel().setBackground(Color.white);
        panelBuilder.add((Component)panelBuilder2.getPanel(), cellConstraints.xy(1, 1));
        formLayout2 = new FormLayout("50dlu:g, 5dlu, p", "p");
        panelBuilder2 = new PanelBuilder(formLayout2);
        panelBuilder2.addLabel("<html>" + AntCustomizer.loc("Properties_Text_Area"), cellConstraints.xy(1, 1));
        panelBuilder2.add((Component)this.bProperties, cellConstraints.xy(3, 1));
        panelBuilder2.getPanel().setBackground(Color.white);
        panelBuilder2.getPanel().setBorder(new TitledBorder(AntCustomizer.loc("Properties_Panel")));
        panelBuilder.add((Component)panelBuilder2.getPanel(), cellConstraints.xy(1, 3));
        formLayout2 = new FormLayout("50dlu:g, 5dlu, p", "p");
        panelBuilder2 = new PanelBuilder(formLayout2);
        panelBuilder2.addLabel("<html>" + AntCustomizer.loc("Classpath_Text_Area"), cellConstraints.xy(1, 1));
        panelBuilder2.add((Component)this.bClasspath, cellConstraints.xy(3, 1));
        panelBuilder2.getPanel().setBackground(Color.white);
        panelBuilder2.getPanel().setBorder(new TitledBorder(AntCustomizer.loc("Classpath_Panel")));
        panelBuilder.add((Component)panelBuilder2.getPanel(), cellConstraints.xy(1, 5));
    }

    private static String loc(String string) {
        return NbBundle.getMessage((Class)AntCustomizer.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)AntCustomizer.loc(string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)AntCustomizer.loc(string));
        }
    }

    void update() {
        this.listen = false;
        AntSettings antSettings = AntSettings.getDefault();
        this.classpath = antSettings.getExtraClasspath();
        this.properties = antSettings.getProperties();
        this.originalAntHome = antSettings.getAntHomeWithDefault();
        this.tfAntHome.setText(this.originalAntHome.toString());
        this.cbSaveFiles.setSelected(antSettings.getSaveAll());
        this.cbReuseOutput.setSelected(antSettings.getAutoCloseTabs());
        this.cbAlwaysShowOutput.setSelected(antSettings.getAlwaysShowOutput());
        this.cbVerbosity.setSelectedIndex(antSettings.getVerbosity() - 1);
        this.lAntVersion.setText("(" + antSettings.getAntVersion() + ")");
        this.changed = false;
        this.initialized = true;
        this.listen = true;
    }

    void applyChanges() {
        if (!this.initialized) {
            return;
        }
        AntSettings antSettings = AntSettings.getDefault();
        String string = this.tfAntHome.getText().trim();
        antSettings.setAntHome(new File(string));
        if (antSettings.getAutoCloseTabs() != this.cbReuseOutput.isSelected()) {
            antSettings.setAutoCloseTabs(this.cbReuseOutput.isSelected());
        }
        if (antSettings.getSaveAll() != this.cbSaveFiles.isSelected()) {
            antSettings.setSaveAll(this.cbSaveFiles.isSelected());
        }
        if (antSettings.getAlwaysShowOutput() != this.cbAlwaysShowOutput.isSelected()) {
            antSettings.setAlwaysShowOutput(this.cbAlwaysShowOutput.isSelected());
        }
        if (antSettings.getVerbosity() != this.cbVerbosity.getSelectedIndex() + 1) {
            antSettings.setVerbosity(this.cbVerbosity.getSelectedIndex() + 1);
        }
        if (!antSettings.getProperties().equals(this.properties)) {
            antSettings.setProperties(this.properties);
        }
        if (!antSettings.getExtraClasspath().equals((Object)this.classpath)) {
            antSettings.setExtraClasspath(this.classpath);
        }
        this.changed = false;
    }

    void cancel() {
        AntSettings antSettings = AntSettings.getDefault();
        if (antSettings.getAntHome() != this.originalAntHome) {
            antSettings.setAntHome(this.originalAntHome);
        }
        this.changed = false;
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        return this.changed;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.listen) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.cbAlwaysShowOutput) {
            this.changed = true;
        } else if (object == this.cbReuseOutput) {
            this.changed = true;
        } else if (object == this.cbSaveFiles) {
            this.changed = true;
        } else if (object == this.cbVerbosity) {
            this.changed = true;
        } else if (object == this.bAntHome) {
            JFileChooser jFileChooser = new JFileChooser(this.tfAntHome.getText());
            jFileChooser.setFileSelectionMode(1);
            int n = jFileChooser.showDialog(SwingUtilities.getWindowAncestor(this), AntCustomizer.loc("Select_Directory"));
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                if (!new File(new File(file, "lib"), "ant.jar").isFile()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(AntCustomizer.loc("Not_a_ant_home"), file), 2));
                    return;
                }
                this.tfAntHome.setText(file.getAbsolutePath());
                AntSettings antSettings = AntSettings.getDefault();
                antSettings.setAntHome(file);
                this.lAntVersion.setText("(" + antSettings.getAntVersion() + ")");
                this.changed = true;
            }
        } else if (object == this.bClasspath) {
            PropertyEditor propertyEditor = PropertyEditorManager.findEditor(NbClassPath.class);
            propertyEditor.setValue(this.classpath);
            Component component = propertyEditor.getCustomEditor();
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)component, AntCustomizer.loc("Classpath_Editor_Title"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
            if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                this.classpath = (NbClassPath)propertyEditor.getValue();
                this.changed = true;
            }
        } else if (object == this.bProperties) {
            PropertyEditor propertyEditor = PropertyEditorManager.findEditor(Properties.class);
            propertyEditor.setValue(this.properties);
            Component component = propertyEditor.getCustomEditor();
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)component, AntCustomizer.loc("Properties_Editor_Title"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
            if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                this.properties = component instanceof EnhancedCustomPropertyEditor ? (Properties)((EnhancedCustomPropertyEditor)component).getPropertyValue() : (Properties)propertyEditor.getValue();
                this.changed = true;
            }
        }
    }
}

