/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.IntrospectedInfo;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.apache.tools.ant.module.spi.AutomaticExtraClasspathProvider;
import org.openide.execution.NbClassPath;
import org.openide.modules.InstalledFileLocator;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class AntSettings
extends SystemOption
implements ChangeListener {
    public static final String PROP_VERBOSITY = "verbosity";
    public static final String PROP_PROPERTIES = "properties";
    public static final String PROP_SAVE_ALL = "saveAll";
    public static final String PROP_CUSTOM_DEFS = "customDefs";
    public static final String PROP_ANT_VERSION = "antVersion";
    public static final String PROP_ANT_HOME = "antHome";
    public static final String PROP_EXTRA_CLASSPATH = "extraClasspath";
    public static final String PROP_AUTOMATIC_EXTRA_CLASSPATH = "automaticExtraClasspath";
    public static final String PROP_AUTO_CLOSE_TABS = "autoCloseTabs";
    public static final String PROP_ALWAYS_SHOW_OUTPUT = "alwaysShowOutput";
    private static final long serialVersionUID = -4457782585534082966L;
    private static File defaultAntHome;
    private NbClassPath defAECP = null;
    private Lookup.Result aecpResult = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected void initialize() {
        super.initialize();
        this.setVerbosity(2);
        Properties properties = new Properties();
        properties.setProperty("build.compiler.emacs", "true");
        this.setProperties(properties);
        this.setSaveAll(true);
        this.setCustomDefs(new IntrospectedInfo());
        this.setAutoCloseTabs(true);
        this.setAlwaysShowOutput(true);
    }

    public String displayName() {
        return NbBundle.getMessage((Class)AntSettings.class, (String)"LBL_settings");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.apache.tools.ant.module.settings");
    }

    public static AntSettings getDefault() {
        return (AntSettings)AntSettings.findObject((Class)AntSettings.class, (boolean)true);
    }

    public int getVerbosity() {
        return (Integer)this.getProperty(PROP_VERBOSITY);
    }

    public void setVerbosity(int n) {
        this.putProperty(PROP_VERBOSITY, new Integer(n), true);
    }

    public Properties getProperties() {
        HashMap hashMap = (HashMap)this.getProperty(PROP_PROPERTIES);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)hashMap);
        return properties;
    }

    public void setProperties(Properties properties) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(properties);
        this.putProperty(PROP_PROPERTIES, hashMap, true);
    }

    public boolean getSaveAll() {
        return (Boolean)this.getProperty(PROP_SAVE_ALL);
    }

    public void setSaveAll(boolean bl) {
        this.putProperty(PROP_SAVE_ALL, bl ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public IntrospectedInfo getCustomDefs() {
        return (IntrospectedInfo)this.getProperty(PROP_CUSTOM_DEFS);
    }

    public void setCustomDefs(IntrospectedInfo introspectedInfo) {
        this.putProperty(PROP_CUSTOM_DEFS, introspectedInfo, true);
        introspectedInfo.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)introspectedInfo));
    }

    public String getAntVersion() {
        String string = (String)this.getProperty(PROP_ANT_VERSION);
        if (string == null) {
            string = AntBridge.getInterface().getAntVersion();
            this.putProperty(PROP_ANT_VERSION, string, false);
        }
        return string;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.firePropertyChange(PROP_CUSTOM_DEFS, null, null);
    }

    static File getDefaultAntHome() {
        if (defaultAntHome == null) {
            File file = InstalledFileLocator.getDefault().locate("ant/lib/ant.jar", "org.apache.tools.ant.module", false);
            if (!$assertionsDisabled && file == null) {
                throw new AssertionError((Object)"Missing binding for ant/lib/ant.jar in InstalledFileLocator");
            }
            defaultAntHome = file.getParentFile().getParentFile();
            if (AntModule.err.isLoggable(1)) {
                AntModule.err.log("getDefaultAntHome: " + defaultAntHome);
            }
        }
        if (!$assertionsDisabled && defaultAntHome == null) {
            throw new AssertionError();
        }
        return defaultAntHome;
    }

    public File getAntHomeWithDefault() {
        File file = this.getAntHome();
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("getAntHomeWithDefault: antHome=" + file);
        }
        if (file == null) {
            file = AntSettings.getDefaultAntHome();
        }
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        return file;
    }

    public File getAntHome() {
        return (File)this.getProperty(PROP_ANT_HOME);
    }

    public void setAntHome(File file) {
        if (file != null && file.equals(AntSettings.getDefaultAntHome())) {
            file = null;
        }
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("setAntHome: " + file);
        }
        this.putProperty(PROP_ANT_HOME, file, true);
        this.putProperty(PROP_ANT_VERSION, null, false);
        this.firePropertyChange(PROP_ANT_VERSION, null, null);
    }

    public NbClassPath getExtraClasspath() {
        NbClassPath nbClassPath = (NbClassPath)this.getProperty(PROP_EXTRA_CLASSPATH);
        if (nbClassPath == null) {
            nbClassPath = new NbClassPath(new File[0]);
            this.putProperty(PROP_EXTRA_CLASSPATH, nbClassPath, false);
        }
        return nbClassPath;
    }

    public void setExtraClasspath(NbClassPath nbClassPath) {
        this.putProperty(PROP_EXTRA_CLASSPATH, nbClassPath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NbClassPath getAutomaticExtraClasspath() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.aecpResult == null) {
                this.aecpResult = Lookup.getDefault().lookup(new Lookup.Template(AutomaticExtraClasspathProvider.class));
                this.aecpResult.addLookupListener(new LookupListener(){

                    public void resultChanged(LookupEvent lookupEvent) {
                        AntSettings.this.defAECP = null;
                        AntSettings.this.firePropertyChange(AntSettings.PROP_AUTOMATIC_EXTRA_CLASSPATH, null, null);
                    }
                });
            }
            if (this.defAECP == null) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                Iterator iterator = this.aecpResult.allInstances().iterator();
                while (iterator.hasNext()) {
                    AutomaticExtraClasspathProvider automaticExtraClasspathProvider = (AutomaticExtraClasspathProvider)iterator.next();
                    arrayList.addAll(Arrays.asList((Object[])automaticExtraClasspathProvider.getClasspathItems()));
                }
                this.defAECP = new NbClassPath(arrayList.toArray(new File[arrayList.size()]));
            }
            return this.defAECP;
        }
    }

    public boolean getAutoCloseTabs() {
        return (Boolean)this.getProperty(PROP_AUTO_CLOSE_TABS);
    }

    public void setAutoCloseTabs(boolean bl) {
        this.putProperty(PROP_AUTO_CLOSE_TABS, bl, true);
    }

    public boolean getAlwaysShowOutput() {
        return (Boolean)this.getProperty(PROP_ALWAYS_SHOW_OUTPUT);
    }

    public void setAlwaysShowOutput(boolean bl) {
        this.putProperty(PROP_ALWAYS_SHOW_OUTPUT, bl, true);
    }

    static {
        $assertionsDisabled = !AntSettings.class.desiredAssertionStatus();
        defaultAntHome = null;
    }
}

